/*
 * FtpSvr
 * Copyright(C) 1997-1999 Eiichiro Ito
*/
#define	STRICT
#include	<windows.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	<commdlg.h>
#include	<tchar.h>
#include	"basewin.h"
#include	"resource.h"
#include	"dialog.h"
#include	"ftpmain.h"

extern	DWORD	AppVersion ;

extern	DWORD	PortNo ;

/*
 * ݒ_CAO
 */
class SetupDialog : public Window {
	HINSTANCE	m_hInst ;

public:
	SetupDialog( HINSTANCE hInst ) { m_hInst = hInst ; }
	~SetupDialog() {}

	void	WMCreate( HWND hDlg ) ;
	LRESULT	WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp ) ;
} ;

void
SetupDialog::WMCreate( HWND hDlg )
{
	TCHAR	buf[ 128 ] ;

	/* o[Wݒ肷 */
	wsprintf( buf, TEXT("FtpSvr for Windows%c CE Ver %d.%02d"),
			  0xAE, AppVersion / 100, AppVersion % 100 ) ;
	SetWindowText( hDlg, buf ) ;
	wsprintf( buf, TEXT("Copyright (C) 1997-1999 %s\r\n%s"),
			  TEXT("Eiichiro Ito"),
			  TEXT("All Rights Reserved") ) ;
	SetDlgItemText( hDlg, IDC_COPYRIGHT, buf ) ;
	/* ڂ̒lݒ肷 */
	SetDlgItemInt( hDlg, IDC_PORTNO, PortNo, 0 ) ;
	if ( ftp_running() ) {
		EnableWindow( GetDlgItem( hDlg, IDC_BTN_START ), FALSE ) ;
		EnableWindow( GetDlgItem( hDlg, IDC_BTN_STOP ), TRUE ) ;
	} else {
		EnableWindow( GetDlgItem( hDlg, IDC_BTN_START ), TRUE ) ;
		EnableWindow( GetDlgItem( hDlg, IDC_BTN_STOP ), FALSE ) ;
	}
	SetForegroundWindow( hDlg ) ;
}

LRESULT
SetupDialog::WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp )
{
	DWORD	ret = 0 ;
	HWND	hWndCtrl ;

	if ( wp == IDCANCEL ) {
		EndDialog( hDlg, 0 ) ;
		return TRUE ;
	} else if ( wp == IDC_EXIT ) {
		EndDialog( hDlg, DIALOG_RET_EXIT ) ;
		return TRUE ;
	} else if ( wp == IDC_UNINSTALL ) {
		if ( MessageBox( hDlg, TEXT("Uninstall this application?"), TEXT("Uninstall"), MB_YESNO ) == IDYES ) {
			EndDialog( hDlg, DIALOG_RET_UNINSTALL ) ;
		}
		return TRUE ;
	} else if ( wp == IDC_BTN_START ) {
		if ( ftp_running() ) {
			return TRUE ;
		}
		/* |[gԍ */
		PortNo = GetDlgItemInt( hDlg, IDC_PORTNO, NULL, FALSE ) ;
		if ( !ftp_start( PortNo ) ) {
			return TRUE ;
		}
		EnableWindow( GetDlgItem( hDlg, IDC_BTN_START ), FALSE ) ;
		hWndCtrl = GetDlgItem( hDlg, IDC_BTN_STOP ) ;
		EnableWindow( hWndCtrl, TRUE ) ;
		SetFocus( hWndCtrl ) ;
		return TRUE ;
	} else if ( wp == IDC_BTN_STOP ) {
		if ( !ftp_running() ) {
			return TRUE ;
		}
		ftp_stop( hDlg ) ;
		hWndCtrl = GetDlgItem( hDlg, IDC_BTN_START ) ;
		EnableWindow( hWndCtrl, TRUE ) ;
		SetFocus( hWndCtrl ) ;
		return TRUE ;
	} else if ( wp == IDM_STOP ) {
		EnableWindow( GetDlgItem( hDlg, IDC_BTN_STOP ), FALSE ) ;
		return TRUE ;
	} else if ( wp != IDOK ) {
		return FALSE ;
	}
	/* |[gԍ */
	PortNo = GetDlgItemInt( hDlg, IDC_PORTNO, NULL, FALSE ) ;
	/* ύXtO */
	ret |= DIALOG_RET_CHANGE ;
	EndDialog( hDlg, ret ) ;
	return TRUE ;
}

BOOL
SetupDialogExec( HINSTANCE hInst, HWND hWnd )
{
	BOOL			ret ;
	SetupDialog		*pDialog = new SetupDialog( hInst ) ;

	ret = DialogBoxParam( hInst, MAKEINTRESOURCE(IDD_DLG_SETUP), hWnd, (DLGPROC) DlgProc, (LPARAM) pDialog ) ;
	delete pDialog ;
	return ret ;
}
