// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "FrotzCE.h"

#include "FrotzCEDoc.h"
#include "FrotzCEView.h"

extern "C"
{
#include "Frotz/Frotz.h"
}

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Array tbSTDButton contains relevant buttons of bitmap IDB_STD_SMALL_COLOR

static TBBUTTON g_tbSTDButton[] = {
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0,  0},  
	{0, ID_RESTORE,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{1, ID_SAVE,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{2, ID_UNDO,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
	{3, ID_NORTH,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{4, ID_SOUTH,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{5, ID_EAST,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{6, ID_WEST,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{7, ID_UP,			TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{8, ID_DOWN,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
	{9, ID_LOOK,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{10, ID_TAKE,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{11, ID_DROP,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{12, ID_GO,			TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{13, ID_OPEN,		TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
	{14, ID_INVENTORY,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0,  0}
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_MESSAGE(WM_UPDATE_MENU, OnUpdateMenu)
	ON_COMMAND(ID_SMALLFONT, OnSmallfont)
	ON_COMMAND(ID_BOLDFONT, OnBoldfont)
	ON_UPDATE_COMMAND_UI(ID_BOLDFONT, OnUpdateBoldfont)
	ON_UPDATE_COMMAND_UI(ID_SMALLFONT, OnUpdateSmallfont)
	ON_COMMAND(ID_COLOURS, OnColours)
	ON_UPDATE_COMMAND_UI(ID_COLOURS, OnUpdateColours)
	ON_COMMAND(ID_STYLES, OnStyles)
	ON_UPDATE_COMMAND_UI(ID_STYLES, OnUpdateStyles)
	ON_COMMAND(ID_EXPANDABBREV, OnExpandabbrev)
	ON_UPDATE_COMMAND_UI(ID_EXPANDABBREV, OnUpdateExpandabbrev)
	ON_COMMAND(ID_IGNOREERRORS, OnIgnoreerrors)
	ON_UPDATE_COMMAND_UI(ID_IGNOREERRORS, OnUpdateIgnoreerrors)
	ON_COMMAND(ID_TANDY, OnTandy)
	ON_UPDATE_COMMAND_UI(ID_TANDY, OnUpdateTandy)
	ON_COMMAND(ID_SHOWCOMMANDBAR, OnShowcommandbar)
	ON_WM_SIZE()
	ON_COMMAND(ID_TERMINALFONT, OnTerminalfont)
	ON_UPDATE_COMMAND_UI(ID_TERMINALFONT, OnUpdateTerminalfont)
	ON_UPDATE_COMMAND_UI(ID_SHOWCOMMANDBAR, OnUpdateShowcommandbar)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_bShowCommandBar = TRUE;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
#if _WIN32_WCE <= 200
	// Add Exit and Help buttons
	if (!AddAdornments( 0 /*CMDBAR_HELP*/ ))
	{
		TRACE0("Failed to add exit and help buttons\n");
		return -1; 
	}
#else
	// Create command bar
	if (!m_cCommandBar.Create( this ))
	{
		TRACE0("Failed to create command bar\n");
		return -1;
	}

	// Set command bar style
	m_cCommandBar.SetBarStyle( m_cCommandBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_FIXED );

	// Add the menu first
	m_cCommandBar.InsertMenuBar( IDR_MAINFRAME );

	if (!m_cCommandBar.AddAdornments( 0 /*CMDBAR_HELP*/ ))
	{
		TRACE0("Failed to add exit and help buttons\n");
		return -1; 
	}
#endif

#if _WIN32_WCE <= 200
	// Save command bar height
	m_nCmdBarHeight = CommandBar_Height( m_hCommandBar );
#else
	// Save command bar height
	m_nCmdBarHeight = CommandBar_Height( m_cCommandBar.m_hWnd );
#endif

	return 0;
}

void CMainFrame::OnUpdateMenu()
{
#if _WIN32_WCE <= 200
	// Clear the command bar
	m_hCommandBar = m_poCommandBar->Reset();

	m_hCommandBarMenu = NULL;
#else
	// Clear the command bar
	m_cCommandBar.ResetCommandBar();
#endif

	// Z-machine running?
	if (FROTZCEAPP->m_bZmachineRunning == FALSE)
	{
#if _WIN32_WCE <= 200
		// Add the menu first
		m_hCommandBarMenu = InsertMenu( IDR_MAINFRAME );

		// Show command bar
		CommandBar_Show( m_hCommandBar, TRUE );

		// Save command bar height
		m_nCmdBarHeight = CommandBar_Height( m_hCommandBar );
#else
		// Add the menu first
		m_cCommandBar.InsertMenuBar( IDR_MAINFRAME );

		// Show command bar
		CommandBar_Show( m_cCommandBar.m_hWnd, TRUE );

		// Save command bar height
		m_nCmdBarHeight = CommandBar_Height( m_cCommandBar.m_hWnd );
#endif
	}
	else
	{
#if _WIN32_WCE <= 200
		// Add the menu first
		m_hCommandBarMenu = InsertMenu( IDR_GAMEMENU );
#else
		// Add the menu first
		m_cCommandBar.InsertMenuBar( IDR_GAMEMENU );
#endif

		// Add button bar
		if (!InsertButtons( g_tbSTDButton, 
#ifdef _WIN32_WCE_PSPC
						   4, 
#else
						   sizeof(g_tbSTDButton)/sizeof(TBBUTTON), // NButtons
#endif
						   IDR_MAINFRAME,	                       // toolbar bitmap
						   15 ))                                    // NImages
		{
			TRACE0("Failed to add command bar buttons\n");
			return;
		}

#if _WIN32_WCE <= 200
		// Show or hide command bar
		CommandBar_Show( m_hCommandBar, m_bShowCommandBar );

		// Save command bar height
		m_nCmdBarHeight = CommandBar_Height( m_hCommandBar );
#else
		// Show or hide command bar
		CommandBar_Show( m_cCommandBar.m_hWnd, m_bShowCommandBar );

		// Save command bar height
		m_nCmdBarHeight = CommandBar_Height( m_cCommandBar.m_hWnd );
#endif
	}

	// Add Exit and Help buttons
#if _WIN32_WCE <= 200
	if (!AddAdornments( 0 /*CMDBAR_HELP*/ ))
#else
	if (!m_cCommandBar.AddAdornments( 0 /*CMDBAR_HELP*/ ))
#endif
	{
		TRACE0("Failed to add exit and help buttons\n");
		return; 
	}
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

void CMainFrame::OnSmallfont() 
{
	if (FROTZCEAPP->m_nFontHeight == 0) 
	{
		FROTZCEAPP->m_nFontHeight = SMALL_FONT_HEIGHT;
		FROTZCEAPP->m_nFontWidth = SMALL_FONT_WIDTH;
	}
	else 
	{
		FROTZCEAPP->m_nFontHeight = 0;
		FROTZCEAPP->m_nFontWidth = 0;
	}
}

void CMainFrame::OnTerminalfont() 
{
	if (FROTZCEAPP->m_nFontWidth != TERMINAL_FONT_WIDTH) 
	{
		FROTZCEAPP->m_nFontHeight = TERMINAL_FONT_HEIGHT;
		FROTZCEAPP->m_nFontWidth = TERMINAL_FONT_WIDTH;
	}
	else 
	{
		FROTZCEAPP->m_nFontHeight = 0;
		FROTZCEAPP->m_nFontWidth = 0;
	}
}

void CMainFrame::OnBoldfont() 
{ 
	if (FROTZCEAPP->m_nDefaultStyle == NORMAL_STYLE) 
		FROTZCEAPP->m_nDefaultStyle = BOLDFACE_STYLE;
	else FROTZCEAPP->m_nDefaultStyle = NORMAL_STYLE;
}

void CMainFrame::OnUpdateBoldfont(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( (FROTZCEAPP->m_nDefaultStyle != NORMAL_STYLE) );
}

void CMainFrame::OnUpdateSmallfont(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( (FROTZCEAPP->m_nFontWidth != 0) );
}

void CMainFrame::OnUpdateTerminalfont(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( (FROTZCEAPP->m_nFontWidth == TERMINAL_FONT_WIDTH) );
}

void CMainFrame::OnColours() 
{
	if (FROTZCEAPP->m_bUseColours) FROTZCEAPP->m_bUseColours = FALSE;
	else FROTZCEAPP->m_bUseColours = TRUE;
}

void CMainFrame::OnUpdateColours(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( FROTZCEAPP->m_bUseColours );
}

void CMainFrame::OnStyles() 
{
	if (FROTZCEAPP->m_bUseStyles) FROTZCEAPP->m_bUseStyles = FALSE;
	else 
	{
		AfxMessageBox( TEXT( "Setting this option may result in irregular spacing" ) );
		FROTZCEAPP->m_bUseStyles = TRUE;
	}
}

void CMainFrame::OnUpdateStyles(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( FROTZCEAPP->m_bUseStyles );
}

void CMainFrame::OnExpandabbrev() 
{
	if (option_expand_abbreviations) option_expand_abbreviations = 0;
	else option_expand_abbreviations = 1;
}

void CMainFrame::OnUpdateExpandabbrev(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( (option_expand_abbreviations == 1) );
}

void CMainFrame::OnIgnoreerrors() 
{
	if (option_ignore_errors) option_ignore_errors = 0;
	else option_ignore_errors = 1;
}

void CMainFrame::OnUpdateIgnoreerrors(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( (option_ignore_errors == 1) );
}

void CMainFrame::OnTandy() 
{
	if (FROTZCEAPP->m_bTandy) FROTZCEAPP->m_bTandy = FALSE;
	else FROTZCEAPP->m_bTandy = TRUE;
}

void CMainFrame::OnUpdateTandy(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( FROTZCEAPP->m_bTandy );
}

void CMainFrame::OnShowcommandbar() 
{
	if (m_bShowCommandBar) m_bShowCommandBar = FALSE;
	else m_bShowCommandBar = TRUE;
}

void CMainFrame::OnUpdateShowcommandbar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( m_bShowCommandBar );
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);
	
	// Z Machine running?
	if (FROTZCEAPP->m_bZmachineRunning
		&& (nType == SIZE_RESTORED || nType == SIZE_MAXIMIZED))
	{
	CRect cRect;
	
		// Get frame window rectangle
		GetClientRect( cRect );

		// Subtract size of command bar if it's showing
		if (m_bShowCommandBar) cRect.top += m_nCmdBarHeight;

		// Resize the view to cover the entire frame window client area
		GetActiveView()->MoveWindow( cRect, FALSE );
	}
}
