#define		STRICT
#include	<windows.h>
#include	"config.h"
#include	"def.h"
#include	"cemain.h"

extern	int	ttrow ;
extern	int	ttcol ;
extern	int	tttop ;
extern	int	ttbot ;
extern	int	tthue ;

int		SG = 0 ;
int		tceeol ;			/* Costs are set later */
int		tcinsl ;
int		tcdell ;

int
ttinit()
{
	tceeol = ttcol ;
	tcdell = NROW * NCOL ;
	tcinsl = NROW * NCOL ;
	return 0 ;
}

int
tttidy()
{
	return 0 ;
}

int
ttmove( int row, int col )
{
	if ( ttrow != row || ttcol != col ) {
		GotoXY( col, row ) ;
		ttrow = row ;
		ttcol = col ;
	}
	return 0 ;
}

/*
 * Erase to end of line.
 */
int
tteeol()
{
	GotoXY( ttcol, ttrow ) ;
	EraseEOL() ;
	return 0 ;
}

int
ttnowindow()
{
	ttrow = HUGE ;
	ttcol = HUGE ;
	tttop = HUGE ;
	ttbot = HUGE ;
	return 0 ;
}

/*
 * Set the current writing color to the
 * specified color. Watch for color changes that are
 * not going to do anything (the color is already right)
 * and don't send anything to the display.
 * The rainbow version does this in putline.s on a
 * line by line basis, so don't bother sending
 * out the color shift.
 */
int
ttcolor( int color )
{
    if ( color != tthue ) {
		tthue = color ;			/* Save the color.	*/
    }
	return 0 ;
}

/*
 * Erase to end of page.
 */
int
tteeop()
{
	GotoXY( ttcol, ttrow ) ;
	EraseEOP() ;
	return 0 ;
}

/*
 * Delete nchunk line(s) from "row", replacing the
 * bottom line on the screen with a blank line.
 * Unless we're using the scrolling region, this is
 * done with a crafty sequences of insert and delete
 * lines.  The presence of the echo area makes a
 * boundry condition go away.
 */
int
ttdell( int row, int bot, int nchunk )
{
	ttrow = HUGE ;
	ttcol = HUGE ;
	return 0 ;
}

/*
 * Insert nchunk blank line(s) onto the
 * screen, scrolling the last line on the
 * screen off the bottom.  Use the scrolling
 * region if possible for a smoother display.
 * If no scrolling region, use a set
 * of insert and delete line sequences
 */
int
ttinsl( int row, int bot, int nchunk )
{
	ttrow = HUGE ;
	ttcol = HUGE ;
	return 0 ;
}

/*
 * Make a noise.
 */
int
ttbeep()
{
	return 0 ;
}

/*
 * This routine is called by the
 * "refresh the screen" command to try and resize
 * the display. The new size, which must be deadstopped
 * to not exceed the NROW and NCOL limits, it stored
 * back into "nrow" and "ncol". Display can always deal
 * with a screen NROW by NCOL. Look in "window.c" to
 * see how the caller deals with a change.
 */
int
ttresize()
{
	return 0 ;
}
