*** ..\..\ORG\CONFIG.H	Fri Jun 24 11:47:00 1994
--- CONFIG.H	Sat Nov 21 22:43:38 1998
***************
*** 8,20 ****
  #define		ZAPTOCHAR
  #define		JUMPERR
  #define		LINENUMOPT
! #define		KBD_BIOS
  
  /*----------------------------------------------------------------------*/
  /*	Features removeable to save space.				*/
  /*----------------------------------------------------------------------*/
  
! #undef	NO_BACKUP	/* Disable backup files when writing. */
  
  #undef	NO_DIR		/* Disable dir change functions.	*/
  			/* If defined, NO_STARTUP must be also. */
--- 8,20 ----
  #define		ZAPTOCHAR
  #define		JUMPERR
  #define		LINENUMOPT
! #undef		KBD_BIOS
  
  /*----------------------------------------------------------------------*/
  /*	Features removeable to save space.				*/
  /*----------------------------------------------------------------------*/
  
! #define	NO_BACKUP	/* Disable backup files when writing. */
  
  #undef	NO_DIR		/* Disable dir change functions.	*/
  			/* If defined, NO_STARTUP must be also. */
***************
*** 32,38 ****
  #undef	NO_MACRO	/* Disable keyboard macros.		*/
  			/* If defined, NO_STARTUP must be also. */
  
! #undef	NO_SHELL	/* Disable shell-command function. */
  
  #undef	NO_STARTUP	/* Disable startup files, load, etc. */
  
--- 32,38 ----
  #undef	NO_MACRO	/* Disable keyboard macros.		*/
  			/* If defined, NO_STARTUP must be also. */
  
! #define	NO_SHELL	/* Disable shell-command function. */
  
  #undef	NO_STARTUP	/* Disable startup files, load, etc. */
  
*** ..\..\ORG\DEF.H	Fri Jun 24 11:47:00 1994
--- DEF.H	Sat Nov 21 22:43:38 1998
***************
*** 334,339 ****
--- 334,352 ----
  #ifdef	HUMAN68K	/* 90.11.09    Sawayanagi Yosirou */
  extern	void	*malloc();
  #else	/* NOT HUMAN68K */
+ #ifndef	_WIN32
  extern	char	*malloc();
+ #endif	/* _WIN32 */
  #endif	/* HUMAN68K */
  #endif	/* MSDOS */
+ 
+ #ifdef	_WIN32
+ void	strcat_num( char *str, int num ) ;
+ void	strcat_char( char *str, int c ) ;
+ int		strnicmp( const char *src, const char *dst, int len ) ;
+ int		stricmp( const char *src, const char *dst ) ;
+ int		chdir( const char *dir ) ;
+ int		Sprintf( char *buf, const char *fmt, ... ) ;
+ #define	exit(rc)	Exit(rc)
+ #define	sprintf		Sprintf
+ #endif	/* _WIN32 */
*** ..\..\ORG\DISPLAY.C	Fri Jun 24 11:47:00 1994
--- DISPLAY.C	Sat Nov 21 22:43:38 1998
***************
*** 783,788 ****
--- 783,791 ----
   * reverse video works on most terminals.
   */
  VOID uline(row, vvp, pvp) VIDEO *vvp; VIDEO *pvp; {
+ #ifdef	_WIN32
+ 	putline( row, 0, &vvp->v_text[0], &vvp->v_sub[0], vvp->v_color ) ;
+ #else	/* _WIN32 */
  #ifdef	MEMMAP
  	ttflush();	/* 90.06.09  by A.Shirahashi */
  #ifdef	PC9801	/* 90.03.24  by A.Shirahashi */
***************
*** 989,994 ****
--- 992,998 ----
  #endif
          ttflush(); /* 90.06.09  by A.Shirahashi */
  #endif  /* MEMMAP */
+ #endif	/* _WIN32 */
  }
  
  /*
*** ..\..\ORG\ECHO.C	Fri Jun 24 11:47:00 1994
--- ECHO.C	Sat Nov 21 22:43:38 1998
***************
*** 15,25 ****
--- 15,29 ----
  #include	"config.h"	/* 90.12.20  by S.Yoshida */
  #include	"def.h"
  #include	"key.h"
+ #ifdef	_WIN32
+ #include	<stdarg.h>
+ #else	/* _WIN32 */
  #ifdef	LOCAL_VARARGS
  #include	"varargs.h"
  #else
  #include	<varargs.h>
  #endif
+ #endif	/* _WIN32 */
  #ifndef NO_MACRO
  #  include	"macro.h"
  #endif
***************
*** 136,141 ****
--- 140,158 ----
   * completion, and the return is echoed as such.
   */
  /*VARARGS 0*/
+ #ifdef	_WIN32
+ int
+ ereply( char *fp, char *buf, int nbuf, ... )
+ {
+ 	int			i ;
+ 	va_list		pvar ;
+ 
+ 	va_start( pvar, nbuf ) ;
+ 	i = veread( fp, buf, nbuf, EFNEW|EFCR, &pvar ) ;
+ 	va_end( pvar ) ;
+ 	return i ;
+ }
+ #else	/* _WIN32 */
  ereply(va_alist)
  va_dcl
  {
***************
*** 152,157 ****
--- 169,175 ----
  	va_end(pvar);
  	return i;
  }
+ #endif	/* _WIN32 */
  
  /*
   * This is the general "read input from the
***************
*** 163,168 ****
--- 181,199 ----
   * the carriage return as CR).
   */
  /* VARARGS 0 */
+ #ifdef	_WIN32
+ int
+ eread( char *fp, char *buf, int nbuf, int flag, ... )
+ {
+ 	int			i ;
+ 	va_list		pvar ;
+ 
+ 	va_start( pvar, flag ) ;
+ 	i = veread( fp, buf, nbuf, flag, &pvar ) ;
+ 	va_end( pvar ) ;
+ 	return i ;
+ }
+ #else	/* _WIN32 */
  eread(va_alist)
  va_dcl
  {
***************
*** 179,184 ****
--- 210,216 ----
  	va_end(pvar);
  	return i;
  }
+ #endif	/* _WIN32 */
  
  #ifdef	NEW_COMPLETE	/* 90.12.10    Sawayanagi Yosirou */
  #include    "complt.h"
***************
*** 845,850 ****
--- 877,903 ----
   * to the standard formatting routine.
   */
  /*VARARGS 0 */
+ #ifdef	_WIN32
+ VOID
+ ewprintf( char *fp, ... )
+ {
+ 	va_list		pvar ;
+ 
+ #ifndef NO_MACRO
+ 	if ( inmacro ) {
+ 		return ;
+ 	}
+ #endif
+ 	va_start( pvar, fp ) ;
+ 	ttcolor( CTEXT ) ;
+ 	ttmove( nrow - 1, 0 ) ;
+ 	eformat( fp, &pvar ) ;
+ 	va_end( pvar ) ;
+ 	tteeol() ;
+ 	ttflush() ;
+ 	epresf = TRUE ;
+ }
+ #else	/* _WIN32 */
  VOID
  ewprintf(va_alist)
  va_dcl
***************
*** 865,870 ****
--- 918,924 ----
  	ttflush();
  	epresf = TRUE;
  }
+ #endif	/* _WIN32 */
  
  /*
   * Printf style formatting. This is
*** ..\..\ORG\FILEIO.C	Fri Jun 24 11:47:00 1994
--- FILEIO.C	Sat Nov 21 22:43:40 1998
***************
*** 16,21 ****
--- 16,25 ----
  char	*adjustname();
  char	*fftolower();	/* 90.07.01  Add by S.Yoshida */
  
+ void bufetos( char *p, int len) ;
+ void kputc(int c, FILE *fp, int kfio) ;
+ void kfselectcode(FILE *fp, int next_is_k) ;
+ 
  /*
   * Open a file for reading.
   */
***************
*** 148,154 ****
   */
  fbackupfile(fn) char *fn; {
  	register char	*nname;
! 	void		*malloc();	/* 90.03.27  by A.Shirahashi */
  	char		*dotp;		/* 90.07.26  Add by N.Kamei */
  	VOID		strmfe();	/* 90.07.26  Add by N.Kamei */
  	char fns[NFILEN];
--- 152,158 ----
   */
  fbackupfile(fn) char *fn; {
  	register char	*nname;
! //	void		*malloc();	/* 90.03.27  by A.Shirahashi */
  	char		*dotp;		/* 90.07.26  Add by N.Kamei */
  	VOID		strmfe();	/* 90.07.26  Add by N.Kamei */
  	char fns[NFILEN];
*** ..\..\ORG\JUMP.C	Fri Jun 24 11:47:00 1994
--- JUMP.C	Sat Nov 21 22:43:40 1998
***************
*** 7,13 ****
--- 7,17 ----
  #include "config.h"
  #ifdef	JUMPERR
  
+ #ifdef	_WIN32
+ #define index(s,c)	strchr(s,c)
+ #else	/* _WIN32 */
  #include <stdio.h>
+ #endif	/* _WIN32 */
  #include "def.h"
  #ifdef	MSDOS
  # include <stdlib.h>
***************
*** 132,138 ****
--- 136,144 ----
      while( col < llength(curwp->w_dotp) &&
  	  parse_error_message( curwp->w_dotp, col, buf, &lineno, &col ) ){
  
+ #ifndef	_WIN32
  	if(0 == access( buf, R_OK )){
+ #endif	/* _WIN32 */
  	    /* ewprintf( "file:`%s' line %d", buf, lineno ); */
  	    /*
  	     * All the hairly works to give filename to filevisit() is done
***************
*** 144,150 ****
--- 150,158 ----
  		return FALSE;
  	    gotoline( FFARG, lineno );
  	    return TRUE;
+ #ifndef	_WIN32
  	}
+ #endif	/* _WIN32 */
      }
      return FALSE;
  }
*** ..\..\ORG\KANJI.C	Fri Jun 24 11:47:00 1994
--- KANJI.C	Thu Nov 26 16:49:16 1998
***************
*** 985,994 ****
--- 985,1003 ----
  /*
   * Output one byte to the file with KANJI code conversion.
   */
+ #ifdef	_WIN32
+ #undef		putc
+ #define		putc(c,fp)		Fputc(c)
+ extern	int		Fputc( int c ) ;
+ 
+ void
+ kputc( int c, int kfio )
+ #else	/* _WIN32 */
  kputc(c, fp, kfio)
  register int	c;	/* 90.07.25  Add "register". by S.Yoshida */
  register FILE	*fp;
  register int	kfio;
+ #endif	/* _WIN32 */
  {
  	static	int	c1 = '\0';	/* 91.01.15  NULL -> '\0' */
  
***************
*** 1115,1123 ****
--- 1124,1137 ----
   * select escape sequence to the file if nessesary.
   * You must not call this function when file I/O code is not JIS.
   */
+ #ifdef	_WIN32
+ int
+ kfselectcode( int next_is_k )
+ #else	/* _WIN32 */
  kfselectcode(fp, next_is_k)
  register FILE	*fp;
  register int	next_is_k;		/* Is next code KANJI ? */
+ #endif	/* _WIN32 */
  {
  	if (kfselected && !next_is_k) {	/* Now KANJI && next is ASCII	*/
  		putc(ESC, fp);		/* Select ASCII code.		*/
***************
*** 1660,1662 ****
--- 1674,1750 ----
  }
  #endif	/* KANJI */
  
+ #ifdef	_WIN32
+ void
+ putline( int row, int column, unsigned char *s, unsigned char *t, short color )
+ {
+ 	int				c, c1 = 0, c2 ;
+ 	unsigned char	sjis[ 256 ], *dst, *cp1, *cp2, *ccp1 ;
+ 
+ 	dst = sjis ;
+ 	cp1 = &s[0] ;
+ 	cp2 = &s[ncol] ;
+ 	ccp1 = &t[0] ;
+ 	while ( cp1 != cp2 ) {
+ 		c = *cp1 ++ ;
+ 		c2 = *ccp1 ++ ;
+ 		if ( c1 ) {
+ 			etos( c1, c ) ;
+ 			*dst++ = c1 ;
+ 			*dst++ = c ;
+ 			c1 = 0 ;
+ 		} else if ( (c & 0xFF) == 0x8E && c2 != 0 ) {
+ 			*dst++ = c2 ;
+ 		} else if ( ISKANJI( c ) ) {
+ 			c1 = c ;
+ 		} else {
+ 			*dst++ = c ;
+ 		}
+ 	}
+ 	*dst = 0 ;
+ 	PutLine( row, sjis, color == CMODE ? 1 : 0 ) ;
+ }
+ 
+ int
+ euc2sjis_crlf( char *dst, const char *euc, int len )
+ {
+ 	int			c1, c2, count ;
+ 	const char	*endp = euc + len ;
+ 
+ 	count = 0 ;
+ 	while ( euc < endp ) {
+ 		c1 = *euc++ & 0xff ;
+ 		if ( ISKANJI( c1 ) ) {
+ #ifdef HANKANA
+ 			if ( c1 == 0x8e ) {
+ 				if ( dst ) {
+ 					*dst++ = *euc++ ;
+ 				}
+ 				count ++ ;
+ 			} else
+ #endif  /* HANKANA */
+ 			{
+ 				c2 = *euc++ & 0xff ;
+ 				etos( c1, c2 ) ;
+ 				if ( dst ) {
+ 					*dst++ = c1 ;
+ 					*dst++ = c2 ;
+ 				}
+ 				count += 2 ;
+ 			}
+ 		} else if ( c1 == '\n' ) {
+ 			if ( dst ) {
+ 				*dst++ = '\r' ;
+ 				*dst++ = '\n' ;
+ 			}
+ 			count += 2 ;
+ 		} else {
+ 			if ( dst ) {
+ 				*dst++ = c1 ;
+ 			}
+ 			count ++ ;
+ 		}
+ 	}
+ 	return count ;
+ }
+ #endif	/* _WIN32 */
*** ..\..\ORG\KEYMAP.C	Fri Jun 24 11:47:00 1994
--- KEYMAP.C	Thu Nov 26 19:41:05 1998
***************
*** 334,339 ****
--- 334,342 ----
  extern	int	fepmode_set();		/* Set FEP control mode		*/
  extern	int	fepmode_chg();		/* Change FEP control mode	*/
  #endif
+ #ifdef	_WIN32
+ extern	int	toggle_fep() ;
+ #endif	/* _WIN32 */
  
  /* defined by "version.c" */
  
***************
*** 624,630 ****
--- 627,637 ----
  	pagenext,	/* ^V */
  };
  static	PF	metasp[] = {
+ #ifdef	_WIN32
+ 	toggle_fep,
+ #else	/* _WIN32 */
  	justone,	/* space */
+ #endif	/* _WIN32 */
  #ifndef NO_SHELL	/* 91.01.10  by K.Maeda */
  	shellcmnd,	/* ! */
  #endif	/* NO_SHELL */
***************
*** 1385,1390 ****
--- 1392,1400 ----
  #endif
  	{usebuffer,	"switch-to-buffer"},
  	{poptobuffer,	"switch-to-buffer-other-window"},
+ #ifdef	_WIN32
+ 	{toggle_fep,	"toggle-fep"},
+ #endif	/* _WIN32 */
  #ifdef	READONLY	/* 91.01.05  by S.Yoshida */
  	{togglereadonly, "toggle-read-only"},
  #endif	/* READONLY */
*** ..\..\ORG\KINIT.H	Fri Jun 24 11:47:00 1994
--- KINIT.H	Sat Nov 21 22:43:40 1998
***************
*** 23,32 ****
--- 23,39 ----
  #define	KINPUT		SJIS		/* kanji-input-code		*/
  #define	KDISPLAY	SJIS		/* kanji-display-code		*/
  #else	/* NOT HUMAN68K */
+ #ifdef	_WIN32
+ #define	KFIO		SJIS	/* default-kanji-fileio-code	*/
+ #define	KEXPECT		T		/* kanji-expected-code		*/
+ #define	KINPUT		SJIS	/* kanji-input-code		*/
+ #define	KDISPLAY	SJIS	/* kanji-display-code		*/
+ #else	/* _WIN32 */
  #define	KFIO		NIL		/* default-kanji-fileio-code	*/
  #define	KEXPECT		T		/* kanji-expected-code		*/
  #define	KINPUT		EUC		/* kanji-input-code		*/
  #define	KDISPLAY	EUC		/* kanji-display-code		*/
+ #endif	/* _WIN32 */
  #endif	/* HUMAN68K */
  #endif	/* MSDOS */
  
*** ..\..\ORG\LINE.C	Fri Jun 24 11:47:00 1994
--- LINE.C	Mon Dec 07 00:44:56 1998
***************
*** 22,27 ****
--- 22,32 ----
  #include	"config.h"	/* 90.12.20  by S.Yoshida */
  #include	"def.h"
  
+ #ifdef	_WIN32
+ extern	int		send_clipboard( void ) ;
+ extern	int		receive_clipboard( void ) ;
+ #endif	/* _WIN32 */
+ 
  /* number of bytes member is from start of structure type	*/
  /* should be computed at compile time				*/
  
***************
*** 417,422 ****
--- 422,430 ----
  		}
  		n -= chunk;
  	}
+ #ifdef	_WIN32
+ 	send_clipboard() ;
+ #endif	/* _WIN32 */
  	return TRUE;
  }
  
***************
*** 607,612 ****
--- 615,623 ----
  	if (dir == KFORW) kbufp[kused++] = c;
  	else if (dir == KBACK) kbufp[--kstart] = c;
  	else panic("broken kinsert call");		/* Oh shit! */
+ #ifdef	_WIN32
+ 	send_clipboard() ;
+ #endif	/* _WIN32 */
  	return (TRUE);
  }
  
***************
*** 649,651 ****
--- 660,730 ----
  		return -1;
  	return CHARMASK(kbufp[n + kstart]);
  }
+ 
+ #ifdef	_WIN32
+ int		SendClipboard( const char *sjis ) ;
+ int		ReceiveClipboard( char *sjis ) ;
+ int		euc2sjis_crlf( char *dst, const char *euc, int len ) ;
+ 
+ int
+ send_clipboard( void )
+ {
+ 	char	*sjis, *euc ;
+ 	int		count, rc, len ;
+ 
+ 	euc = &kbufp[ kstart ] ;
+ 	len = kused - kstart ;
+ 	count = euc2sjis_crlf( NULL, euc, len ) ;
+ 	/* SJISi[̈mۂ */
+ 	sjis = malloc( count + 1 ) ;
+ 	if ( !sjis ) {
+ 		return 0 ;
+ 	}
+ 	/* EUCSJISɕϊ */
+ 	euc2sjis_crlf( sjis, euc, len ) ;
+ 	sjis[ count ] = 0 ;
+ 	/* obt@Nbv{[hɓ] */
+ 	rc = SendClipboard( sjis ) ;
+ 	/* mۂ */
+ 	free( sjis ) ;
+ 	return rc ;
+ }
+ 
+ int
+ receive_clipboard( void )
+ {
+ 	int		len, size ;
+ 	char	*sjis, *src, *dst, c ;
+ 
+ 	kdelete() ;
+ 	size = ReceiveClipboard( NULL ) ;
+ 	if ( !size ) {
+ 		return 1 ;
+ 	}
+ 	sjis = malloc( size ) ;
+ 	if ( !sjis ) {
+ 		return 0 ;
+ 	}
+ 	*sjis = 0 ;
+ 	ReceiveClipboard( sjis ) ;
+ 	dst = src = sjis ;
+ 	while ( c = *src++ ) {
+ 		if ( c != '\r' ) {
+ 			*dst++ = c ;
+ 		}
+ 	}
+ 	*dst = 0 ;
+ 	len = strlen( sjis ) ;
+ 	ksize = bufstoe_c( sjis, len + 1 ) ;
+ 	ksize = (ksize + KBLOCK - 1) / KBLOCK * KBLOCK ;
+ 	kbufp = malloc( ksize ) ;
+ 	if ( !kbufp ) {
+ 		ksize = 0 ;
+ 		return 0 ;
+ 	}
+ 	strcpy( kbufp, sjis ) ;
+ 	kused = bufstoe( kbufp, len ) ;
+ 	kstart = 0 ;
+ 	return 1 ;
+ }
+ #endif	/* _WIN32 */
*** ..\..\ORG\MAIN.C	Fri Jun 24 11:47:00 1994
--- MAIN.C	Sat Nov 21 22:43:40 1998
***************
*** 21,30 ****
--- 21,35 ----
  
  static VOID	edinit();
  
+ #ifdef	_WIN32
+ int
+ Main( int argc, char **argv )
+ #else	/* _WIN32 */
  VOID
  main(argc, argv)
  int  argc;
  char **argv;
+ #endif	/* _WIN32 */
  {
  #ifndef NO_STARTUP
  	char	*startupfile();
***************
*** 87,92 ****
--- 92,109 ----
  		bufstoe(argve, strlen(argve) + 1);
  		cp = adjustname(argve);
  #else
+ #ifdef	_WIN32
+ #ifdef LINENUMOPT
+ 		static unsigned lno =0;
+ 
+ 		if( argv[1][0] == '+' && ISDIGIT(argv[1][1]) ){
+ 			lno = atoi(&argv[1][1]);
+ 			++argv;
+ 			continue;
+ 		}
+ 
+ #endif
+ #endif	/* _WIN32 */
  		cp = adjustname(*++argv);
  #endif
  #ifndef NO_DIRED	/* 91.01.16  by S.Yoshida */
*** ..\..\ORG\RANDOM.C	Fri Jun 24 11:47:00 1994
--- RANDOM.C	Thu Nov 26 17:30:32 1998
***************
*** 606,611 ****
--- 606,616 ----
  #endif	/* READONLY */
  
  	if (n < 0) return FALSE;
+ #ifdef	_WIN32
+ 	if ( !receive_clipboard() ) {
+ 		return FALSE ;
+ 	}
+ #endif	/* _WIN32 */
  	nline = 0;				/* Newline counting.	*/
  	while (n--) {
  		isetmark();			/* mark around last yank */
*** ..\..\ORG\SPAWN.C	Fri Jun 24 11:47:00 1994
--- SPAWN.C	Sat Nov 21 22:43:40 1998
***************
*** 8,13 ****
--- 8,20 ----
  #include	"config.h"	/* 90.12.20  by S.Yoshida */
  #include	"def.h"
  
+ #ifdef	_WIN32
+ int
+ spawncli( int f, int n )
+ {
+ 	return FALSE ;
+ }
+ #else	/* _WIN32 */
  #include	<signal.h>
  #include	<process.h>
  
***************
*** 175,177 ****
--- 182,185 ----
  	return tmp;
  }
  #endif	/* NO_SHELL */
+ #endif	/* _WIN32 */
*** ..\..\ORG\SYSDEF.H	Fri Jun 24 11:47:00 1994
--- SYSDEF.H	Sat Nov 21 22:43:40 1998
***************
*** 1,12 ****
--- 1,22 ----
  /*
   *		MS-DOS based systems
   */
+ #ifdef	_WIN32_WCE
+ #ifndef	NULL
+ #ifdef	__cplusplus
+ #define	NULL	0
+ #else
+ #define	NULL	((void *)0)
+ #endif
+ #endif
+ #else	/* _WIN32_WCE */
  #include <stdio.h>
  #ifdef	__TURBOC__	/* 90.03.23  by A.Shirahashi */
  #include <mem.h>
  #else	/* NOT __TURBOC__ */
  #include <memory.h>			/* need to use memmove().	*/
  #endif	/* __TURBOC__ */
+ #endif	/* _WIN32_WCE */
  
  #define	KBLOCK	1024			/* Kill grow.			*/
  #define	GOOD	0			/* Good exit status.		*/
*** ..\..\ORG\VERSION.C	Fri Jun 24 11:47:00 1994
--- VERSION.C	Thu Nov 26 18:08:36 1998
***************
*** 45,50 ****
--- 45,53 ----
  #else	/* NOT KANJI */
  char version[] = "Mg 2a (formerly MicroGnuEmacs)";
  #endif	/* KANJI */
+ #ifdef	_WIN32
+ extern	unsigned int	g_dwAppVersion ;
+ #endif	/* _WIN32 */
  
  /*
   * Display the version. All this does
***************
*** 132,138 ****
  {
  	register BUFFER	*bp;
  	register WINDOW	*wp;
! 	char	 line[80];
  
  	if ((bp = bfind("*Ng Version*", TRUE)) == NULL) return FALSE;
  	if (bclear(bp) != TRUE) return FALSE;
--- 135,141 ----
  {
  	register BUFFER	*bp;
  	register WINDOW	*wp;
! 	char	 line[80], *ptr;
  
  	if ((bp = bfind("*Ng Version*", TRUE)) == NULL) return FALSE;
  	if (bclear(bp) != TRUE) return FALSE;
***************
*** 140,147 ****
--- 143,162 ----
  
  	strcpy(line, "Ng version:");
  	if (addline(bp, line) == FALSE) return FALSE;
+ #ifdef	_WIN32
+ 	ptr = line ;
+ 	strcpy( ptr, "\tNg for WinCE V" ) ;
+ 	ptr += strlen( ptr ) ;
+ 	*ptr++ = '0' + (char) ((g_dwAppVersion / 100) % 10) ;
+ 	*ptr++ = '.' ;
+ 	*ptr++ = '0' + (char) ((g_dwAppVersion / 10)  % 10) ;
+ 	*ptr++ = '0' + (char) (g_dwAppVersion         % 10) ;
+ 	sprintf( ptr, "  [%s]", version ) ;
+ 	if (addline(bp, line) == FALSE) return FALSE;
+ #else	/* _WIN32 */
  	sprintf(line, "\t%s", version);
  	if (addline(bp, line) == FALSE) return FALSE;
+ #endif	/* _WIN32 */
  	strcpy(line, "Compile time options:");
  	if (addline(bp, line) == FALSE) return FALSE;
  #ifndef	NO_BACKUP
***************
*** 242,249 ****
--- 257,279 ----
   */
  printversion()
  {
+ #ifdef	_WIN32
+ 	char	buf[ 128 ], *ptr = buf ;
+ 	extern	void	MessageOut( const char * ) ;
+ 
+ 	strcpy( ptr, "Ng for WinCE V" ) ;
+ 	ptr += strlen( ptr ) ;
+ 	*ptr++ = '0' + (char) ((g_dwAppVersion / 100) % 10) ;
+ 	*ptr++ = '.' ;
+ 	*ptr++ = '0' + (char) ((g_dwAppVersion / 10)  % 10) ;
+ 	*ptr++ = '0' + (char) (g_dwAppVersion         % 10) ;
+ 	strcpy( ptr, "\r\nbased on " ) ;
+ 	strcat( ptr, version ) ;
+ 	MessageOut( buf ) ;
+ #else	/* _WIN32 */
  	printf("Ng version:\n");
  	printf("\t%s\n", version);
+ #endif	/* _WIN32 */
  	return TRUE;
  }
  
***************
*** 252,257 ****
--- 282,288 ----
   */
  printoptions()
  {
+ #ifndef	_WIN32
  	printf("Compile time options:\n");
  #ifndef	NO_BACKUP
  	printf("%s\n", backup_msg);
***************
*** 316,321 ****
--- 347,353 ----
  #ifndef	NO_STARTUP
  	printf("%s\n", startup_msg);
  #endif
+ #endif	/* _WIN32 */
  
  	return TRUE;
  }
