// Copyright (c) 1995 K.Yoshizawa (PAF02413.niftyserve.or.jp)
// This file is partially derived from nt.h which is ...
// Copyright (c) 1990,1991,1992 Chris and John Downey 

/***

* program name:
    wvi
* function:
    PD version of UNIX "vi" editor for WIN32, with extensions.
* module name:
    win32.h
* module function:
    Definitions for Windows NT system interface module.
* history:
    STEVIE - ST Editor for VI Enthusiasts, Version 3.10
    Originally by Tim Thompson (twitch!tjt)
    Extensive modifications by Tony Andrews (onecom!wldrdg!tony)
    Heavily modified by Chris & John Downey
	modified for WIN32 / UNICODE / C++ by K.Yoshizawa
		(PAF02413.niftyserve.or.jp)

***/

//***************************************************************
//																*
// SECTION : MACROS for Win32									*
//																*
//***************************************************************

// A fake character for multi columns characters.
#define DUMMY_CHAR	0xffff

// Default file format.
#define DEF_TFF		fmt_DOS

// System file format (for pipe, preservation, etc).
#define SYSTEM_TFF	fmt_DOS

// Default file code type.
#define DEF_TCT		CODETYPE_MULTIBYTE

// Pipe code type.
#define PIPE_TCT	CODETYPE_MULTIBYTE

// Preserve file code type.
#define PRESERVE_TCT	CODETYPE_UNICODE

// System-dependent constants - these are needed by file i/o routines.
// I hope that these are enough size ...
#define  MAXPATHLEN	1024	// path
#define  MAXNAMLEN  256		// file name
#define  MAXENVLEN  256		// environment variable

// Default value for helpfile parameter.
#ifndef HELPFILE
#   define  HELPFILE	L"c:\\usr\\lib\\help.wvi"
#endif

// The number of reserved lines (system lines) at the bottom of
// the console. (for IME status line, etc.)
//#define SYSLINE 0		// If you don't want any system lines...
#define SYSLINE	1		// for most CJK usr...

#define set_default_colors() ConsoleAutoSetupColor()

//***************************************************************
//																*
// SECTION : GLOBAL VARIABLES AND PROTOTYPES FOR win32.cpp		*
//																*
//***************************************************************

// Error

_declspec(thread) extern LPSTR lpszFatalErrorFileName;
_declspec(thread) extern int iFatalErrorLine;

void Win32ApiFatalError(LPWSTR format, ...);

// This is a tricky macro ...
#define API_FATAL						\
	lpszFatalErrorFileName=__FILE__,	\
	iFatalErrorLine=__LINE__,			\
	Win32ApiFatalError

// Screen dimensions

extern int iRows, iColumns;

// Console

extern HANDLE hStdIn, hStdOut, hStdErr;

int ConsoleGetc(DWORD dwMsecTimeout = 0);

int ConsolePutc(WCHAR ch, HANDLE hConsole = hStdOut);
int ConsolePuts(LPCWSTR lpcsz, HANDLE hConsole = hStdOut);
int ConsoleHprintf(HANDLE hConsole, LPCWSTR lpcszFormat, ...);
int ConsolePrintf(LPCWSTR lpcszFormat, ...);
void ConsoleFlushOutput();
void ConsoleEraseScreen();
void ConsoleEraseLine();
void ConsoleMoveCursor(int iRow, int iCol);
void ConsoleScrollDown(int iStartRow, int iEndRow, int iLines);
void ConsoleScrollUp(int iStartRow, int iEndRow, int iLines);

void ConsoleAutoSetupColor();
void ConsoleSelectColor(int n);

void ConsoleViMode();
void ConsoleNormalMode();

// File

#define FILESTREAMBUFSIZE 0x10000

struct FILESTREAM	// fs
{
	FILE		*fp;
	CODETYPE	ct;
	int			iChar;
	int			iPreFetched;	// for MULTIBYTE only
	BYTE		achBuf[FILESTREAMBUFSIZE];
};

typedef FILESTREAM *LPFILESTREAM;

BOOL FileExists(LPCWSTR lpcszFileName);
BOOL CanWriteOnFile(LPCWSTR lpcszFileName);
LPFILESTREAM FileOpen(LPCWSTR lpcszFileName, LPCWSTR lpcszMode, CODETYPE ct);
int FileClose(LPFILESTREAM lpfs);
int FileGetc(LPFILESTREAM lpfs);
int FileUngetc(int c, LPFILESTREAM lpfs);
LPWSTR FileGets(LPWSTR lpszBuf, int iBufSize, LPFILESTREAM lpfs);
int FilePutc(WCHAR wc, LPFILESTREAM lpfs);
int FilePuts(LPCWSTR lpcsz, LPFILESTREAM lpfs);
int FilePrintf(LPFILESTREAM lpfs, LPCWSTR lpcszFormat, ...);
LPWSTR TempFileName(LPCWSTR lpcszOriginalFileName);

// Signal

void IgnoreSignals();
void CatchSignals();

// Process

void SystemExit(int iReturnCode);
DWORD CallSystem(LPWSTR lpszCmdLine);
BOOL SystemPipe(LPCWSTR lpcszCmd, int (*WriteFunc)(LPFILESTREAM), int (*ReadFunc)(LPFILESTREAM));
//void SystemSuspend(void);
#define SystemSuspend()

// Environment
#define GetEnv(EnvName, EnvValue, Size) GetEnvironmentVariable(EnvName, EnvValue, Size)

// Misc.
void AlertBell();

BOOL set_codepage(Xviwin *window, Paramval new_value, BOOL interactive);

#define get_system_codepage() GetConsoleCP()

//***************************************************************
//																*
// SECTION : SCREEN CONTROL CAPABILITIES AND DUMMY FUNCTIONS	*
//																*
//***************************************************************

#define can_ins_line	FALSE
#define can_del_line	FALSE
#define can_scroll_area TRUE

// tty_linefeed() isn't needed if can_scroll_area is TRUE.
#define tty_linefeed()
#define can_inschar		FALSE
#define inschar(c)
#define cost_goto		0	// cost of tty_goto() 

#define tty_close()
#define vis_cursor()
#define invis_cursor()
#define insert_line()
#define delete_line()
#define delay()

// THIS SHOULD BE FIXED TO DO REAL FILENAME EXPANSION!!! 
#define fexpand(f)	(f)

