// Copyright (c) 1990,1991,1992 Chris and John Downey 

/***

* @(#)unicodde.h	2.1 (Chris & John Downey) 7/29/92

* program name:
    wvi
* function:
    PD version of UNIX "vi" editor for WIN32, with extensions.
* module name:
    unicodde.h (ex-ascii.h)
* module function:
    Keycode definitions for special keys - e.g. help, cursor arrow
    keys, page up, page down etc., & test & conversion macros for
    single characters.

    On systems that have any special keys, the routine 'inchar' in
    the terminal interface code should return one of the codes
    here.

    This file is specific to the ASCII character set; versions for
    other character sets could be implemented if required.
* history:
    STEVIE - ST Editor for VI Enthusiasts, Version 3.10
    Originally by Tim Thompson (twitch!tjt)
    Extensive modifications by Tony Andrews (onecom!wldrdg!tony)
    Heavily modified by Chris & John Downey
	modified for WIN32 / UNICODE / C++ by K.Yoshizawa
		(PAF02413.niftyserve.or.jp)

***/

// Tests on single characters.

#define iswoctdigit(c) (L'0'<=(wchar_t)(c)&&(wchar_t)(c)<=L'7')

// Conversions.
//
// Note that no argument validity checking is performed.
// Hexadecimal digit to binary integer.
#define hex_to_bin(h)	(iswdigit(h) ? (wchar_t)(h) - L'0': towupper(h) - L'A' + 10)

// Extended key code list.
// If you change this, change normal.c too.
//
// CAUTION !
// I don't know where is 'SAFE' free code area in UNICODE.
// I decided to use 0xd0xx, but this may cause problems ...
// (K.Y.)

#define K_EXTENDED_KEY_BASE	0xd000

enum
{
	K_HELP = K_EXTENDED_KEY_BASE,
	K_UNDO,
	K_INSERT,
	K_HOME,
	K_UARROW,
	K_DARROW,
	K_LARROW,
	K_RARROW,
	K_CGRAVE,		// control grave
	K_PGDOWN,
	K_PGUP,
	K_END,
	K_DELETE,

	K_FUNC_BASE		// This should be the last one.
};

// Function keys.
#define K_FUNC(n)	(K_FUNC_BASE+(n)<<16)

// Some common control characters.
#define ESC		0x001b
#define DEL		0x007f

#undef	CTRL
#define CTRL(x) 	((x) & 0x001f)
