// Copyright (c) 1990,1991,1992 Chris and John Downey 
#ifdef SCCID
static char *sccsid = "@(#)status.c 	2.1 (Chris & John Downey) 7/29/92";
#endif

/***

* program name:
	wvi
* function:
	PD version of UNIX "vi" editor for WIN32, with extensions.
* module name:
	status.c
* module function:
	Routines to print status line messages.
* history:
	STEVIE - ST Editor for VI Enthusiasts, Version 3.10
	Originally by Tim Thompson (twitch!tjt)
	Extensive modifications by Tony Andrews (onecom!wldrdg!tony)
	Heavily modified by Chris & John Downey
	modified for WIN32 / UNICODE / C++ by K.Yoshizawa
		(PAF02413.niftyserve.or.jp)

***/

#include "xvi.h"

// Set up the "slinetype" field in the given buffer structure,
// according to the number of columns available.
void init_sline(Xviwin *win)
{
	flexclear(&win->w_statusline);
}

void show_message(Xviwin *window, WCHAR *format, ...)
{
	va_list 	argp;

	va_start(argp, format);
	(void) flexclear(&window->w_statusline);
	(void) vformat(&window->w_statusline, format, argp);
	va_end(argp);

	update_sline(window);
}

void show_error(Xviwin *window, WCHAR *format, ...)
{
	va_list 	argp;

	beep(window);
	va_start(argp, format);
	(void) flexclear(&window->w_statusline);
	(void) vformat(&window->w_statusline, format, argp);
	va_end(argp);

	update_sline(window);
}

void show_file_info(Xviwin *window)
{
	if (echo & e_SHOWINFO) {
		Buffer	*buffer;
		Flexbuf *slp;
		long	position, total;
		long	percentage;

		buffer = window->w_buffer;

		position = lineno(buffer, window->w_cursor->p_line);
		total = lineno(buffer, buffer->b_lastline->l_prev);
		percentage = (total > 0) ? (position * 100) / total : 0;

		slp = &window->w_statusline;
		flexclear(slp);
		if (buffer->b_filename == NULL) {
			(void) lformat(slp, L"No File [%s,%s] ", ctname, fmtname);
		} else {
			(void) lformat(slp, L"\"%s\" [%s,%s] "
				, buffer->b_filename, ctname, fmtname);
		}
		(void) lformat(slp, L"%s%s%sline %ld of %ld (%ld%%)",
				is_readonly(buffer) ? L"[Read only] " : L"",
				not_editable(buffer) ? L"[Not editable] " : L"",
				is_modified(buffer) ? L"[Modified] " : L"",
				position,
				total,
				percentage);
	}
	update_sline(window);
}
