/***

* @(#)regexp.h	2.1 7/29/92

* program name:
    wvi
* function:
    PD version of UNIX "vi" editor for WIN32, with extensions.
* module name:
    regexp.h
* module function:
    Definitions for regular expression routines.

* history:
    Regular expression routines by Henry Spencer.
    Modfied for use with STEVIE (ST Editor for VI Enthusiasts,
     Version 3.10) by Tony Andrews.
    Adapted for use with Xvi by Chris & John Downey.
    Original copyright notice is in regexp.c.
    Please note that this is a modified version.
	modified for WIN32 / UNICODE / C++ by K.Yoshizawa
		(PAF02413.niftyserve.or.jp)
***/

// Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
// not the System V one.

#define NSUBEXP 10
struct regexp {
    WCHAR    *startp[NSUBEXP];
    WCHAR    *endp[NSUBEXP];
    WCHAR    regstart;			// Internal use only. 
    WCHAR    reganch;			// Internal use only. 
    WCHAR    *regmust;			// Internal use only. 
    int      regmlen;			// Internal use only. 
    WCHAR    program[1];		// Unwarranted chumminess with compiler. 
};

// regerror.c 
void	regerror (WCHAR *s);

// regexp.c 
regexp	*regcomp (WCHAR *exp);
int	regexec (regexp *prog, WCHAR *string, int at_bol);

// regsub.c 
void	regsub (regexp *prog, WCHAR *source, WCHAR *dest);
