// Copyright (c) 1990,1991,1992 Chris and John Downey 
#ifdef SCCID
static char *sccsid = "@(#)mark.c		2.1 (Chris & John Downey) 7/29/92";
#endif

/***

* program name:
	wvi
* function:
	PD version of UNIX "vi" editor for WIN32, with extensions.
* module name:
	mark.c
* module function:
	Routines to maintain and manipulate marks.
* history:
	STEVIE - ST Editor for VI Enthusiasts, Version 3.10
	Originally by Tim Thompson (twitch!tjt)
	Extensive modifications by Tony Andrews (onecom!wldrdg!tony)
	Heavily modified by Chris & John Downey
	modified for WIN32 / UNICODE / C++ by K.Yoshizawa
		(PAF02413.niftyserve.or.jp)

***/

#include "xvi.h"

// A new buffer - initialise it so there are no marks.
void init_marks(Buffer *buffer)
{
	Mark		*mlist = buffer->b_mlist;
	int i;

	for (i = 0; i < NMARKS; i++)
		mlist[i].m_name = L'\0';

	buffer->b_pcvalid = FALSE;
}

// setmark(c) - set mark 'c' at current cursor position in given buffer.
//
// Returns TRUE on success, FALSE if no room for mark or bad name given.
BOOL setmark(int c, Buffer *buffer, Posn *pos)
{
	Mark		*mlist = buffer->b_mlist;
	int i;

	if (!iswalpha((WCHAR) c))
		return(FALSE);

	// If there is already a mark of this name, then just use the
	// existing mark entry.
	for (i = 0; i < NMARKS; i++) {
		if (mlist[i].m_name == (WCHAR) c) {
			mlist[i].m_pos = *pos;
			return(TRUE);
		}
	}

	// There wasn't a mark of the given name, so find a free slot
	for (i = 0; i < NMARKS; i++) {
		if (mlist[i].m_name == L'\0') {	// got a free one 
			mlist[i].m_name = c;
			mlist[i].m_pos = *pos;
			return(TRUE);
		}
	}
	return(FALSE);
}

// setpcmark() - set the previous context mark to the current position
void setpcmark(Xviwin *window)
{
	window->w_buffer->b_pcmark.m_pos = *(window->w_cursor);
	window->w_buffer->b_pcvalid = TRUE;
}

// getmark(c) - find mark for char 'c' in given buffer
//
// Return pointer to Position or NULL if no such mark.
Posn *getmark(int c, Buffer *buffer)
{
	Mark		*mlist = buffer->b_mlist;
	int i;

	if (c == L'\'' || c == L'`') {		// previous context mark 
		return(buffer->b_pcvalid ? &(buffer->b_pcmark.m_pos) : NULL);
	}

	for (i = 0; i < NMARKS; i++) {
		if (mlist[i].m_name == (WCHAR) c)
			return(&(mlist[i].m_pos));
	}
	return(NULL);
}

// clrmark(line) - clear any marks for 'line'
//
// Used any time a line is deleted so we don't have marks pointing to
// non-existent lines.
void clrmark(Line *line, Buffer *buffer)
{
	Mark		*mlist = buffer->b_mlist;
	int i;

	for (i = 0; i < NMARKS; i++) {
		if (mlist[i].m_pos.p_line == line) {
			mlist[i].m_name = L'\0';
		}
	}
	if (buffer->b_pcvalid && (buffer->b_pcmark.m_pos.p_line == line)) {
		buffer->b_pcvalid = FALSE;
	}
}
