// Copyright (c) 1990,1991,1992 Chris and John Downey 

#ifdef SCCID
static char *sccsid = "@(#)defscr.c 	2.4 (Chris & John Downey) 9/4/92";
#endif

/***

* program name:
	wvi
* function:
	PD version of UNIX "vi" editor for WIN32, with extensions.
* module name:
	defscr.c
* module function:
	VirtScr interface using old style porting functions.
	We assume newscr() is only called once; it is an
	error for it to be called more than once.
* history:
	STEVIE - ST Editor for VI Enthusiasts, Version 3.10
	Originally by Tim Thompson (twitch!tjt)
	Extensive modifications by Tony Andrews (onecom!wldrdg!tony)
	Heavily modified by Chris & John Downey
	modified for WIN32 / UNICODE / C++ by K.Yoshizawa
		(PAF02413.niftyserve.or.jp)

***/

#include "xvi.h"

static	VirtScr *newscr(VirtScr *);
static	void	closescr(VirtScr *);
static	int 	getrows(VirtScr *);
static	int 	getcols(VirtScr *);
static	void	clear_all(VirtScr *);
static	void	clear_line(VirtScr *, int, int);
static	void	xygoto(VirtScr *, int, int);
static	void	xyadvise(VirtScr *, int, int, int, WCHAR *);
static	void	put_char(VirtScr *, int, int, int);
static	void	put_str(VirtScr *, int, int, WCHAR *);
static	void	ins_str(VirtScr *, int, int, WCHAR *);
static	void	pset_color(VirtScr *, int);
static	int 	color_cost(VirtScr *);
static	int 	scroll(VirtScr *, int, int, int);
static	void	flushout(VirtScr *);
static	void	pbeep(VirtScr *);

VirtScr defscr = {
	NULL,				// pv_window		
	0,					// pv_rows			
	0,					// pv_cols			

	newscr, 			// v_new			
	closescr,			// v_close			
	getrows,			// v_rows			
	getcols,			// v_cols			
	clear_all,			// v_clear_all		
	clear_line, 		// v_clear_line 	
	xygoto, 			// v_goto			
	xyadvise,			// v_advise 		
	put_str,			// v_write			
	put_char,			// v_putc			
	pset_color,			// v_set_color 	
	color_cost,			// v_color_cost	
	flushout,			// v_flush			
	pbeep,				// v_beep			

	ins_str,			// v_insert 		
	scroll, 			// v_scroll 		
	NULL,				// v_flash			
	NULL,				// v_status 		
	NULL,				// v_activate		
};

extern "C" {
int wmain(int argc, WCHAR *argv[]);
}

int wmain(int argc, WCHAR *argv[])
{
	xvEvent 	event;
	long		timeout = 0;

	// Set up the system and terminal interfaces. This establishes
	// the window size, changes to raw mode and does whatever else
	// is needed for the system we're running on.
	ConsoleViMode();

	if (!can_inschar) {
		defscr.v_insert = NULL;
	}
	if (!can_scroll_area && !can_ins_line && !can_del_line) {
		defscr.v_scroll = NULL;
	}
	defscr.pv_rows = iRows;
	defscr.pv_cols = iColumns;

	defscr.pv_window = (void *) xvi_startup(&defscr, argc, argv);

	while (1) {
		int	r;

		r = ConsoleGetc(timeout);
		if (r == EOF) {
			event.ev_type = Ev_timeout;
		} else {
			event.ev_type = Ev_char;
			event.ev_inchar = r;
		}
		timeout = xvi_handle_event(&event);
	}
	return 0;
}

static VirtScr *newscr(VirtScr *scr)
{
	return NULL;
}

static void closescr(VirtScr *scr)
{
}

static int getrows(VirtScr *scr)
{
	return scr->pv_rows;
}

static int getcols(VirtScr *scr)
{
	return scr->pv_cols;
}

static void clear_all(VirtScr *scr)
{
	ConsoleEraseScreen();
}

static void clear_line(VirtScr *scr, int row, int col)
{
	ConsoleMoveCursor(row, col);
	ConsoleEraseLine();
}

static void xygoto(VirtScr *scr, int row, int col)
{
	ConsoleMoveCursor(row, col);
}

static void xyadvise(VirtScr *scr, int row, int col, int index, WCHAR *str)
{
	if (index > cost_goto) {
		ConsoleMoveCursor(row, col + index);
	} else {
		ConsoleMoveCursor(row, col);
		while (--index > 0) {
			ConsolePutc(*str++);
		}
	}
}

static void put_str(VirtScr *scr, int row, int col, WCHAR *str)
{
	ConsoleMoveCursor(row, col);
	ConsolePuts(str);
}

static void put_char(VirtScr *scr, int row, int col, int c)
{
	ConsoleMoveCursor(row, col);
	ConsolePutc(c);
}

static void ins_str(VirtScr *scr, int row, int col, WCHAR *str)
{
	// If we are called, can_inschar is TRUE,
	// so we know it is safe to use inschar().
	ConsoleMoveCursor(row, col);
	for ( ; *str != L'\0'; str++) {
		inschar(*str);
	}
}

static void pset_color(VirtScr *scr, int color)
{
	ConsoleSelectColor(color);
}

static int color_cost(VirtScr *scr)
{
	return 0;
}

static int scroll(VirtScr *scr, int start_row, int end_row, int nlines)
{
	if (nlines < 0) {
		// nlines negative means scroll reverse - i.e. move
		// the text downwards with respect to the terminal.
		nlines = -nlines;

		if (can_scroll_area) {
			ConsoleScrollDown(start_row, end_row, nlines);
		} else if (can_ins_line && end_row == iRows - 1) {
			int line;

			for (line = 0; line < nlines; line++) {
				ConsoleMoveCursor(start_row, 0);
				insert_line();
			}
		} else {
			return(0);
		}
	} else if (nlines > 0) {
		// Whereas nlines positive is "normal" scrolling.
		if (can_scroll_area) {
			ConsoleScrollUp(start_row, end_row, nlines);
		} else if (end_row == iRows - 1) {
			int line;

			if (can_del_line) {
				for (line = 0; line < nlines; line++) {
					ConsoleMoveCursor(start_row, 0);
					delete_line();
				}
			} else if (start_row == 0) {
				ConsoleMoveCursor(start_row, 0);
				for (line = 0; line < nlines; line++) {
					ConsoleEraseLine();
				}
			} else {
				return(0);
			}
		} else {
			return(0);
		}
	}
	return(1);
}

static void flushout(VirtScr *scr)
{
	ConsoleFlushOutput();
}

static void pbeep(VirtScr *scr)
{
	flushout(scr);
	AlertBell();
}
