// du.h

#ifndef __DU_H
#define __DU_H

#include "App.h"

#define	SHOW	1
#define	NOSHOW	0

/*+CLASS
  du - Disk Usage.<br>
  This is an old unix utility to find the disk space used by any directory.
  @note This version dosen't check arguments.<br>
		The only assumption is if you dosen't pass any argument, it uses the current
		directory.
  @author Daniel A. Francesch
  @version 0.10
*/
class duApp : public App {
protected:
	/*+METHOD
	  Calculate the space used by the directory.
	  @param	showmode	it could be <b>SHOW</b> -to show the information of each 
							file/directory it inspects- or <b>NOSHOW</b> -silent mode.
	  @param	s			specify the directory to inspect.
	  @return				the space the direcotry use.
	*/
	ULONG dirSpace( int showmode, LPTSTR s );
public:
	/*+METHOD
	  Constructor.<br>
	  It receives and initializes the program parameters.
	  @param	argc		paramaters count (or argv size).
	  @param	argv		parameters vector; [0] is the command name, [1] is the
							first command line parameter, and so on.
	*/
	duApp( DWORD argc, LPTSTR argv[] ) 
		: App( argc, argv ) {};
	/*+METHOD
	  Main process.<br>
	  It parses the parameters and call dirSpace().
	  @see duApp::dirSpace
	*/
	int run();
};

#endif // __DU_H
