// du.cpp

#include	<stdlib.h>
#include	<tchar.h>
#include	"du.h"

int duApp::run()
{
	long	sp = 0;
	TCHAR	MessageBuf[ 256 ] ;
	LPTSTR	arg;
	DWORD	rc;

	rc = GetCurDir( 256, MessageBuf );

	if ( _argc < 2 )
		arg = MessageBuf;
	else
		arg = _argv[1];

	sp = dirSpace( SHOW, arg );

	wsprintf( MessageBuf, TEXT("%10lu bytes \n"),
			  sp ) ;
	Cputs( MessageBuf ) ;

	return 0 ;
}

ULONG duApp::dirSpace( int showmode, LPTSTR s )
{
	HANDLE	ffh;
	WIN32_FIND_DATA	fd;
	BOOL rc;
	ULONG sp = 0, tsp = 0;
	TCHAR	MessageBuf[ 256 ] ;
	TCHAR path_buffer[_MAX_PATH];

	ffh = FindFirstFile( s, &fd );

	if ( ffh != INVALID_HANDLE_VALUE )
	{
		rc = TRUE;
		while ( rc )
		{
			if ( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
			{
				wcscpy(path_buffer, s);
				UpDir(path_buffer);
				wcscat(path_buffer, TEXT("\\"));
				wcscat(path_buffer, fd.cFileName);
				wcscat(path_buffer, TEXT("\\*"));
				sp = dirSpace( NOSHOW, path_buffer );
			}
			else 
				sp = fd.nFileSizeLow;
			if ( showmode == SHOW )
			{
				wsprintf( MessageBuf, TEXT("%10lu %s\n"), sp, fd.cFileName ) ;
				Cputs( MessageBuf ) ;
			}
			tsp += sp;

			rc = FindNextFile( ffh, &fd );
		}
	}
	return tsp;
}


