// App.h

#include	"conslib.h"

#ifndef __APP_H
#define __APP_H

/*+CLASS
  General Purpose Application Class.<br>
  It Intends to encupsulate a General Application.
*/
class App {
protected:
	DWORD _argc;
	LPTSTR *_argv;
	int _rc;

public:
	/*+METHOD
	  Constructor.<br>
	  Initialize the application.
	*/
	App() : _argc(0), _argv(NULL), _rc(0) {};
	/*+METHOD
	  Constructor.<br>
	  Initialize the application with the parameters from the command line.
	  @param	argc		paramaters count (or argv size).
	  @param	argv		parameters vector; [0] is the command name, [1] is the
							first command line parameter, and so on.
	*/
	App( DWORD argc, LPTSTR argv[] ) : _argc(argc), _argv(argv), _rc(0) {};
	/*+METHOD
	  Starts the application.
	  @return				the exit code.
	*/
	virtual int run() = 0;
};

#endif // __APP_H
