/*
 * CONSOLE : ConsolevOFNCAgǗ[`
 * Copyright(C) 1997-1999 Eiichiro Ito, Yasuhiro Mizukoshi, Fjw
 *
 * 1997/07/04:Eiichiro Ito
 *  (1) 쐬Jn
 * C
 * 1998/02/15:Yasuhiro Mizukoshi
 *  (1) ESCV[PXΉ
 * 1998/02/19:Eiichiro Ito
 *  (1) ʍXVWbNC
 * 1998/02/20:Eiichiro Ito
 *  (1) ]\Ή
 * 1998/03/31:Yasuhiro Mizukoshi
 *  (1) ESCV[PXC
 * 1998/04/11:Fjw
 *  (1) OtBbNLN^̏̒ǉ
 *
 */
#define	STRICT
#include	<windows.h>
#include	<string.h>
#include	<tchar.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	"resource.h"
#include	"client.h"

const TCHAR	ClassName[] = TEXT("ConsApp") ;

struct ClientList_t ClientList[ MAX_CLIENT ] ;
DWORD		Num_client = 0 ;
DWORD		Cur_client = 0 ;

extern	HANDLE	hShareFile ;
extern	HWND	hMainWnd ;
extern	TCHAR	szWinName[] ;
extern	DWORD	ConsoleCH ;

void
set_title( void )
{
	TCHAR	buf[ MAX_PATH ] ;

	_tcscpy( buf, szWinName ) ;
	if ( Cur_client ) {
		HWND	hWnd = CurTerm.hWnd ;
		GetWindowText( hWnd, buf, sizeof buf / sizeof *buf ) ;
	}
	SetWindowText( hMainWnd, buf ) ;
}

DWORD
client_add( HANDLE hWnd )
{
	if ( Num_client >= MAX_CLIENT ) {
		return 0 ;
	}
	ClientList[ Num_client ].hWnd          = hWnd ;
	ClientList[ Num_client ].ttymode       = TTY_NORMAL ;
	ClientList[ Num_client ].term_state    = TERM_DATA ;
	ClientList[ Num_client ].term_tmp_pos  = 0 ;
	ClientList[ Num_client ].tab_size      = 8 ;
	ClientList[ Num_client ].col_tmp       = 0 ;
	ClientList[ Num_client ].line_tmp      = 0 ;
	ClientList[ Num_client ].scroll_top    = 0 ;
	ClientList[ Num_client ].scroll_bottom = ConsoleCH - 1 ;
	ClientList[ Num_client ].TermSetup     = DEFAULT_TERMSETUP ;
	ClientList[ Num_client ].bTermAttr     = 0 ;
	ClientList[ Num_client ].char_set      = CS_USASCII ;	// Fjw
	ClientList[ Num_client ].G0_char_set   = CS_USASCII ;
	ClientList[ Num_client ].G1_char_set   = CS_USASCII ;
	Num_client ++ ;
	Cur_client = Num_client ;
	set_title() ;
	return Cur_client ;
}

void
client_del( HANDLE hWnd )
{
	DWORD	i ;

	for ( i = 0 ; i < Num_client ; i ++ ) {
		if ( ClientList[ i ].hWnd == hWnd ) {
			Num_client -- ;
			for ( ; i < Num_client ; i ++ ) {
				ClientList[i].hWnd          = ClientList[i+1].hWnd ;
				ClientList[i].ttymode       = ClientList[i+1].ttymode ;
				ClientList[i].term_state    = ClientList[i+1].term_state ;
				ClientList[i].term_tmp_pos  = ClientList[i+1].term_tmp_pos ;
				ClientList[i].col_tmp       = ClientList[i+1].col_tmp ;
				ClientList[i].line_tmp      = ClientList[i+1].line_tmp ;
				ClientList[i].scroll_top    = ClientList[i+1].scroll_top ;
				ClientList[i].scroll_bottom = ClientList[i+1].scroll_bottom ;
				ClientList[i].tab_size      = ClientList[i+1].tab_size ;
				ClientList[i].bConsDraw     = ClientList[i+1].bConsDraw ;
				ClientList[i].TermSetup     = ClientList[i+1].TermSetup ;
				ClientList[i].bTermAttr     = ClientList[i+1].bTermAttr ;
				ClientList[i].char_set      = ClientList[i+1].char_set ;	// Fjw
				ClientList[i].G0_char_set   = ClientList[i+1].G0_char_set ;
				ClientList[i].G1_char_set   = ClientList[i+1].G1_char_set ;
				memcpy( ClientList[i].term_tmp, ClientList[i+1].term_tmp, sizeof (TCHAR)*(KEYBUFF_SIZE) ) ;
			}
			Cur_client = Num_client ;
			set_title() ;
			break ;
		}
	}
}

void
client_send( TCHAR c )
{
	HWND		hWnd ;

	if ( !Cur_client ) {
		return ;
	}
	hWnd = CurTerm.hWnd ;
	SendMessage( hWnd, WM_COMMAND, IDM_ADDCHAR, c ) ;
}

void
str_client_send( LPCTSTR buf )
{
	TCHAR			c ;
	COPYDATASTRUCT	cds ;
	HWND			hWnd ;

	if ( !Cur_client ) {
		return ;
	}
	hWnd = CurTerm.hWnd ;
	cds.dwData = TTY_NORMAL ;
	cds.cbData = (_tcslen( buf ) + 1) * sizeof (TCHAR) ;
	cds.lpData = (PBYTE) buf ;
	if ( !SendMessage( hWnd, WM_COPYDATA, (WPARAM) hMainWnd, (LPARAM) &cds ) ) {
		while ( c = *buf++ ) {
			SendMessage( hWnd, WM_COMMAND, IDM_ADDCHAR, (LPARAM) c ) ;
		}
	}
}

void
client_killall( void )
{
	while ( 1 ) {
		HANDLE	hWnd ;

		hWnd = FindWindow( ClassName, NULL ) ;
		if ( hWnd == NULL ) {
			break ;
		}
		SendMessage( hWnd, WM_CLOSE, 0, 0 ) ;
		Sleep( 500 ) ;
	}
}

DWORD
client_getindex( HWND hWnd )
{
	DWORD	i ;

	for ( i = 0 ; i < Num_client ; i ++ ) {
		if ( ClientList[ i ].hWnd == hWnd ) {
			return i + 1 ;
		}
	}
	return 0 ;
}

BOOL
client_switch( DWORD idx )
{
	if ( idx && idx <= Num_client ) {
		Cur_client = idx ;
		return TRUE ;
	}
	return FALSE ;
}

void
client_break( void )
{
	HWND		hWnd ;

	if ( !Cur_client ) {
		return ;
	}
	hWnd = CurTerm.hWnd ;
	SendMessage( hWnd, WM_COMMAND, IDM_BREAK, 0 ) ;
}

BOOL
client_exists( void )
{
	return Num_client ;
}
