#define	STRICT
#include	<windows.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	<commdlg.h>
#include	<tchar.h>
#include	"basewin.h"
#include	"resource.h"
#include	"dialog.h"

extern	DWORD	AppVersion ;
extern	DWORD	DllVersion ;

extern	DWORD	PreWait ;
extern	DWORD	PostWait ;
extern	DWORD	F_QuickSend ;
extern	DWORD	F_JIS ;
extern	TCHAR	DictPath[ MAX_PATH ] ;
extern	HWND	g_hWndDialog ;

static	BOOL	DictOpenDlg( HINSTANCE hInst, HWND hWnd, LPTSTR buf, DWORD size ) ;

/*
 * ݒ_CAO
 */
class SetupDialog : public Window {
	HINSTANCE	m_hInst ;

public:
	SetupDialog( HINSTANCE hInst ) { m_hInst = hInst ; }
	~SetupDialog() {}

	void	WMCreate( HWND hDlg ) ;
	LRESULT	WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp ) ;
} ;

void
SetupDialog::WMCreate( HWND hDlg )
{
	TCHAR	buf[ 128 ] ;

	g_hWndDialog = hDlg ;
	/* o[Wݒ肷 */
	wsprintf( buf, TEXT("KanjiIn for Windows%c CE V%d.%02d"),
			  0xAE, AppVersion / 100, AppVersion % 100 ) ;
	SetWindowText( hDlg, buf ) ;
	wsprintf( buf, TEXT("KCTRL Ver %d.%02d\r\nCopyright %c 1997 %s\r\n%s"),
			  DllVersion / 100, DllVersion % 100,
			  0xA9,
			  TEXT("Eiichiroh Itoh"),
			  TEXT("All Rights Reserved") ) ;
	SetDlgItemText( hDlg, IDC_COPYRIGHT, buf ) ;
	/* ڂ̒lݒ肷 */
	SetDlgItemText( hDlg, IDC_PATH_DICT, DictPath ) ;
	SetDlgItemInt( hDlg, IDC_PREWAIT, PreWait, 0 ) ;
	SetDlgItemInt( hDlg, IDC_POSTWAIT, PostWait, 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CHK_SEND,
						BM_SETCHECK, (WPARAM) (F_QuickSend ? 1 : 0), 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CHK_JIS,
						BM_SETCHECK, (WPARAM) (F_JIS ? 1 : 0), 0 ) ;
	SetForegroundWindow( hDlg ) ;
}

LRESULT
SetupDialog::WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp )
{
	DWORD	attr, ret = 0 ;
	TCHAR	buf[ MAX_PATH ] ;

	if ( wp == IDCANCEL ) {
		EndDialog( hDlg, 0 ) ;
		return TRUE ;
	} else if ( wp == IDC_BTN_DICT ) {
		/* Browse{^ꂽꍇ */
		if ( DictOpenDlg( m_hInst, hDlg, buf, sizeof buf ) ) {
			SetDlgItemText( hDlg, IDC_PATH_DICT, buf ) ;
		}
		return TRUE ;
	} else if ( wp == IDC_EXIT ) {
		EndDialog( hDlg, DIALOG_RET_EXIT ) ;
		return TRUE ;
	} else if ( wp == IDC_UNINSTALL ) {
		if ( MessageBox( hDlg, TEXT("Uninstall this application?"), TEXT("Uninstall"), MB_YESNO ) == IDYES ) {
			EndDialog( hDlg, DIALOG_RET_UNINSTALL ) ;
		}
		return TRUE ;
	} else if ( wp != IDOK ) {
		return FALSE ;
	}
	/* OKꂽꍇ */
	/* t@C̃pX */
	GetDlgItemText( hDlg, IDC_PATH_DICT, buf, MAX_PATH ) ;
	attr = GetFileAttributes( buf ) ;
	if ( !*buf || (attr == 0xFFFFFFFF) || (attr & FILE_ATTRIBUTE_DIRECTORY) ) {
		/* Ct@C݂ȂCfBNg̏ꍇ͖߂ */
		return TRUE ;
	}
	if ( _tcscmp( DictPath, buf ) ) {
		/* ύXtO */
		ret |= DIALOG_RET_CHANGEDICT ;
		_tcscpy( DictPath, buf ) ;
	}
	/* y[XgȎ҂b */
	PreWait = GetDlgItemInt( hDlg, IDC_PREWAIT, NULL, FALSE ) ;
	/* y[Xg̑҂b */
	PostWait = GetDlgItemInt( hDlg, IDC_POSTWAIT, NULL, FALSE ) ;
	/* m著MtO */
	F_QuickSend = SendDlgItemMessage( hDlg, IDC_CHK_SEND, BM_GETCHECK, 0, 0 ) ? 1 : 0 ;
	/* JISMtO */
	F_JIS = SendDlgItemMessage( hDlg, IDC_CHK_JIS, BM_GETCHECK, 0, 0 ) ? 1 : 0 ;
	/* ύXtO */
	ret |= DIALOG_RET_CHANGE ;
	EndDialog( hDlg, ret ) ;
	return TRUE ;
}

BOOL
SetupDialogExec( HINSTANCE hInst, HWND hWnd )
{
	BOOL	ret ;
	SetupDialog		*pDialog = new SetupDialog( hInst ) ;

	ret = DialogBoxParam( hInst, MAKEINTRESOURCE(IDD_DLG_SETUP), hWnd, (DLGPROC) DlgProc, (LPARAM) pDialog ) ;
	delete pDialog ;
	g_hWndDialog = NULL ;
	return ret ;
}

static	OPENFILENAME	ofn ;
static	TCHAR			buf1[ MAX_PATH ] ;

static	BOOL
DictOpenDlg( HINSTANCE hInst, HWND hWnd, LPTSTR buf, DWORD size )
{
	memset( &ofn, 0, sizeof ofn ) ;
	memcpy( buf1, TEXT("*.dic\0"), sizeof TEXT("*.dic\0") ) ;
	ofn.lStructSize = sizeof ofn ;
    ofn.hwndOwner = hWnd ;
    ofn.hInstance = hInst ;
    ofn.lpstrFilter = TEXT("Dict Files (*.dic;*.s;*.m;*.l)\0*.dic;*.s;*.m;*.l\0All Files (*.*)\0*.*\0\0") ;
    ofn.lpstrCustomFilter = NULL ;
    ofn.nMaxCustFilter = 0 ;
    ofn.nFilterIndex = 1 ;
    ofn.lpstrFile = buf1 ;
    ofn.nMaxFile = MAX_PATH ;
    ofn.lpstrFileTitle = NULL ;
    ofn.nMaxFileTitle = 0 ;
    ofn.lpstrInitialDir = NULL ;
    ofn.lpstrTitle = TEXT("Open Dictionary") ;
    ofn.Flags = 0 ;
    ofn.nFileOffset = 0 ;
    ofn.nFileExtension = 0 ;
    ofn.lpstrDefExt = TEXT("DIC") ;
    ofn.lCustData = 0 ;
    ofn.lpfnHook = NULL ;
    ofn.lpTemplateName = NULL ;
	if ( !GetOpenFileName( &ofn ) ) {
		return FALSE ;
	}
	_tcscpy( buf, buf1 ) ;
	return TRUE ;
}

