#ifndef	STRICT
#define	STRICT
#endif	/* STRICT */
#ifndef	UNICODE
#define	UNICODE
#endif	/* UNICODE */
#ifndef	_UNICODE
#define	_UNICODE
#endif	/* _UNICODE */
#include	<windows.h>
#include	<windowsx.h>
#include	<winuser.h>
#include	<string.h>
#include	<commctrl.h>
#include	<commdlg.h>
#include	<tchar.h>
#include	"kctrl.h"

extern	DWORD	FontZenVW ;
extern	DWORD	FontHanVW ;
extern	DWORD	FontVH ;
extern	DWORD	TabWidth ;
extern	DWORD	F_convmode ;

#define		MAX_FONT		2
#define		BaseKey			TEXT("Software\\Gawaro\\Kctrl")
#define		VAR_TTFONT		TEXT("TTFont")
#define		VAR_FONTWIDTH	TEXT("FontWidth")
#define		VAR_FONTHEIGHT	TEXT("FontHeight")

static	BOOL	get_reg( void ) ;

HFONT		hFont[ MAX_FONT ] ;
LOGFONT		LF_MSG[ MAX_FONT ] = {
	{ 14, 7, 0, 0, 0x000, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
		{0x0000} },
	{ 12, 6, 0, 0, 0x000, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
		{0x0000} },
} ;

DWORD		g_dwCurFont = 0 ;

BOOL
InitLocal( void )
{
	int		i ;

	get_reg() ;
	for ( i = 0 ; i < MAX_FONT ; i ++ ) {
		hFont[i] = LF_MSG[i].lfWidth ? CreateFontIndirect( &LF_MSG[i] ) : 0 ;
	}
	if ( !hFont[0] ) {
		return FALSE ;
	}
	g_dwCurFont = 0 ;
	FontHanVW = LF_MSG[g_dwCurFont].lfWidth ;
	FontZenVW = LF_MSG[g_dwCurFont].lfWidth * 2 ;
	FontVH    = LF_MSG[g_dwCurFont].lfHeight + 1 ;
	/* R[hϊȂ */
	F_convmode = MODE_NOCONV ;
	SetLastError( 0 ) ;
	return TRUE ;
}

void
ReleaseLocal( void )
{
	int		i ;

	for ( i = 0 ; i < MAX_FONT ; i ++ ) {
		if ( hFont[i] ) {
			DeleteObject( hFont[i] ) ;
		}
	}
}

void
KDrawText( HDC hDC, LPCTSTR str, int len, LPRECT pos, UINT format )
{
	DWORD	col = 0, cw = 0, num = 0, max  ;
	TCHAR	c, outbuf[ 256 ], *dst = outbuf ;
	HFONT	oldfont = SelectObject( hDC, hFont[g_dwCurFont] ) ;

	max = (sizeof outbuf / sizeof *outbuf) - TabWidth - 8 ;
	while ( (c = *str++) && (num < max) ) {
		if ( c == 9 ) {
			cw = TabWidth - (col % TabWidth) ;
			col += cw ;
			do {
				*dst++ = TEXT(' ') ;
				num ++ ;
			} while ( -- cw ) ;
			continue ;
		} else if ( c & 0xFF00 ) {
			c = TEXT('?') ;
			*dst++ = c ;		num ++ ;
			col ++ ;
		}
		col ++ ;
		*dst++ = c ;		num ++ ;
	}
	*dst = 0 ;
	FillRect( hDC, pos, GetStockObject( WHITE_BRUSH ) ) ;
	DrawText( hDC, outbuf, len, pos, format|DT_NOPREFIX ) ;
	SelectObject( hDC, oldfont ) ;
}

void
KDrawTextW( HDC hDC, LPCTSTR str, int len, LPRECT pos, UINT format )
{
	KDrawText( hDC, str, len, pos, format ) ;
}

void
KDrawTextI( HDC hDC, LPCTSTR str, int len, LPRECT pos, UINT format )
{
	DWORD	col = 0, cw = 0, num = 0, max  ;
	TCHAR	c, outbuf[ 256 ], *dst = outbuf ;
	HFONT	oldfont = SelectObject( hDC, hFont[g_dwCurFont] ) ;

	max = (sizeof outbuf / sizeof *outbuf) - TabWidth - 8 ;
	while ( (c = *str++) && (num < max) ) {
		if ( c == 9 ) {
			cw = TabWidth - (col % TabWidth) ;
			col += cw ;
			do {
				*dst++ = TEXT(' ') ;
				num ++ ;
			} while ( -- cw ) ;
			continue ;
		} else if ( c & 0xFF00 ) {
			c = TEXT('?') ;
			*dst++ = c ;		num ++ ;
			col ++ ;
		}
		*dst++ = c ;		num ++ ;
		col ++ ;
	}
	*dst = 0 ;
	FillRect( hDC, pos, GetStockObject( LTGRAY_BRUSH ) ) ;
	DrawText( hDC, outbuf, len, pos, format|DT_NOPREFIX ) ;
	SelectObject( hDC, oldfont ) ;
}

#define		iskanji(x)		(((x)>=0x81 && (x)<=0x9F)||((x)>=0xE0 && (x)<=0xFC))

/*
 * @́FUnicodeSJISR[hϊ
 * @́Funicode2sjis
 * @TvFUnicodeSJISɕϊ
 * Fsrc = Unicode
 * @@@Fdst = SJISi[̈ւ̃|C^
 * @@@Fmax = SJISi[̈̍őoCg
 * ߂lFDWORD = ϊʂ̃oCg(dst=0͕̎KvoCg)\0܂
 */
DWORD
unicode2sjis( LPCTSTR src, BYTE *dst, DWORD max )
{
	TCHAR		c ;
	DWORD		count ;
	BYTE		ch, cl ;

	count = 0 ;
	if ( dst ) {
		if ( max <= 1 ) {
			return count ;
		}
		max -- ;
	}
	while ( ( c = *src++ ) != 0 ) {
		ch = (BYTE) (c / 256) ;
		cl = (BYTE) (c % 256) ;
		if ( ch == 0xFF ) {
			//ch = 0 ;
			cl += 0x40 ;
		} else if ( ch ) {
			count ++ ;
			if ( dst ) {
				*dst++ = ch ;
				if ( !(-- max) ) {
					break ;
				}
			}
		}
		count ++ ;
		if ( dst ) {
			*dst++ = cl ;
			if ( !(-- max) ) {
				break ;
			}
		}
	}
	count ++ ;
	if ( dst ) {
		*dst = 0 ;
	}
	return count ;
}

/*
 * @́FSJISUnicodeR[hϊ
 * @́Fsjis2unicode
 * @TvFSJISUnicodeɕϊ
 * Fsrc = SJIS
 * @@@Fdst = Unicodei[̈ւ̃|C^
 * @@@Fmax = Unicodei[̈̍őoCg
 * ߂lFDWORD = ϊʂ̃oCg(dst=0͕̎KvoCg)\0܂
 */
DWORD
sjis2unicode( const BYTE *src, LPTSTR dst, DWORD max )
{
	BYTE		c, c1 ;
	DWORD		count ;
	TCHAR		dstchar ;

	count = 0 ;
	if ( dst ) {
		max /= sizeof (TCHAR) ;
		if ( max <= 1 ) {
			return count * sizeof (TCHAR) ;
		}
		max -- ;
	}
	while ( ( c = *src++ ) != 0 ) {
		if ( iskanji( c ) ) {
			c1 = *src++ ;
			if ( !c1 ) {
				break ;
			}
			dstchar = (TCHAR) (c << 8) | (TCHAR) c1 ;
#ifndef	_WIN32_WCE
		} else if ( c >= 0x80 ) {
			dstchar = 0xFF00 | (TCHAR) (c - 0x40) ;
#endif	/* _WIN32_WCE */
		} else {
			dstchar = (TCHAR) c ;
		}
		count ++ ;
		if ( dst ) {
			*dst++ = dstchar ;
			if ( !(-- max) ) {
				break ;
			}
		}
	}
	count ++ ;
	if ( dst ) {
		*dst = 0 ;
	}
	return count * sizeof (TCHAR) ;
}

/*
 * @́FVtgihrR[hUNICODEϊ
 * @́Fsjis2unicode_char
 * @TvFVtgihrR[hUNICODEɕϊ
 * Fsjis(WORD) = VtgihrR[h
 * ߂lFTCHAR = UNICODE
 */
TCHAR
sjis2unicode_char( WORD sjis )
{
	return (TCHAR) sjis ;
}

/*
 * @́FUNICODEVtgihrR[hϊ
 * @́Funicode2sjis_char
 * @TvFUNICODEVtgihrR[hɕϊ
 * Funicode(TCHAR) = UNICODE
 * ߂lFWORD = VtgihrR[h
 */
WORD
unicode2sjis_char( TCHAR unicode )
{
	return (WORD) unicode ;
}

/*
 * @́Fp`FbN
 * @́Fis_hankaku
 * @TvFUnicodepǂׂ
 * Fc = Unicode
 * ߂lFBOOL = TRUE:p, FALSE:Sp
 */
BOOL
is_hankaku( TCHAR c )
{
	return !(c & 0xFF00) ;
}

/*
 * @́FKCTRLP[擾
 * @́FGetKLocale
 * @TvFKCTRL(US)KCTRL(JP)Ȃǂ̋ʂԂ
 * FȂ
 * ߂lFDWORD = 0:US, 1:JP, ...
 */
DWORD
GetKLocale( void )
{
	return LOCALE_USONLY ;
}

/*
 * @́FtHg擾
 * @́FGetNumFont
 * @TvF\ɎgpłtHg𒲂ׂ
 * FȂ
 * ߂lFDWORD = tHg
 */
DWORD
GetNumFont( void )
{
	return MAX_FONT ;
}

/*
 * @́FptHgݒ
 * @́FSetCurFont
 * @TvF\ɎgptHg߂
 * Findex(DWORD) = ԍ(0..1)
 * ߂lFȂ
 */
void
SetCurFont( DWORD index )
{
	g_dwCurFont = index ;
	FontHanVW = LF_MSG[g_dwCurFont].lfWidth ;
	FontZenVW = LF_MSG[g_dwCurFont].lfWidth * 2 ;
	FontVH    = LF_MSG[g_dwCurFont].lfHeight + 1 ;
}

/*
 * @́F݃tHg擾
 * @́FGetCurFont
 * @TvF\ɎgpĂtHg𒲂ׂ
 * FȂ
 * ߂lFDWORD = 0..1
 */
DWORD
GetCurFont( void )
{
	return g_dwCurFont ;
}

static	BOOL
get_reg( void )
{
	HKEY	hk ;
	LONG	lret ;
	LPBYTE	lpData ;
	DWORD	dwType, cbData, dValue, i ;
	TCHAR	name[ 64 ], sValue[ 256 ] ;

	/* WXgL[I[v */
	lret = RegOpenKeyEx( HKEY_CURRENT_USER, BaseKey, 0,
						 KEY_QUERY_VALUE, &hk ) ;
	if ( lret != ERROR_SUCCESS ) {
		return FALSE ;
	}
	for ( i = 0 ; i < MAX_FONT ; i ++ ) {
		/* TrueTypetHg */
		wsprintf( name, TEXT("%s%d"), VAR_TTFONT, i ) ;
		dwType = REG_SZ ;
		lpData = (LPBYTE) sValue ;
		cbData = sizeof sValue ;
		if ( RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) == ERROR_SUCCESS ) {
			_tcscpy( LF_MSG[i].lfFaceName, sValue ) ;
		}
		/* tHg */
		wsprintf( name, TEXT("%s%d"), VAR_FONTWIDTH, i ) ;
		dwType = REG_DWORD ;
		lpData = (LPBYTE) &dValue ;
		cbData = sizeof dValue ;
		if ( RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) == ERROR_SUCCESS ) {
			LF_MSG[i].lfWidth = dValue ;
		}
		/* tHg */
		wsprintf( name, TEXT("%s%d"), VAR_FONTHEIGHT, i ) ;
		dwType = REG_DWORD ;
		lpData = (LPBYTE) &dValue ;
		cbData = sizeof dValue ;
		if ( RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) == ERROR_SUCCESS ) {
			LF_MSG[i].lfHeight = dValue ;
		}
	}
	/* WXgN[Y */
	RegCloseKey( hk ) ;
	return TRUE ;
}
