#define	STRICT
#include	<windows.h>
#include	<tchar.h>
#include	"kctrl.h"

#define		Version			(27)

#ifdef	_WIN32_WCE
BOOL WINAPI
DllMain( HINSTANCE hInstDll, DWORD reason, LPVOID situation )
{
	return TRUE ;
}
#endif	/* _WIN32_WCE */

extern	BOOL	InitLocal( void ) ;
extern	void	ReleaseLocal( void ) ;

TCHAR	MessageBuf[ 128 ] ;
/* tHggbN */
DWORD	FontZenVW = 0 ;			/* SptHg̕\ */
DWORD	FontHanVW = 0 ;			/* ptHg̕\ */
DWORD	FontVH = 0 ;			/* SptHg̕\ */
/* ^uTCY */
DWORD	TabWidth = 8 ;
/* R[hϊʍƗ̈ */
DWORD	ConvCount = 0 ;			/* ϊ㕶 */
LPTSTR	ConvPtr = 0 ;			/* ϊ̈ */
DWORD	Stat = 0 ;				/* O */
DWORD	F_convmode = MODE_NORMAL ;	/* 0=Normal, 1=GXP[v'\'gp, 2=BASE64 */
/* JIS->UNICODEϊƗ̈ */
TCHAR	PendingBuffer[ 128 ] ;	/* ۗobt@ */
int		PendingSize = 0 ;		/* ۗobt@TCY */
/* UNICODE->JISϊƗ̈ */
TCHAR	C1 = 0 ;				/* O */

/* pSpϊe[u(0xA0`0xDF) */
const	WORD	hank_to_zenk[] = {
	0x2020, 0x8142, 0x8175, 0x8176, 0x8141, 0x8145, 0x8392, 0x8340,
	0x8342, 0x8344, 0x8346, 0x8348, 0x8383, 0x8385, 0x8387, 0x8362,
	0x815B, 0x8341, 0x8343, 0x8345, 0x8347, 0x8349, 0x834A, 0x834C,
	0x834E, 0x8350, 0x8352, 0x8354, 0x8356, 0x8358, 0x835A, 0x835C,
	0x835E, 0x8360, 0x8363, 0x8365, 0x8367, 0x8369, 0x836A, 0x836B,
	0x836C, 0x836D, 0x836E, 0x8371, 0x8374, 0x8377, 0x837A, 0x837D,
	0x837E, 0x8380, 0x8381, 0x8382, 0x8384, 0x8386, 0x8388, 0x8389,
	0x838A, 0x838B, 0x838C, 0x838D, 0x838F, 0x8393, 0x814A, 0x814B,
} ;
/* K`h */
const	WORD	ga_do[] = {
	0x834B, 0x834D, 0x834F, 0x8351, 0x8353,
	0x8355, 0x8357, 0x8359,	0x835B, 0x835D,
	0x835F, 0x8361, 0x8364, 0x8366, 0x8368,
} ;
/* o`{ */
const	WORD	ba_bo[] = {
    0x836F, 0x8372, 0x8375, 0x8378, 0x837B,
} ;
/* p`| */
const	WORD	pa_po[] = {
    0x8370, 0x8373, 0x8376, 0x8379, 0x837C,
} ;

BOOL
InitKanjiControls( void )
{
	return InitLocal() ;
}

void
ReleaseKanjiControls( void )
{
	ReleaseLocal() ;
}

#include	"han2zen.c"

/*
 * G[_CAO\[`
 */
void
error_dialog( LPCTSTR message, LPCTSTR opt )
{
	TCHAR	buf[ 128 ] ;

	SetCursor( NULL ) ;
	wsprintf( buf, TEXT("%s:%s\n"), message, opt ) ;
	MessageBox( NULL,
				buf,
				TEXT("Error"),
				MB_ICONSTOP|MB_OK ) ;
}

/*
 * fobO_CAO\[`
 */
void
debug_dialog( LPCTSTR message, LPCTSTR opt )
{
	TCHAR	buf[ 128 ] ;

	SetCursor( NULL ) ;
	wsprintf( buf, TEXT("%s:%s\n(ErrorCode=%d)"), message, opt, GetLastError() ) ;
	MessageBox( NULL,
				buf,
				TEXT("Error"),
				MB_ICONSTOP|MB_OK ) ;
}

DWORD
GetFontZW( void )
{
	return FontZenVW ;
}

DWORD
GetFontHW( void )
{
	return FontHanVW ;
}

DWORD
GetFontH( void )
{
	return FontVH ;
}

void
SetTabWidth( DWORD tab )
{
	TabWidth = tab ;
}

DWORD
GetTabWidth( void )
{
	return TabWidth ;
}

DWORD
GetKVersion( void )
{
	return Version ;
}

/*
 * JIS <-> SJIS R[hϊ֌W
 */
/*
 * @́FVtgihrihrR[hϊ
 * @́Fsjis2jis_char
 * @TvFVtgihrR[hihrR[hɕϊ
 * Fsjis(WORD) = VtgihrR[h
 * ߂lFWORD = ihrR[h
 */
WORD
sjis2jis_char( WORD sjis )
{
	BYTE	c1 = sjis / 256 ;
	BYTE	c2 = sjis % 256 ;

    c1 -= (c1 <= 0x9F) ? 0x70 : 0xB0 ;
    c1 <<= 1 ;
    if ( c2 < 0x9F ) {
        c2 -= (c2 < 0x7F) ? 0x1F : 0x20 ;
        c1 -- ;
    } else {
        c2 -= 0x7E ;
	}
	return c1 << 8 | c2 ;
}

/*
 * @́FihrVtgihrR[hϊ
 * @́Fjis2sjis_char
 * @TvFihrR[hVtgihrR[hɕϊ
 * Fjis(WORD) = ihrR[h
 * ߂lFWORD = VtgihrR[h
 */
WORD
jis2sjis_char( WORD jis )
{
	BYTE	c1 = jis / 256 ;
	BYTE	c2 = jis % 256 ;

	if ( c1 & 1 ) {
		c1 >>= 1 ;
		c1 += 0x71 ;
		c2 += 0x1F ;
		if ( c2 >= 0x7F ) {
			c2 ++ ;
		}
	} else {
		c1 >>= 1 ;
		c1 += 0x70 ;
		c2 += 0x7E ;
	}
	if ( c1 > 0x9F ) {
		c1 += 0x40 ;
	}
	return (c1 << 8) | c2 ;
}

static	BOOL	F_base64 = FALSE ;
static	TCHAR	Base64Buf[3] ;
static	int		Base64Len = 0 ;
static	TCHAR	Base64Table[] = TEXT("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/") ;

static	void
PUT_base64( TCHAR c )
{
	Base64Buf[ Base64Len ++ ] = c ;
	if ( Base64Len >= 3 ) {
		Base64Len = 0 ;
		c = Base64Buf[0] >> 2 ;
		putchar_codeconv( Base64Table[c] ) ;
		c = ((Base64Buf[0] & 0x03) << 4) | (Base64Buf[1] >> 4) ;
		putchar_codeconv( Base64Table[c] ) ;
		c = ((Base64Buf[1] & 0x0F) << 2) | (Base64Buf[2] >> 6) ;
		putchar_codeconv( Base64Table[c] ) ;
		c = Base64Buf[2] & 0x3F ;
		putchar_codeconv( Base64Table[c] ) ;
	}
}

static	void
PUT_base64_flush( void )
{
	TCHAR	c ;

	if ( !Base64Len ) {
		return ;
	}
	c = Base64Buf[0] >> 2 ;
	putchar_codeconv( Base64Table[c] ) ;
	c = (Base64Buf[0] & 0x03) << 4 ;
	if ( Base64Len == 1 ) {
		putchar_codeconv( Base64Table[c] ) ;
		putchar_codeconv( '=' ) ;
	} else {
		c |= Base64Buf[1] >> 4 ;
		putchar_codeconv( Base64Table[c] ) ;
		c = (Base64Buf[1] & 0x0F) << 2 ;
		putchar_codeconv( Base64Table[c] ) ;
	}
	putchar_codeconv( '=' ) ;
}

static	void
start_base64( BOOL flag )
{
	if ( flag ) {
		puts_codeconv( TEXT("=?ISO-2022-JP?B?") ) ;
	}
	Base64Len = 0 ;
	F_base64 = TRUE ;
}

static	void
end_base64( BOOL flag )
{
	if ( F_base64 ) {
		F_base64 = FALSE ;
		PUT_base64_flush() ;
		if ( flag ) {
			putchar_codeconv( TEXT('?') ) ;
			putchar_codeconv( TEXT('=') ) ;
		}
	}
}

static	void
PUT_jis( TCHAR c )
{
	if ( F_base64 ) {
		PUT_base64( c ) ;
	} else {
		putchar_codeconv( c ) ;
	}
}

/* 
 * SJISJISR[hϊ
 */
static	void
sjis_jis( WORD sjis )
{
	WORD	jis = sjis2jis_char( sjis ) ;

	if ( F_convmode == MODE_QUOTE ) {
		TCHAR	c = jis / 256 ;
		if ( c == '"' ) {
			putchar_codeconv( TEXT('\\') ) ;
		}
		putchar_codeconv( c ) ;
		c = jis % 256 ;
		if ( c == '"' ) {
			putchar_codeconv( TEXT('\\') ) ;
		}
		putchar_codeconv( c ) ;
	} else {
		PUT_jis( (TCHAR) (jis / 256) ) ;
		PUT_jis( (TCHAR) (jis % 256) ) ;
	}
}

static	void
literals( int mode )
{
	switch ( mode ) {
	case 1:
		if ( F_convmode == MODE_BASE64 ) {
			start_base64( TRUE ) ;
		}
		PUT_jis( ESC ) ;	PUT_jis('$') ;	PUT_jis('B') ;	//PUT_jis('@') ;
		break ;
	case 2:
		PUT_jis( ESC ) ;	PUT_jis('(') ;	PUT_jis('B') ;	//PUT_jis('J') ;
		end_base64( TRUE ) ;
		break ;
	case 3:
		PUT_jis( 0x0E ) ;
		break ;
	case 4:
		PUT_jis( 0x0F ) ;
		break ;
	}
}

#define		IS_KANJI(c)		((c)&0xFF00)
#define		IS_HANKANA(c)	((0xA0<=(c))&&((c)<=0xDF))

/*
 * @́FUNICODE->JISR[hϊC
 * @́Funicode_jis_char
 * @TvFUNICODE->JISR[hϊsBsetup_codeconṽp[^
 * @@@FāČvZ܂͎ۂ̃R[hϊs
 * Fc = UNICODE(TCHAR)
 * ߂lFȂ
 * gp@F1.setup_codeconv(0)call
 * @@@F2.UNICODE̕SĂɂunicode_jis_charcall
 * @@@F3.unicode_jis_char(0)Ńobt@tbV
 * @@@F4.get_codeconv()ŁCϊɕKvȕ𓾂āCmۂ
 * @@@F5.setup_codeconv( [4.Ŋmۂ] )call
 * @@@F6.UNICODE̕SĂɂunicode_jis_charcall
 * @@@F7.unicode_jis_char(0)Ńobt@tbV
 * @@@FȏŃR[hϊsB
 */
void
unicode_jis_char( TCHAR c )
{
	if ( F_convmode == MODE_NOCONV ) {
		putchar_codeconv( c ) ;
		return ;
	}
	if ( !c ) {
		/* flush static buffer */
		if ( Stat == 4 ) {
			sjis_jis( hank_to_zenk[ C1 - C_KANA ] ) ;
		}
		if ( Stat == 2 || Stat == 4 ) {
			literals( 2 ) ;
		}
		Stat = 0 ;
		/* ŌɂOǉ */
		PUT_jis( 0 ) ;
		return ;
	}
	/* USJISR[hɂȂ */
	c = unicode2sjis_char( c ) ;
TOP:
	switch ( Stat ) {
	case 0:	/* pp[h */
		if ( IS_KANJI( c ) ) {
			/* ̏ꍇ */
			literals( 1 ) ;
			sjis_jis( c ) ;
			Stat = 2 ;
		} else if ( IS_HANKANA( c ) ) {
			/* pJȉꍇ */
			C1 = c ;
			literals( 1 ) ;
			Stat = 4 ;
		} else {
			PUT_jis( c ) ;
			// Stat = 0 ;
		}
		break ;
	case 2:	/* [h */
		if ( IS_KANJI( c ) ) {
			/* ̏ꍇ */
			sjis_jis( c ) ;
			// Stat = 2 ;
		} else if ( IS_HANKANA( c ) ) {
			/* pJȉꍇ */
			C1 = c ;
			Stat = 4 ;
		} else {
			/* p̏ꍇ */
			literals( 2 ) ;
			Stat = 0 ;
			goto TOP ;
		}
		break ;
	case 4:	/* pJi[h */
		if ( c == C_DAKUTEN ) {
			/* _̏ꍇ */
			if ( C1 == C_U ) {
				/*  */
				sjis_jis( 0x8394 ) ;
			} else if ( C1 >= C_KA && C1 <= C_TO ) {
				/* K`h */
				sjis_jis( ga_do[ C1 - C_KA ] ) ;
			} else if ( C1 >= C_HA && C1 <= C_HO ) {
				/* o`{ */
				sjis_jis( ba_bo[ C1 - C_HA ] ) ;
			} else {
				sjis_jis( hank_to_zenk[ C1 - C_KANA ] ) ;
				sjis_jis( hank_to_zenk[ c  - C_KANA ] ) ;
			}
			Stat = 2 ;
		} else if ( c == C_HANDAKU ) {
			/* _̏ꍇ */
			if ( C1 >= C_HA && C1 <= C_HO ) {
				/* p`| */
				sjis_jis( pa_po[ C1 - C_HA ] ) ;
			} else {
				sjis_jis( hank_to_zenk[ C1 - C_KANA ] ) ;
				sjis_jis( hank_to_zenk[ c  - C_KANA ] ) ;
			}
			Stat = 2 ;
		} else if ( IS_HANKANA( c ) ) {
			/* pJȉꍇ */
			sjis_jis( hank_to_zenk[ C1 - C_KANA ] ) ;
			C1 = c ;
			Stat = 4 ;
		} else if ( IS_KANJI( c ) ) {
			/* ̏ꍇ */
			sjis_jis( hank_to_zenk[ C1 - C_KANA ] ) ;
			Stat = 2 ;
			goto TOP ;
		} else {
			/* p̏ꍇ */
			sjis_jis( hank_to_zenk[ C1 - C_KANA ] ) ;
			literals( 2 ) ;
			Stat = 0 ;
			goto TOP ;
		}
		break ;
	}
}

/*
 * JISUNICODER[hϊ
 */
static	void
clear_pending( void )
{
	PendingSize = 0 ;
}

static	void
add_pending( TCHAR c )
{
	PendingBuffer[ PendingSize ++ ] = c ;
}

static	void
put_pending( void )
{
	LPTSTR	ptr = PendingBuffer ;

	if ( !PendingSize ) {
		return ;
	}
	do {
		putchar_codeconv( *ptr++ ) ;
	} while ( -- PendingSize ) ;
}

#define		is_sjis1byte(x)	(((x)>=0x81 && (x)<=0x9F)||((x)>=0xE0 && (x)<=0xFC))

enum jis_unicode {
	ANK_NORMAL, ANK_ESC, ANK_ESC1, ANK_ESC2,
	JIS_NORMAL, JIS_ESC, JIS_ESC1, JIS_ESC2, JIS_2BYTE,
	SJIS_2BYTE
} ;

/*
 * @́FJIS->UNICODER[hϊC
 * @́Fjis_unicode_char
 * @TvFJIS->UNICODER[hϊsBsetup_codeconṽp[^
 * @@@FāČvZ܂͎ۂ̃R[hϊs
 * Fc = JIS(TCHAR)
 * ߂lFȂ
 * gp@F1.setup_codeconv(0)call
 * @@@F2.JIS̕SĂɂjis_unicode_charcall
 * @@@F3.jis_unicode_char(0)Ńobt@tbV
 * @@@F4.get_codeconv()ŁCϊɕKvȕ𓾂āCmۂ
 * @@@F5.setup_codeconv( [4.Ŋmۂ] )call
 * @@@F6.JIS̕SĂɂjis_unicode_charcall
 * @@@F7.jis_unicode_char(0)Ńobt@tbV
 * @@@FȏŃR[hϊsB
 */
void
jis_unicode_char( TCHAR c )
{
	WORD	sjis ;
	TCHAR	last ;

	if ( !c ) {
		/* c == 0 ̏ꍇ̓obt@tbV */
		put_pending() ;
		return ;
	}
	add_pending( c ) ;
	switch ( Stat ) {
	case ANK_NORMAL:
		if ( c >= 0x100 ) {
			goto put_ank_normal ;
		} else if ( is_sjis1byte( c ) ) {
			Stat = SJIS_2BYTE ;
			break ;
		} else if ( c != ESC ) {
			if ( c == 0xA0 ) {
				PendingBuffer[ PendingSize - 1 ] = 0x20 ;
			}
			goto put_ank_normal ;
		}
		Stat = ANK_ESC ;
		break ;
	case ANK_ESC:	/* ESC */
		if ( c == '$' ) {
			Stat = ANK_ESC1 ;
			break ;
		} else if ( c == '(' ) {
			Stat = ANK_ESC2 ;
			break ;
		}
		goto put_ank_normal ;
	case ANK_ESC1:	/* ESC $ */
		if ( c != '@' && c != 'B' ) {
			goto put_ank_normal ;
		}
		/* ESC $ [@B] ôJIS[hɈڍs */
		clear_pending() ;
		Stat = JIS_NORMAL ;
		break ;
	case ANK_ESC2:	/* ESC ( */
		if ( c != 'J' && c != 'B' ) {
			goto put_ank_normal ;
		}
		/* ESC ( B o */
		clear_pending() ;
		Stat = ANK_NORMAL ;
		break ;
	case JIS_NORMAL:	/* (JIS) */
		if ( c == ESC ) {
			Stat = JIS_ESC ;
			break ;
		} else if ( c < ' ' ) {
			goto put_ank_normal ;
		}
		Stat = JIS_2BYTE ;
		break ;
	case JIS_ESC:	/* (JIS) ESC */
		if ( c == '$' ) {
			Stat = JIS_ESC1 ;
			break ;
		} else if ( c == '(' ) {
			Stat = JIS_ESC2 ;
			break ;
		}
		goto put_jis_normal ;
	case JIS_ESC1:	/* (JIS) ESC $ */
		if ( c != '@' && c != 'B' ) {
			goto put_jis_normal ;
		}
		/* ESC $ [@B] o */
		clear_pending() ;
		Stat = JIS_NORMAL ;
		break ;
	case JIS_ESC2:	/* (JIS) ESC ( */
		if ( c != 'J' && c != 'B' && c != 'I' ) {
			goto put_jis_normal ;
		}
		clear_pending() ;
		Stat = ANK_NORMAL ;
		break ;
	case JIS_2BYTE:	/* (JIS) 2byte */
		last = PendingBuffer[0] ;
		/* JISSJISUNICODEϊďo͂ */
		sjis = jis2sjis_char( (WORD) ((last << 8) | c) ) ;
		c = sjis2unicode_char( sjis ) ;
		putchar_codeconv( c ) ;
		/* JIS_NORMAL[hɈڍs */
		clear_pending() ;
		Stat = JIS_NORMAL ;
		break ;
	case SJIS_2BYTE:
		/* 2oCgďo͂ */
		last = PendingBuffer[0] ;
		c = (last << 8) | c ;
		c = sjis2unicode_char( c ) ;
		putchar_codeconv( c ) ;
		/* ANK_NORMAL[hɈڍs */
		clear_pending() ;
		Stat = ANK_NORMAL ;
		break ;
	}
	return ;

put_ank_normal:
	/* PendingBuffero͂ă[hANK_NORMALɂ */
	Stat = ANK_NORMAL ;
	put_pending() ;
	return ;

put_jis_normal:
	/* PendingBuffero͂ă[hJIS_NORMALɂ */
	Stat = JIS_NORMAL ;
	put_pending() ;
	return ;
}

/*
 * @́FR[hϊJn
 * @́Fsetup_codeconv
 * @TvFϊɐ旧ĕϊ̗̈w肷
 * Fptr = ϊ̗̈
 * ߂lFȂ
 * @lFptr = NULL ƂꍇCۂɗ̈ւ݂͍̏sꂸ
 * @@@F̃JEĝݍsBŁCgetcount_codeconvŕϊ
 * @@@FɕKvȕ𓾂邱ƂłB
 */
void
setup_codeconv( LPTSTR ptr )
{
	ConvPtr = ptr ;
	ConvCount = 0 ;
	Stat = 0 ;
	C1 = 0 ;
	F_base64 = FALSE ;
}

/*
 * @́Fϊ敶擾
 * @́Fgetcount_codeconv
 * @TvFR[hϊɕKvȗ̈TCY߂
 * FȂ
 * ߂lF(DWORD)
 */
DWORD
getcount_codeconv( void )
{
	return ConvCount ;
}

/*
 * @́Fi[
 * @́Fputchar_codeconv
 * @TvF1ϊobt@Ɋi[
 * Fc = i[镶
 * ߂lFȂ
 */
void
putchar_codeconv( TCHAR c )
{
	if ( ConvPtr ) {
		/* ̈ɏ */
		*ConvPtr++ = c ;
	} else {
		/* JEg */
		ConvCount ++ ;
	}
}

/*
 * @́Fi[
 * @́Fputs_codeconv
 * @TvFϊobt@Ɋi[
 * Fstr = i[镶
 * ߂lFȂ
 */
void
puts_codeconv( LPCTSTR str )
{
	TCHAR	c ;

	while ( c = *str++ ) {
		putchar_codeconv( c ) ;
	}
}

/*
 * @́Fϊ[hݒ
 * @́Fset_convmode
 * @TvFR[hϊ̃[hݒ肷
 * Fmode = 0:W, 1:GXP[vgp, 2:Base64
 * ߂lFȂ
 */
void
set_convmode( DWORD mode )
{
	end_base64( TRUE ) ;
	F_convmode = mode ;
}
