loop

call clrscr
print "Cursor positioning test"

loop for i%=1 to 10
   call curpos(i%*2,i%)
   print i%
   endloop

!call pause("Press any key to continue")
wait 1.5



call clrscr
print "Testing point plot"
call color(3)

loop for i%=0 to 470 step 20
loop for j%=0 to 170 step 20
   call point(i%,j%)
   endloop
   endloop

!call pause("Press any key to continue")
wait 1.5
print



call clrscr
print "Testing line drawing"
call color(3)

loop for i%=1 to 186 step 2
   call line(0,i%,479,186-i%)
   endloop

!call pause("Press any key to continue")
wait 1.5
print

call curpos(0,0)
print "Testing rectangle fill"

call color(0)
call fillrect(10,50,50,100)



!call pause("Press any key to continue")
wait 1.5
print

call clrscr
print "Plot test"
call gr_init
call gr_setwin(50,200,1,91)
call gr_setscale(0,7,-1,1)

call gr_xaxis(0,7,1,5,0,8,8)
call gr_xaxis(0,7,1,5,-1,0,8)
call gr_xaxis(0,7,1,5,1,8,0)

call gr_yaxis(-1,1,0.5,2,0,0,8)
call gr_yaxis(-1,1,0.5,2,7,8,0)

t# = 0
pen% = 0
loop
  while t# < 6.28
  y#=sin(t#)
  call gr_plot(t#,y#,pen%)
  pen%=1
  t# = t#+0.1
  endloop

call gr_setwin(250,400,1,91)
call gr_setscale(0,7,-1,1)

call gr_xaxis(0,7,1,5,0,8,8)
call gr_xaxis(0,7,1,5,-1,0,8)
call gr_xaxis(0,7,1,5,1,8,0)

call gr_yaxis(-1,1,0.5,2,0,0,8)
call gr_yaxis(-1,1,0.5,2,7,8,0)

t# = 0
pen% = 0
loop
  while t# < 6.28
  y#=cos(t#)
  call gr_plot(t#,y#,pen%)
  pen%=1
  t# = t#+0.1
  endloop

!call pause("Press any key to continue")
wait 1.5
print

endloop


procedure gr_init
  gr_width# = 480
  gr_height# = 188
  gr_curx# = 0
  gr_cury# = 0
  gr_color% = 3
  gr_curx% = 0
  gr_cury% = 0
  call gr_setwin(0,gr_width#,0,gr_height#)
  call gr_setscale(0,1,0,1)
  call color(gr_color%)
  endproc

procedure gr_color(uu%)
  gr_color% = uu%
  call color(gr_color%)
  endproc

procedure gr_setwin(xmin%,xmax%,ymin%,ymax%)
  gr_win_xmin% = xmin%
  gr_win_xmax% = xmax%
  gr_win_ymin% = ymin%
  gr_win_ymax% = ymax%
  gr_win_width# = (xmax% - xmin%)
  gr_win_height# = (ymax% - ymin%)
  endproc

procedure gr_setscale(xmin#,xmax#,ymin#,ymax#)
  gr_xmin# = xmin#
  gr_xmax# = xmax#
  gr_ymin# = ymin#
  gr_ymax# = ymax#
  gr_xscale# = 1.0/(xmax# - xmin#)
  gr_yscale# = 1.0/(ymax# - ymin#)
  endproc

procedure gr_scalex(x#)
  gr_ux% = (x#-gr_xmin#) * gr_xscale# * gr_win_width# + gr_win_xmin%
  return (gr_ux%)
  endproc

procedure gr_scaley(y#)
  gr_uy% = gr_height# - ((y#-gr_ymin#) * gr_yscale# * gr_win_height# + gr_win_ymin%)
  return (gr_uy%)
  endproc

procedure gr_plot(x#,y#,pen%)
  gr_ux% = gr_scalex(x#)
  gr_uy% = gr_scaley(y#)
  if pen% then
    call line(gr_curx%,gr_cury%,gr_ux%,gr_uy%)
  endif
  gr_curx# = x#
  gr_curx% = gr_ux%
  gr_cury# = y#
  gr_cury% = gr_uy%
  endproc

procedure gr_point(x#,y#)
  gr_ux% = gr_scalex(x#)
  gr_uy% = gr_scaley(y#)
  call point(gr_ux%,gr_uy%)
  gr_curx# = x#
  gr_curx% = gr_ux%
  gr_cury# = y#
  gr_cury% = gr_uy%
  endproc

procedure gr_clrwin
  call fillrect(gr_win_xmin%,gr_win_ymin%,gr_win_xmax%,gr_win_ymax%)
  endproc

procedure gr_xaxis(min#,max#,tick#,minticks%,pos#,below%,above%)
  utmp# = tick#/minticks%
  ux# = min#
  up% = 0
  u1% = below%/2
  u2% = above%/2
  tickcnt% = 0
  loop

    call gr_plot(ux#,pos#,up%)
    up%=1

    if tickcnt% = 0 then
      call line(gr_curx%,gr_cury%-above%,gr_curx%,gr_cury%+below%)
      else
      call line(gr_curx%,gr_cury%-u2%,gr_curx%,gr_cury%+u1%)
      endif

    ux#=ux#+utmp#

    tickcnt% = tickcnt%+1
    if tickcnt% = minticks% then
       tickcnt% = 0
       endif

    while ux# < (max# + utmp#/2)

    endloop

  endproc

procedure gr_yaxis(min#,max#,tick#,minticks%,pos#,left%,right%)
  utmp# = tick#/minticks%
  uy# = min#
  up% = 0
  u1% = left%/2
  u2% = right%/2
  tickcnt% = 0
  loop

    call gr_plot(pos#,uy#,up%)
    up%=1

    if tickcnt% = 0 then
      call line(gr_curx%-left%,gr_cury%,gr_curx%+right%,gr_cury%)
      else
      call line(gr_curx%-u1%,gr_cury%,gr_curx%+u2%,gr_cury%)
      endif

    uy#=uy#+utmp#

    tickcnt% = tickcnt%+1
    if tickcnt% = minticks% then
       tickcnt% = 0
       endif

    while uy# < (max# + utmp#/2)

    endloop

  endproc

