#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
extern "C" {
#include <notify.h>
}
#include <tchar.h>
//#include <stdlib.h>
extern "C" wchar_t * _itow( int value, wchar_t *string, int radix );

WCHAR szAppName[80];
WCHAR szTitle[80]; 
WCHAR szCurrentDirectory[80]=L"\\";
WCHAR szQualifiedName[160]=L"\\timer.exe";

// Emulation size window | resolution of Pegasus machine
const int WINDOW_WIDTH = 480;   
const int WINDOW_HEIGHT = 214; 
const int PATH_MAX = 255;

const int cbWidth = 50;
const int cbWidth2 = 76;
const int cbID = 101;
const int cbID2 = 102;

 // Height of caption bar
int nCaptionSize  = GetSystemMetrics( SM_CYCAPTION );  

 // Width and Height of Client Area
RECT rc;
int CLIENT_WIDTH;         
int CLIENT_HEIGHT;

int iCount=0;
int i = 0;
int units = 1;
int num = 1;
HANDLE hn=NULL;
HWND hwndCB,hwndCombo,hwndCombo2;
HDC hDC;
HINSTANCE hInst=NULL;
SYSTEMTIME tm;
TCHAR pwszSound[PATH_MAX]=L"ALARM1.WAV";
PEG_USER_NOTIFICATION un = {
	PUN_DIALOG | PUN_LED | PUN_SOUND | PUN_REPEAT,
	L"Egg Timer",
	L"It's time!",
	pwszSound,
	PATH_MAX*sizeof(TCHAR),
	0};

LRESULT DoCommand( HWND hWnd, WORD id)
{
	switch (id) {
	case IDOK:
		PegGetUserNotificationPreferences(hWnd,&un);
		GetLocalTime(&tm);
		num=SendMessage(hwndCombo,CB_GETCURSEL,0,0);
		units=SendMessage(hwndCombo2,CB_GETCURSEL,0,0);
		switch(units) {
		case 0:
			tm.wSecond += num;
			break;
		case 1:
			tm.wMinute += num;
			break;
		case 2:
			tm.wHour += num;
			break;
		default:
			tm.wMinute += num;
			break;
		}
		while(tm.wSecond>=60) {
			tm.wSecond -= 60;
			tm.wMinute++;
		}
		while(tm.wMinute>=60) {
			tm.wMinute -= 60;
			tm.wHour++;
		}
		while(tm.wHour>=24) {
			tm.wHour -= 24;
			tm.wDay++;
		}

		hn=PegSetUserNotification(0,szQualifiedName,&tm,&un);
		if(hn==0) {
			MessageBox(hWnd,L"PegSetUserNotification failed",L"Debug",MB_OK);
		}
		else {
			PegHandleAppNotifications(szQualifiedName);
			hDC=GetDC(hWnd);
			ExtTextOut(hDC,4,nCaptionSize+2,ETO_OPAQUE,&rc,L"Timer set!",10,NULL);
			ReleaseDC(hWnd,hDC);
		}
		break;

	case cbID:
	case cbID2:
//		MessageBox(hWnd,L"ComboBox message seen",L"Debug",MB_OK);
		break;

	default:
		break;
	}
	return 0;
}

LRESULT CALLBACK WndProc (	HWND hWnd,
							UINT message,
							WPARAM uParam,
							LPARAM lParam )
{
	TCHAR tz[4];
    HDC hdc;
    PAINTSTRUCT ps;

    switch (message) {
    case WM_COMMAND:
          DoCommand(hWnd, GET_WM_COMMAND_ID(uParam, lParam));
          break;

	case WM_CREATE:
		hwndCB = CommandBar_Create(hInst, hWnd, 1);
		hwndCombo = CommandBar_InsertComboBox(hwndCB,hInst,cbWidth,CBS_DROPDOWNLIST|WS_VSCROLL,cbID,0);
		hwndCombo2= CommandBar_InsertComboBox(hwndCB,hInst,cbWidth2,CBS_DROPDOWNLIST|WS_VSCROLL,cbID2,1);
		CommandBar_AddAdornments(hwndCB, CMDBAR_OK, 0);
		for(i=0;i<100;i++) {
			_itow(i,tz,10);
			SendMessage(hwndCombo,CB_ADDSTRING,0,(long)tz);
		}
		SendMessage(hwndCombo,CB_SETCURSEL,3,0); //default to 3

		SendMessage(hwndCombo2,CB_ADDSTRING,0,(long)TEXT("seconds"));
		SendMessage(hwndCombo2,CB_ADDSTRING,0,(long)TEXT("minutes"));
		SendMessage(hwndCombo2,CB_ADDSTRING,0,(long)TEXT("hours"));
		SendMessage(hwndCombo2,CB_SETCURSEL,1,0); //default to minutes

		rc.top=nCaptionSize;
		break;

	case WM_PAINT:
	    hdc = BeginPaint(hWnd, &ps);
	    EndPaint(hWnd, &ps);
	    break;

	case WM_DESTROY:
	    PostQuitMessage(0);
	    break;

	default:
	    return (DefWindowProc(hWnd, message, uParam, lParam));
    }

    return (0);
}
/***************************************************************************

		BOOL InitApplication ( HINSTANCE hInstance )

****************************************************************************/
BOOL InitApplication ( HINSTANCE hInstance )
{
    WNDCLASSW  wc;
    BOOL f;

    wc.style =  0 ;                     
    wc.lpfnWndProc = (WNDPROC) WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = NULL;                              
    wc.hCursor = NULL;                                           
    wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = szAppName;

    f = (RegisterClass(&wc));
    return f;
}
/*************************************************************************************

		BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )

  ************************************************************************************/

BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
    HWND hWnd;
	hInst = hInstance;

                               	// Use default window settings
#ifdef TARGET_NT
	 hWnd = CreateWindow(szAppName,szTitle,WS_POPUP,
	                     0,0,CW_USEDEFAULT,CW_USEDEFAULT,
	                     NULL, NULL, hInstance, NULL);
#else
	 hWnd = CreateWindow(szAppName,szTitle,WS_VISIBLE,
	                     0,0,CW_USEDEFAULT,CW_USEDEFAULT,
	                     NULL, NULL, hInstance, NULL);
#endif


     if ( hWnd == 0 )    // Check CreateWindow return values for validity
		{ return (FALSE); }
	 if (IsWindow(hWnd) != TRUE) 
	    { return (FALSE); }

    GetClientRect(hWnd, &rc);
    CLIENT_WIDTH = rc.right;
    CLIENT_HEIGHT = rc.bottom;
    ShowWindow(hWnd, SW_SHOW);
    UpdateWindow(hWnd);

/*	GetCurrentDirectory(80,szCurrentDirectory);
	lstrcpy(szQualifiedName,szCurrentDirectory);
	lstrcat(szQualifiedName,szAppName);
	lstrcat(szQualifiedName,L".exe");
*/
	PegHandleAppNotifications(szQualifiedName);

    return(TRUE);                  // Window handle hWnd is valid   
}
/***************************************************************************

		int WINAPI WinMain ( HINSTANCE hInstance, HINSTANCE hPrevInstance,
						   	 LPWSTR lpCmdLine ,UINT nCmdShow )

  **************************************************************************/

int WINAPI WinMain ( HINSTANCE hInstance,
		             HINSTANCE hPrevInstance,
                     LPWSTR lpCmdLine,     
                     int nCmdShow )

{
    MSG msg;
	HWND hwndPrev;

	//Load strings
	LoadString(hInstance,1,szAppName,
		       sizeof(szAppName)/sizeof(TCHAR));
	LoadString(hInstance, 2,szTitle,
		       sizeof(szTitle)/sizeof(TCHAR));

   
    if ( lstrlen(lpCmdLine) ) {
		PegHandleAppNotifications(szQualifiedName);
		hwndPrev=FindWindow(szAppName,szTitle);
		if(hwndPrev) {
			SetFocus(hwndPrev);
			return (FALSE);
		}
	}

    if ( hPrevInstance == 0 )
	{
		if ( InitApplication(hInstance) == FALSE ) 
			{ return(FALSE);}
    }

    if ( InitInstance(hInstance, nCmdShow) == FALSE ) 
		{ return(FALSE);}


    while ( GetMessage(&msg, NULL, 0, 0) == TRUE ) 
	{
		
		DispatchMessage(&msg);
    }

    return(msg.wParam);
}
