  /* Bubble

   by Tenny Woo 
   tennywoo@hotmail.com

  */


import waba.fx.*;
import waba.ui.*;
import waba.sys.*;


public class bubble extends App
{
  Graphics thisg=new Graphics(this);

  // game stage
  int intLevel=0; // init level
  MAP oMAP;
  GAME oGAME;
  GUI oGUI;
  ARROW oARROW;
  int LandX=0, LandY=0;
  int LandI=0, LandJ=0;
  int CurrentBall=0;
  int LastActionFinished=0;
  float ArrowSpeed=1.0f;

  public void onStart()
  {
    UTL.SetRandomSeed();
    oMAP=new MAP(intLevel);
    oGAME=new GAME();
    oGUI=new GUI(thisg);
    oARROW=new ARROW(thisg);
    setTimerInterval(VAR.GAMESPEED);
  }

  public void onPaint(Graphics gPaint)
  {
    ClearScreen();
    oMAP.Paint(thisg);
    oGUI.Paint(oGAME.ThisBall, oGAME.NextBall);
    oARROW.SaveImage((ISurface) this);
    oARROW.Paint();
  }

  void ClearScreen()
  {
    thisg.setColor(VAR.WHITE, VAR.WHITE, VAR.WHITE);
    thisg.fillRect(VAR.LEFT,VAR.TOP,VAR.WIDTH,VAR.HEIGHT);
  }

  public void onTimerTick()
  {
    if (oGUI.Stage==oGUI.NOTHING || oGUI.Stage==oGUI.SHOOTBUTTON)
    {
      return;
    }
    if (ArrowSpeed<7)
    {
      ArrowSpeed=ArrowSpeed+0.3f;
    }
    if (oGUI.Stage==oGUI.LEFTBUTTON)
    {
      oARROW.TurnLeft((int)ArrowSpeed);
    }
    if (oGUI.Stage==oGUI.RIGHTBUTTON)
    {
      oARROW.TurnRight((int)ArrowSpeed);
    }
    oARROW.Paint();
    return;
  }

  public void onEvent(Event event)
  {
    int intRet=0;

    if (event.type==PenEvent.PEN_UP)
    {
      oGUI.Release();
      return;
    }

    if (event.type==PenEvent.PEN_DOWN)
    {
      PenEvent penEvent = (PenEvent)event;

      if (intLevel==-1)
      {
        exit(0); // game over
      }

      intRet = oGUI.Click(penEvent.x,penEvent.y); // 0-nothing, 1-click left, 2-click right
      if (intRet==oGUI.LEFTBUTTON || intRet==oGUI.RIGHTBUTTON)
      {
        ArrowSpeed=1.0f;
      }
      if (intRet==oGUI.SHOOTBUTTON)
      {
        if (penEvent.timeStamp > LastActionFinished && penEvent.timeStamp < LastActionFinished+500)
        {
          // just shoot within last second
          LastActionFinished=penEvent.timeStamp;
          return;
        }
        LastActionFinished=penEvent.timeStamp;

        CurrentBall=oGAME.ThisBall;
        Shoot();
        oGAME.GetBall(); // get next ball
        if (PopBubble())
        {
          UnlinkBubble();
        }
        oMAP.Down();

        if (CheckGameOver())
        {
          return;
        }
        if (CheckGameFinish())
        {
          oMAP=new MAP(intLevel);
          if (!oMAP.LevelInited)
          {
            thisg.drawImage(new Image("gamedone.wbm"), VAR.LEFT, VAR.TOP);
            intLevel=-1;
            return;
          }
          oGAME=new GAME();
        }
        oMAP.Paint(thisg);
        oGUI.Paint(oGAME.ThisBall, oGAME.NextBall);
        oARROW.SaveImage((ISurface) this);
        oARROW.Paint();
      }
    }
  }

  boolean CheckGameFinish()
  {
    int i=0, j=0;

    for (i=0;i<MAP.row;i++)
    {
      for (j=0;j<MAP.column;j++)
      {
        if (MAP.type[i][j]!=-1)
        {
          return false;
        }
      }
    }
    ++intLevel;
    return true;
  }

  boolean CheckGameOver()
  {
    int j=0;

    for (j=0;j<MAP.column;j++)
    {
      if (MAP.type[MAP.row-1-oMAP.DownLevel][j]!=-1)
      {
        oMAP.Paint(thisg);
        Vm.sleep(3000);
        thisg.drawImage(new Image("gameover.wbm"), VAR.LEFT, VAR.TOP);
        intLevel=-1;
        return true;
      }
    }
    return false;
  }

  void Shoot()
  {
    int i=0;
    int x=VAR.THISBALLX,y=VAR.THISBALLY;
    Image iSaved=new Image(VAR.WIDTH, VAR.HEIGHT);
    Graphics gSaved=new Graphics(iSaved);
    Image iDraw=new Image(VAR.BALLD+12, VAR.BALLD+12);
    Graphics gDraw=new Graphics(iDraw);

    thisg.setColor(VAR.WHITE, VAR.WHITE, VAR.WHITE);
    thisg.fillRect(VAR.THISBALLX, VAR.THISBALLY, VAR.BALLD, VAR.BALLD);
    // save the screen
    gSaved.copyRect((ISurface) this, VAR.TOP, VAR.LEFT, VAR.WIDTH, VAR.HEIGHT, 0, 0);

    while (!Landed(x,y))
    {
      x=(int) (VAR.SIN[oARROW.Degree]*i+VAR.THISBALLX);

      // if ball reach edge
      while (x<=VAR.LEFT || x>VAR.RIGHT-VAR.BALLD)
      {
        if (x<=VAR.LEFT) x=1-x;
        if (x>VAR.RIGHT-VAR.BALLD) x=VAR.RIGHT-VAR.BALLD-(x-(VAR.RIGHT-VAR.BALLD));
      }
      y=(int) (VAR.COS[oARROW.Degree]*i+VAR.THISBALLY);
      i=i+6; // step 6

      gDraw.setDrawOp(gDraw.DRAW_OVER);
      gDraw.copyRect(iSaved, x-6, y-6, VAR.BALLD+12, VAR.BALLD+12, 0, 0);
      gDraw.setDrawOp(gDraw.DRAW_OR);
      gDraw.drawImage(BMP.Ball[CurrentBall], 6, 6);
      thisg.drawImage(iDraw, x-6, y-6);
    }

    gSaved.setDrawOp(gSaved.DRAW_OR);
    gSaved.drawImage(BMP.Ball[CurrentBall], LandX, LandY);
    thisg.setDrawOp(thisg.DRAW_OVER);
    thisg.copyRect(iSaved, 0, 0, VAR.WIDTH, VAR.HEIGHT, VAR.TOP, VAR.LEFT);
  }

  boolean Landed(int x, int y)
  {
    int i=0, j=0;
    int nearest=9999, nearestHit=9999, distance=0;

    if (y<=VAR.TOP+(oMAP.DownLevel*VAR.BALLVS)) // if ball reach top!
    {
      for (j=0;j<MAP.column;j++)
      {
        distance=UTL.abs((MAP.x[0][j]-x)*(MAP.x[0][j]-x))+UTL.abs(((oMAP.DownLevel*VAR.BALLVS+MAP.y[0][j])-y)*((oMAP.DownLevel*VAR.BALLVS+MAP.y[0][j])-y));
        if (nearest>distance)
        {
          nearest=distance;
          LandI=0; LandJ=j;
          this.LandX=MAP.x[0][j];
          this.LandY=oMAP.DownLevel*VAR.BALLVS+MAP.y[0][j];
        }
      }
      MAP.type[LandI][LandJ]=CurrentBall;
      return true;
    }

    // get nearest landing and hitting point
    nearest=9999;
    for (i=0;i<MAP.row;i++)
    {
      for (j=0;j<MAP.column;j++)
      {
        distance=UTL.abs((MAP.x[i][j]-x)*(MAP.x[i][j]-x))+UTL.abs(((oMAP.DownLevel*VAR.BALLVS+MAP.y[i][j])-y)*((oMAP.DownLevel*VAR.BALLVS+MAP.y[i][j])-y));
        if (MAP.type[i][j]!=-1 && nearestHit>distance)
        {
          nearestHit=distance;
        }
        if (nearest>distance)
        {
          nearest=distance;
          LandI=i; LandJ=j;
          this.LandX=MAP.x[i][j];
          this.LandY=oMAP.DownLevel*VAR.BALLVS+MAP.y[i][j];
        }
      }
    }

    if (nearestHit<=700)  // 700=BALLD*BALLD-200
    {
      // hit!
      MAP.type[LandI][LandJ]=CurrentBall;
      return true;
    }

    return false;
  }

  boolean PopBubble()
  {
    int I[]=new int[MAP.row*MAP.column];
    int J[]=new int[MAP.row*MAP.column];
    int CP=0; // Check Point
    int QE=0; // Queue Ending point
    int i=0;

    // init to -1
    for (i=0;i<MAP.row*MAP.column;i++)
    {
      I[i]=-1; J[i]=-1;
    }

    I[QE]=LandI; J[QE]=LandJ;
    MAP.type[I[QE]][J[QE]]=100; // 100 = popping

    while (CP<=QE) // something to check on the list
    {
      // check if same type to the right
      if (J[CP]<MAP.column-1)
      {
        if (MAP.type[I[CP]][J[CP]+1]==CurrentBall)
        {
          ++QE;
          I[QE]=I[CP]; J[QE]=J[CP]+1;
          MAP.type[I[QE]][J[QE]]=100; // 100 = popping
        }
      }

      // check if same type to the left
      if (J[CP]>0)
      {
        if (MAP.type[I[CP]][J[CP]-1]==CurrentBall)
        {
          ++QE;
          I[QE]=I[CP]; J[QE]=J[CP]-1;
          MAP.type[I[QE]][J[QE]]=100; // 100 = popping
        }
      }

      // check if same type to the upper left
      if (I[CP]>0 && J[CP]>0)
      {
        if (MAP.type[I[CP]-1][J[CP]-(I[CP]%2)]==CurrentBall)
        {
          ++QE;
          I[QE]=I[CP]-1; J[QE]=J[CP]-(I[CP]%2);
          MAP.type[I[QE]][J[QE]]=100; // 100 = popping
        }
      }

      // check if same type to the upper right
      if (I[CP]>0 && (J[CP]<MAP.column-1 || (I[CP]%2)==1))
      {
        if (MAP.type[I[CP]-1][J[CP]+(1-I[CP]%2)]==CurrentBall)
        {
          ++QE;
          I[QE]=I[CP]-1; J[QE]=J[CP]+(1-I[CP]%2);
          MAP.type[I[QE]][J[QE]]=100; // 100 = popping
        }
      }

      // check if same type to the lower left
      if (I[CP]<MAP.row-1 && J[CP]>0)
      {
        if (MAP.type[I[CP]+1][J[CP]-(I[CP]%2)]==CurrentBall)
        {
          ++QE;
          I[QE]=I[CP]+1; J[QE]=J[CP]-(I[CP]%2);
          MAP.type[I[QE]][J[QE]]=100; // 100 = popping
        }
      }

      // check if same type to the lower right
      if (I[CP]<MAP.row-1 && (J[CP]<MAP.column-1 || (I[CP]%2)==1))
      {
        if (MAP.type[I[CP]+1][J[CP]+(1-I[CP]%2)]==CurrentBall)
        {
          ++QE;
          I[QE]=I[CP]+1; J[QE]=J[CP]+(1-I[CP]%2);
          MAP.type[I[QE]][J[QE]]=100; // 100 = popping
        }
      }

      ++CP;
    }

    if (QE>=2)
    {
      for (i=0;i<=QE;i++)
      {
        thisg.drawImage(BMP.BallPop,MAP.x[I[i]][J[i]],MAP.y[I[i]][J[i]]+(oMAP.DownLevel*VAR.BALLVS));
        MAP.type[I[i]][J[i]]=-1; // reset to blank
      }
      return true;
    }
    else
    {
      for (i=0;i<=QE;i++)
      {
        MAP.type[I[i]][J[i]]=CurrentBall; // reset to original type
      }
    }

    return false;
  }

  void UnlinkBubble()
  {
    int I[]=new int[MAP.row*MAP.column];
    int J[]=new int[MAP.row*MAP.column];
    int CP=0; // Check Point
    int QE=-1; // Queue Ending point
    int i=0, j=0;

    // init to -1
    for (i=0;i<MAP.row*MAP.column;i++)
    {
      I[i]=-1; J[i]=-1;
    }

    // get top most linked
    for (j=0;j<MAP.column;j++)
    {
      if (MAP.type[0][j]!=-1) // something
      {
        ++QE;
        I[QE]=0; J[QE]=j;
        MAP.type[I[QE]][J[QE]]=MAP.type[I[QE]][J[QE]]+100; // +100 = linked
      }
    }

    while (CP<=QE) // something to check on the list
    {
      // check if linked to the right
      if (J[CP]<MAP.column-1)
      {
        if (MAP.type[I[CP]][J[CP]+1]!=-1 && MAP.type[I[CP]][J[CP]+1]<100)
        {
          ++QE;
          I[QE]=I[CP]; J[QE]=J[CP]+1;
          MAP.type[I[QE]][J[QE]]=MAP.type[I[QE]][J[QE]]+100; // +100 = linked
        }
      }

      // check if linked to the left
      if (J[CP]>0)
      {
        if (MAP.type[I[CP]][J[CP]-1]!=-1 && MAP.type[I[CP]][J[CP]-1]<100)
        {
          ++QE;
          I[QE]=I[CP]; J[QE]=J[CP]-1;
          MAP.type[I[QE]][J[QE]]=MAP.type[I[QE]][J[QE]]+100; // +100 = linked
        }
      }

      // check if linked to the upper left
      if (I[CP]>0 && J[CP]>0)
      {
        if (MAP.type[I[CP]-1][J[CP]-(I[CP]%2)]!=-1 && MAP.type[I[CP]-1][J[CP]-(I[CP]%2)]<100)
        {
          ++QE;
          I[QE]=I[CP]-1; J[QE]=J[CP]-(I[CP]%2);
          MAP.type[I[QE]][J[QE]]=MAP.type[I[QE]][J[QE]]+100; // +100 = linked
        }
      }

      // check if linked to the upper right
      if (I[CP]>0 && (J[CP]<MAP.column-1 || (I[CP]%2)==1))
      {
        if (MAP.type[I[CP]-1][J[CP]+(1-I[CP]%2)]!=-1 && MAP.type[I[CP]-1][J[CP]+(1-I[CP]%2)]<100)
        {
          ++QE;
          I[QE]=I[CP]-1; J[QE]=J[CP]+(1-I[CP]%2);
          MAP.type[I[QE]][J[QE]]=MAP.type[I[QE]][J[QE]]+100; // +100 = linked
        }
      }

      // check if linked to the lower left
      if (I[CP]<MAP.row-1 && J[CP]>0)
      {
        if (MAP.type[I[CP]+1][J[CP]-(I[CP]%2)]!=-1 && MAP.type[I[CP]+1][J[CP]-(I[CP]%2)]<100)
        {
          ++QE;
          I[QE]=I[CP]+1; J[QE]=J[CP]-(I[CP]%2);
          MAP.type[I[QE]][J[QE]]=MAP.type[I[QE]][J[QE]]+100; // +100 = linked
        }
      }

      // check if linked to the lower right
      if (I[CP]<MAP.row-1 && (J[CP]<MAP.column-1 || (I[CP]%2)==1))
      {
        if (MAP.type[I[CP]+1][J[CP]+(1-I[CP]%2)]!=-1 && MAP.type[I[CP]+1][J[CP]+(1-I[CP]%2)]<100)
        {
          ++QE;
          I[QE]=I[CP]+1; J[QE]=J[CP]+(1-I[CP]%2);
          MAP.type[I[QE]][J[QE]]=MAP.type[I[QE]][J[QE]]+100; // +100 = linked
        }
      }

      ++CP;
    }

    for (i=0;i<MAP.row;i++)
    {
      for (j=0;j<MAP.column;j++)
      {
        if (MAP.type[i][j]!=-1 && MAP.type[i][j]<100)
        {
          // remove unlinked
          thisg.drawImage(BMP.BallPop,MAP.x[i][j],MAP.y[i][j]+(oMAP.DownLevel*VAR.BALLVS));
          MAP.type[i][j]=-1;
        }
        else if (MAP.type[i][j]>=100)
        {
          // reset original
          MAP.type[i][j]=MAP.type[i][j]-100;
        }
      }
    }

  }

}