import waba.fx.*;
import waba.ui.*;
import waba.sys.*;
import waba.io.*;


class MAP
{
  static int row=11;
  static int column=8;
  int DownLevel=0;
  int DownSpeed=5;
  int DownCount=0;
  String MapName="Test Level";
  String MapAuthor="Tenny Woo";
  boolean ShowInfo=true;
  boolean LevelInited=false;

  static int x[][]={ new int[] { 0,30,60,90,120,150,180,210},
                     new int[] {-99,15,45,75,105,135,165,195},
                     new int[] { 0,30,60,90,120,150,180,210},
                     new int[] {-99,15,45,75,105,135,165,195},
                     new int[] { 0,30,60,90,120,150,180,210},
                     new int[] {-99,15,45,75,105,135,165,195},
                     new int[] { 0,30,60,90,120,150,180,210},
                     new int[] {-99,15,45,75,105,135,165,195},
                     new int[] { 0,30,60,90,120,150,180,210},
                     new int[] {-99,15,45,75,105,135,165,195},
                     new int[] { 0,30,60,90,120,150,180,210}};

  static int y[][]={ new int[] { 0, 0, 0, 0, 0, 0, 0, 0},
                     new int[] {-99,25,25,25,25,25,25,25},
                     new int[] {50,50,50,50,50,50,50,50},
                     new int[] {-99,75,75,75,75,75,75,75},
                     new int[] {100,100,100,100,100,100,100,100},
                     new int[] {-99,125,125,125,125,125,125,125},
                     new int[] {150,150,150,150,150,150,150,150},
                     new int[] {-99,175,175,175,175,175,175,175},
                     new int[] {200,200,200,200,200,200,200,200},
                     new int[] {-99,225,225,225,225,225,225,225},
                     new int[] {250,250,250,250,250,250,250,250}};

  static int type[][]={ new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                        new int[] {-1,-1,-1,-1,-1,-1,-1,-1}};

  // dump the map to system out for debug use only
  public void DumpMap()
  {
    int i=0, j=0;

    System.out.println("******************************");
    for (i=0;i<row;i++)
    {
      for (j=0;j<column;j++)
      {
        System.out.print(type[i][j]+",");
      }
      System.out.println(" row:"+i);
    }
  }

  public MAP(int intLevel)
  {
    int i=0, j=0;
    int intLine=0, intColumn=0;

    if (VAR.PLATFORM!=0) // not PalmCE
    {
      GetBuildInMap(intLevel);
      return;
    }

    File file = new File("/Program Files/bubble");
    if (file.listDir()==null) // cannot list dir
    {
      GetBuildInMap(intLevel);
      return;
    }
    String dirFile[]=file.listDir();
    j=-1;
    for (i=0;i<dirFile.length;i++)
    {
      if (dirFile[i].length()>4)
      {
        if (dirFile[i].substring(dirFile[i].length()-4,dirFile[i].length()).equals(".txt"))
        {
          ++j;
          if (j==intLevel)
          {
            break;
          }
        }
      }
    }
    if (j!=intLevel && intLevel>=3) // level not found
    {
      return;
    }
    file.close(); // for safety, close the directory

    if (j==intLevel)
    {
      file = new File("/Program Files/bubble/"+dirFile[i]); // open the level file
      byte bdata[]=new byte[1];
      char cdata[]=new char[1];
      MapName="";
      while (file.readBytes(bdata,0,1)==1)
      {
        // skip remark lines
        while (bdata[0]==42)
        {
          while (bdata[0]!=10)
          {
            file.readBytes(bdata,0,1);
          }
          file.readBytes(bdata,0,1);
        }

        cdata[0]=(char) bdata[0];
        String Sdata=new String(cdata);
        switch (intLine)
        {
          case 0:
            if (bdata[0]==10)
            {
              MapAuthor="";
              intLine++;
            }
            else if (bdata[0]!=13)
            {
              MapName=MapName.concat(Sdata);
            }
            break;
          case 1:
            if (bdata[0]==10)
            {
              intLine++;
            }
            else if (bdata[0]!=13)
            {
              MapAuthor=MapAuthor.concat(Sdata);
            }
            break;
          case 2:
            if (bdata[0]==10)
            {
              intLine++;
            }
            else if (bdata[0]>=48 && bdata[0]<=57)
            {
              DownSpeed=(int)bdata[0]-47;
            }
            break;
          default:
            if (intLine>=3 && intLine<=12)
            {
              if (bdata[0]==10)
              {
                intLine++;
                intColumn=1-intLine%2;
              }
              if (bdata[0]==46) // blank
              {
                ++intColumn;
              }
              if (bdata[0]>=48 && bdata[0]<=57)
              {
                if (intColumn<column)
                {
                  type[intLine-3][intColumn]=bdata[0]-48;
                  ++intColumn;
                }
              }
            }
        }
      }
      file.close(); // close the level file
      LevelInited=true;
    }
    else  // use build in levels
    {
      GetBuildInMap(intLevel);
    }
  }


  void GetBuildInMap(int intLevel)
  {
    int i=0, j=0;

    switch (intLevel)
    {
      case 0:
        LevelInited=true;
        DownSpeed=10;
        int t0[][]={ new int[] { 1, 1, 2, 2, 3, 3, 4, 4},
                     new int[] {-1, 1, 1, 2, 2, 3, 3, 4},
                     new int[] { 5, 5, 6, 6, 7, 7, 0, 0},
                     new int[] {-1, 5, 5, 6, 6, 7, 7, 0},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1}};
        for (i=0;i<row;i++)
        {
          for (j=0;j<column;j++)
          {
            type[i][j]=t0[i][j];
          }
        }
        break;
  
      case 1:
        LevelInited=true;
        int t1[][]={ new int[] {-1,-1,-1, 1, 3,-1,-1,-1},
                     new int[] {-1,-1,-1, 3, 5, 1,-1,-1},
                     new int[] {-1,-1, 3, 1, 3, 1,-1,-1},
                     new int[] {-1,-1, 1, 3, 5, 1, 3,-1},
                     new int[] {-1, 1, 3, 1, 3, 1, 3,-1},
                     new int[] {-1, 3, 1, 3, 5, 1, 3, 1},
                     new int[] { 3, 1, 3, 1, 3, 1, 3, 1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1}};
        for (i=0;i<row;i++)
        {
          for (j=0;j<column;j++)
          {
            type[i][j]=t1[i][j];
          }
        }
        break;

      case 2:
        LevelInited=true;
        int t2[][]={ new int[] {-1, 1,-1,-1,-1,-1, 0,-1},
                     new int[] {-1,-1, 3,-1,-1,-1, 2,-1},
                     new int[] {-1, 5,-1,-1,-1,-1, 4,-1},
                     new int[] {-1,-1, 7,-1,-1,-1, 6,-1},
                     new int[] {-1, 1,-1,-1,-1,-1, 0,-1},
                     new int[] {-1,-1, 3,-1,-1,-1, 2,-1},
                     new int[] {-1, 5,-1,-1,-1,-1, 4,-1},
                     new int[] {-1,-1, 7,-1,-1,-1, 6,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1},
                     new int[] {-1,-1,-1,-1,-1,-1,-1,-1}};
        for (i=0;i<row;i++)
        {
          for (j=0;j<column;j++)
          {
            type[i][j]=t2[i][j];
          }
        }
        break;
    }
  }

  public void Down()
  {
    ++DownCount;
    if (DownCount==DownSpeed)
    {
      DownCount=0;
      ++DownLevel;
    }
  }

  public void Paint(Graphics g)
  {
    Image iMAP=new Image(VAR.WIDTH, VAR.DEADLINE);
    Graphics gMAP=new Graphics(iMAP);
    int i=0,j=0;

    gMAP.setColor(VAR.WHITE, VAR.WHITE, VAR.WHITE);
    gMAP.fillRect(0, 0, VAR.WIDTH, VAR.DEADLINE);
    gMAP.setDrawOp(gMAP.DRAW_OR);

    for (i=0;i<row;i++)
    {
      for (j=0;j<column;j++)
      {
        if (type[i][j]!=-1)
        {
          gMAP.drawImage(BMP.Ball[type[i][j]],x[i][j],y[i][j]+(DownLevel*VAR.BALLVS));
        }
      }
    }
    // draw frame
    gMAP.setDrawOp(gMAP.DRAW_OVER);
    gMAP.setColor(VAR.BLACK, VAR.BLACK, VAR.BLACK);
    gMAP.drawLine(VAR.LEFT,VAR.TOP,VAR.RIGHT,VAR.TOP);
    gMAP.drawLine(VAR.RIGHT,VAR.TOP,VAR.RIGHT,VAR.BOTTOM);
    gMAP.drawLine(VAR.LEFT,VAR.BOTTOM,VAR.LEFT,VAR.TOP);
    // draw push bar
    if (DownLevel>0)
    {
      gMAP.drawImage(BMP.PushBar,VAR.LEFT+1,y[DownLevel][column-1]-VAR.PUSHBARH);
    }

    if (ShowInfo)
    {
      ShowInfo=false;
      Font f = new Font("Arial", Font.BOLD, 12);

      gMAP.setColor(VAR.BLACK,VAR.BLACK,VAR.BLACK);
      gMAP.setFont(f);
      gMAP.drawText("Bubble v0.3a, 1999.",      VAR.LEFT+2, VAR.DEADLINE-((VAR.FONTH+VAR.FONTVSPACE)*6));
      gMAP.drawText("by tennywoo@hotmail.com",  VAR.LEFT+2, VAR.DEADLINE-((VAR.FONTH+VAR.FONTVSPACE)*5));

      gMAP.drawText("Map: "+MapName,            VAR.LEFT+2, VAR.DEADLINE-((VAR.FONTH+VAR.FONTVSPACE)*3));
      gMAP.drawText("by: "+MapAuthor,           VAR.LEFT+2, VAR.DEADLINE-((VAR.FONTH+VAR.FONTVSPACE)*2));
    }

    g.drawImage(iMAP, VAR.LEFT, VAR.TOP);
  }

}