import waba.fx.*;
import waba.ui.*;
import waba.sys.*;

class GUI
{
  Graphics g;

  public final int NOTHING=0;
  public final int LEFTBUTTON=1;
  public final int RIGHTBUTTON=2;
  public final int SHOOTBUTTON=3;

  public int Stage=0;

  public GUI(Graphics pg)
  {
    g=pg;
  }

  public void Paint(int pThisBall, int pNextBall)
  {
    g.setColor(VAR.WHITE, VAR.WHITE, VAR.WHITE);
    g.fillRect(VAR.LEFT+1, VAR.DEADLINE+1, VAR.WIDTH-2, VAR.HEIGHT-1-VAR.DEADLINE);
    g.setColor(VAR.BLACK, VAR.BLACK, VAR.BLACK);
    g.drawLine(VAR.LEFT, VAR.DEADLINE, VAR.RIGHT, VAR.DEADLINE);
    g.drawImage(BMP.BoxNext, VAR.NEXTBUTTONX, VAR.NEXTBUTTONY);
    g.drawImage(BMP.Ball[pNextBall], VAR.NEXTBALLX, VAR.NEXTBALLY);
    g.drawImage(BMP.BoxLeft, VAR.LEFTBUTTONX, VAR.LEFTBUTTONY);
    g.drawImage(BMP.BoxRight, VAR.RIGHTBUTTONX, VAR.RIGHTBUTTONY);
    g.drawImage(BMP.BoxShot, VAR.SHOOTBUTTONX, VAR.SHOOTBUTTONY);
    g.drawImage(BMP.Ball[pThisBall], VAR.THISBALLX, VAR.THISBALLY);
  }

  public int Click(int x, int y)
  {
    Stage=NOTHING;

    if (x>=VAR.LEFTBUTTONX && x<=VAR.LEFTBUTTONX+VAR.BUTTONW && y>=VAR.LEFTBUTTONY && y<=VAR.LEFTBUTTONY+VAR.BUTTONH)
    {
      Stage=LEFTBUTTON;  // turn left button clicked!
    }

    if (x>=VAR.RIGHTBUTTONX && x<=VAR.RIGHTBUTTONX+VAR.BUTTONW && y>=VAR.RIGHTBUTTONY && y<=VAR.RIGHTBUTTONY+VAR.BUTTONH)
    {
      Stage=RIGHTBUTTON;  // turn right button clicked!
    }

    if ((x>=VAR.SHOOTBUTTONX && x<=VAR.SHOOTBUTTONX+VAR.BUTTONW && y>=VAR.SHOOTBUTTONY && y<=VAR.SHOOTBUTTONY+VAR.BUTTONH) ||
        (x>=VAR.THISBALLX && x<=VAR.THISBALLX+VAR.BALLD && y>=VAR.THISBALLY && y<=VAR.THISBALLY+VAR.BALLD) )
    {
      Stage=SHOOTBUTTON;  // shoot button clicked!
    }

    return Stage; // nothing!!
  }

  public int Release()
  {
    Stage=NOTHING;
    return Stage;
  }
}