  /* Majong

   by Tenny Woo 
   tennywoo@hotmail.com

  */


import waba.core.*;

public class majong extends App
{
  // game stage
  int intGameStage=0, intSavedStage=0;
  int intWhoWin=0; // 1=player,2=computer
  int intPlayerOwn=Var.MONEYSTART, intComputerOwn=Var.MONEYSTART; // init money
  int intLevel=0; // init level
  int intPlayerSeat=MJ.EAST, intComputerSeat=MJ.SOUTH;
  int intWind=MJ.EAST;

  Graphics g=new Graphics(this);
  Table objTable=new Table(g, intLevel, intWind, intPlayerOwn, intComputerOwn);
  Player objPlayer=new Player(g, intPlayerOwn, intWind, intPlayerSeat);
  Computer objComputer=new Computer(g, intComputerOwn, intWind, intComputerSeat, intLevel);

  public void onStart()
  {
    SetRandomSeed();
  }

  public void onPaint(int x, int y, int width, int height)
  {
    ClearScreen();
    PrintFrame();

    switch (intGameStage)
    {
      case 0:
        PrintPicture("welcome.wbm");
        break;

      case 1:
      case 2:
        objTable.Paint();
        objPlayer.Paint();
        objComputer.Paint();
        break;
      case 99:
        g.drawImage(new Image("closebutton.wbm"), Var.WIDTH-Var.CLOSEBUTTONW, Var.TOP);
        PrintAuthor();
        break;
    }
  }

  void SetRandomSeed()
  {
    Time t = new Time();
    MJ.srand((float)t.minute * t.second);
  }

  void PrintPicture(String strFileName)
  {
    ClearScreen();
    PrintFrame();
    g.drawImage(new Image(strFileName), 1, 1);
    g.drawImage(new Image("closebutton.wbm"), Var.WIDTH-Var.CLOSEBUTTONW, Var.TOP);
    PrintAuthor();
    intSavedStage=intGameStage;
    intGameStage=99;
  }

  void PrintFrame()
  {
    g.setColor(Var.BLACK, Var.BLACK, Var.BLACK);
    g.drawLine(Var.LEFT,Var.TOP,Var.RIGHT,Var.TOP);
    g.drawLine(Var.RIGHT,Var.TOP,Var.RIGHT,Var.BOTTOM);
    g.drawLine(Var.RIGHT,Var.BOTTOM,Var.LEFT,Var.BOTTOM);
    g.drawLine(Var.LEFT,Var.BOTTOM,Var.LEFT,Var.TOP);
  }

  void ClearScreen()
  {
    g.setColor(Var.WHITE, Var.WHITE, Var.WHITE);
    g.fillRect(Var.LEFT,Var.TOP,Var.WIDTH,Var.HEIGHT);
  }


  void PrintAuthor()
  {
    Font f = new Font("Arial", Font.PLAIN, 10);

    g.setColor(Var.BLACK,Var.BLACK,Var.BLACK);
    g.setFont(f);
    g.drawText("HK Majong v0.3b, 1999.",        Var.LEFT+2, Var.BOTTOM-((Var.FONTH+Var.FONTVSPACE)*6));

    g.drawText("Original by Tenny Woo",         Var.LEFT+2, Var.BOTTOM-((Var.FONTH+Var.FONTVSPACE)*4));
    g.drawText("   tennywoo@hotmail.com",       Var.LEFT+2, Var.BOTTOM-((Var.FONTH+Var.FONTVSPACE)*3));
    g.drawText("PalmPilot Version by Alex Lau", Var.LEFT+2, Var.BOTTOM-((Var.FONTH+Var.FONTVSPACE)*2));
    g.drawText("   alex_lau@bigfoot.com",       Var.LEFT+2, Var.BOTTOM-((Var.FONTH+Var.FONTVSPACE)*1));
  }

  public void onPenDown(int x, int y, int modifiers, int timeStamp)
  {
    int intRet=0;
    int intGotFace=0;

    switch (intGameStage)
    {
      case 0:
        intGameStage=1;
        ClearScreen();
        PrintFrame();
        objTable.Paint();
        objPlayer.Paint();
        objComputer.Paint();
        break;

      case 1:  //show MJs
        int i,j;

        // show dice
        objTable.PaintDice();
        if (Var.PLATFORM != 1) Vm.sleep(8*Var.DELAY);
        // get MJs
        for(i=0;i<3;i++)
        {
          if (intPlayerSeat==MJ.EAST)
          {
            for (j=0;j<4;j++) objPlayer.AddMJ(objTable.GetMJ());
            objTable.Paint();
            objPlayer.Paint();
            if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
            for (j=0;j<4;j++) objComputer.AddMJ(objTable.GetMJ());
            objTable.Paint();
            objComputer.Paint();
            if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
          }
          else
          {
            for (j=0;j<4;j++) objComputer.AddMJ(objTable.GetMJ());
            objTable.Paint();
            objComputer.Paint();
            if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
            for (j=0;j<4;j++) objPlayer.AddMJ(objTable.GetMJ());
            objTable.Paint();
            objPlayer.Paint();
            if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
          }
        }
        // who is the host?
        if (intPlayerSeat==MJ.EAST)
        {
          objPlayer.AddMJ(objTable.GetMJ());
          objTable.Paint();
          objPlayer.Paint();
          if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
          objComputer.AddMJ(objTable.GetMJ());
          objTable.Paint();
          objComputer.Paint();
          if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
          objPlayer.AddMJ(objTable.GetMJ());
          objTable.Paint();
          objPlayer.Paint();
        }
        else
        {
          objComputer.AddMJ(objTable.GetMJ());
          objTable.Paint();
          objComputer.Paint();
          if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
          objPlayer.AddMJ(objTable.GetMJ());
          objTable.Paint();
          objPlayer.Paint();
          if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
          objComputer.AddMJ(objTable.GetMJ());
          objTable.Paint();
          objComputer.Paint();
        }

        if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
        objPlayer.SetStage(Var.MJNOTDEFINED,MJ.Stage.CLOSE);
        objComputer.SetStage(Var.MJNOTDEFINED,MJ.Stage.CLOSE);
        objPlayer.Paint();
        objComputer.Paint();
        objPlayer.SortMJ();
        objComputer.SortMJ();
        if (Var.PLATFORM != 1) Vm.sleep(10*Var.DELAY);
        objPlayer.SetStage(Var.MJNOTDEFINED,MJ.Stage.SHOW);
        objComputer.SetStage(Var.MJNOTDEFINED,MJ.Stage.HIDE);
        objPlayer.Paint();
        objComputer.Paint();

        if (Var.PLATFORM != 1) Vm.sleep(15*Var.DELAY);
        objComputer.GetDone();
        objComputer.Paint();


        // who is the host?
        if (intComputerSeat==MJ.EAST)
        {
          if (Var.PLATFORM != 1) Vm.sleep(4*Var.DELAY);
          objComputer.SeatEast();
        }

        intGameStage=2;
        break;

      case 2:  // get next face
        if (x>=Var.MISCAREAX && x<=Var.MISCAREAX+Var.MISCAREAW && y>=Var.MISCAREAY && y<=Var.MISCAREAY+Var.MISCAREAH)
        {
          if (x>=Var.MISCAREAW-((Var.BUTTONW+1)*2) && x<=Var.MISCAREAW-((Var.BUTTONW+1)*2)+Var.BUTTONW) // press four
          {
            intRet=objPlayer.PressFour();
          }
          if (x>=Var.MISCAREAW-Var.BUTTONW-1 && x<=Var.MISCAREAW-1) // press Done
          {
            intRet=objPlayer.CheckDone(objComputer.LastAbortFace());
            if (intRet>0)
            {
              intWhoWin=1;
              intGameStage=3;
              intPlayerOwn=intPlayerOwn + CalcMoney(intRet);
              intComputerOwn=intComputerOwn - CalcMoney(intRet);
              break;
            }
          }
        }

        if (x>=Var.LEFTAREAX && x<=Var.LEFTAREAX+Var.LEFTAREAW && y>=Var.LEFTAREAY && y<=Var.LEFTAREAY+Var.LEFTAREAH)
        {
          // pretend hit new face area
          x=Var.PLAYERHANDX+Var.PLAYERHANDW-2; y=Var.PLAYERHANDY+Var.PLAYERHANDH-2;
        }

        if (x>=Var.PLAYERHANDX && x<=Var.PLAYERHANDX+Var.PLAYERHANDW && y>=Var.PLAYERHANDY && y<=Var.PLAYERHANDY+Var.PLAYERHANDH)
        {
          if (objPlayer.onPenDown(x-Var.PLAYERHANDX, y-Var.PLAYERHANDY, modifiers, timeStamp))
          {
            if (objPlayer.LastAction()==1) // get a new face
            {
              intGotFace=objTable.GetMJ();
              if(intGotFace==Var.MJNOTDEFINED)
              {
                intWhoWin=0;
                intGameStage=3;
                break;
              }
              objPlayer.AddMJ(intGotFace);
              objTable.Paint();
              objPlayer.Paint();
            }
            if (objPlayer.LastAction()==2) // abort a title
            {
              intRet=objComputer.CheckPlayerAbort(objPlayer.LastAbortFace());
              if (intRet>0)
              {
                intWhoWin=2;
                intGameStage=3;
                intPlayerOwn=intPlayerOwn - CalcMoney(intRet);
                intComputerOwn=intComputerOwn + CalcMoney(intRet);
                break;
              }
              if (objComputer.LastAction()==3 || objComputer.LastAction()==4)
              {
                objPlayer.RemoveLastAbortFace();
              }
             
              intRet=1;
              while(intRet==1 || objComputer.LastAction()==3)
              {
                intGotFace=objTable.GetMJ();
                if(intGotFace==Var.MJNOTDEFINED)
                {
                  intWhoWin=0;
                  intGameStage=3;
                  intRet=0;
                  break;
                }
                objTable.Paint();
                intRet=objComputer.GetNewFace(intGotFace);
              }
              if(intRet>0)
              {
                intWhoWin=2;
                intGameStage=3;
                intPlayerOwn=intPlayerOwn - CalcMoney(intRet);
                intComputerOwn=intComputerOwn + CalcMoney(intRet);
                break;
              }
            }
          }
        }
        if (x>=Var.COMPPOOLX && x<=Var.COMPPOOLX+Var.COMPPOOLW && y>=Var.COMPPOOLY && y<=Var.COMPPOOLY+Var.COMPPOOLH)
        {
          intRet=objPlayer.OppPoolClick(objComputer.LastAbortFace());
          if (intRet==1)
          {
            objComputer.RemoveLastAbortFace();
          }
        }
        break;

      case 3:
        if(intWhoWin==0 || (x>=Var.SHOWFANX+Var.SHOWFANW-Var.CLOSEBUTTONW && x<=Var.SHOWFANX+Var.SHOWFANW && y>=Var.SHOWFANY && y<=Var.SHOWFANY+Var.CLOSEBUTTONH))
        {
          intGameStage=4;
          if(intWhoWin==1) // player  win
          {
            if (intComputerOwn<=0)
            {
              intPlayerOwn=Var.MONEYSTART;
              intComputerOwn=Var.MONEYSTART;
              intLevel++;
            }
            if (intPlayerSeat==MJ.SOUTH)
            {
              intPlayerSeat=MJ.EAST;
              intComputerSeat=MJ.SOUTH;
              intWind=intWind+20;
              if (intWind>MJ.NORTH) intWind=MJ.EAST;
            }
            PrintPicture("playerwin.wbm");
          }
          else if(intWhoWin==2) // computer win
          {
            if (intPlayerOwn<=0)
            {
              intGameStage=5; // gameover
              PrintPicture("gameover.wbm");
            }
            else
            {
              if (intComputerSeat==MJ.SOUTH)
              {
                intPlayerSeat=MJ.SOUTH;
                intComputerSeat=MJ.EAST;
              }
              PrintPicture("computerwin.wbm");
            }
          }
          else
          {
            PrintPicture("drawgame.wbm");
          }
        }
        break;

      case 4:
        MJ.Init();
        intGameStage=1;
        intWhoWin=0;
        objTable=new Table(g, intLevel, intWind, intPlayerOwn, intComputerOwn);
        objPlayer=new Player(g, intPlayerOwn, intWind, intPlayerSeat);
        objComputer=new Computer(g, intComputerOwn, intWind, intComputerSeat, intLevel);
        ClearScreen();
        PrintFrame();
        objTable.Paint();
        objPlayer.Paint();
        objComputer.Paint();
        MJ.srand(x+y);
        break;

      case 5:
        exit(0);

      case 99:  // close button control
        if(x>=Var.WIDTH-Var.CLOSEBUTTONW && x<=Var.WIDTH && y>=Var.TOP && y<=Var.TOP+Var.CLOSEBUTTONH)
        {
          intGameStage=intSavedStage;
          onPenDown(x, y, modifiers, timeStamp);
        }
        break;
    }
  }

  public int CalcMoney(int intFan)
  {
    int i=0;
    int intMoney=Var.MONEYPERFAN;

    for(i=1;i<intFan;i++)
    {
      intMoney=intMoney*2;
    }
    return intMoney;
  }
}

