import waba.core.*;

class Table
{
  Graphics g;
  // mj left
  int intMJLeft=78;
  // dice number
  int intDice1=Var.DICENOTDEFINED, intDice2=Var.DICENOTDEFINED;
  // game stage
  int intPlayerOwn=5000, intComputerOwn=5000; // init money
  int intLevel=0; // init level
  int intWind;

  public Table(Graphics gWindow, int intL, int Wind, int intP, int intC)
  {
    g=gWindow;
    intLevel=intL;
    intPlayerOwn=intP;
    intComputerOwn=intC;
    intWind=Wind;
  }

  public int Left()
  {
    return intMJLeft;
  }

  public void Paint()
  {
    g.drawImage(CreateLeft(intMJLeft), Var.LEFTAREAX, Var.LEFTAREAY);
    PaintMisc();
  }

  void PaintMisc()
  {
    Image iMisc=new Image(Var.MISCAREAW, Var.MISCAREAH);
    Graphics gMisc=new Graphics(iMisc);
    Font f = new Font("Arial", Font.PLAIN, 12);

    gMisc.setColor(Var.WHITE, Var.WHITE, Var.WHITE);
    gMisc.fillRect(0, 0, Var.MISCAREAW, Var.MISCAREAH);
    
    if(intDice1!=Var.DICENOTDEFINED) gMisc.drawImage(MJ.DiceBmp[intDice1-1], 0, 0);
    if(intDice2!=Var.DICENOTDEFINED) gMisc.drawImage(MJ.DiceBmp[intDice2-1], Var.DICEW+1, 0);

    gMisc.setColor(Var.BLACK, Var.BLACK, Var.BLACK);
    gMisc.setFont(f);
    gMisc.drawText("Level:"+(intLevel+1)+" Wind:"+MJ.RealNum2Name(intWind), (Var.DICEW+1)*2+5 ,2);

    gMisc.drawImage(MJ.FourBmp, Var.MISCAREAW-((Var.BUTTONW+1)*2), 0);
    gMisc.drawImage(MJ.DoneBmp, Var.MISCAREAW-Var.BUTTONW-1, 0);

    g.drawImage(iMisc, Var.MISCAREAX, Var.MISCAREAY);
  }

  public void PaintDice()
  {
    int i=0;

    // show dice
    for(i=0;i<3;i++)
    {
      intDice1=MJ.rand(6)+1;
      intDice2=MJ.rand(6)+1;
      PaintMisc();
      if (Var.PLATFORM != 1) Vm.sleep(3*Var.DELAY);
    }
  }

  public int GetMJ()
  {
    int i,j=0;
    int intNewFace=0;

    if(intMJLeft>0)
    {
      intMJLeft=intMJLeft-1;
      intNewFace=MJ.rand(34);

      //check if 4 match got
      for (i=0;i<34;i++)
      {
        j=i+intNewFace;
        if(j>=34) j=j-34;
        if(MJ.intFaceCount[j]<3)
        {
          MJ.intFaceCount[j]++;
          return MJ.Real2FaceNum(j);
        }
      }
    }
    return Var.MJNOTDEFINED;
  }

  Image CreateLeft(int intLeft)
  {
    int i,j;
    Image iLeft=new Image(Var.LEFTAREAW, Var.LEFTAREAH);
    Graphics gLeft=new Graphics(iLeft);
    Image iMJ=MJ.CreateMaJong(MJ.Stage.CLOSE, MJ.M1);

    gLeft.setColor(Var.WHITE,Var.WHITE,Var.WHITE);
    gLeft.fillRect(0, 0, Var.LEFTAREAW, Var.LEFTAREAH);

    if (intLeft%(Var.MAXMJPERROW*2)==0 && intLeft>0)
    {
      j=Var.MAXMJPERROW*2-1;
    }
    else
    {
      j=intLeft%(Var.MAXMJPERROW*2)-1;
    }

    for(i=j;i>=0;i--)
    {
      if((i%2) == 0)
      {
        gLeft.drawImage(iMJ, (int) (Var.MAXMJPERROW-1-(i/2))*(Var.MJW+Var.MJSPACE), Var.MJCLOSEVSPACE);
      }
    }

    for(i=j;i>=0;i--)
    {
      if((i%2) == 1)
      {
        gLeft.drawImage(iMJ, (int) (Var.MAXMJPERROW-1-(i/2))*(Var.MJW+Var.MJSPACE), 0);
      }
    }

    return iLeft;
  }
}
