import waba.core.*;

class Player
{
  Graphics g;
  // player hand
  int intMJFace[] = new int[14];
  int intMJStage[] = new int[14];
  int intMJAbort[] = new int[28];
  int int13Face[]={MJ.M1, MJ.M9, MJ.B1, MJ.B9, MJ.T1, MJ.T9, MJ.EAST, MJ.SOUTH, MJ.WEST, MJ.NORTH, MJ.MIDDLE, MJ.FAT, MJ.WHITE};
  int intTmpFace[]=new int[14];
  // player action
  int intPlayerAction = 0; //0-no action, 1-get a face, 2-removed a face, 3-four, 4-got from opp.
  // player properties
  int intOwn=0;
  int intWind=0;
  int intSeat=0;

  public Player(Graphics gWindow, int Own, int Wind, int Seat)
  {
    int i;

    g=gWindow;
    intOwn=Own;
    intWind=Wind;
    intSeat=Seat;
    for(i=0;i<14;i++) {intMJFace[i]=Var.MJNOTDEFINED; intMJStage[i]=MJ.Stage.SHOW;}
    for(i=0;i<28;i++) intMJAbort[i]=Var.MJNOTDEFINED;
  }

  public int LastAbortFace()
  {
    int i;

    for(i=27;i>=0;i--)
    {
      if (intMJAbort[i]!=Var.MJNOTDEFINED)
      {
        return intMJAbort[i];
      }
    }
    return Var.MJNOTDEFINED;
  }

  public void RemoveLastAbortFace()
  {
    int i;

    for(i=27;i>=0;i--)
    {
      if (intMJAbort[i]!=Var.MJNOTDEFINED)
      {
        intMJAbort[i]=Var.MJNOTDEFINED;
        break;
      }
    }
    Paint();
  }

  public void SetStage(int intWhich, int intStage)
  {
    int i=0;

    if(intWhich>14)
    {
      for(i=0;i<14;i++)
      {
        if (intMJStage[i]!=MJ.Stage.FOUR) intMJStage[i]=intStage;
      }
    }
    else
    {
      intMJStage[intWhich]=intStage;
    }
  }

  public void SortMJ()
  {
    int i,j;
    int intTemp;

    //sort stage
    for(i=0;i<14;i++)
    {
      for(j=0;j<13;j++)
      {
        if(intMJStage[j]>intMJStage[j+1])
        {
          // swap face
          intTemp=intMJFace[j];
          intMJFace[j]=intMJFace[j+1];
          intMJFace[j+1]=intTemp;
          // swap stage
          intTemp=intMJStage[j];
          intMJStage[j]=intMJStage[j+1];
          intMJStage[j+1]=intTemp;
        }
      }
    }
    //sort face
    for(i=0;i<14;i++)
    {
      for(j=0;j<13;j++)
      {
        if(intMJFace[j]>intMJFace[j+1] && intMJStage[j]==intMJStage[j+1])
        {
          // swap face
          intTemp=intMJFace[j];
          intMJFace[j]=intMJFace[j+1];
          intMJFace[j+1]=intTemp;
          // swap stage
          intTemp=intMJStage[j];
          intMJStage[j]=intMJStage[j+1];
          intMJStage[j+1]=intTemp;
        }
      }
    }
  }

  public void AddMJ(int intFace)
  {
    int i;

    for (i=0;i<14;i++)
    {
      if(intMJFace[i]==Var.MJNOTDEFINED)
      {
        intMJFace[i]=intFace;
        break;
      }
    }
  }

  public void AddAbortMJ(int intFace)
  {
    int i;

    for (i=0;i<28;i++)
    {
      if(intMJAbort[i]==Var.MJNOTDEFINED)
      {
        intMJAbort[i]=intFace;
        break;
      }
    }
  }

  public void Paint()
  {
    int i;
    Image iMJ;
    Graphics gMJ;
    Font f = new Font("Arial", Font.PLAIN, 12);

    iMJ=new Image(Var.PLAYERHANDW, Var.PLAYERHANDH);
    gMJ=new Graphics(iMJ);
    gMJ.setColor(Var.WHITE, Var.WHITE, Var.WHITE);
    gMJ.fillRect(0, 0, Var.PLAYERHANDW, Var.PLAYERHANDH);

    // show info
    gMJ.setColor(Var.BLACK, Var.BLACK, Var.BLACK);
    gMJ.setFont(f);
    gMJ.drawText(" Point:"+intOwn+"  Seat:"+MJ.RealNum2Name(intSeat), 0, 0);

    // draw hand
    for (i=0;i<14;i++)
    {
      if(intMJFace[i]!=Var.MJNOTDEFINED)
      {
        if(intMJStage[i]!=MJ.Stage.SELECTED)
        {
          gMJ.drawImage(MJ.CreateMaJong(intMJStage[i], intMJFace[i]), i*(Var.MJW+Var.MJSPACE), Var.PLAYERHANDH-Var.MJH);
        }
        else
        {
          gMJ.drawImage(MJ.CreateMaJong(intMJStage[i], intMJFace[i]), i*(Var.MJW+Var.MJSPACE), Var.PLAYERHANDH-Var.MJH-Var.MJSELECTVSPACE);
        }
      }
    }
    g.drawImage(iMJ, Var.PLAYERHANDX, Var.PLAYERHANDY);

    // draw abort pool
    iMJ=new Image(Var.PLAYERPOOLW, Var.PLAYERPOOLH);
    gMJ=new Graphics(iMJ);
    gMJ.setColor(Var.WHITE, Var.WHITE, Var.WHITE);
    gMJ.fillRect(0, 0, Var.PLAYERPOOLW, Var.PLAYERPOOLH);
    for (i=0;i<Var.MAXMJPERROW*2;i++)
    {
      if(intMJAbort[i]!=Var.MJNOTDEFINED)
      {
        gMJ.drawImage(MJ.CreateMaJong(MJ.Stage.OPEN, intMJAbort[i]), (i%Var.MAXMJPERROW)*(Var.MJW+Var.MJSPACE), (i/Var.MAXMJPERROW)*Var.MJOPENVSPACE);
      }
    }
    g.drawImage(iMJ, Var.PLAYERPOOLX, Var.PLAYERPOOLY);
  }

  public int LastAction()
  {
    return intPlayerAction;
  }

  public boolean onPenDown(int x, int y, int modifiers, int timeStamp)
  {
    int i=0;
    int intHit=0;

    intHit=(int) x/(Var.MJW+Var.MJSPACE);
    if (intHit>13) intHit=13;
    if (intHit<0) intHit=0;
    if (intMJFace[13]==Var.MJNOTDEFINED && intHit==13)
    {
      //deselected faces on hand
      for (i=0;i<13;i++)
      {
        if (intMJStage[i]==MJ.Stage.SELECTED)
        {
          intMJStage[i]=MJ.Stage.SHOW;
        }
      }
      //get a new face
      intPlayerAction=1;
      return true;
    }
    else if (intMJFace[13]!=Var.MJNOTDEFINED && intMJStage[intHit]==MJ.Stage.SHOW)
    {
      intPlayerAction=2;
      AddAbortMJ(intMJFace[intHit]);
      intMJFace[intHit]=Var.MJNOTDEFINED;
      Paint();
      if (Var.PLATFORM != 1) Vm.sleep(1*Var.DELAY);
      SortMJ();
      Paint();
      return true;
    }
    else // select or deselect a face
    {
      if(intMJStage[intHit]==MJ.Stage.SHOW)
      {
        intMJStage[intHit]=MJ.Stage.SELECTED;
        Paint();
      }
      else if(intMJStage[intHit]==MJ.Stage.SELECTED)
      {
        intMJStage[intHit]=MJ.Stage.SHOW;
        Paint();
      }
    }
    return false;
  }

  public int PressFour()
  {
    int intRet=0; // return status 1=used
    int i=0,j=0,k=0;
    int intFoundFace=Var.MJNOTDEFINED;

    if (intMJFace[13]==Var.MJNOTDEFINED)
    {
       return intRet;
    }

    //check all faces on hand with 4 matched
    for (i=0;i<14 && intFoundFace==Var.MJNOTDEFINED;i++)
    {
      k=0;
      for (j=0;j<14 && intMJStage[i]!=MJ.Stage.FOUR;j++)
      {
        if (intMJFace[i]==intMJFace[j] && i!=j)
        {
          k++;
        }
      }
      if (k==3)
      {
        intFoundFace=intMJFace[i];
      }
    }

    if (intFoundFace!=Var.MJNOTDEFINED)
    {
      intPlayerAction=3;
      intRet=1;
      j=0;
      for (i=0;i<14;i++)
      {
        if (intMJFace[i]==intFoundFace)
        {
          if (j==0)
          {
            intMJStage[i]=MJ.Stage.SHOW;
            intMJFace[i]=Var.MJNOTDEFINED;
          }
          else
          {
            intMJStage[i]=MJ.Stage.FOUR;
          }
          j++;
        }
      }
      SortMJ();
      Paint();
    }
    return intRet;
  }

  public int CheckDone(int ComputerAbortFace)
  {
    int intRet=0; // return 1 if done hand
    int i=0,j=0,k=0;
    int intDoneFace[];
    int intDoneByOwn=0; //0-not done by own, 1-done by own, 2-done by four
    int intFanChecked=0;
    int intHeightFanChecked=0;
    boolean booShow=false;

    // copy intMJFace to intTmpFace
    for(i=0;i<14;i++)
    {
      intTmpFace[i]=intMJFace[i];
    }
    if(intTmpFace[13]==Var.MJNOTDEFINED) // if need computer aborted face
    {
      intTmpFace[13]=ComputerAbortFace;
    }
    if(intPlayerAction==1) intDoneByOwn=1;
    if(intPlayerAction==3) intDoneByOwn=2;

    // sort it
    for(i=0;i<14;i++)
    {
      for(j=0;j<13;j++)
      {
        if(intTmpFace[j]>intTmpFace[j+1])
        {
          // swap face
          k=intTmpFace[j];
          intTmpFace[j]=intTmpFace[j+1];
          intTmpFace[j+1]=k;
        }
      }
    }

    for (i=0;i<2;i++) // check at the first time, show for the second time
    {
      if (i==0 || intHeightFanChecked==1)
      {
        // check 13 faces
        intDoneFace=MJ.CheckDone13Face(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=1;
          }
        }
      }

      if (i==0 || intHeightFanChecked==2)
      {
        // check from left to right in order first
        intDoneFace=MJ.CheckDoneLeft2RightOPE(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=2;
          }
        }
      }

      if (i==0 || intHeightFanChecked==3)
      {
        // check from right to left in order first
        intDoneFace=MJ.CheckDoneRight2LeftOPE(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=3;
          }
        }
      }

      if (i==0 || intHeightFanChecked==4)
      {
        // check from left to right 3 kind first
        intDoneFace=MJ.CheckDoneLeft2RightPOE(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=4;
          }
        }
      }

      if (i==0 || intHeightFanChecked==5)
      {
        // check from right to left 3 kind first
        intDoneFace=MJ.CheckDoneRight2LeftPOE(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=5;
          }
        }
      }

      if (i==0 || intHeightFanChecked==6)
      {
        // check from left to right in order first
        intDoneFace=MJ.CheckDoneLeft2RightOEP(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=6;
          }
        }
      }

      if (i==0 || intHeightFanChecked==7)
      {
        // check from right to left in order first
        intDoneFace=MJ.CheckDoneRight2LeftOEP(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=7;
          }
        }
      }

      if (i==0 || intHeightFanChecked==8)
      {
        // check from left to right 3 kind first
        intDoneFace=MJ.CheckDoneLeft2RightPEO(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=8;
          }
        }
      }

      if (i==0 || intHeightFanChecked==9)
      {
        // check from right to left 3 kind first
        intDoneFace=MJ.CheckDoneRight2LeftPEO(intTmpFace);
        if (intDoneFace[0]!=Var.MJNOTDEFINED)
        {
          intFanChecked=MJ.CheckFan(intDoneFace,intDoneByOwn,intWind,intSeat,booShow,g)+1;
          if(intFanChecked>intRet)
          {
            intRet=intFanChecked;
            intHeightFanChecked=9;
          }
        }
      }

      if(i==0 && intRet!=0)
      {
        SetStage(Var.MJNOTDEFINED,MJ.Stage.OPEN);
        Paint();
        booShow=true;
      }
    }

    return intRet;
  }

  public int OppPoolClick(int intFace)
  {
    int intRet=0; // return status 1=used
    int i=0,j=-1;
    int intSelected[]=new int[13];
    int intSelectedPos[]=new int[13];

    //get selected faces on hand
    for (i=0;i<13;i++)
    {
      if (intMJStage[i]==MJ.Stage.SELECTED)
      {
        j=j+1;
        intSelected[j]=intMJFace[i];
        intSelectedPos[j]=i;
        intMJStage[i]=MJ.Stage.SHOW;
      }
    }
    if (j>=0)
    {
      Paint();
      if (Var.PLATFORM != 1) Vm.sleep(2*Var.DELAY);
    }

    //check if three of a kind
    if (j==1 && intSelected[0]==intFace && intSelected[1]==intFace)
    {
      intPlayerAction=4;
      intRet=1;
      intMJFace[13]=intFace;
      intMJStage[13]=MJ.Stage.OPEN;
      intMJStage[intSelectedPos[0]]=MJ.Stage.OPEN;
      intMJStage[intSelectedPos[1]]=MJ.Stage.OPEN;
      SortMJ();
      Paint();
    }

    //check if four of a kind
    if (j==2 && intSelected[0]==intFace && intSelected[1]==intFace && intSelected[2]==intFace)
    {
      intPlayerAction=3;
      intRet=1;
      intMJStage[intSelectedPos[0]]=MJ.Stage.FOUR;
      intMJStage[intSelectedPos[1]]=MJ.Stage.FOUR;
      intMJStage[intSelectedPos[2]]=MJ.Stage.FOUR;
      SortMJ();
      Paint();
    }

    //check if in order
    if (j==1 && 
       ( (intSelected[0]==intFace-2 && intSelected[1]==intFace-1) ||
         (intSelected[0]==intFace-1 && intSelected[1]==intFace+1) ||
         (intSelected[0]==intFace+1 && intSelected[1]==intFace+2) ))
    {
      intPlayerAction=4;
      intRet=1;
      intMJFace[13]=intFace;
      intMJStage[13]=MJ.Stage.OPEN;
      intMJStage[intSelectedPos[0]]=MJ.Stage.OPEN;
      intMJStage[intSelectedPos[1]]=MJ.Stage.OPEN;
      SortMJ();
      Paint();
    }
    return intRet;
  }
}
