import waba.core.*;

class MJStage
{
  public final static int FOUR=0;
  public final static int OPEN=1;
  public final static int CLOSE=2;
  public final static int SHOW=3;
  public final static int HIDE=4;
  public final static int SELECTED=5;

  public final static Image[] StageBmp = {
        new Image("mj_open.wbm"),
        new Image("mj_open.wbm"),
        new Image("mj_close.wbm"),
        new Image("mj_show.wbm"),
        new Image("mj_hide.wbm"),
        new Image("mj_show.wbm")};

  public final static int X[] = {Var.MJOPENFACEX, Var.MJOPENFACEX, -1, Var.MJSHOWFACEX, -1, Var.MJSHOWFACEX};
  public final static int Y[] = {Var.MJOPENFACEY, Var.MJOPENFACEY, -1, Var.MJSHOWFACEY, -1, Var.MJSHOWFACEY};
  public final static boolean[] drawFace = {true, true, false, true, false, true};

  public static final Image BMP(int intWhich)
  {
    return StageBmp[intWhich];
  }
}

class MJ
{
  public static MJStage Stage;

  public final static Image FourBmp = new Image("four.wbm");
  public final static Image DoneBmp = new Image("done.wbm");

  public final static Image[] DiceBmp = {
         new Image("dice1.wbm"),
         new Image("dice2.wbm"),
         new Image("dice3.wbm"),
         new Image("dice4.wbm"),
         new Image("dice5.wbm"),
         new Image("dice6.wbm")};

  public final static Image[] FaceBmp = {
	new Image("m1.wbm"),
	new Image("m2.wbm"),
	new Image("m3.wbm"),
	new Image("m4.wbm"),
	new Image("m5.wbm"),
	new Image("m6.wbm"),
	new Image("m7.wbm"),
	new Image("m8.wbm"),
	new Image("m9.wbm"),
	new Image("b1.wbm"),
	new Image("b2.wbm"),
	new Image("b3.wbm"),
	new Image("b4.wbm"),
	new Image("b5.wbm"),
	new Image("b6.wbm"),
	new Image("b7.wbm"),
	new Image("b8.wbm"),
	new Image("b9.wbm"),
	new Image("t1.wbm"),
	new Image("t2.wbm"),
	new Image("t3.wbm"),
	new Image("t4.wbm"),
	new Image("t5.wbm"),
	new Image("t6.wbm"),
	new Image("t7.wbm"),
	new Image("t8.wbm"),
	new Image("t9.wbm"),
	new Image("east.wbm"),
	new Image("south.wbm"),
	new Image("west.wbm"),
	new Image("north.wbm"),
	new Image("middle.wbm"),
	new Image("fat.wbm"),
	new Image("white.wbm")};

  public final static int M1=1; //0
  public final static int M2=2; //1
  public final static int M3=3; //2
  public final static int M4=4; //3
  public final static int M5=5; //4
  public final static int M6=6; //5
  public final static int M7=7; //6
  public final static int M8=8; //7
  public final static int M9=9; //8
  public final static int B1=21; //9
  public final static int B2=22; //10
  public final static int B3=23; //11
  public final static int B4=24; //12
  public final static int B5=25; //13
  public final static int B6=26; //14
  public final static int B7=27; //15
  public final static int B8=28; //16
  public final static int B9=29; //17
  public final static int T1=41; //18
  public final static int T2=42; //19
  public final static int T3=43; //20
  public final static int T4=44; //21
  public final static int T5=45; //22
  public final static int T6=46; //23
  public final static int T7=47; //24
  public final static int T8=48; //25
  public final static int T9=49; //26
  public final static int EAST=60; //27
  public final static int SOUTH=80; //28
  public final static int WEST=100; //29
  public final static int NORTH=120; //30
  public final static int MIDDLE=140; //31
  public final static int FAT=160; //32
  public final static int WHITE=180; //33

  public final static int intFaceCount[]=new int[34];

  static float randomSeed=0;

  public static final void Init()
  {
    int i;

    for(i=0;i<34;i++)
    {
      intFaceCount[i]=0;
    }
  }

  public static final Image BMP(int intWhich)
  {
    return FaceBmp[Face2RealNum(intWhich)];
  }

  public static final int Real2FaceNum(int intNum)
  {
    int intWhich=0;

    if(intNum<=8)
    {
      intWhich=intNum+1; // for m?
    }
    else if(intNum>=9 && intNum<=17)
    {
      intWhich=intNum+12;
    }
    else if(intNum>=18 && intNum<=26)
    {
      intWhich=intNum+23;
    }
    else
    {
      intWhich=(intNum-27)*20+60;
    }
    return intWhich;
  }

  public static final int Face2RealNum(int intWhich)
  {
    if (intWhich>=M1 && intWhich<=M9)
    {
      intWhich=intWhich-M1;
    }
    else if (intWhich>=B1 && intWhich<=B9)
    {
      intWhich=intWhich-B1+9;
    }
    else if (intWhich>=T1 && intWhich<=T9)
    {
      intWhich=intWhich-T1+18;
    }
    else
    {
      intWhich=(intWhich-60)/20+27;
    }
    return intWhich;
  }

  public static final String RealNum2Name(int intWhich)
  {
    String strRet;
    switch(intWhich)
    {
      case MJ.EAST:
        strRet="East";
        break;
      case MJ.SOUTH:
        strRet="South";
        break;
      case MJ.WEST:
        strRet="West";
        break;
      case MJ.NORTH:
        strRet="North";
        break;
      case MJ.MIDDLE:
        strRet="Middle";
        break;
      case MJ.FAT:
        strRet="Fat";
        break;
      case MJ.WHITE:
        strRet="White";
        break;
      default:
        strRet="Unknown";
        break;
      }
    return strRet;
  }

  public static final Image CreateMaJong(int intStage, int intFace)
  {
    Image iMaJong;
    Graphics gMaJong;
    int intFaceX, intFaceY;

    // load face
    Image iMJFace=MJ.BMP(intFace);

    iMaJong=MJ.Stage.BMP(intStage);
    if(MJ.Stage.drawFace[intStage]==true)
    {
      gMaJong=new Graphics(iMaJong);

      // place MaJong face
      gMaJong.drawImage(iMJFace, MJ.Stage.X[intStage], MJ.Stage.Y[intStage]);
      // check if four of a kind
      if(intStage==Stage.FOUR)
      {
        gMaJong.setColor(Var.DARKGREY, Var.DARKGREY, Var.DARKGREY);
        gMaJong.fillRect(MJ.Stage.X[intStage]+1, MJ.Stage.Y[intStage], Var.MJFOURW, Var.MJFOURH);
      }
    }

    return iMaJong;
  }

  public static int rand(int intMax)
  {
    float temp;

    randomSeed = randomSeed * 1103 + 12345;
    randomSeed = randomSeed % 65535;
    temp=(randomSeed % 255);
    temp=(int)(temp/255 * intMax);
    if(temp>=intMax) temp=temp-intMax;
    return((int)temp);
  }

  public static void srand(float seed)
  {
    randomSeed=randomSeed+seed;
  }

/*************************************************************************/
  public static int CheckFan(int intMJFace[], int intByOwn, int intWind, int intSeat, boolean booShow, Graphics g)
  {
    int i=0, j=0;
    int intFan;
    boolean booDone;
    int intGroup[]=new int[5];
    int intType[]=new int[5]; //0=same, 1=in order
    // for drawing
    Image iFan=new Image(Var.SHOWFANW, Var.SHOWFANH);
    Graphics gFan=new Graphics(iFan);
    Font f = new Font("Arial", Font.PLAIN, 14);
    FontMetrics fm = new FontMetrics(f, iFan);
    int intLineSpace=fm.getHeight()+fm.getLeading();
    int intCurLine=intLineSpace;

    if(booShow)
    {
      gFan.setColor(Var.BLACK,Var.BLACK,Var.BLACK);
      gFan.fillRect(0, 0, Var.SHOWFANW, Var.SHOWFANH);
      gFan.setColor(Var.LIGHTGREY,Var.LIGHTGREY,Var.LIGHTGREY);
      gFan.fillRect(0+1, 0+1, Var.SHOWFANW-2, Var.SHOWFANH-2);
      gFan.setColor(Var.BLACK,Var.BLACK,Var.BLACK);
      gFan.setFont(f);
    }

    intFan=0;
    booDone=false;
    for(i=0;i<5;i++)
    {
      if(intMJFace[i*3]>=1 && intMJFace[i*3]<=9)
        intGroup[i]=1;
      else if(intMJFace[i*3]>=21 && intMJFace[i*3]<=29)
        intGroup[i]=21;
      else if(intMJFace[i*3]>=41 && intMJFace[i*3]<=49)
        intGroup[i]=41;
      else
        intGroup[i]=intMJFace[i*3];

      if(intMJFace[i*3] != intMJFace[(i*3)+1]) // in order
      {
        intType[i]=1;
      }
    }

    if (intByOwn>0) // got by own
    {
      if(booShow) gFan.drawText("Own last tile = 1", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
      intFan=intFan+1;
      intByOwn--;
    }

    if (intByOwn>0) // got by four
    {
      if(booShow) gFan.drawText("Last tile after four = 1", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
      intFan=intFan+1;
    }

    if (booDone == false) // check 13 fan
    {
      if (intMJFace[0]+1 < intMJFace[1])
      {
        if(booShow) gFan.drawText("13 Faces = 13", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
        intFan=intFan+13;
        booDone=true;
      }
    }

    if (booDone == false) // check Big ESWN
    {
      if (intGroup[0]>=60 && intGroup[0]<=120 &&
          intGroup[1]>=60 && intGroup[1]<=120 &&
          intGroup[2]>=60 && intGroup[2]<=120 &&
          intGroup[3]>=60 && intGroup[3]<=120)
      {
        if(booShow) gFan.drawText("Big E S W N = 7", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
        intFan=intFan+7;
        booDone=true;
      }
    }

    if (booDone == false) // check Small ESWN
    {
      if (intGroup[1]>=60 && intGroup[1]<=120 &&
          intGroup[2]>=60 && intGroup[2]<=120 &&
          intGroup[3]>=60 && intGroup[3]<=120 &&
          intGroup[4]>=60 && intGroup[4]<=120)
      {
        if(booShow) gFan.drawText("Small E S W N = 4", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
        intFan=intFan+4;
        booDone=true;
      }
    }

    if (booDone == false) // check Big MFW
    {
      if (intGroup[1]>=140 && intGroup[1]<=180 &&
          intGroup[2]>=140 && intGroup[2]<=180 &&
          intGroup[3]>=140 && intGroup[3]<=180)
      {
        if(booShow) gFan.drawText("Big M F W = 7", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
        intFan=intFan+7;
        booDone=true;
      }
    }

    if (booDone == false) // check Small MFW
    {
      if (intGroup[2]>=140 && intGroup[2]<=180 &&
          intGroup[3]>=140 && intGroup[3]<=180 &&
          intGroup[4]>=140 && intGroup[4]<=180)
      {
        if(booShow) gFan.drawText("Small M F W = 4", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
        intFan=intFan+4;
        booDone=true;
      }
    }

    if (booDone == false) // check All Same
    {
      if ( (intGroup[0]==intGroup[1] && intGroup[1]==intGroup[2] && intGroup[2]==intGroup[3] && intGroup[3]==intGroup[4]) ||
           (intGroup[0]>=60 && intGroup[1]>=60 && intGroup[2]>=60 && intGroup[3]>=60 && intGroup[4]>=60) )
      {
        if(booShow) gFan.drawText("All in same group = 7", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
        intFan=intFan+7;
      }
    }

    // check mixed
    {
      if (intGroup[0]>=60 || intGroup[1]>=60 || intGroup[2]>=60 || intGroup[3]>=60 || intGroup[4]>=60)
      {
        if ((intGroup[0]==intGroup[1] || intGroup[0]>=60 || intGroup[1]>=60) &&
            (intGroup[0]==intGroup[2] || intGroup[0]>=60 || intGroup[2]>=60) &&
            (intGroup[0]==intGroup[3] || intGroup[0]>=60 || intGroup[3]>=60) &&
            (intGroup[0]==intGroup[4] || intGroup[0]>=60 || intGroup[4]>=60) &&
            (intGroup[1]==intGroup[2] || intGroup[1]>=60 || intGroup[2]>=60) &&
            (intGroup[1]==intGroup[3] || intGroup[1]>=60 || intGroup[3]>=60) &&
            (intGroup[1]==intGroup[4] || intGroup[1]>=60 || intGroup[4]>=60) &&
            (intGroup[2]==intGroup[3] || intGroup[2]>=60 || intGroup[3]>=60) &&
            (intGroup[2]==intGroup[4] || intGroup[2]>=60 || intGroup[4]>=60) &&
            (intGroup[3]==intGroup[4] || intGroup[3]>=60 || intGroup[4]>=60))
        {
          if(booShow) gFan.drawText("Mixed = 3", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
          intFan=intFan+3;
        }
      }
    }

    // check All Three of a Kind
    {
      if (intType[0]==0 && intType[1]==0 && intType[2]==0 && intType[3]==0)
      {
        if(booShow) gFan.drawText("All three of a kind = 3", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
        intFan=intFan+3;
      }
    }

    // check All In Ordered
    {
      if (intType[0]==1 && intType[1]==1 && intType[2]==1 && intType[3]==1)
      {
        if(booShow) gFan.drawText("All in ordered = 1", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
        intFan=intFan+1;
      }
    }


    // check wind
    if (booDone == false)
    {
      for (i=0;i<4;i++)
      {
        if (intGroup[i]==intWind)
        {
          if(booShow) gFan.drawText(RealNum2Name(intGroup[i])+" wind has fan = 1", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
          intFan=intFan+1;
        }
      }
    }

    // check seat
    if (booDone == false)
    {
      for (i=0;i<4;i++)
      {
        if (intGroup[i]==intSeat)
        {
          if(booShow) gFan.drawText(RealNum2Name(intGroup[i])+" seat has fan = 1", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
          intFan=intFan+1;
        }
      }
    }

    // check M F W
    if (booDone == false)
    {
      for (i=0;i<4;i++)
      {
        if (intGroup[i]>=140)
        {
          if(booShow) gFan.drawText("Tile "+RealNum2Name(intGroup[i])+" has fan = 1", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
          intFan=intFan+1;
        }
      }
    }

    if(booShow)
    {
      gFan.drawText("Total = "+intFan+" fan(s)", intLineSpace, intCurLine); intCurLine=intCurLine+intLineSpace;
      gFan.drawImage(new Image("closebutton.wbm"), Var.SHOWFANW-Var.CLOSEBUTTONW, 0);
      g.drawImage(iFan, Var.SHOWFANX, Var.SHOWFANY);
    }

    return intFan;
  }

/*************************************************************************/
  public static int[] CheckDone13Face(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int13Face[]={MJ.M1, MJ.M9, MJ.B1, MJ.B9, MJ.T1, MJ.T9, MJ.EAST, MJ.SOUTH, MJ.WEST, MJ.NORTH, MJ.MIDDLE, MJ.FAT, MJ.WHITE};
    boolean booEye=false;

    // check 13 faces
if (Var.DEBUG) System.out.println("--- check 13 faces ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=0;i<13;i++)
    {
      for(j=0;j<14;j++)
      {
        if(int13Face[i]==intMJFace[j] && booChecked[j]==false)
        {
          booChecked[j]=true;
          l++;
          intDoneFace[k++]=intMJFace[j];
          break;
        }
      }
    }
    for(i=0;i<14 && booEye==false;i++)  // check last MJ
    {
      if(booChecked[i]==false)
      {
        for(j=0;j<13 && booEye==false;j++)
        {
          if(intMJFace[i]==int13Face[j])
          {
            intDoneFace[k++]=intMJFace[i];
            booEye=true;
          }
        }
      }
    }
    if(l!=13 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }

/*************************************************************************/
  public static int[] CheckDoneLeft2RightOPE(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int3Kind=0;
    boolean booEye=false;
    boolean booFoundPair=false;

    // check from left to right
if (Var.DEBUG) System.out.println("--- check from left to right in order first ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=0;i<14;i++)
    {
      booFoundPair=false;
      if(booChecked[i]==false)
      {
if (Var.DEBUG) System.out.println("checking pos:"+i+" Face:"+intMJFace[i]);
        booChecked[i]=true;
        // check in order
        for(j=0;j<14 && booFoundPair==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]+1==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=0;k<14 && booFoundPair==false;k++)
            {
              if(booChecked[k]==false && intMJFace[j]+1==intMJFace[k]) //found in order
              {
if (Var.DEBUG) System.out.println("in order");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[i];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[k];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check three of a kind
        for(j=0;j<14 && booFoundPair==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=0;k<14 && booFoundPair==false;k++)
            {
              if(booChecked[k]==false && intMJFace[j]==intMJFace[k]) //found three of a kind
              {
if (Var.DEBUG) System.out.println("three of a kind");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[i];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[k];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check for a pair(eye)
        for(j=0;j<14 && booFoundPair==false && booEye==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
if (Var.DEBUG) System.out.println("eye");
            booChecked[j]=true;
            booEye=true;
            booFoundPair=true;
            intDoneFace[12]=intMJFace[i];
            intDoneFace[13]=intMJFace[j];
          }
        }

        if(booFoundPair==false) booChecked[i]=false; //reset
      }
    }
if (Var.DEBUG) System.out.println("kind:"+int3Kind+" Eye:"+booEye);
    if(int3Kind!=4 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }

/*************************************************************************/
  public static int[] CheckDoneRight2LeftOPE(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int3Kind=0;
    boolean booEye=false;
    boolean booFoundPair=false;

    // check from right to left
if (Var.DEBUG) System.out.println("--- check from right to left in order first ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=13;i>=0;i--)
    {
      booFoundPair=false;
      if(booChecked[i]==false)
      {
if (Var.DEBUG) System.out.println("checking pos:"+i+" Face:"+intMJFace[i]);
        booChecked[i]=true;
        // check in order
        for(j=13;j>=0 && booFoundPair==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]-1==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=13;k>=0 && booFoundPair==false;k--)
            {
              if(booChecked[k]==false && intMJFace[j]-1==intMJFace[k]) //found in order
              {
if (Var.DEBUG) System.out.println("in order");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[k];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[i];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check three of a kind
        for(j=13;j>=0 && booFoundPair==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=13;k>=0 && booFoundPair==false;k--)
            {
              if(booChecked[k]==false && intMJFace[j]==intMJFace[k]) //found three of a kind
              {
if (Var.DEBUG) System.out.println("three of a kind");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[k];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[i];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check for a pair(eye)
        for(j=13;j>=0 && booFoundPair==false && booEye==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
if (Var.DEBUG) System.out.println("eye");
            booChecked[j]=true;
            booEye=true;
            booFoundPair=true;
            intDoneFace[12]=intMJFace[i];
            intDoneFace[13]=intMJFace[j];
          }
        }

        if(booFoundPair==false) booChecked[i]=false; //reset
      }
    }
if (Var.DEBUG) System.out.println("kind:"+int3Kind+" Eye:"+booEye);
    if(int3Kind!=4 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }

/*************************************************************************/
  public static int[] CheckDoneLeft2RightPOE(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int3Kind=0;
    boolean booEye=false;
    boolean booFoundPair=false;

    // check from left to right
if (Var.DEBUG) System.out.println("--- check from left to right 3 Kind first ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=0;i<14;i++)
    {
      booFoundPair=false;
      if(booChecked[i]==false)
      {
if (Var.DEBUG) System.out.println("checking pos:"+i+" Face:"+intMJFace[i]);
        booChecked[i]=true;
        // check three of a kind
        for(j=0;j<14 && booFoundPair==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=0;k<14 && booFoundPair==false;k++)
            {
              if(booChecked[k]==false && intMJFace[j]==intMJFace[k]) //found three of a kind
              {
if (Var.DEBUG) System.out.println("three of a kind");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[i];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[k];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check in order
        for(j=0;j<14 && booFoundPair==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]+1==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=0;k<14 && booFoundPair==false;k++)
            {
              if(booChecked[k]==false && intMJFace[j]+1==intMJFace[k]) //found in order
              {
if (Var.DEBUG) System.out.println("in order");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[i];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[k];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check for a pair(eye)
        for(j=0;j<14 && booFoundPair==false && booEye==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
if (Var.DEBUG) System.out.println("eye");
            booChecked[j]=true;
            booEye=true;
            booFoundPair=true;
            intDoneFace[12]=intMJFace[i];
            intDoneFace[13]=intMJFace[j];
          }
        }

        if(booFoundPair==false) booChecked[i]=false; //reset
      }
    }
if (Var.DEBUG) System.out.println("kind:"+int3Kind+" Eye:"+booEye);
    if(int3Kind!=4 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }

/*************************************************************************/
  public static int[] CheckDoneRight2LeftPOE(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int3Kind=0;
    boolean booEye=false;
    boolean booFoundPair=false;

    // check from right to left
if (Var.DEBUG) System.out.println("--- check from right to left 3 Kind first ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=13;i>=0;i--)
    {
      booFoundPair=false;
      if(booChecked[i]==false)
      {
if (Var.DEBUG) System.out.println("checking pos:"+i+" Face:"+intMJFace[i]);
        booChecked[i]=true;
        // check three of a kind
        for(j=13;j>=0 && booFoundPair==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=13;k>=0 && booFoundPair==false;k--)
            {
              if(booChecked[k]==false && intMJFace[j]==intMJFace[k]) //found three of a kind
              {
if (Var.DEBUG) System.out.println("three of a kind");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[k];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[i];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check in order
        for(j=13;j>=0 && booFoundPair==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]-1==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=13;k>=0 && booFoundPair==false;k--)
            {
              if(booChecked[k]==false && intMJFace[j]-1==intMJFace[k]) //found in order
              {
if (Var.DEBUG) System.out.println("in order");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[k];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[i];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check for a pair(eye)
        for(j=13;j>=0 && booFoundPair==false && booEye==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
if (Var.DEBUG) System.out.println("eye");
            booChecked[j]=true;
            booEye=true;
            booFoundPair=true;
            intDoneFace[12]=intMJFace[i];
            intDoneFace[13]=intMJFace[j];
          }
        }

        if(booFoundPair==false) booChecked[i]=false; //reset
      }
    }
if (Var.DEBUG) System.out.println("kind:"+int3Kind+" Eye:"+booEye);
    if(int3Kind!=4 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }
/*************************************************************************/
  public static int[] CheckDoneLeft2RightOEP(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int3Kind=0;
    boolean booEye=false;
    boolean booFoundPair=false;

    // check from left to right
if (Var.DEBUG) System.out.println("--- check from left to right in order first ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=0;i<14;i++)
    {
      booFoundPair=false;
      if(booChecked[i]==false)
      {
if (Var.DEBUG) System.out.println("checking pos:"+i+" Face:"+intMJFace[i]);
        booChecked[i]=true;
        // check in order
        for(j=0;j<14 && booFoundPair==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]+1==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=0;k<14 && booFoundPair==false;k++)
            {
              if(booChecked[k]==false && intMJFace[j]+1==intMJFace[k]) //found in order
              {
if (Var.DEBUG) System.out.println("in order");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[i];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[k];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check for a pair(eye)
        for(j=0;j<14 && booFoundPair==false && booEye==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
if (Var.DEBUG) System.out.println("eye");
            booChecked[j]=true;
            booEye=true;
            booFoundPair=true;
            intDoneFace[12]=intMJFace[i];
            intDoneFace[13]=intMJFace[j];
          }
        }

        // check three of a kind
        for(j=0;j<14 && booFoundPair==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=0;k<14 && booFoundPair==false;k++)
            {
              if(booChecked[k]==false && intMJFace[j]==intMJFace[k]) //found three of a kind
              {
if (Var.DEBUG) System.out.println("three of a kind");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[i];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[k];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        if(booFoundPair==false) booChecked[i]=false; //reset
      }
    }
if (Var.DEBUG) System.out.println("kind:"+int3Kind+" Eye:"+booEye);
    if(int3Kind!=4 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }

/*************************************************************************/
  public static int[] CheckDoneRight2LeftOEP(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int3Kind=0;
    boolean booEye=false;
    boolean booFoundPair=false;

    // check from right to left
if (Var.DEBUG) System.out.println("--- check from right to left in order first ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=13;i>=0;i--)
    {
      booFoundPair=false;
      if(booChecked[i]==false)
      {
if (Var.DEBUG) System.out.println("checking pos:"+i+" Face:"+intMJFace[i]);
        booChecked[i]=true;
        // check in order
        for(j=13;j>=0 && booFoundPair==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]-1==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=13;k>=0 && booFoundPair==false;k--)
            {
              if(booChecked[k]==false && intMJFace[j]-1==intMJFace[k]) //found in order
              {
if (Var.DEBUG) System.out.println("in order");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[k];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[i];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check for a pair(eye)
        for(j=13;j>=0 && booFoundPair==false && booEye==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
if (Var.DEBUG) System.out.println("eye");
            booChecked[j]=true;
            booEye=true;
            booFoundPair=true;
            intDoneFace[12]=intMJFace[i];
            intDoneFace[13]=intMJFace[j];
          }
        }

        // check three of a kind
        for(j=13;j>=0 && booFoundPair==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=13;k>=0 && booFoundPair==false;k--)
            {
              if(booChecked[k]==false && intMJFace[j]==intMJFace[k]) //found three of a kind
              {
if (Var.DEBUG) System.out.println("three of a kind");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[k];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[i];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        if(booFoundPair==false) booChecked[i]=false; //reset
      }
    }
if (Var.DEBUG) System.out.println("kind:"+int3Kind+" Eye:"+booEye);
    if(int3Kind!=4 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }

/*************************************************************************/
  public static int[] CheckDoneLeft2RightPEO(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int3Kind=0;
    boolean booEye=false;
    boolean booFoundPair=false;

    // check from left to right
if (Var.DEBUG) System.out.println("--- check from left to right 3 Kind first ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=0;i<14;i++)
    {
      booFoundPair=false;
      if(booChecked[i]==false)
      {
if (Var.DEBUG) System.out.println("checking pos:"+i+" Face:"+intMJFace[i]);
        booChecked[i]=true;
        // check three of a kind
        for(j=0;j<14 && booFoundPair==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=0;k<14 && booFoundPair==false;k++)
            {
              if(booChecked[k]==false && intMJFace[j]==intMJFace[k]) //found three of a kind
              {
if (Var.DEBUG) System.out.println("three of a kind");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[i];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[k];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check for a pair(eye)
        for(j=0;j<14 && booFoundPair==false && booEye==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
if (Var.DEBUG) System.out.println("eye");
            booChecked[j]=true;
            booEye=true;
            booFoundPair=true;
            intDoneFace[12]=intMJFace[i];
            intDoneFace[13]=intMJFace[j];
          }
        }

        // check in order
        for(j=0;j<14 && booFoundPair==false;j++)
        {
          if(booChecked[j]==false && intMJFace[i]+1==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=0;k<14 && booFoundPair==false;k++)
            {
              if(booChecked[k]==false && intMJFace[j]+1==intMJFace[k]) //found in order
              {
if (Var.DEBUG) System.out.println("in order");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[i];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[k];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        if(booFoundPair==false) booChecked[i]=false; //reset
      }
    }
if (Var.DEBUG) System.out.println("kind:"+int3Kind+" Eye:"+booEye);
    if(int3Kind!=4 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }

/*************************************************************************/
  public static int[] CheckDoneRight2LeftPEO(int intMJFace[])
  {
    int i=0, j=0, k=0, l=0;
    boolean booChecked[]=new boolean[14];
    int intDoneFace[]=new int[14];
    int int3Kind=0;
    boolean booEye=false;
    boolean booFoundPair=false;

    // check from right to left
if (Var.DEBUG) System.out.println("--- check from right to left 3 Kind first ---");
    for(i=0;i<14;i++)
    {
      booChecked[i]=false;
      intDoneFace[i]=Var.MJNOTDEFINED;
    }
    for(i=13;i>=0;i--)
    {
      booFoundPair=false;
      if(booChecked[i]==false)
      {
if (Var.DEBUG) System.out.println("checking pos:"+i+" Face:"+intMJFace[i]);
        booChecked[i]=true;
        // check three of a kind
        for(j=13;j>=0 && booFoundPair==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=13;k>=0 && booFoundPair==false;k--)
            {
              if(booChecked[k]==false && intMJFace[j]==intMJFace[k]) //found three of a kind
              {
if (Var.DEBUG) System.out.println("three of a kind");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[k];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[i];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        // check for a pair(eye)
        for(j=13;j>=0 && booFoundPair==false && booEye==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]==intMJFace[j])
          {
if (Var.DEBUG) System.out.println("eye");
            booChecked[j]=true;
            booEye=true;
            booFoundPair=true;
            intDoneFace[12]=intMJFace[i];
            intDoneFace[13]=intMJFace[j];
          }
        }

        // check in order
        for(j=13;j>=0 && booFoundPair==false;j--)
        {
          if(booChecked[j]==false && intMJFace[i]-1==intMJFace[j])
          {
            booChecked[j]=true;
            for(k=13;k>=0 && booFoundPair==false;k--)
            {
              if(booChecked[k]==false && intMJFace[j]-1==intMJFace[k]) //found in order
              {
if (Var.DEBUG) System.out.println("in order");
                booChecked[k]=true;
                int3Kind++;
                booFoundPair=true;
                intDoneFace[l++]=intMJFace[k];
                intDoneFace[l++]=intMJFace[j];
                intDoneFace[l++]=intMJFace[i];
              }
            }
            if(booFoundPair==false) booChecked[j]=false; //reset
          }
        }

        if(booFoundPair==false) booChecked[i]=false; //reset
      }
    }
if (Var.DEBUG) System.out.println("kind:"+int3Kind+" Eye:"+booEye);
    if(int3Kind!=4 || booEye==false)
    {
      intDoneFace[0]=Var.MJNOTDEFINED; // not done!
    }

    return intDoneFace;
  }
}