import waba.core.*;

class Computer
{
  Graphics g;

  int intComputerAction=0; //0-no action, 1-get a face, 2-removed a face, 3-four, 4-got from opp.

  // player hand
  int intMJFace[] = new int[15];
  int intMJStage[] = new int[15];
  int intMJAbort[] = new int[28];
  // Is a Done hand or not?
  int intDone=0;
  // player properties
  int intLuck=0;
  int intDoneFans=0;
  int intOwn=0;
  int intWind=0;
  int intSeat=0;
  int intLevel=0;

  public Computer(Graphics gWindow, int Own, int Wind, int Seat, int Level)
  {
    int i;

    g=gWindow;
    intOwn=Own;
    intWind=Wind;
    intSeat=Seat;
    intLevel=Level;
    for(i=0;i<15;i++) {intMJFace[i]=Var.MJNOTDEFINED; intMJStage[i]=MJ.Stage.HIDE;}
    for(i=0;i<28;i++) intMJAbort[i]=Var.MJNOTDEFINED;
  }

  public int LastAction()
  {
    return intComputerAction;
  }

  public void LastAction(int intAction)
  {
    intComputerAction=intAction;
  }

  public int LastAbortFace()
  {
    int i;

    for(i=27;i>=0;i--)
    {
      if (intMJAbort[i]!=Var.MJNOTDEFINED)
      {
        return intMJAbort[i];
      }
    }
    return Var.MJNOTDEFINED;
  }

  public void RemoveLastAbortFace()
  {
    int i;

    for(i=27;i>=0;i--)
    {
      if (intMJAbort[i]!=Var.MJNOTDEFINED)
      {
        intMJAbort[i]=Var.MJNOTDEFINED;
        break;
      }
    }
    Paint();
  }

  public void SetStage(int intWhich, int intStage)
  {
    int i=0;

    if(intWhich>15)
    {
      for(i=0;i<15;i++)
      {
        if (intMJStage[i]!=MJ.Stage.FOUR) intMJStage[i]=intStage;
      }
    }
    else
    {
      intMJStage[intWhich]=intStage;
    }
  }

  public void SortMJ()
  {
    int i,j;
    int intTemp;

    //sort stage
    for(i=0;i<14;i++)
    {
      for(j=0;j<14;j++)
      {
        if(intMJStage[j]>intMJStage[j+1])
        {
          // swap face
          intTemp=intMJFace[j];
          intMJFace[j]=intMJFace[j+1];
          intMJFace[j+1]=intTemp;
          // swap stage
          intTemp=intMJStage[j];
          intMJStage[j]=intMJStage[j+1];
          intMJStage[j+1]=intTemp;
        }
      }
    }
  }

  public void AddMJ(int intFace)
  {
    int i;

    for (i=0;i<15;i++)
    {
      if(intMJFace[i]==Var.MJNOTDEFINED)
      {
        intMJFace[i]=intFace;
        break;
      }
    }
  }

  public void AddAbortMJ(int intFace)
  {
    int i;

    for (i=0;i<28;i++)
    {
      if(intMJAbort[i]==Var.MJNOTDEFINED)
      {
        intMJAbort[i]=intFace;
        break;
      }
    }
  }

  public void Paint()
  {
    int i;
    Image iMJ;
    Graphics gMJ;
    Font f = new Font("Arial", Font.PLAIN, 12);

    iMJ=new Image(Var.COMPHANDW,Var.COMPHANDH);
    gMJ=new Graphics(iMJ);
    gMJ.setColor(Var.WHITE,Var.WHITE,Var.WHITE);
    gMJ.fillRect(0,0,Var.COMPHANDW,Var.COMPHANDH);

    // show info
    gMJ.setColor(Var.BLACK, Var.BLACK, Var.BLACK);
    gMJ.setFont(f);
    gMJ.drawText(" Point:"+intOwn+"  Seat:"+MJ.RealNum2Name(intSeat), 0, Var.MJH+Var.FONTVSPACE);

    // draw hand
    if(intMJFace[14]!=Var.MJNOTDEFINED)
    {
      gMJ.drawImage(MJ.CreateMaJong(intMJStage[14], intMJFace[14]), 0, 0);
    }
    for (i=13-intDone;i>=0;i--)
    {
      if(intMJFace[i]!=Var.MJNOTDEFINED)
      {
        gMJ.drawImage(MJ.CreateMaJong(intMJStage[i], intMJFace[i]), (Var.MAXMJPERROW-1-i)*(Var.MJW+Var.MJSPACE), 0);
      }
    }
    g.drawImage(iMJ,Var.COMPHANDX,Var.COMPHANDY);

    // draw abort pool
    iMJ=new Image(Var.COMPPOOLW, Var.COMPPOOLH);
    gMJ=new Graphics(iMJ);
    gMJ.setColor(Var.WHITE,Var.WHITE,Var.WHITE);
    gMJ.fillRect(0, 0, Var.COMPPOOLW, Var.COMPPOOLH);

    if (Var.PLATFORM==0)
    {
      for (i=(Var.MAXMJPERROW*2)-1;i>=0;i--)
      {
        if(intMJAbort[i]!=Var.MJNOTDEFINED)
        {
          gMJ.drawImage(MJ.CreateMaJong(MJ.Stage.OPEN, intMJAbort[i]), ((Var.MAXMJPERROW-1)-(i%Var.MAXMJPERROW))*(Var.MJW+Var.MJSPACE), (1-(i/Var.MAXMJPERROW))*Var.MJOPENVSPACE);
        }
      }
    }
    else
    {
      for (i=0;i<=(Var.MAXMJPERROW*2)-1;i++)
      {
        if(intMJAbort[i]!=Var.MJNOTDEFINED)
        {
          gMJ.drawImage(MJ.CreateMaJong(MJ.Stage.OPEN, intMJAbort[i]), ((Var.MAXMJPERROW-1)-(i%Var.MAXMJPERROW))*(Var.MJW+Var.MJSPACE), (1-(i/Var.MAXMJPERROW))*Var.MJOPENVSPACE);
        }
      }
    }

    g.drawImage(iMJ, Var.COMPPOOLX, Var.COMPPOOLY);
  }

  public int CheckPlayerAbort(int intFace) // return > 0 if done
  {
    int i,j;
    int intRet=0;  // 0-nothing happen

    for (i=0;i<12;i++)
    {
      if(intMJFace[i]==intFace && intMJStage[i]==MJ.Stage.HIDE)
      {
        j=MJ.rand(29-intLuck); // random win
        if(j==0)
        {
          intComputerAction=4;
          intMJFace[14]=intMJFace[13];
          SetStage(Var.MJNOTDEFINED,MJ.Stage.OPEN);
          Paint();
          intRet=MJ.CheckFan(intMJFace, 0, intWind, intSeat, true, g)+1;
          break;
        }

        if(MJ.rand(2)==1) // half of chance will take
        {
          //use player aborted face
          j=(i/3)*3;
          if (intMJFace[j]==intMJFace[j+1] && intMJFace[j+1]==intMJFace[j+2] && MJ.rand(5)==1) // five out of one will four
          {
              intComputerAction=3;
              intMJStage[j]=MJ.Stage.FOUR;
              intMJStage[j+1]=MJ.Stage.FOUR;
              intMJStage[j+2]=MJ.Stage.FOUR;
          }
          else
          {
            intComputerAction=4;
            MJ.intFaceCount[MJ.Face2RealNum(intFace)]--;
            intMJStage[j]=MJ.Stage.OPEN;
            intMJStage[j+1]=MJ.Stage.OPEN;
            intMJStage[j+2]=MJ.Stage.OPEN;
          }
          SortMJ();
          break;
        }
      }
    }
    return intRet;
  }

  public int GetNewFace(int intFace)
  {
    int i,j;
    int intRet=0;  // 0-nothing happen

    intLuck++; // have more luck
    intMJFace[14]=intFace;
    Paint();
    if (Var.PLATFORM != 1) Vm.sleep(3*Var.DELAY);

    // calculate random win factor
    i=(29*(intDoneFans+1))-(intLuck*(intDoneFans+1));
    if (i<2) i=2;

    j=MJ.rand(i); // random win

    if(j==1 && intComputerAction!=4)
    {
      intMJFace[14]=intMJFace[13];
      SetStage(Var.MJNOTDEFINED,MJ.Stage.OPEN);
      Paint();
      if(intComputerAction==3)
      {
        intRet=MJ.CheckFan(intMJFace, 2, intWind, intSeat, true, g)+1;
      }
      else
      {
        intRet=MJ.CheckFan(intMJFace, 1, intWind, intSeat, true, g)+1;
      }
      return intRet;
    }

    intComputerAction=1;

    for (i=0;i<12;i++)
    {
      if(intMJFace[i]==intFace)
      {
        j=(i/3)*3;
        if (intMJFace[j]==intMJFace[j+1] && intMJFace[j+1]==intMJFace[j+2])
        {
          intComputerAction=3; //four of a kind
          intMJStage[j]=MJ.Stage.FOUR;
          intMJStage[j+1]=MJ.Stage.FOUR;
          intMJStage[j+2]=MJ.Stage.FOUR;
          break;
        }
      }
    }
    intMJFace[14]=Var.MJNOTDEFINED;
    if (intComputerAction!=3)
    {

      AddAbortMJ(intFace);
    }
    Paint();
    return intRet;
  }

  public void SeatEast()
  {
    AddAbortMJ(intMJFace[14]);
    intMJFace[14]=Var.MJNOTDEFINED;
    Paint();
  }

  public void GetDone()
  {
    int i,j;
    int intMJ=0;
    int intExpectedFans=0, intCheckedFans=-1, intTried=0;
    boolean booFound=false;

    intMJFace[14]=intMJFace[13];  // in case of seating EAST

if (Var.DEBUG) System.out.println("Level ="+intLevel);
   intExpectedFans=MJ.rand(intLevel);
   if (intExpectedFans>5) intExpectedFans=5;  // Max random fans is 5
if (Var.DEBUG) System.out.println("ExpectedFans ="+intExpectedFans);

    while (intExpectedFans>intCheckedFans && intTried++<10)
    {
      //put back titles
      for (i=0;i<14;i++)
      {
        if(intMJFace[i]!=Var.MJNOTDEFINED)
        {
          MJ.intFaceCount[MJ.Face2RealNum(intMJFace[i])]--;
          intMJFace[i]=Var.MJNOTDEFINED;
        }
      }

      //construct done hand
      for(i=0;i<4;i++)
      {
        booFound=false;
        while(booFound==false)
        {
          intMJ=MJ.rand(34);
          if (intMJ>=27 || MJ.rand(2)==0) //three of a kind
          {
            if (MJ.intFaceCount[intMJ]<2)
            {
              MJ.intFaceCount[intMJ]=MJ.intFaceCount[intMJ]+3;
              booFound=true;
              AddMJ(MJ.Real2FaceNum(intMJ));
              AddMJ(MJ.Real2FaceNum(intMJ));
              AddMJ(MJ.Real2FaceNum(intMJ));
            }
          }
          else if(intMJ<=6 || (intMJ>=9 && intMJ<=15) || (intMJ>=18 && intMJ<=24)) //ordered
          {
            if (MJ.intFaceCount[intMJ]<4 && MJ.intFaceCount[intMJ+1]<4 && MJ.intFaceCount[intMJ+2]<4)
            {
              booFound=true;
              MJ.intFaceCount[intMJ]++;
              AddMJ(MJ.Real2FaceNum(intMJ));
              MJ.intFaceCount[intMJ+1]++;
              AddMJ(MJ.Real2FaceNum(intMJ+1));
              MJ.intFaceCount[intMJ+2]++;
              AddMJ(MJ.Real2FaceNum(intMJ+2));
            }
          }
        }
      }
      //generate a pair
      booFound=false;
      while(booFound==false)
      {
        intMJ=MJ.rand(34);
        if (MJ.intFaceCount[intMJ]<3)
        {
          MJ.intFaceCount[intMJ]=MJ.intFaceCount[intMJ]+2;
          booFound=true;
          AddMJ(MJ.Real2FaceNum(intMJ));
          AddMJ(MJ.Real2FaceNum(intMJ));
        }
      }
      intCheckedFans=MJ.CheckFan(intMJFace, 0, intWind, intSeat, false, g);
      intDoneFans=intCheckedFans;
if (Var.DEBUG) System.out.println("Computer Fan = "+intCheckedFans);
      MJ.srand(1);
    }
    intDone=1;
  }
}
