// ----------------------------------------------------------------------------------- 
//
//	Copyright (C) 1997 Ruksun Software Technologies Pvt. Ltd. All rights reserved.
//
// Author		:	Rohit Ojha ( rohit@corus.com )
//
//	Description	:	Declaration for the trace call. Call the function directly
//						or use the macro. Also currently you will have to use "\r\n"
//						for new line. Will be fixed in next release.
//
//-----------------------------------------------------------------------------------


#ifndef __DBTRACE_H
#define __DBTRACE_H

void DebugTraceCE(LPCTSTR lpszFormat, ...);
void SetDBDebugTraceInfo( PSTR lpszFileName, UINT uLineNum, DWORD dwThreadID );
void SetDBErrorTraceInfo( PSTR lpszFileName, UINT uLineNum, DWORD dwThreadID );

#ifdef DEBUG
	#define DBTRACE DebugTraceCE

	#define DBTRACE0	\
			SetDBDebugTraceInfo( __FILE__, __LINE__, -1 );	\
			DebugTraceCE

	#define DBTRACE1	\
			SetDBDebugTraceInfo( __FILE__, __LINE__, GetCurrentThreadId() );	\
			DebugTraceCE

	#define ERRTRACE0	\
			SetDBErrorTraceInfo( __FILE__, __LINE__, -1 );	\
			DebugTraceCE

	#define ERRTRACE1	\
			SetDBErrorTraceInfo( __FILE__, __LINE__, GetCurrentThreadId() );	\
			DebugTraceCE

#else
	#define DBTRACE	0
	#define DBTRACE0	0
	#define DBTRACE1	0
	#define ERRTRACE0	0
	#define ERRTRACE1	0

#endif	// DEBUG

#endif // __DBTRACE_H
