// Copyright (c) 1990,1991,1992 Chris and John Downey 

/***

* @(#)virtscr.h	2.3 (Chris & John Downey) 9/4/92

* program name:
    wvi
* function:
    PD version of UNIX "vi" editor for WIN32, with extensions.
* module name:
    virtscr.h
* module function:
    Definition of the VirtScr class.
* history:
    STEVIE - ST Editor for VI Enthusiasts, Version 3.10
    Originally by Tim Thompson (twitch!tjt)
    Extensive modifications by Tony Andrews (onecom!wldrdg!tony)
    Heavily modified by Chris & John Downey
	modified for WIN32 / UNICODE / C++ by K.Yoshizawa
		(PAF02413.niftyserve.or.jp)

***/

typedef struct virtscr {
    void	*pv_window;
    int		pv_rows;
    int		pv_cols;
// public: 
    struct virtscr *(*v_new)(struct virtscr *);
    void	(*v_close)(struct virtscr *);

    int		(*v_rows)(struct virtscr *);
    int		(*v_cols)(struct virtscr *);

    void	(*v_clear_all)(struct virtscr *);
    void	(*v_clear_line)(struct virtscr *, int, int);

    void	(*v_goto)(struct virtscr *, int, int);
    void	(*v_advise)(struct virtscr *, int, int, int, WCHAR *);

    void	(*v_write)(struct virtscr *, int, int, WCHAR *);
    void	(*v_putc)(struct virtscr *, int, int, int);

    void	(*v_set_color)(struct virtscr *, int);
    int		(*v_color_cost)(struct virtscr *);

    void	(*v_flush)(struct virtscr *);

    void	(*v_beep)(struct virtscr *);

// optional: do not use if NULL 
    void	(*v_insert)(struct virtscr *, int, int, WCHAR *);

    int		(*v_scroll)(struct virtscr *, int, int, int);

    void	(*v_flash)(struct virtscr *);

    void	(*v_status)(struct virtscr *, WCHAR *, WCHAR *, long, long);

    void	(*v_activate)(struct virtscr *);
} VirtScr;

#define	VSrows(vs)			((*(vs->v_rows))(vs))
#define	VScols(vs)			((*(vs->v_cols))(vs))
#define	VSclear_all(vs)			((*(vs->v_clear_all))(vs))
#define	VSclear_line(vs, row, col)	((*(vs->v_clear_line))(vs, row, col))
#define	VSgoto(vs, row, col)		((*(vs->v_goto))(vs, row, col))
#define	VSadvise(vs, r, c, i, str)	((*(vs->v_advise))(vs, r, c, i, str))
#define	VSwrite(vs, row, col, str)	((*(vs->v_write))(vs, row, col, str))
#define	VSputc(vs, row, col, c)		((*(vs->v_putc))(vs, row, col, c))
#define	VSset_color(vs, color)	((*(vs->v_set_color))(vs, color))
#define	VScolor_cost(vs)		((*(vs->v_color_cost))(vs))
#define	VSflush(vs)			((*(vs->v_flush))(vs))
#define	VSbeep(vs)			((*(vs->v_beep))(vs))
#define	VSinsert(vs, row, col, str)	((*(vs->v_insert))(vs, row, col, str))
#define	VSscroll(vs, start, end, n)	((*(vs->v_scroll))(vs, start, end, n))
