BEGIN {
	nitem = 0
	mx = 15
	my = 17

	while ( getline < "vars.tbl" > 0 ) {
		if ( $0 ~ /^#/ ) {
			continue
		}
		gsub( / /, "", $0 )
		split( $0, arr, "," )
		vars[arr[1]] = arr[2]
	}
}
/^STYLE/ {
	style = $0
	next
}
/^CAPTION/ {
	caption = $0
	next
}
/^BEGIN/ {
	flag = 1
	last = ""
	next
}
/^END/ {
	flag = 0
	next
}
$1=="EDITTEXT" || $1=="LISTBOX" || $1=="COMBOBOX" || $1=="PUSHBUTTON" {
	if ( last != "" ) {
		gsub( / /, "", last )
		ctrl[nitem] = lastctrl
		item[nitem] = last
		nitem ++
	}
	lastctrl = $1
	last = $0
	sub( lastctrl, "", last )
	next
}
{
	if ( flag ) {
		last = last $0
	}
}
END {
	if ( last != "" ) {
		gsub( / /, "", last )
		ctrl[nitem] = lastctrl
		item[nitem] = last
		nitem ++
	}
#	printf( "style=%s.\n", style )
#	printf( "caption=%s.\n", caption )
	for ( i = 0 ; i < nitem ; i ++ ) {
		control( i + 1, ctrl[i], item[i] )
	}
}
function control( i, nm, arg,    tmp, arr ) {
	split( arg, arr, "," )
	if ( nm == "EDITTEXT" ) {
		return control_edit( i, arr )
	} else if ( nm == "LISTBOX" ) {
		return control_listbox( i, arr )
	} else if ( nm == "COMBOBOX" ) {
		return control_combo( i, arr )
	} else if ( nm == "PUSHBUTTON" ) {
		return control_button( i, arr )
	} else {
		printf( "%d=%s:%s.\n", i, ctrl[i], item[i] )
	}
}
function control_edit( i, arr ) {
	control_name( i, arr[1] )
	printf( "CreateWindowEx( WS_EX_CLIENTEDGE, TEXT(\"EDIT\")," )
	printf( " TEXT(\"\"),\n\t\t\t%s|WS_CHILD|WS_TABSTOP|WS_VISIBLE,\n",
			arr[6] )
	printf( "\t\t\t%d+x0, %d+y0, %d, %d,\n",
			arr[2]*mx/10, arr[3]*my/10, arr[4]*mx/10, arr[5]*my/10 )
	printf( "\t\t\thMainWnd, (HMENU)%s, hInst, NULL ) ;\n", arr[1] )
}
function control_listbox( i, arr ) {
	control_name( i, arr[1] )
	printf( "CreateWindowEx( WS_EX_CLIENTEDGE, TEXT(\"%s\"),",
			"LISTBOX" )
	printf( " TEXT(\"\"),\n\t\t\t%s|WS_CHILD|WS_VISIBLE|LBS_NOTIFY,\n",
			arr[6] )
	printf( "\t\t\t%d+x0, %d+y0, %d, %d,\n",
			arr[2]*mx/10, arr[3]*my/10, arr[4]*mx/10, arr[5]*my/10 )
	printf( "\t\t\thMainWnd, (HMENU)%s, hInst, NULL ) ;\n", arr[1] )
}
function control_combo( i, arr ) {
	control_name( i, arr[1] )
	printf( "CreateWindowEx( WS_EX_CLIENTEDGE, TEXT(\"%s\"),",
			"COMBOBOX" )
	printf( " TEXT(\"\"),\n\t\t\t%s|WS_CHILD|WS_VISIBLE,\n",
			arr[6] )
	printf( "\t\t\t%d+x0, %d+y0, %d, %d,\n",
			arr[2]*mx/10, arr[3]*my/10, arr[4]*mx/10, arr[5]*my/10 )
	printf( "\t\t\thMainWnd, (HMENU)%s, hInst, NULL ) ;\n", arr[1] )
}
function control_button( i, arr ) {
	control_name( i, arr[2] )
	printf( "CreateWindowEx( 0, TEXT(\"%s\"),",
			"BUTTON" )
	printf( " TEXT(%s),\n\t\t\tWS_CHILD|WS_VISIBLE,\n",
			arr[1] )
	printf( "\t\t\t%d+x0, %d+y0, %d, %d,\n",
			arr[3]*mx/10, arr[4]*my/10, arr[5]*mx/10, arr[6]*my/10 )
	printf( "\t\t\thMainWnd, (HMENU)%s, hInst, NULL ) ;\n", arr[2] )
}
function control_name( i, id ) {
	if ( id in vars ) {
		printf( "\t%s = ", vars[ id ] )
	} else {
		printf( "\thWnd%d = ", i )
	}
}
