#ifndef _POBOXKEY_H_
#define _POBOXKEY_H_

#define	MAXCANDKEYS		100		/* ̍ő */
#define MAXCANDLINES	3		/* j[\Ƃ̍ő\s */
#define	PHRASEFILE		TEXT("phrase")
#define	WORDFILE		TEXT("word")

#define DELSTR			"DEL"
#define ENTERSTR		"RET"
#define MODSTR			"MOD"
#define CANSTR			"CAN"
#define ALTSTR			"ALT"
#define JPNSTR			"JPN"
#define ENGSTR			"ENG"
#define SFTSTR			"SFT"
#define	CAPSTR			"CAP"
#define	NEXTSTR			"NXT"
#define	PREVSTR			"PRV"
#define	UPSTR			"UP"
#define	DOWNSTR			"DWN"
#define	LEFTSTR			"LFT"
#define	RIGHTSTR		"RGT"
#define	ZENSTR			"ZEN"
#define	HANSTR			"HAN"
#define	KATASTR			"KAT"
#define	TABSTR			"TAB"

typedef struct {
	int		x, y ;			/* \JnW */
	int		width ;			/* hbg */
	int		height ;		/* chbg */
	CHAR	str[ 64 ] ;
	CHAR	yomi[ 64 ] ;
} Key ;

typedef enum {
	JAPANESE,		/* ȃ[h */
	ENGLISH,		/* At@xbg[h */
} InputMode ;

typedef enum {
	NEWCAND, NEXTCAND, PREVCAND
} CandType ;

typedef struct {
	int		x, y ;		/* \JnW */
	int		width ;		/*  */
	int		height ;	/* s */
} CandPos ;

#ifdef	__cplusplus
extern "C" {
#endif

	Key		*inkey( Key *key, int x, int y ) ;
	int		readphrases( void ) ;
	int		writephrases( void ) ;
	LPCSTR	addphrase( LPCSTR p, LPCSTR c, LPCSTR y, BOOL fForce ) ;
	int		makecand( CandType candtype, BOOL fForce ) ;
	BOOL	check_abort( void ) ;
	int		strwidth( LPCSTR str ) ;

	extern	InputMode	inputmode ;		/* ̓[h */
	extern	TCHAR		g_szDictBase[] ;/* i[tH_ */
	extern	Key			candkey[] ;		/* L[ */
	extern	Key			g_KeyNormal[] ;		/* At@xbgL[ */
	extern	Key			g_KeyShift[] ;		/* ShiftL[ */
	extern	Key			g_KeyRoma[] ;		/* [}L[ */
	extern	Key			g_KeyHira[] ;	/* ȃL[ */
	extern	int			g_dwNumCand ;	/* \␔ */
	extern	DWORD		g_dwCandIndex ;

	extern	CandPos		g_CandPos ;
	extern	CHAR		hstr[128] ;		/* m蕶 */
	extern	CHAR		outstr[128] ;	/* m蕶 (\Ɏgp) */

#ifdef	__cplusplus
} ;
#endif

#endif
