#define	STRICT
#include	<windows.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	<commdlg.h>
#include	<tchar.h>
#include	"basewin.h"
#include	"resource.h"
#include	"dialog.h"

extern	DWORD	g_dwAppVersion ;
extern	DWORD	g_dwDllVersion ;

extern "C" {
	extern	TCHAR	g_szDictBase[ MAX_PATH ] ;
	extern	DWORD	g_dwPreWait ;
	extern	DWORD	g_dwPostWait ;
	extern	DWORD	g_dwSoftKey ;		/* 0:NONE, 1:HIRA, 2:ROMA */
	extern	BOOL	g_fLeftPos ;		/* ʒutO */
	extern	DWORD	g_fJis ;
	extern	BOOL	g_fSaveDic ;		/* wKtO */
	extern	BOOL	g_fPredict ;		/* \\tO */
	extern	HWND	g_hWndDialog ;
} ;

static	BOOL	DictOpenDlg( HINSTANCE hInst, HWND hWnd, LPTSTR buf, DWORD size ) ;

/*
 * ݒ_CAO
 */
class SetupDialog : public Window {
	HINSTANCE	m_hInst ;

public:
	SetupDialog( HINSTANCE hInst ) { m_hInst = hInst ; }
	~SetupDialog() {}

	BOOL	WMCreate( HWND hDlg ) ;
	LRESULT	WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp ) ;
} ;

BOOL
SetupDialog::WMCreate( HWND hDlg )
{
	TCHAR	buf[ 128 ] ;
	LPCTSTR	appName = TEXT("POBox") ;

	g_hWndDialog = hDlg ;
	/* o[Wݒ肷 */
	_tcscpy( buf, appName ) ;
	_tcscat( buf, TEXT(" setup") ) ;
	SetWindowText( hDlg, buf ) ;
	wsprintf( buf,
			  TEXT("%s for WinCE V%d.%02d\r\n")
			  TEXT("KCTRL Ver %d.%02d\r\n")
			  TEXT("Copyright %c 1998 %s")
			  TEXT("All Rights Reserved"),
			  appName, g_dwAppVersion / 100, g_dwAppVersion % 100,
			  g_dwDllVersion / 100, g_dwDllVersion % 100,
			  0xA9, TEXT("Eiichiroh Itoh") ) ;
	SetDlgItemText( hDlg, IDC_COPYRIGHT, buf ) ;
	/* ڂ̒lݒ肷 */
	SetDlgItemText( hDlg, IDC_PATH_DICT, g_szDictBase ) ;
	SetDlgItemInt( hDlg, IDC_PREWAIT, g_dwPreWait, 0 ) ;
	SetDlgItemInt( hDlg, IDC_POSTWAIT, g_dwPostWait, 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_ADDSTRING, (WPARAM) 0, (LPARAM) TEXT("None") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_ADDSTRING, (WPARAM) 0, (LPARAM) TEXT("Kana") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_ADDSTRING, (WPARAM) 0, (LPARAM) TEXT("Roma") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_ADDSTRING, (WPARAM) 0, (LPARAM) TEXT("1Line") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_SETCURSEL, (WPARAM) g_dwSoftKey, 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CHK_JIS,
						BM_SETCHECK, (WPARAM) (g_fJis ? 1 : 0), 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CHK_LEFT,
						BM_SETCHECK, (WPARAM) (g_fLeftPos ? 1 : 0), 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CHK_SAVE,
						BM_SETCHECK, (WPARAM) (g_fSaveDic ? 1 : 0), 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CHK_PREDICT,
						BM_SETCHECK, (WPARAM) (g_fPredict ? 1 : 0), 0 ) ;
	SetForegroundWindow( hDlg ) ;
	return FALSE ;
}

LRESULT
SetupDialog::WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp )
{
	BOOL	oldLeftPos ;
	TCHAR	buf[ MAX_PATH ], *ptr ;
	DWORD	attr, ret = 0, oldSoftKey ;

	if ( wp == IDCANCEL ) {
		EndDialog( hDlg, 0 ) ;
		return TRUE ;
	} else if ( wp == IDC_BTN_DICT ) {
		/* Browse{^ꂽꍇ */
		if ( DictOpenDlg( m_hInst, hDlg, buf, sizeof buf ) ) {
			ptr = _tcsrchr( buf, TEXT('\\') ) ;
			if ( ptr ) {
				*ptr = 0 ;
			} else {
				_tcscpy( buf, TEXT("\\") ) ;
			}
			SetDlgItemText( hDlg, IDC_PATH_DICT, buf ) ;
		}
		return TRUE ;
	} else if ( wp == IDC_UNINSTALL ) {
		if ( MessageBox( hDlg, TEXT("Uninstall this application?"), TEXT("Uninstall"), MB_YESNO ) == IDYES ) {
			EndDialog( hDlg, DIALOG_RET_UNINSTALL ) ;
		}
		return TRUE ;
	} else if ( wp != IDOK ) {
		return FALSE ;
	}
	/* OKꂽꍇ */
	/* t@C̃pX */
	GetDlgItemText( hDlg, IDC_PATH_DICT, buf, MAX_PATH ) ;
	attr = GetFileAttributes( buf ) ;
	if ( !*buf || (attr == 0xFFFFFFFF) || !(attr & FILE_ATTRIBUTE_DIRECTORY) ) {
		/* Ct@C݂ȂCfBNg̏ꍇ͖߂ */
		MessageBeep( MB_ICONHAND ) ;
		return TRUE ;
	}
	if ( _tcscmp( g_szDictBase, buf ) ) {
		/* ύXtO */
		ret |= DIALOG_RET_CHANGEDICT ;
		_tcscpy( g_szDictBase, buf ) ;
	}
	/* y[XgȎ҂b */
	g_dwPreWait = GetDlgItemInt( hDlg, IDC_PREWAIT, NULL, FALSE ) ;
	/* y[Xg̑҂b */
	g_dwPostWait = GetDlgItemInt( hDlg, IDC_POSTWAIT, NULL, FALSE ) ;
	/* \tgL[tO */
	oldSoftKey = g_dwSoftKey ;
	g_dwSoftKey = SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_GETCURSEL, 0, 0 ) ;
	if ( oldSoftKey != g_dwSoftKey ) {
		ret |= DIALOG_RET_CHANGEKEY ;
	}
	/* JISMtO */
	g_fJis = SendDlgItemMessage( hDlg, IDC_CHK_JIS, BM_GETCHECK, 0, 0 ) ? 1 : 0 ;
	/* ʒutO */
	oldLeftPos = g_fLeftPos ;
	g_fLeftPos = SendDlgItemMessage( hDlg, IDC_CHK_LEFT, BM_GETCHECK, 0, 0 ) ? 1 : 0 ;
	if ( oldLeftPos != g_fLeftPos ) {
		ret |= DIALOG_RET_CHANGEKEY ;
	}
	/* ۑtO */
	g_fSaveDic = SendDlgItemMessage( hDlg, IDC_CHK_SAVE, BM_GETCHECK, 0, 0 ) ? 1 : 0 ;
	/* \\tO */
	g_fPredict = SendDlgItemMessage( hDlg, IDC_CHK_PREDICT, BM_GETCHECK, 0, 0 ) ? 1 : 0 ;
	/* ύXtO */
	ret |= DIALOG_RET_CHANGE ;
	EndDialog( hDlg, ret ) ;
	return TRUE ;
}

BOOL
SetupDialogExec( HINSTANCE hInst, HWND hWnd )
{
	BOOL	ret ;
	SetupDialog		*pDialog = new SetupDialog( hInst ) ;

	ret = DialogBoxParam( hInst, MAKEINTRESOURCE(IDD_DLG_SETUP), hWnd, (DLGPROC) DlgProc, (LPARAM) pDialog ) ;
	delete pDialog ;
	g_hWndDialog = NULL ;
	return ret ;
}

static	OPENFILENAME	ofn ;
static	TCHAR			buf1[ MAX_PATH ] ;

static	BOOL
DictOpenDlg( HINSTANCE hInst, HWND hWnd, LPTSTR buf, DWORD size )
{
	memset( &ofn, 0, sizeof ofn ) ;
	memcpy( buf1, TEXT("*.*\0"), sizeof TEXT("*.*\0") ) ;
	ofn.lStructSize = sizeof ofn ;
    ofn.hwndOwner = hWnd ;
    ofn.hInstance = hInst ;
    ofn.lpstrFilter = TEXT("All Files (*.*)\0*.*\0\0") ;
    ofn.lpstrCustomFilter = NULL ;
    ofn.nMaxCustFilter = 0 ;
    ofn.nFilterIndex = 1 ;
    ofn.lpstrFile = buf1 ;
    ofn.nMaxFile = MAX_PATH ;
    ofn.lpstrFileTitle = NULL ;
    ofn.nMaxFileTitle = 0 ;
    ofn.lpstrInitialDir = NULL ;
    ofn.lpstrTitle = TEXT("Open Dictionary") ;
    ofn.Flags = 0 ;
    ofn.nFileOffset = 0 ;
    ofn.nFileExtension = 0 ;
    ofn.lpstrDefExt = TEXT("") ;
    ofn.lCustData = 0 ;
    ofn.lpfnHook = NULL ;
    ofn.lpTemplateName = NULL ;
	if ( !GetOpenFileName( &ofn ) ) {
		return FALSE ;
	}
	_tcscpy( buf, buf1 ) ;
	return TRUE ;
}
