#ifndef	APP_TOOLS1
#define	APP_TOOLS1

#include	"conslib.h"

#define	NUM_CEFILE		16
#define	CE_stdin		((CEFILE*) 1)
#define	CE_stdout		((CEFILE*) 2)
#define	CE_stderr		((CEFILE*) 3)
#define	CE_special		((CEFILE*) 3)
#define	CE_EOF			(-1)

#define	NO_CLIPBOARD
#define	NO_DIR
#define	NO_STDIO

typedef struct {
	HANDLE	m_hfile ;
	BOOL	m_bEof ;
	BOOL	m_bBinary ;
	BOOL	m_bError ;
	DWORD	m_dwRin ;
	DWORD	m_dwRout ;
	DWORD	m_dwWin ;
	BYTE	m_rBuf[ 256 ] ;
	BYTE	m_sBuf[ 256 ] ;
} CEFILE ;

#ifdef	__cplusplus
extern "C" {
#endif

CEFILE*	Fopen( LPCTSTR path, LPCTSTR modestr ) ;
void	Fclose( CEFILE *fp ) ;
int		Fgetc( CEFILE *fp ) ;
char*	Fgets( char *buf, int size, CEFILE *fp ) ;
int		Fputc( int c, CEFILE *fp ) ;
int		Fputs( const char *buf, CEFILE *fp ) ;
int		Fread( char *buf, int size, CEFILE *fp ) ;
void	Fwrite( const char *buf, int size, CEFILE *fp ) ;
void	Fflush( CEFILE *fp ) ;
BOOL	Ferror( CEFILE *fp ) ;
int		Fseek( CEFILE *fp, long offset, int whence ) ;
DWORD	Fsize( CEFILE *fp ) ;
int		Feof( CEFILE *fp ) ;

void	slash2backslash( LPTSTR str ) ;
void	catdir( LPTSTR body, LPCTSTR adddir, LPTSTR pPrevDir ) ;
void	rel2abs( LPTSTR newPath, LPCTSTR oldPath, LPCTSTR adddir ) ;
int		Sprintf( char *buf, const char *fmt, ... ) ;
int		SendClipboard( const char *sjis ) ;
int		ReceiveClipboard( char *sjis ) ;

#ifdef	__cplusplus
} ;
#endif

#endif	/* APP_TOOLS1 */
