/*
 * CCu݊[`
 * Copyright 1998-2000 (C) Eiichiroh Itoh
 *
 * 1997/11/06:Eiichiroh Itoh
 *  (1) 쐬Jn
 * C
 * 1998/04/03:Eiichiroh Itoh
 *  (1) IrCopyPOBoxpɕϊ
 * 1999/12/23:Eiichiroh Itoh
 *  (1) CEFILE\̂쐬
 *
 */
#define	STRICT
#include	<windows.h>
#include	<tchar.h>
//#include	"kctrl.h"
#include	"cetools.h"

/*--------------------------------------------------------------------
 * t@C֘A
 *--------------------------------------------------------------------*/
CEFILE	g_CEFILE[ NUM_CEFILE ] ;
BOOL	g_bInitCEFILE = FALSE ;

static	void
clear_CEFILE( CEFILE *fp )
{
	fp->m_hfile = INVALID_HANDLE_VALUE ;
	fp->m_bEof = FALSE ;
	fp->m_bBinary = FALSE ;
	fp->m_bError = FALSE ;
	fp->m_dwRin = 0 ;
	fp->m_dwRout = 0 ;
	fp->m_dwWin = 0 ;
	memset( fp->m_rBuf, 0, sizeof fp->m_rBuf ) ;
	memset( fp->m_sBuf, 0, sizeof fp->m_sBuf ) ;
}

static	void
init_CEFILE( void )
{
	int		i ;

	if ( g_bInitCEFILE ) {
		return ;
	}
	g_bInitCEFILE = TRUE ;
	for ( i = 0 ; i < NUM_CEFILE ; i ++ ) {
		clear_CEFILE( &g_CEFILE[ i ] ) ;
	}
}

CEFILE*
find_empty_CEFILE( void )
{
	int		i ;
	CEFILE	*fp ;

	init_CEFILE() ;
	for ( i = 0 ; i < NUM_CEFILE ; i ++ ) {
		fp = &g_CEFILE[ i ] ;
		if ( fp->m_hfile == INVALID_HANDLE_VALUE ) {
			clear_CEFILE( fp ) ;
			return fp ;
		}
	}
	return NULL ;
}

CEFILE*
Fopen( LPCTSTR path, LPCTSTR modestr )
{
	CEFILE	*fp ;
	BOOL	bTrunc = FALSE, bLast = FALSE ;
	DWORD	access = GENERIC_READ ;
	DWORD	mode = FILE_SHARE_READ ;
	DWORD	dist = OPEN_EXISTING ;

	fp = find_empty_CEFILE() ;
	if ( !fp ) {
		return NULL ;
	}
	fp->m_bBinary = FALSE ;
	fp->m_bError = FALSE ;
	if ( *modestr == TEXT('r') ) {
		access = GENERIC_READ ;
		dist = OPEN_EXISTING ;
		if ( modestr[1] == TEXT('+') ) {
			access = GENERIC_READ|GENERIC_WRITE ;
			dist = OPEN_ALWAYS ;
			if ( modestr[2] == TEXT('b') ) {
				fp->m_bBinary = TRUE ;
			}
		} else if ( modestr[1] == TEXT('b') ) {
			fp->m_bBinary = TRUE ;
		}
	} else if ( *modestr == TEXT('w') ) {
		access = GENERIC_WRITE ;
		dist = CREATE_ALWAYS ;
		bTrunc = TRUE ;
		if ( modestr[1] == TEXT('+') ) {
			access = GENERIC_READ|GENERIC_WRITE ;
			if ( modestr[2] == TEXT('b') ) {
				fp->m_bBinary = TRUE ;
			}
		} else if ( modestr[1] == TEXT('b') ) {
			fp->m_bBinary = TRUE ;
		}
	} else if ( *modestr == TEXT('a') ) {
		access = GENERIC_WRITE ;
		dist = CREATE_ALWAYS ;
		bLast = TRUE ;
		if ( modestr[1] == TEXT('+') ) {
			access = GENERIC_READ|GENERIC_WRITE ;
			if ( modestr[2] == TEXT('b') ) {
				fp->m_bBinary = TRUE ;
			}
		} else if ( modestr[1] == TEXT('b') ) {
			fp->m_bBinary = TRUE ;
		}
	} else {
		return FALSE ;
	}
	fp->m_hfile = CreateFile( path, access, mode, NULL,
							  dist, FILE_ATTRIBUTE_NORMAL, 0 ) ;
	if ( fp->m_hfile == INVALID_HANDLE_VALUE ) {
		return NULL ;
	}
	if ( bTrunc ) {
		SetEndOfFile( fp->m_hfile ) ;
	} else if ( bLast ) {
		SetFilePointer( fp->m_hfile, 0, NULL, FILE_END ) ;
	}
	fp->m_bEof = FALSE ;
	fp->m_dwRin = fp->m_dwRout = fp->m_dwWin = 0 ;
	return fp ;
}

void
Fclose( CEFILE *fp )
{
	if ( fp <= CE_special ) {
		return ;
	}
	if ( fp->m_hfile != INVALID_HANDLE_VALUE ) {
		Fflush( fp ) ;
		CloseHandle( fp->m_hfile ) ;
		fp->m_hfile = INVALID_HANDLE_VALUE ;
	}
}

int
Fgetc( CEFILE *fp )
{
	int		c ;
	BOOL	ret ;
	DWORD	nRead ;

	if ( fp <= CE_special ) {
		MessageBox( NULL, TEXT("fgetc"), TEXT("fgetc"), MB_OK ) ;
		c = Getch() ;
		return c == 0x1A ? CE_EOF : c ;
	}
	do {
		if ( fp->m_bEof ) {
			return CE_EOF ;
		}
		if ( fp->m_dwRin == fp->m_dwRout ) {
			fp->m_dwRin = fp->m_dwRout = 0 ;
			ret = ReadFile( fp->m_hfile, fp->m_rBuf, sizeof fp->m_rBuf, &nRead, NULL ) ;
			if ( !ret || !nRead ) {
				fp->m_bEof = TRUE ;
				return CE_EOF ;
			}
			fp->m_dwRin = nRead ;
			fp->m_dwRin %= sizeof fp->m_rBuf ;
		}
		c = (int) fp->m_rBuf[ fp->m_dwRout ] ;
		fp->m_dwRout ++ ;
		fp->m_dwRout %= sizeof fp->m_rBuf ;
	} while ( !fp->m_bBinary && c == '\r' ) ;
	return c ;
}

char *
Fgets( char *buf, int size, CEFILE *fp )
{
	int		c ;
	LPBYTE	ptr = buf ;

	size -- ;
	while ( (c = Fgetc( fp )) != CE_EOF ) {
		if ( !size ) {
			break ;
		}
		*ptr++ = c ;
		if ( c == '\n' ) {
			break ;
		}
	}
	*ptr = 0 ;
	return ptr == buf ? NULL : buf ;
}

static	int
Fputc_sub( int c, CEFILE *fp )
{
	DWORD	tmp, nWrite ;

	fp->m_sBuf[ fp->m_dwWin ] = c ;
	fp->m_dwWin ++ ;
	fp->m_dwWin %= sizeof fp->m_sBuf ;
	if ( !fp->m_dwWin || c == '\n' ) {
		tmp = fp->m_dwWin ? fp->m_dwWin : sizeof fp->m_sBuf ;
		fp->m_dwWin = 0 ;
		if ( !WriteFile( fp->m_hfile, fp->m_sBuf, tmp, &nWrite, NULL ) ) {
			fp->m_bError = TRUE ;
			return FALSE ;
		} else if ( nWrite == 0 ) {
			fp->m_bError = TRUE ;
			return FALSE ;
		}
	}
	return TRUE ;
}

int
Fputc( int c, CEFILE *fp )
{
	if ( fp <= CE_special ) {
		Putch( (TCHAR) c ) ;
		return c ;
	}
	if ( !fp->m_bBinary && c == '\n' ) {
		if ( !Fputc_sub( '\r', fp ) ) {
			return -1 ;
		}
	}
	return Fputc_sub( c, fp ) ? c : -1 ;
}

int
Fputs( const char *buf, CEFILE *fp )
{
	BYTE	c ;
	int		last = -1 ;

	if ( fp <= CE_special ) {
		TCHAR	szUnicode[ 256 ] ;
		mbstowcs( szUnicode, buf, 256 ) ;
		Cputs( szUnicode ) ;
		return 0 ;
	}
	while ( c = *buf++ ) {
		last = (int) c ;
		if ( Fputc( last, fp ) == -1 ) {
			return -1 ;
		}
	}
	return last ;
}

int
Fread( char *buf, int size, CEFILE *fp )
{
	int		c, nRead = 0 ;

	if ( !size ) {
		return nRead ;
	}
	do {
		c = Fgetc( fp ) ;
		if ( c == -1 ) {
			return nRead ;
		}
		*buf++ = c ;
		nRead ++ ;
	} while ( -- size ) ;
	return nRead ;
}

void
Fwrite( const char *buf, int size, CEFILE *fp )
{
	if ( !size ) {
		return ;
	}
	do {
		Fputc( *buf++, fp ) ;
	} while ( -- size ) ;
}

void
Fflush( CEFILE *fp )
{
	DWORD	nWrite ;

	if ( fp <= CE_special ) {
		return ;
	}
	if ( fp->m_dwWin ) {
		WriteFile( fp->m_hfile, fp->m_sBuf, fp->m_dwWin, &nWrite, NULL ) ;
		fp->m_dwWin = 0 ;
	}
}

BOOL
Ferror( CEFILE *fp )
{
	if ( fp <= CE_special ) {
		return FALSE ;
	}
	return fp->m_bError ;
}

int
Fseek( CEFILE *fp, long offset, int whence )
{
	DWORD   method ;

	if ( fp <= CE_special ) {
		return -1 ;
	}
	if ( whence == 1 ) {
		method = FILE_CURRENT ;
	} else if ( whence == 2 ) {
		method = FILE_END ;
	} else {
		method = FILE_BEGIN ;
	}
	fp->m_bEof = FALSE ;
	fp->m_dwRin = fp->m_dwRout = fp->m_dwWin = 0 ;
	return SetFilePointer( fp->m_hfile, offset, NULL, method ) ? 0 : -1 ;
}

DWORD
Fsize( CEFILE *fp )
{
	if ( fp <= CE_special ) {
		return 0 ;
	}
	return GetFileSize( fp->m_hfile, NULL ) ;
}

int
Feof( CEFILE *fp )
{
	if ( fp <= CE_special ) {
		return 0 ;
	}
	return fp->m_bEof ? CE_EOF : 0 ;
}

/*--------------------------------------------------------------------
 * fBNg֘A
 *--------------------------------------------------------------------*/
#ifndef	NO_DIR
void
slash2backslash( LPTSTR str )
{
	LPTSTR	ptr ;

	/* '/''\'ɕϊ */
	while ( ptr = _tcschr( str, TEXT('/') ) ) {
		*ptr = TEXT('\\') ;
	}
}

void
catdir( LPTSTR body, LPCTSTR adddir, LPTSTR pPrevDir )
{
	DWORD	len ;
	LPTSTR	ptr ;

	slash2backslash( body ) ;
	if ( pPrevDir ) {
		_tcscpy( pPrevDir, TEXT("..") ) ;
	}
	while ( *adddir ) {
		if ( _tcschr( TEXT("/\\"), *adddir ) ) {
			/* 擪"/""\"̏ꍇ͓ǂݔ΂ */
			adddir ++ ;
			continue ;
		}
		if ( adddir[0] == TEXT('.') && adddir[1] == TEXT('.') ) {
			ptr = _tcsrchr( body, TEXT('\\') ) ;
			if ( ptr && pPrevDir ) {
				_tcscpy( pPrevDir, ptr + 1 ) ;
			}
			if ( ptr && ptr != body ) {
				*ptr = 0 ;
			} else {
				_tcscpy( body, TEXT("\\") ) ;
			}
			adddir += 2 ;
		} else if ( adddir[0] == TEXT('.') ) {
			adddir ++ ;
		} else {
			break ;
		}
	}
	if ( !*adddir ) {
		return ;
	}
	len = _tcslen( body ) ;
	if ( !len || body[ len - 1 ] != TEXT('\\') ) {
		body[ len ++ ] = TEXT('\\') ;
	}
	_tcscpy( &body[ len ], adddir ) ;
	slash2backslash( body ) ;
}

void
rel2abs( LPTSTR newPath, LPCTSTR oldPath, LPCTSTR adddir )
{
	if ( _tcschr( TEXT("/\\"), *adddir ) ) {
		_tcscpy( newPath, adddir ) ;
		slash2backslash( newPath ) ;
	} else {
		_tcscpy( newPath, oldPath ) ;
		catdir( newPath, adddir, NULL ) ;
	}
}
#endif	/* NO_DIR */

int
sleep( int sec )
{
	Sleep( sec * 1000 ) ;
	return 0 ;
}

#ifndef	NO_STDIO
#undef		islower
#define		islower(c)		((c)>='a'&&(c)<='z')
#define		toupper(c)		(islower(c)?(c)-'a'+'A':(c))

int
stricmp( const char *src, const char *dst )
{
	char	c = 0, c1 ;

	while ( (c = *src++) ) {
		c = toupper( c ) ;
		c1 = *dst++ ;
		c1 = toupper( c1 ) ;
		if ( c != c1 ) {
			return c - c1 ;
		}
	}
	c = toupper( c ) ;
	c1 = *dst++ ;
	c1 = toupper( c1 ) ;
	return c - c1 ;
}

int
strnicmp( const char *src, const char *dst, int len )
{
	char	c = 0, c1 ;

	while ( len && (c = *src++) ) {
		c = toupper( c ) ;
		c1 = *dst++ ;
		c1 = toupper( c1 ) ;
		if ( c != c1 ) {
			return c - c1 ;
		}
		len -- ;
	}
	c = toupper( c ) ;
	c1 = *dst++ ;
	c1 = toupper( c1 ) ;
	return len ? c - c1 : 0 ;
}

int
bcmp( char *s1, char *s2, int len )
{
	return memcmp( s1, s2, len ) ;
}

int
bzero( char *s, int len )
{
	memset( s, 0, len ) ;
	return 0 ;
}

void
strcat_num( char *str, int num )
{
	CHAR	digits[ 10 ], *ptr = digits ;

	str += strlen( str ) ;
	if ( num < 0 ) {
		*str++ = '-' ;
		num = - num ;
	}
	if ( num ) {
		while ( num ) {
			*ptr++ = '0' + (CHAR) (num % 10) ;
			num /= 10 ;
		}
	} else {
		*ptr++ = '0' ;
	}
	while ( ptr -- != digits ) {
		*str++ = *ptr ;
	}
	*str = 0 ;
}

void
strcat_char( char *str, int c )
{
	str += strlen( str ) ;
	*str++ = (char) (c & 0xFF) ;
	*str = 0 ;
}
#endif	/* NO_STDIO */

#ifndef	NO_SPRINTF
static	char	SprintNumList[] = "0123456789abcdef" ;

static void
SprintfNum( char **buf, int i, int r )
{
	int		q ;

	if ( i < 0 ) {
		*(*buf) ++ = '-' ;
		i = -i ;
	}
	q = i / r ;
	if ( q ) {
		SprintfNum( buf, q, r ) ;
	}
	*(*buf) ++ = SprintNumList[ i % r ] ;
}

static int
SprintfSub( char *buf, const char *fmt, va_list *ap )
{
	int		c ;
	char	*orgbuf = buf ;

	while ( ( c = *fmt++ ) != '\0' ) {
		if ( c != '%') {
			*buf++ = c ;
		} else {
			c = *fmt++ ;
			switch ( c ) {
			case 'c':
				*buf++ = (char) (0xFF & va_arg( *ap, int )) ;
				break ;
			case 'l':
				c = *fmt++ ;
			case 'x':
				SprintfNum( &buf, va_arg( *ap, int ), 16 ) ;
				break ;
			case 'd':
				SprintfNum( &buf, va_arg( *ap, int ), 10 ) ;
				break ;
			case 'o':
				SprintfNum( &buf, va_arg( *ap, int ), 8 ) ;
				break ;
			case 's':
				strcpy( buf, va_arg( *ap, char * ) ) ;
				buf += strlen( buf ) ;
				break ;
			default:
				*buf++ = c ;
			}
		}
	}
	*buf = 0 ;
	return strlen( orgbuf ) ;
}

int
Sprintf( char *buf, const char *fmt, ... )
{
	int			ret ;
	va_list		pvar ;

	va_start( pvar, fmt ) ;
	ret = SprintfSub( buf, fmt, &pvar ) ;
	va_end( pvar ) ;
	return ret ;
}
#endif	/* NO_SPRINTF */

#ifndef	NO_CLIPBOARD
int
SendClipboard( const char *sjis )
{
	LPTSTR		ptr ;
	DWORD		size ;
#ifdef	_WIN32_WCE
	HLOCAL		hGMem ;
#else	/* _WIN32_WCE */
	HGLOBAL		hGMem ;
#endif	/* _WIN32_WCE */

	size = sjis2unicode( (LPBYTE) sjis, NULL, 0 ) ;
	if ( !size ) {
		return 1 ;
	}
	/* Nbv{[hI[v */
	if ( !OpenClipboard( 0 ) ) {
		return 0 ;
	} else if ( !EmptyClipboard() ) {
		CloseClipboard() ;
		return 0 ;
	}
	/* Kvȕmۂs */
#ifdef	_WIN32_WCE
	hGMem = LocalAlloc( LMEM_FIXED, size ) ;
	ptr = (LPTSTR) hGMem ;
#else	/* _WIN32_WCE */
	hGMem = GlobalAlloc( GMEM_MOVEABLE|GMEM_DDESHARE, size ) ;
	ptr = (LPTSTR) GlobalLock( hGMem ) ;
#endif	/* _WIN32_WCE */
	/* UNICODE->JISϊʂɏ */
	sjis2unicode( (LPBYTE) sjis, ptr, size ) ;
	/* Nbv{[hɌʂZbg */
	SetClipboardData( CF_UNICODETEXT, hGMem ) ;
#ifndef	_WIN32_WCE
	GlobalUnlock( hGMem ) ;
#endif	/* _WIN32_WCE */
	/* Nbv{[hN[Y */
	CloseClipboard() ;
	return 1 ;
}

int
ReceiveClipboard( char *sjis )
{
	LPCTSTR		cbptr ;
	int			cbsize, ret = 0 ;
#ifdef  _WIN32_WCE
	HLOCAL		hGMem ;
#else   /* _WIN32_WCE */
	HGLOBAL		hGMem ;
#endif  /* _WIN32_WCE */

	if ( !OpenClipboard( 0 ) ) {
		return 0 ;
	}
#ifdef  _WIN32_WCE
	hGMem = GetClipboardData( CF_UNICODETEXT ) ;
	cbsize = LocalSize( hGMem ) ;
	cbptr = (LPCTSTR) hGMem ;
#else   /* _WIN32_WCE */
	hGMem = GetClipboardData( CF_UNICODETEXT ) ;
	cbsize = GlobalSize( hGMem ) ;
	cbptr = (LPCTSTR) GlobalLock( hGMem ) ;
#endif  /* _WIN32_WCE */
	if ( !cbsize ) {
		goto exit ;
	}
	ret = unicode2sjis( cbptr, (LPBYTE) sjis, cbsize ) ;

exit:
#ifndef _WIN32_WCE
	GlobalUnlock( hGMem ) ;
#endif  /* _WIN32_WCE */
	CloseClipboard() ;
	return ret ;
}
#endif	/* NO_CLIPBOARD */
