#define	STRICT
#include	<windows.h>
#include	<tchar.h>
#include	"cefep.h"

#define		NO_CTRLSPACE

#define		GawaroBaseKey			TEXT("Software\\Gawaro")
#define		VAR_FEPNAME				TEXT("FepName")
#define		VAR_FEPPROGRAM			TEXT("FepProgram")
#define		VAR_USECTRL				TEXT("UseCtrl")

TCHAR		g_szFepName[ MAX_PATH ] = TEXT("KANJIIN") ;
TCHAR		g_szFepProgram[ MAX_PATH ] = TEXT("KanjiIn.exe") ;
BOOL		g_fKanji = FALSE ;
BOOL		g_fUseCtrl = FALSE ;
BOOL		g_fFepOption = FALSE ;

/*
 * FEP
 */
BOOL
InitFep( void )
{
	HKEY	hk ;
	LONG	lret ;
	LPCTSTR	name ;
	LPBYTE	lpData ;
	TCHAR	sValue[ 256 ] ;
	DWORD	dwType, cbData, dwValue ;

	/* WXgL[I[v */
	lret = RegOpenKeyEx( HKEY_CURRENT_USER, GawaroBaseKey, 0,
						 KEY_QUERY_VALUE, &hk ) ;
	if ( lret == ERROR_SUCCESS ) {
		/* FEP */
		name = VAR_FEPNAME ;
		dwType = REG_SZ ;
		lpData = (LPBYTE) sValue ;
		cbData = sizeof sValue ;
		if ( RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) == ERROR_SUCCESS ) {
			_tcscpy( g_szFepName, sValue ) ;
		}
		/* FEPvO */
		name = VAR_FEPPROGRAM ;
		dwType = REG_SZ ;
		lpData = (LPBYTE) sValue ;
		cbData = sizeof sValue ;
		if ( RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) == ERROR_SUCCESS ) {
			_tcscpy( g_szFepProgram, sValue ) ;
		}
		/* CTRL/ALT؂ւ */
		name = VAR_USECTRL ;
		dwType = REG_DWORD ;
		lpData = (LPBYTE) &dwValue ;
		cbData = sizeof dwValue ;
		if ( RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) == ERROR_SUCCESS ) {
			g_fUseCtrl = dwValue ;
		}
		/* WXgN[Y */
		RegCloseKey( hk ) ;
	}
	return TRUE ;
}

/*
 * FEPN
 */
void
Fep_Execute( HWND hWnd )
{
	HWND	hWndFep ;

	hWndFep = FindWindow( g_szFepName, NULL ) ;
	if ( hWndFep ) {
		/* FEPꍇ݂͌̋t̏Ԃɂ */
		g_fKanji = SendMessage( hWndFep, WM_COMMAND, IDM_FEPGETMODE, 0 ) ;
		SendMessage( hWndFep, WM_COMMAND, IDM_FEPSETMODE, g_fKanji ? 0 : 1 ) ;
#ifdef	_WIN32_WCE
	} else {
		/* FEPȂꍇ */
		PROCESS_INFORMATION	pi ;
		TCHAR				param[ 20 ] ;
		wsprintf( param, TEXT("%d"), hWnd ) ;
		g_fKanji = CreateProcess( g_szFepProgram, param,
						NULL, NULL, FALSE, 0, NULL, NULL, NULL, &pi ) ;
#endif	/* _WIN32_WCE */
	}
}

/*
 * WM_CHAȐs
 */
BOOL
Fep_WM_CHAR( HWND hWnd, TCHAR chCharCode, LONG lKeyData )
{
	HWND	hWndFep ;

#ifndef	NO_CTRLSPACE
	if ( chCharCode == TEXT(' ') ) {
		if ( g_fUseCtrl && (GetKeyState( VK_CONTROL) & 0x80) ) {
			/* CTRL+SPACEꂽꍇ */
			Fep_Execute( hWnd ) ;
			return TRUE ;
		}
		return FALSE ;
	}
#endif	/* NO_CTRLSPACE */
	if ( chCharCode < TEXT(' ') ) {
		return FALSE ;
	}
	hWndFep = FindWindow( g_szFepName, NULL ) ;
	if ( hWndFep ) {
		g_fKanji = SendMessage( hWndFep, WM_COMMAND, IDM_FEPGETMODE, 0 ) ? FALSE : TRUE ;
	} else {
		g_fKanji = FALSE ;
	}
	if ( g_fKanji && (chCharCode != TEXT(' ')) ) {
		SendMessage( hWndFep, WM_COMMAND, MAKEWPARAM( IDM_ACTIVATE_HWND, chCharCode ), (LPARAM) hWnd ) ;
		return TRUE ;
	}
	return FALSE ;
}

/*
 * WM_SYSCHAȐs
 */
BOOL
Fep_WM_SYSCHAR( HWND hWnd, TCHAR chCharCode, LONG lKeyData )
{
#ifndef	NO_CTRLSPACE
	if ( chCharCode == TEXT(' ') ) {
		if ( !g_fUseCtrl && (lKeyData & 0x20000000) ) {
			/* ALT+SPACEꂽꍇ */
			Fep_Execute( hWnd ) ;
			return TRUE ;
		}
	}
#endif	/* NO_CTRLSPACE */
	return FALSE ;
}

BOOL
Fep_WM_ACTIVATE( HWND hWnd, WORD fActive, BOOL fMinimize, HWND hWndDeactive )
{
	if ( g_fFepOption ) {
		if ( fActive == WA_ACTIVE || fActive == WA_CLICKACTIVE ) {
			HWND	hWndFep = FindWindow( g_szFepName, NULL ) ;
			if ( hWndFep ) {
				g_fKanji = SendMessage( hWndFep, WM_COMMAND, IDM_FEPGETMODE, 0 ) ? FALSE : TRUE ;
				if ( g_fKanji ) {
					SendMessage( hWndFep, WM_COMMAND, IDM_FEPSETMODE, 1 ) ;
				}
			}
		}
	}
	return FALSE ;
}
