/*
 * FtpSvr
 * Copyright(C) 1997-1999 Eiichiro Ito
*/
#define	STRICT
#include	<windows.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	<tchar.h>
#include	"resource.h"
#include	"appmain.h"
#include	"dialog.h"
#include	"ftpmain.h"

TCHAR	MessageBuf[ 512 ] ;
DWORD	PortNo = 21 ;

class MainWindow : public Window {
private:
	MainApp		*m_pApp ;			/* AvP[Vւ̃|C^ */
	HWND		m_hWnd ;
	HICON		m_hIcon ;			/* AvACR̃nh */
	BOOL		m_fLoadNotify ;		/* ^XNo[i[tO */
	BOOL		m_fSetup ;

public:
	MainWindow( MainApp *app ) ;

	BOOL	Create() ;

	void	WMCreate( HWND hWnd ) ;
	BOOL	AddTaskBarIcon() const ;
	BOOL	DeleteTaskBarIcon() const ;

	void	WMDestroy() ;
	LRESULT	WMCommand( HWND hWnd, UINT msg, WPARAM wp, LPARAM lp ) ;
	void	WMNotify( HWND hWnd, int idCtrl, LPNMHDR pnmh ) ;
	BOOL	WMClose() ;

	static	BOOL	RegisterClass( HINSTANCE hInst ) ;
	static	LPCTSTR	GetClassName() { return TEXT("FTPSVR") ; }
} ;

/*-------------------------------------------------------------------------*
 * MainApp
 *-------------------------------------------------------------------------*/
MainApp::MainApp()
{
}

MainApp::~MainApp()
{
}

BOOL
MainApp::Create( HINSTANCE hInstance )
{
	m_hInst = hInstance ;

	if ( !MainWindow::RegisterClass( m_hInst ) ) {
		return FALSE ;
	}

#ifdef	_WIN32_WCE
//	m_hAccl = LoadAccelerators( m_hInst,
//								MAKEINTRESOURCE(IDR_ACCELERATOR1) ) ;
#else	/* _WIN32_WCE */
//	m_hAccl = LoadAccelerators( GetModuleHandle(NULL),
//								MAKEINTRESOURCE(IDR_ACCELERATOR1) ) ;
#endif	/* _WIN32_WCE */

	m_pMainWnd = new MainWindow( this ) ;
	if ( !m_pMainWnd ) {
		return FALSE ;
	}
	if ( !m_pMainWnd->Create() ) {
		delete m_pMainWnd ;
		return FALSE ;
	}

//	HWND	hWnd = m_pMainWnd->get_hwnd() ;
//	if ( !get_reg() ) {
//		goto setup ;
//	}

	if ( !ftp_init() ) {
		PostMessage( m_pMainWnd->get_hwnd(), WM_CLOSE, 0, 0 ) ;
	} else if ( !ftp_start( PortNo ) ) {
		PostMessage( m_pMainWnd->get_hwnd(), WM_COMMAND, IDM_SETUP, 0 ) ;
	}

	return TRUE ;
}

int
MainApp::Run()
{
	MSG		msg ;

	while ( GetMessage( &msg, NULL, 0, 0 ) ) {
//		if ( !TranslateAccelerator( m_pMainWnd->get_hwnd(), m_hAccl, &msg ) ) {
			TranslateMessage( &msg ) ;
//		}
		DispatchMessage( &msg ) ;
	}
	ftp_stop( 0 ) ;
	ftp_release() ;
	return msg.wParam ;
}

/*-------------------------------------------------------------------------*
 * MainWindow
 *-------------------------------------------------------------------------*/
MainWindow::MainWindow( MainApp *pApp )
{
	m_pApp = pApp ;
	m_hIcon = 0 ;
	m_fSetup = FALSE ;
}

void
MainWindow::WMCreate( HWND hWnd )
{
	m_hWnd = hWnd ;
	/* ACR쐬^XNo[ɓo^ */
	m_hIcon = (HICON) LoadImage( m_pApp->get_inst(), MAKEINTRESOURCE(IDI_NOTIFYICON),
								 IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR ) ;
	if ( m_hIcon ) {
		SendMessage( hWnd, WM_SETICON, FALSE, (LPARAM) m_hIcon ) ;
	}
	/* ^XNo[ɓo^ */
	m_fLoadNotify = AddTaskBarIcon() ;
}

/*
 * ^XNo[ɒʒmACRo^
 */
BOOL
MainWindow::AddTaskBarIcon() const
{
	NOTIFYICONDATA	tnid ;
	HICON			hIcon ;

	/* ʒmGAp̃ACR쐬 */
	hIcon = (HICON) LoadImage( m_pApp->get_inst(), MAKEINTRESOURCE(IDI_NOTIFYICON),
							   IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR ) ;
	memset( &tnid, 0, sizeof tnid ) ;
	tnid.cbSize = sizeof (NOTIFYICONDATA) ;
	tnid.hWnd = m_hWnd ;
	tnid.uID = IDM_NOTIFY ;
	tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP ;
	tnid.uCallbackMessage = WM_COMMAND ;
	tnid.hIcon = hIcon ;
	_tcscpy( tnid.szTip, szTitleName ) ;
	return Shell_NotifyIcon( NIM_ADD, &tnid ) ;
}

/*
 * ʒmACR폜
 */
BOOL
MainWindow::DeleteTaskBarIcon() const
{
	NOTIFYICONDATA	tnid ;

	memset( &tnid, 0, sizeof tnid ) ;
	tnid.cbSize = sizeof (NOTIFYICONDATA) ;
	tnid.hWnd = m_hWnd ;
	tnid.uID = IDM_NOTIFY ;
	return Shell_NotifyIcon( NIM_DELETE, &tnid ) ;
}

void
MainWindow::WMDestroy()
{
	DeleteTaskBarIcon() ;
	if ( m_hIcon ) {
		::DeleteObject( m_hIcon ) ;
		m_hIcon = 0 ;
	}
	PostQuitMessage( 0 ) ;
}

LRESULT
MainWindow::WMCommand( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	DWORD	ret ;
	WORD	notifyCode = HIWORD(wParam), cmd = LOWORD(wParam) ;

	switch ( cmd ) {
	case IDOK:
	case IDM_EXIT:
		SendMessage( hWnd, WM_CLOSE, 0, 0 ) ;
		break ;
	case IDM_NOTIFY:
		if ( lParam == WM_LBUTTONDOWN ) {
			if ( GetAsyncKeyState( VK_MENU ) & 0x8000 ) {
				SendMessage( hWnd, WM_CLOSE, 0, 0 ) ;
			} else {
				PostMessage( hWnd, WM_COMMAND, IDM_SETUP, 0 ) ;
			}
		}
		break ;
#if 0
	case IDM_FEPLINE:
		SendMessage( hWnd, WM_COMMAND, IDM_FEPSETMODE, 0 ) ;
		if ( m_fFepLine ) {
			SendMessage( g_hWndFep, WM_COMMAND, IDM_CHAR, (TCHAR) lParam ) ;
			break ;
		}
		m_fFepLine = TRUE ;
//		if ( FepDialogExec( m_pApp->get_inst(), hWnd, (TCHAR) lParam ) ) {
		if ( FepDialogExec( m_pApp->get_inst(), NULL, (TCHAR) lParam ) ) {
			SendMessage( hWnd, WM_COMMAND, IDM_FEPSETMODE, 1 ) ;
		}
		m_fFepLine = FALSE ;
		break ;
	case IDM_ACTIVATE:
		point.x = GetSystemMetrics( SM_CXSCREEN ) / 2 ;
		point.y = GetSystemMetrics( SM_CYSCREEN ) / 2 ;
		hWndParent = WindowFromPoint( point ) ;
		hWndTmp = GetParent( hWndParent ) ;
		if ( hWndTmp ) {
			hWndParent = hWndTmp ;
		}
		FepSetParent( hWndParent ) ;
		PostMessage( hWnd, WM_COMMAND, IDM_FEPLINE, 0 ) ;
		break ;
	case IDM_ACTIVATE_HWND:
		hWndParent = (HWND) lParam ;
		FepSetParent( hWndParent ) ;
		if ( notifyCode ) {
			PostMessage( hWnd, WM_COMMAND, IDM_FEPLINE, (LPARAM) notifyCode ) ;
		} else {
			SendMessage( hWnd, WM_COMMAND, IDM_FEPSETMODE, 0 ) ;
		}
		break ;
	case IDM_FEPGETMODE:
		return g_dFepMode ;
		break ;
	case IDM_FEPSETMODE:
		ret = (DWORD) lParam ;
		if ( g_dFepMode != ret && ret < 2 ) {
			g_dFepMode = ret ;
			ModifyTaskBarIcon( g_dFepMode ) ;
		}
		break ;
#endif
	case IDM_SETUP:
		/* ZbgAbv */
		if ( m_fSetup ) {
			break ;
		}
		m_fSetup = TRUE ;
		SetForegroundWindow( hWnd ) ;
		ret = SetupDialogExec( m_pApp->get_inst(), hWnd ) ;
		m_fSetup = FALSE ;
		if ( ret & DIALOG_RET_EXIT ) {
			SendMessage( hWnd, WM_CLOSE, 0, 0 ) ;
			break ;
		} else if ( ret & DIALOG_RET_UNINSTALL ) {
//			delete_reg() ;
			SendMessage( hWnd, WM_CLOSE, 0, 0 ) ;
			break ;
		}
		if ( ret ) {
//			set_reg() ;
		}
		break ;
	}
	return 0 ;
}

void
MainWindow::WMNotify( HWND hWnd, int idCtrl, LPNMHDR pnmh )
{
}

BOOL
MainWindow::WMClose()
{
	return FALSE ;
}

BOOL
MainWindow::Create()
{
	HWND	hWnd = CreateWindowEx( 0,
						GetClassName(),
						szTitleName,
						WS_BORDER,
						0, 0, 10, 10,
						NULL,
						NULL,
						m_pApp->get_inst(),
						this ) ;
	if ( hWnd == 0 ) {
		return FALSE ;
	}
	ShowWindow( hWnd, SW_HIDE ) ;
    UpdateWindow( hWnd ) ;
    return TRUE ;
}

BOOL
MainWindow::RegisterClass( HINSTANCE hInst )
{
	WNDCLASS	wc ;

	wc.style         = NULL ;
	wc.lpfnWndProc   = (WNDPROC) WndProc ;
	wc.cbClsExtra    = 0 ;
	wc.cbWndExtra    = 4 ;
	wc.hInstance     = hInst ;
	wc.hIcon         = NULL ;
	wc.hCursor       = NULL ;
	wc.hbrBackground = (HBRUSH) GetStockObject( WHITE_BRUSH ) ;
	wc.lpszMenuName  = 0 ;
	wc.lpszClassName = 	GetClassName() ;
	return ::RegisterClass( &wc ) ;
}
