#define	STRICT
#include	<windows.h>
#include	<commctrl.h>
#include	<tchar.h>
#include	"kctrl.h"
#include	"appmain.h"

DWORD	AppVersion = 20 ;
DWORD	DllVersion = 0 ;

extern "C" {
	void	init_compat( void ) ;
	void	release_compat( void ) ;
} ;

int WINAPI
#ifdef	_WIN32_WCE
WinMain( HINSTANCE hThisInst, HINSTANCE hPrevInst,
		 LPTSTR lpszArgs, int nWinMode )
#else	/* _WIN32_WCE */
WinMain( HINSTANCE hThisInst, HINSTANCE hPrevInst,
		 LPSTR lpszArgs, int nWinMode )
#endif	/* _WIN32_WCE */
{
#ifdef	_WIN32_WCE
	if ( !_tcsnicmp( lpszArgs, APP_RUN_TO_HANDLE_NOTIFICATION, _tcslen( APP_RUN_TO_HANDLE_NOTIFICATION ) ) ) {
		/* A[N̏ */
		if ( DiaApp::HandleAlarm() ) {
			return TRUE ;
		}
	}
	InitCommonControls() ;
#endif	/* _WIN32_WCE */
	/* KCTRL.DLL̏s */
	if ( !InitKanjiControls() ) {
		wsprintf( MessageBuf, TEXT("KCTRL.DLL Initialize error\r\nError=%x"),
				  GetLastError() ) ;
		MessageBeep( MB_ICONEXCLAMATION ) ;
		MessageBox( NULL, MessageBuf, TEXT("KCTRL Error"), MB_OK ) ;
		return -1 ;
	}
	DllVersion = GetKVersion() ;
	init_compat() ;

	BOOL		exitVal = FALSE ;
	DiaApp		*pApp = new DiaApp() ;
	if ( !pApp ) {
		goto exit ;
	}
	if ( pApp->Create( hThisInst ) ) {
		exitVal = pApp->Run() ;
	}
	delete pApp ;

exit:
	release_compat() ;
	ReleaseKanjiControls() ;
	return exitVal ;
}
