#include	"list.h"

#define		HOUR_NOW		0xFF
#define		HOUR_ALL		0xFE

#define		FORMAT_NONE		(0)
#define		FORMAT_DIA		(1)
#define		FORMAT_NEXT		(2)

class HourInfo ;
class MinInfo ;
class TimeTableInfo ;

/*
 * e
 */
class DetailInfo : public Link {
private:
	char		m_cMark ;
	LPSTR		m_pText ;

public:
	DetailInfo( char mark ) ;
	~DetailInfo() ;

	BOOL	is_mark( char mark ) const { return m_cMark == mark ; }
	LPCSTR	get_text() const { return m_pText ; }
	void	set( LPCSTR text ) ;

	static void	append( List *pList, char mark, LPCSTR text ) ;
	static DetailInfo	*find( List *pList, char mark ) ;

	void		print() const ;
} ;

/*
 * ԏ
 */
class HourInfo : public Link {
private:
	TimeTableInfo	*m_pParent ;	/* \ւ̃|C^ */
	List			m_oMin ;
	BYTE			m_bHour ;

public:
	HourInfo( TimeTableInfo *table, BYTE hour ) ;

	int			cmp( BYTE hour ) const ;
	void		append( MinInfo *pMin ) ;
	static HourInfo	*append( List *pList, TimeTableInfo *pTable, BYTE hour ) ;

	List		*get_min() { return &m_oMin ; }
	List		*get_detail() ;
	BYTE		get_hour() const { return m_bHour ; }
	void		pickup( List *pList, DWORD mask, BYTE start_min ) ;

	void		print() ;
} ;

/*
 * 
 */
class MinInfo : public Link {
private:
	HourInfo	*m_pParent ;	/* ԏւ̃|C^ */
	BYTE		m_bMinute ;		/*  */
	char		m_cDetail ;		/* e */
	char		m_cExtra ;		/* ǉ */
	DWORD		m_dDayMask ;	/* t̃}XN */

public:
	MinInfo( HourInfo *parent, BYTE min, DWORD mask ) ;
	MinInfo( MinInfo *base ) ;
	void		set_detail( char mark ) { m_cDetail = mark ; }
	void		set_extra( char mark ) { m_cExtra = mark ; }
	void		set_mask( DWORD mask ) { m_dDayMask = mask ; }
	BYTE		get_min() const { return m_bMinute ; }
	DWORD		get_mask() const { return m_dDayMask ; }
	HourInfo	*get_parent() const { return m_pParent ; }
	BYTE		get_hour() const { return m_pParent->get_hour() ; }

	int			cmp( MinInfo *min ) const ;
	void		make_str_normal( char *buf ) const ;
	void		make_str_on_now( char *ptr, WORD now ) const ;
	void		make_str_on_alarm( char *ptr ) const ;
	void		make_str_for_message( char *ptr ) const ;

	static void	append( List *pList, MinInfo *pMin ) ;

	void		print() const ;
} ;

/*
 * \
 */
class TimeTableInfo {
private:
	CHAR		m_sTitle[ 128 ] ;
	List		m_oHour ;			/* ԏ */
	List		m_oDetail ;			/* e */
	BYTE		m_bMaxHour ;		/* ő̎Ԓl */
	char		m_cMark[ 32 ] ;		/* }[Nz */
	DWORD		m_dMask[ 32 ] ;		/* t}XNz(NextTrainp) */
	int			m_dNumMask ;		/* t}XŇ(NextTrainp) */
	DWORD		m_dCurMask ;		/* ݗLȓt}XN(NextTrainp) */
	DWORD		m_dDefMask ;		/* ftHg̓t}XN(NextTrainp) */
	BYTE		m_bLastHour ;		/* t@Cǂݍݒ̍ŏI */
	DWORD		m_dFormat ;			/* t@Cǂݍݒ̌` */
	char		m_cLast ;			/* t@Cǂݍݒ̍ŏIL(DiaTrainp) */
	char		m_cCur ;			/* t@Cǂݍݒ̌݋L(DiaTrainp) */

public:
	TimeTableInfo() ;
	List		*get_detail() { return &m_oDetail ; }
	DWORD		parse_day_nextfmt( LPSTR ptr ) const ;
	DWORD		except_previous_mask( DWORD event ) const ;
	int			add_mask( char c, DWORD newmask ) ;
	BOOL		check_format( LPSTR line ) ;
	BOOL		read_diatrain( LPSTR line ) ;
	void		adjust_diatrain() ;
	BOOL		read_nextfmt( LPSTR line ) ;
	void		adjust_nextfmt() ;
	BOOL		read( LPCTSTR fn ) ;
	BYTE		get_hour( BYTE hour ) const ;
	BYTE		get_maxhour() const { return m_bMaxHour ; }
	int			pickup( List *list, WORD base, BYTE hour ) ;
	int			delete_until_now( List *list, WORD base ) ;
} ;

/*
 * t@CXg
 */
class FileTableInfo : public Link {
private:
	TCHAR		m_sPath[ MAX_PATH ] ;
	char		m_sText[ 128 ] ;

public:
	FileTableInfo( LPCTSTR path, LPCSTR text ) ;
	LPCTSTR		get_path() const { return m_sPath ; }
	LPSTR		get_detail() { return m_sText ; }

	static	List	FileList ;
	static	BOOL	read_nextfmt( LPCTSTR fn ) ;
	static	int		list_proc( int index, const BYTE **ptr, int *len ) ;
	static	LPCTSTR	get_path( int index ) ;
	static	LPCSTR	get_detail( int index ) ;
} ;
