#define	STRICT
#include	<windows.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	<commdlg.h>
#include	<tchar.h>
#include	"kctrl.h"
#include	"controls.h"
#include	"basewin.h"
#include	"fileopen.h"
#include	"resource.h"

#ifdef	_WIN32_WCE
#include	<notify.h>
#endif	/* _WIN32_WCE */

extern	DWORD	AppVersion ;
extern	DWORD	DllVersion ;

extern	WORD	get_now() ;

/*-------------------------------------------------------------------------*
 * t@CI[v_CAO
 *-------------------------------------------------------------------------*/
static	OPENFILENAME	ofn ;
static	TCHAR			buf1[ MAX_PATH + 1 ] ;

BOOL
FileOpenDlg( HINSTANCE hInst, HWND hWnd, LPTSTR buf, DWORD size )
{
	memset( &ofn, 0, sizeof ofn ) ;
	memcpy( buf1, TEXT("*.dia\0"), sizeof TEXT("*.dia\0") ) ;
	ofn.lStructSize = sizeof ofn ;
	ofn.hwndOwner = hWnd ;
	ofn.hInstance = hInst ;
	ofn.lpstrFilter = TEXT("Dia Files (*.dia)\0*.dia\0\0") ;
	ofn.lpstrCustomFilter = NULL ;
	ofn.nMaxCustFilter = 0 ;
	ofn.nFilterIndex = 1 ;
	ofn.lpstrFile = buf1 ;
	ofn.nMaxFile = MAX_PATH + 1 ;
	ofn.lpstrFileTitle = NULL ;
	ofn.nMaxFileTitle = 0 ;
	ofn.lpstrInitialDir = NULL ;
	ofn.lpstrTitle = NULL ;
	ofn.Flags = 0 ;
	ofn.nFileOffset = 0 ;
	ofn.nFileExtension = 0 ;
	ofn.lpstrDefExt = TEXT("DIA") ;
	ofn.lCustData = 0 ;
	ofn.lpfnHook = NULL ;
	ofn.lpTemplateName = NULL ;
	if ( !GetOpenFileName2( &ofn, NULL ) ) {
		return FALSE ;
	}
	_tcscpy( buf, buf1 ) ;
	return TRUE ;
}

/*-------------------------------------------------------------------------*
 * EXEt@CI[v_CAO
 *-------------------------------------------------------------------------*/
BOOL
ExeFileOpenDlg( HINSTANCE hInst, HWND hWnd, LPTSTR buf, DWORD size )
{
	memset( &ofn, 0, sizeof ofn ) ;
	memcpy( buf1, TEXT("*.exe\0"), sizeof TEXT("*.exe\0") ) ;
	ofn.lStructSize = sizeof ofn ;
	ofn.hwndOwner = hWnd ;
	ofn.hInstance = hInst ;
	ofn.lpstrFilter = TEXT("Exe Files (*.exe)\0*.exe\0\0") ;
	ofn.lpstrCustomFilter = NULL ;
	ofn.nMaxCustFilter = 0 ;
	ofn.nFilterIndex = 1 ;
	ofn.lpstrFile = buf1 ;
	ofn.nMaxFile = MAX_PATH + 1 ;
	ofn.lpstrFileTitle = NULL ;
	ofn.nMaxFileTitle = 0 ;
	ofn.lpstrInitialDir = NULL ;
	ofn.lpstrTitle = NULL ;
	ofn.Flags = 0 ;
	ofn.nFileOffset = 0 ;
	ofn.nFileExtension = 0 ;
	ofn.lpstrDefExt = TEXT("EXE") ;
	ofn.lCustData = 0 ;
	ofn.lpfnHook = NULL ;
	ofn.lpTemplateName = NULL ;
	if ( !GetOpenFileName2( &ofn, NULL ) ) {
		return FALSE ;
	}
	_tcscpy( buf, buf1 ) ;
	return TRUE ;
}

/*-------------------------------------------------------------------------*
 * About_CAO
 *-------------------------------------------------------------------------*/
class AboutDialog : public Window {
	BOOL	m_fDelete ;

public:
	AboutDialog() { m_fDelete = FALSE ; }
	~AboutDialog() {}

	void	WMCreate( HWND hDlg ) ;
	LRESULT	WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp ) ;

	BOOL	get_delete() const { return m_fDelete ; }
} ;

void
AboutDialog::WMCreate( HWND hDlg )
{
	TCHAR	buf[ 128 ] ;

	wsprintf( buf, TEXT("DiaTrain for WinCE V%d.%02d"),
			  AppVersion / 100, AppVersion % 100 ) ;
	SetDlgItemText( hDlg, IDC_VERSION, buf ) ;
	wsprintf( buf, TEXT("KCTRL Ver %d.%02d"),
			  DllVersion / 100, DllVersion % 100 ) ;
	SetDlgItemText( hDlg, IDC_DLLVERSION, buf ) ;
	wsprintf( buf, TEXT("Copyright %c 1997-1998\r\n%s\r\n%s"),
			  0xA9,
			  TEXT("Eiichiro Ito"),
			  TEXT("All Rights Reserved") ) ;
	SetDlgItemText( hDlg, IDC_COPYRIGHT, buf ) ;
}

LRESULT
AboutDialog::WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp )
{
	if ( wp == IDCANCEL || wp == IDOK ) {
		EndDialog( hDlg, TRUE ) ;
	} else if ( wp == IDC_UNINSTALL ) {
		if ( MessageBox( hDlg, TEXT("Delete registry information for DiaTrain?"), TEXT("UNINSTALL"), MB_YESNO ) == IDYES ) {
			m_fDelete = TRUE ;
			EndDialog( hDlg, TRUE ) ;
		}
	}
	return 0 ;
}

BOOL
AboutDialogExec( HINSTANCE hInst, HWND hWnd, LPBOOL fDelete )
{
	AboutDialog		*pDialog = new AboutDialog() ;

	*fDelete = FALSE ;
	if ( !DialogBoxParam( hInst, MAKEINTRESOURCE(IDD_DLG_ABOUT), hWnd, (DLGPROC) DlgProc, (LPARAM) pDialog ) ) {
		delete pDialog ;
		return FALSE ;
	}
	*fDelete = pDialog->get_delete() ;
	delete pDialog ;
	return TRUE ;
}

#ifdef	_WIN32_WCE
/*-------------------------------------------------------------------------*
 * Alarm_CAO
 *-------------------------------------------------------------------------*/
class AlarmDialog : public Window {
	HINSTANCE	m_hInst ;
	WORD		m_wMinute ;
	HWND		m_hWndMsg1 ;
	HWND		m_hWndMsg2 ;
	LPCSTR		m_szArrival ;
	PEG_USER_NOTIFICATION	*m_pPUN ;

public:
	AlarmDialog( HINSTANCE hInst, WORD minute, PEG_USER_NOTIFICATION *pun, LPCSTR szArrival ) {
		m_hInst = hInst ;
		m_wMinute = minute ;
		m_pPUN = pun ;
		m_szArrival = szArrival ;
	}
	~AlarmDialog() {}

	void	WMCreate( HWND hDlg ) ;
	LRESULT	WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp ) ;

	BOOL	get_minute() const { return m_wMinute ; }
} ;

void
AlarmDialog::WMCreate( HWND hDlg )
{
	RECT			rect ;
	BOOL			flag ;
	HWND			hWnd ;
	WIN32_FIND_DATA	find ;
	HANDLE			hFind ;
	DWORD			index, size ;
	WORD			now = get_now() ;
	TCHAR			buf[ 128 ], *ptr ;
	DWORD			ch = GetFontH() + 2, y = 2 ;

	GetClientRect( hDlg, &rect ) ;
	/* Ԏ쐬 */
	ptr = buf ;
	size = sizeof buf ;
	if ( (m_wMinute % (24 * 60)) <= now ) {
		sjis2unicode( (LPBYTE) "", ptr, size ) ;
		index = _tcslen( ptr ) ;
		ptr += index ;
		size -= index * sizeof (TCHAR) ;
	}
	wsprintf( ptr, TEXT("%02d:%02d"), m_wMinute / 60, m_wMinute % 60 ) ;
	index = _tcslen( ptr ) ;
	ptr += index ;
	size -= index * sizeof (TCHAR) ;
	sjis2unicode( (LPBYTE) "", ptr, size ) ;
	m_hWndMsg1 = CreateWindowEx( 0,
					CTRL_LABEL,
					buf,
					WS_CHILD|WS_VISIBLE,
					2, y, rect.right - 4, ch,
					hDlg,
					(HMENU) IDC_MESSAGE1,
					m_hInst,
					0 ) ;
	y += ch + 2 ;
	/* s敶쐬 */
	ptr = buf ;
	size = sizeof buf ;
	sjis2unicode( (LPBYTE) m_szArrival, ptr, size ) ;
	index = _tcslen( ptr ) ;
	ptr += index ;
	size -= index * sizeof (TCHAR) ;
	sjis2unicode( (LPBYTE) "s", ptr, size ) ;
	m_hWndMsg2 = CreateWindowEx( 0,
					CTRL_LABEL,
					buf,
					WS_CHILD|WS_VISIBLE,
					2, y, rect.right - 4, ch,
					hDlg,
					(HMENU) IDC_MESSAGE1,
					m_hInst,
					0 ) ;
	y += ch + 2 ;
	/* A[ݒ莞p̃R{{bNX */
	SendDlgItemMessage( hDlg, IDC_CMB_MIN, CB_ADDSTRING, 0, (LPARAM) TEXT("1") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_MIN, CB_ADDSTRING, 0, (LPARAM) TEXT("5") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_MIN, CB_ADDSTRING, 0, (LPARAM) TEXT("10") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_MIN, CB_ADDSTRING, 0, (LPARAM) TEXT("15") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_MIN, CB_ADDSTRING, 0, (LPARAM) TEXT("30") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_MIN, CB_ADDSTRING, 0, (LPARAM) TEXT("60") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_MIN, CB_ADDSTRING, 0, (LPARAM) TEXT("90") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_MIN, CB_ADDSTRING, 0, (LPARAM) TEXT("120") ) ;
	/* Xg{bNXWAVt@CXgAbv */
	hWnd = GetDlgItem( hDlg, IDC_LST_SOUND ) ;
	hFind = FindFirstFile( TEXT("\\Windows\\*.WAV"), &find ) ;
	if ( hFind == INVALID_HANDLE_VALUE ) {
		return ;
	}
	do {
		if ( find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {
			continue ;
		}
		/* Xg{bNXɍڂǉ */
		SendMessage( hWnd, LB_ADDSTRING, 0, (LPARAM) find.cFileName ) ;
	} while ( FindNextFile( hFind, &find ) ) ;
	FindClose( hFind ) ;
	/* Xg{bNX̃J[\ݒ肷 */
	index = SendMessage( hWnd, LB_FINDSTRINGEXACT, (WPARAM)-1, (LPARAM) m_pPUN->pwszSound ) ;
	index = index == LB_ERR ? 0 : index ;
	SendMessage( hWnd, LB_SETCURSEL, (WPARAM) index, 0 ) ;
	/* TEh`FbN{bNX̐ݒ */
	flag = m_pPUN->ActionFlags & PUN_SOUND ;
	SendDlgItemMessage( hDlg, IDC_CHK_SOUND, BM_SETCHECK, (WPARAM) (flag ? 1 : 0), 0 ) ;
	/* LED`FbN{bNX̐ݒ */
	flag = m_pPUN->ActionFlags & PUN_LED ;
	SendDlgItemMessage( hDlg, IDC_CHK_LED, BM_SETCHECK, (WPARAM) (flag ? 1 : 0), 0 ) ;
}

LRESULT
AlarmDialog::WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp )
{
	BOOL		flag ;
	HWND		hWnd ;
	DWORD		index ;
	TCHAR		buf[ 30 ] ;
	WORD		now = get_now(), time ;

	if ( wp == IDCANCEL ) {
		EndDialog( hDlg, FALSE ) ;
	} else if ( wp == IDOK ) {
		*buf = 0 ;
		GetDlgItemText( hDlg, IDC_CMB_MIN, buf, 10 ) ;
		if ( !*buf ) {
			MessageBeep( MB_OK ) ;
			return TRUE ;
		}
		time = GetDlgItemInt( hDlg, IDC_CMB_MIN, NULL, TRUE ) ;
		if ( time >= 600 || (now <= m_wMinute && now + time >= m_wMinute) ) {
			MessageBeep( MB_OK ) ;
			return TRUE ;
		}
		m_wMinute -= time ;
		/* TEhtO̐ݒ */
		flag = SendDlgItemMessage( hDlg, IDC_CHK_SOUND, BM_GETCHECK, 0, 0 ) ;
		m_pPUN->ActionFlags &= ~PUN_SOUND ;
		m_pPUN->ActionFlags |= flag ? PUN_SOUND : 0 ;
		/* LEDtO̐ݒ */
		flag = SendDlgItemMessage( hDlg, IDC_CHK_LED, BM_GETCHECK, 0, 0 ) ;
		m_pPUN->ActionFlags &= ~PUN_LED ;
		m_pPUN->ActionFlags |= flag ? PUN_LED : 0 ;
		/* TEht@C̐ݒ */
		hWnd = GetDlgItem( hDlg, IDC_LST_SOUND ) ;
		index = SendMessage( hWnd, LB_GETCURSEL, 0, 0 ) ;
		index = index == LB_ERR ? 0 : index ;
		SendMessage( hWnd, LB_GETTEXT, (WPARAM) index, (LPARAM) m_pPUN->pwszSound ) ;
		EndDialog( hDlg, TRUE ) ;
	}
	return 0 ;
}

BOOL
AlarmDialogExec( HINSTANCE hInst, HWND hWnd, LPWORD pMinute, PEG_USER_NOTIFICATION *pPUN, LPCSTR pArrival )
{
	AlarmDialog		*pDialog = new AlarmDialog( hInst, *pMinute, pPUN, pArrival ) ;

	if ( !DialogBoxParam( hInst, MAKEINTRESOURCE(IDD_DLG_ALARM), hWnd, (DLGPROC) DlgProc, (LPARAM) pDialog ) ) {
		delete pDialog ;
		return FALSE ;
	}
	*pMinute = pDialog->get_minute() ;
	delete pDialog ;
	return TRUE ;
}
#endif	/* _WIN32_WCE */

/*-------------------------------------------------------------------------*
 * Setup_CAO
 *-------------------------------------------------------------------------*/
class SetupDialog : public Window {
	HINSTANCE	m_hInst ;
	DWORD		m_dInterval ;
	TCHAR		m_sPath[ MAX_PATH ] ;

public:
	SetupDialog( HINSTANCE hInst, LPCTSTR path, DWORD val ) {
		m_hInst = hInst ;
		_tcscpy( m_sPath, path ) ;
		m_dInterval = val ;
	}
	~SetupDialog() {}

	void	WMCreate( HWND hDlg ) ;
	LRESULT	WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp ) ;

	LPCTSTR	get_path() const { return m_sPath ; }
	DWORD	get_interval() const { return m_dInterval ; }
} ;

void
SetupDialog::WMCreate( HWND hDlg )
{
	SetDlgItemText( hDlg, IDC_EDT_EDITOR, m_sPath ) ;
	SetDlgItemInt( hDlg, IDC_EDT_TIMER, m_dInterval, FALSE ) ;
}

LRESULT
SetupDialog::WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp )
{
	DWORD	tmp ;

	if ( wp == IDCANCEL ) {
		EndDialog( hDlg, FALSE ) ;
	} else if ( wp == IDOK ) {
		tmp = GetDlgItemInt( hDlg, IDC_EDT_TIMER, NULL, TRUE ) ;
		if ( !tmp ) {
			return 0 ;
		}
		m_dInterval = tmp ;
		GetDlgItemText( hDlg, IDC_EDT_EDITOR, m_sPath, sizeof m_sPath / sizeof (TCHAR) ) ;
		EndDialog( hDlg, TRUE ) ;
	} else if ( wp == IDC_BTN_EDITOR ) {
		TCHAR	buf[ MAX_PATH ] ;

		if ( ExeFileOpenDlg( m_hInst, hDlg, buf, sizeof buf ) ) {
			SetDlgItemText( hDlg, IDC_EDT_EDITOR, buf ) ;
		}
	}
	return 0 ;
}

BOOL
SetupDialogExec( HINSTANCE hInst, HWND hWnd, LPTSTR path, LPDWORD interval )
{
	SetupDialog		*pDialog = new SetupDialog( hInst, path, *interval ) ;

	if ( !DialogBoxParam( hInst, MAKEINTRESOURCE(IDD_DLG_SETUP), hWnd, (DLGPROC) DlgProc, (LPARAM) pDialog ) ) {
		delete pDialog ;
		return FALSE ;
	}
	_tcscpy( path, pDialog->get_path() ) ;
	*interval = pDialog->get_interval() ;
	delete pDialog ;
	return TRUE ;
}
