#ifndef	UNICODE
#define	UNICODE
#endif	/* UNICODE */
#ifndef	_UNICODE
#define	_UNICODE
#endif	/* _UNICODE */
#include	<windows.h>
#include	<math.h>

#define		EOF		(-1)

typedef struct {
	BOOL	f_inuse ;
	BOOL	f_eof ;
	BOOL	f_binary ;
	HANDLE	hFile ;
	BYTE	rbuf[ 256 ] ;
	DWORD	r_in, r_out ;
	BYTE	wbuf[ 256 ] ;
	DWORD	w_in ;
} FILE ;

#ifdef	__cplusplus
extern "C" {
#endif
void	init_compat( void ) ;
void	release_compat( void ) ;

#ifdef	_WIN32_WCE
int		isalpha( int c ) ;
int		isdigit( int c ) ;
int		strcmpi( const char *dst, const char *src ) ;
#endif	/* _WIN32_WCE */

void *	memset( void *dst, int c, unsigned int len ) ;
void *	memcpy( void *dst, const void *src, unsigned int len ) ;
size_t	strlen( const char *str ) ;
char *	strcpy( char *dst, const char *src ) ;
char *	strncpy( char *dst, const char *src, unsigned int len ) ;
char *	strcat( char *dst, const char *src ) ;
char *	strncat( char *dst, const char *src, unsigned int len ) ;
int	strcmp( const char *dst, const char *src ) ;
char *	strchr( const char *dst, int find_c ) ;
char *	strrchr( const char *dst, int find_c ) ;
char *	strpbrk( const char *dst, const char *src ) ;
char *	strstr( const char *dst, const char *src ) ;
long	atol( const char *str ) ;
double	atof( const char *str ) ;
void *	malloc( unsigned int size ) ;
void	free( void *buf ) ;
void	my_exit( int code ) ;
int		kbhit( void ) ;
void	exception( unsigned long code ) ;
int		system( const char *str ) ;

FILE	*fopenW( LPCTSTR fn, LPCTSTR mode ) ;
FILE	*fopen( const char *fn, const char *mode ) ;
int		fclose( FILE *fp ) ;
int		fexistW( LPCTSTR path ) ;
int		fexist( const char *path ) ;
int		fexist_dirW( LPCTSTR path ) ;
int		fexist_dir( const char *path ) ;
int		fexist_fileW( LPCTSTR path ) ;
int		fexist_file( const char *path ) ;
int		fgetc( FILE *fp ) ;
int		fputc( int c, FILE *fp ) ;
int		ungetc( int c, FILE *fp ) ;
char*	fgets( char *buf, int size, FILE *fp ) ;
int		fputs( char *buf, FILE *fp ) ;
int		feof( FILE *fp ) ;
int		fseek( FILE *fp, long offset, int whence ) ;

extern	FILE	Files[] ;

typedef	char *	va_list;
#ifndef	_INTSIZEOF
#define	_INTSIZEOF(n)	((sizeof(n)+sizeof(int)-1) & ~(sizeof(int)-1))
#endif	/* _INTSIZEOF */
#ifndef	va_start
#define	va_start(ap,v)	( ap = (va_list)&v + _INTSIZEOF(v) )
#define	va_arg(ap,t)	( *(t *)((ap += _INTSIZEOF(t)) - _INTSIZEOF(t)) )
#define	va_end(ap)		( ap = (va_list)0 )
#endif	/* va_start */

int		sprintf( char *buf, ... ) ;
int		fprintf( FILE *fp, ... ) ;
int		printf( char *fmt, ... ) ;
int		vfprintf( FILE *, const char *, va_list ) ;

void	sprintf_int( char *buf, char *fmt, int value ) ;
void	sprintf_double( char *buf, char *fmt, double value ) ;
void	sprintf_str( char *buf, char *fmt, const char *str ) ;
void	fprintf_int( FILE *fp, char *fmt, int value ) ;
void	fprintf_double( FILE *fp, char *fmt, double value ) ;
void	fprintf_str( FILE *fp, char *fmt, const char *str ) ;

#define		exit(c)		my_exit(c)

void	pause( char *msg ) ;
#ifdef	__cplusplus
} ;
#endif
