#ifdef	_WIN32_WCE
#include	<notify.h>
#endif	/* _WIN32_WCE */

#define		szTitleName		TEXT("DiaTrain")
#define		AppName			TEXT("DiaTrain.exe")

class MainWindow ;
class ListArea ;
class HeaderArea ;
class DateArea ;

class List ;
class TimeTableInfo ;
class MinInfo ;

class DiaApp {
private:
	HINSTANCE	m_hInst ;
	HACCEL		m_hAccl ;
	MainWindow	*m_pMainWnd ;			/* C */
	ListArea	*m_pListArea ;			/* ꗗ\̈ */
	HeaderArea	*m_pHeaderArea ;		/* wb_[\̈ */
	DateArea	*m_pDateArea ;			/* t\̈ */
	TCHAR		m_path[ MAX_PATH ] ;	/* f[^t@CpX */
	BOOL		m_fNeedData ;			/* f[^ǂݍ݂Kvȏꍇ*^* */
	TimeTableInfo	*m_pTtable ;		/* \IuWFNg */
	BOOL		m_fTitle ;				/* ^Cg\̏ꍇ */
	DWORD		m_dTitleIndex ;			/* ^Cg\ł̈ʒu */
#ifdef	_WIN32_WCE
	PEG_USER_NOTIFICATION	m_Notify ;	/* A[p\ */
	TCHAR		m_sWave[ MAX_PATH ] ;	/* A[Ŗ炷WAVt@C */
#endif	/* _WIN32_WCE */
	TCHAR		m_sEditor[ MAX_PATH ] ;	/* Editor̃pX */
	DWORD		m_dInterval ;			/* ^C}[̊Ԋu */

public:
	DiaApp() ;
	~DiaApp() ;

	BOOL		Create( HINSTANCE hInst ) ;
	int			Run() ;

	HINSTANCE	get_inst() const {
		return m_hInst ;
	}
	ListArea	*get_list() { return m_pListArea ; }
	HeaderArea	*get_header() { return m_pHeaderArea ; }
	DateArea	*get_date() { return m_pDateArea ; }
	LPCTSTR		get_path() const { return m_path ; }
	BOOL		is_title() const { return m_fTitle ; }

	BOOL		OpenTableFile( HWND hWnd, BOOL fReread, LPBOOL pfQuit ) ;
	BOOL		LoadFromNextTrain( LPCTSTR fn ) ;
	void		SetupList() const ;
	BOOL		Refresh() ;
	BOOL		Home() ;
	BOOL		Prev() ;
	BOOL		Next() ;
	BOOL		EnterContent() ;
	BOOL		EnterTitle() ;
	BOOL		SetAlarm() ;
	static BOOL	HandleAlarm() ;
	BOOL		Setup( HWND hWnd ) ;
	BOOL		ExecuteEditor( BOOL fTable ) ;
	void		SetTimer( HWND hWnd, BOOL fKill, BOOL fSet ) const ;

	BOOL		GetReg() ;
	BOOL		SetReg() const ;
	void		DeleteReg() const ;

	static	int		list_proc( int index, const BYTE **ptr, int *len ) ;
	static	MinInfo	*GetMinInfo( int index ) ;
	static	BYTE	CurHour ;
	static	List	CurList ;
	static	WORD	CurBase ;
} ;

extern "C" {
	extern	TCHAR	MessageBuf[ 512 ] ;
} ;
