#include "rpc.h"
#include "rpcndr.h"

#ifndef __sip_h__
#define __sip_h__

#ifdef __cplusplus
extern "C"{
#endif 

#ifndef __IIMCallback_FWD_DEFINED__
#define __IIMCallback_FWD_DEFINED__
typedef interface IIMCallback IIMCallback;
#endif 	/* __IIMCallback_FWD_DEFINED__ */


#ifndef __IInputMethod_FWD_DEFINED__
#define __IInputMethod_FWD_DEFINED__
typedef interface IInputMethod IInputMethod;
#endif 	/* __IInputMethod_FWD_DEFINED__ */


#ifndef __CPOBoxIm_FWD_DEFINED__
#define __CPOBoxIm_FWD_DEFINED__

#ifdef __cplusplus
typedef class CPOBoxIm CPOBoxIm;
#else
typedef struct CPOBoxIm CPOBoxIm;
#endif /* __cplusplus */

#endif 	/* __CPOBoxIm_FWD_DEFINED__ */


void __RPC_FAR * __RPC_USER MIDL_user_allocate(size_t);
void __RPC_USER MIDL_user_free( void __RPC_FAR * ); 


#ifndef __POBOXIM_LIBRARY_DEFINED__
#define __POBOXIM_LIBRARY_DEFINED__

typedef struct  _tagImInfo
    {
    DWORD cbSize;
    HANDLE hImageNarrow;
    HANDLE hImageWide;
    int iNarrow;
    int iWide;
    DWORD fdwFlags;
    RECT rcSipRect;
    }	IMINFO;


EXTERN_C const IID LIBID_POBOXIM;

#ifndef __IIMCallback_INTERFACE_DEFINED__
#define __IIMCallback_INTERFACE_DEFINED__

EXTERN_C const IID IID_IIMCallback;

interface DECLSPEC_UUID("42429669-ae04-11d0-a4f8-00aa00a749b9")
IIMCallback : public IUnknown {
public:
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE SetImInfo( 
		IMINFO __RPC_FAR *pimi) = 0;

	virtual /* [id] */ HRESULT STDMETHODCALLTYPE SendVirtualKey( 
		BYTE bVK,
		DWORD dwFlags) = 0;

	virtual /* [id] */ HRESULT STDMETHODCALLTYPE SendCharEvents( 
		UINT uVK,
		UINT uKeyFlags,
		UINT uChars,
		UINT __RPC_FAR *puShift,
		UINT __RPC_FAR *puChars) = 0;

	virtual /* [id] */ HRESULT STDMETHODCALLTYPE SendString( 
		BSTR ptszStr,
		DWORD dwChars) = 0;
} ;

/* [id] */ HRESULT STDMETHODCALLTYPE IIMCallback_SetImInfo_Proxy( 
    IIMCallback __RPC_FAR * This,
    IMINFO __RPC_FAR *pimi);

void __RPC_STUB IIMCallback_SetImInfo_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);

/* [id] */ HRESULT STDMETHODCALLTYPE IIMCallback_SendVirtualKey_Proxy( 
    IIMCallback __RPC_FAR * This,
    BYTE bVK,
    DWORD dwFlags);

void __RPC_STUB IIMCallback_SendVirtualKey_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);

/* [id] */ HRESULT STDMETHODCALLTYPE IIMCallback_SendCharEvents_Proxy( 
    IIMCallback __RPC_FAR * This,
    UINT uVK,
    UINT uKeyFlags,
    UINT uChars,
    UINT __RPC_FAR *puShift,
    UINT __RPC_FAR *puChars);

void __RPC_STUB IIMCallback_SendCharEvents_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);

/* [id] */ HRESULT STDMETHODCALLTYPE IIMCallback_SendString_Proxy( 
    IIMCallback __RPC_FAR * This,
    BSTR ptszStr,
    DWORD dwChars);

void __RPC_STUB IIMCallback_SendString_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);

#endif 	/* __IIMCallback_INTERFACE_DEFINED__ */

#ifndef __IInputMethod_INTERFACE_DEFINED__
#define __IInputMethod_INTERFACE_DEFINED__

EXTERN_C const IID IID_IInputMethod;

interface DECLSPEC_UUID("42429666-ae04-11d0-a4f8-00aa00a749b9")
IInputMethod : public IUnknown {
public:
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE Select( /* [in] */ HWND hwndSip ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE Deselect( void ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE Showing( void ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE Hiding( void ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE GetInfo( /* [out] */ IMINFO __RPC_FAR *pimi ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE ReceiveSipInfo( /* [in] */ SIPINFO __RPC_FAR *psi ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE RegisterCallback( /* [in] */ IIMCallback __RPC_FAR *lpIMCallback ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE GetImData( /* [in] */ DWORD dwSize, /* [out] */ LPVOID pvImData ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE SetImData( /* [in] */ DWORD dwSize, /* [in] */ LPVOID pvImData ) = 0;
	virtual /* [id] */ HRESULT STDMETHODCALLTYPE UserOptionsDlg( /* [in] */ HWND hwndParent ) = 0;
} ;

/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_Select_Proxy( 
    IInputMethod __RPC_FAR * This,
    /* [in] */ HWND hwndSip);


void __RPC_STUB IInputMethod_Select_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_Deselect_Proxy( 
    IInputMethod __RPC_FAR * This);


void __RPC_STUB IInputMethod_Deselect_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_Showing_Proxy( 
    IInputMethod __RPC_FAR * This);


void __RPC_STUB IInputMethod_Showing_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_Hiding_Proxy( 
    IInputMethod __RPC_FAR * This);


void __RPC_STUB IInputMethod_Hiding_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_GetInfo_Proxy( 
    IInputMethod __RPC_FAR * This,
    /* [out] */ IMINFO __RPC_FAR *pimi);


void __RPC_STUB IInputMethod_GetInfo_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_ReceiveSipInfo_Proxy( 
    IInputMethod __RPC_FAR * This,
    /* [in] */ SIPINFO __RPC_FAR *psi);


void __RPC_STUB IInputMethod_ReceiveSipInfo_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_RegisterCallback_Proxy( 
    IInputMethod __RPC_FAR * This,
    /* [in] */ IIMCallback __RPC_FAR *lpIMCallback);


void __RPC_STUB IInputMethod_RegisterCallback_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_GetImData_Proxy( 
    IInputMethod __RPC_FAR * This,
    /* [in] */ DWORD dwSize,
    /* [out] */ LPVOID pvImData);


void __RPC_STUB IInputMethod_GetImData_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_SetImData_Proxy( 
    IInputMethod __RPC_FAR * This,
    /* [in] */ DWORD dwSize,
    /* [in] */ LPVOID pvImData);


void __RPC_STUB IInputMethod_SetImData_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


/* [id] */ HRESULT STDMETHODCALLTYPE IInputMethod_UserOptionsDlg_Proxy( 
    IInputMethod __RPC_FAR * This,
    /* [in] */ HWND hwndParent);


void __RPC_STUB IInputMethod_UserOptionsDlg_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);



#endif 	/* __IInputMethod_INTERFACE_DEFINED__ */


EXTERN_C const CLSID CLSID_CPOBoxIm;

class DECLSPEC_UUID("FE872260-0596-11d2-94D1-006097A8699E")
CPOBoxIm : IInputMethod {
public:
	virtual HRESULT STDMETHODCALLTYPE QueryInterface( const IID& iid, void **ppv ) ;
	virtual ULONG STDMETHODCALLTYPE AddRef() ;
	virtual ULONG STDMETHODCALLTYPE Release() ;

    virtual /* [id] */ HRESULT STDMETHODCALLTYPE Select( /* [in] */ HWND hwndSip ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE Deselect( void ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE Showing( void ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE Hiding( void ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE GetInfo( /* [out] */ IMINFO __RPC_FAR *pimi ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE ReceiveSipInfo( /* [in] */ SIPINFO __RPC_FAR *psi ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE RegisterCallback( /* [in] */ IIMCallback __RPC_FAR *lpIMCallback ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE GetImData( /* [in] */ DWORD dwSize, /* [out] */ LPVOID pvImData ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE SetImData( /* [in] */ DWORD dwSize, /* [in] */ LPVOID pvImData ) ;
    virtual /* [id] */ HRESULT STDMETHODCALLTYPE UserOptionsDlg( /* [in] */ HWND hwndParent ) ;

public:
	CPOBoxIm() ;
	~CPOBoxIm() ;

private:
	HWND		m_hwndCtrl ;
	HIMAGELIST	m_imlNarrow ;
	HIMAGELIST	m_imlWide ;
	IIMCallback	*m_pimCallback ;
	LONG		m_cRef ;
	BOOL		m_bInit ;
} ;

#endif /* __POBOXIM_LIBRARY_DEFINED__ */

/* Additional Prototypes for ALL interfaces */

/* end of Additional Prototypes */

#ifdef __cplusplus
}
#endif

#endif
