#define	STRICT
#include	<windows.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	<commdlg.h>
#include	<tchar.h>
#include	"basewin.h"
#include	"resource.h"
#include	"dialog.h"

#ifdef	__cplusplus
extern "C" {
#endif
	extern	DWORD	g_dwAppVersion ;
	extern	TCHAR	MessageBuf[ 512 ] ;
	extern	TCHAR	g_szDictBase[ MAX_PATH ] ;
	extern	DWORD	g_dwSoftKey ;			/* 0:NONE, 1:HIRA, 2:ROMA, 3:1LINE */
	extern	BOOL	g_fSaveDic ;			/* ۑtO */
	extern	BOOL	g_fPredict ;			/* \\tO */
	extern	DWORD	g_dwSelColor ;
#ifdef	__cplusplus
} ;
#endif

/*
 * ݒ_CAO
 */
class SetupDialog : public Window {
	HINSTANCE	m_hInst ;

public:
	SetupDialog( HINSTANCE hInst ) { m_hInst = hInst ; }
	~SetupDialog() {}

	BOOL	WMCreate( HWND hDlg ) ;
	LRESULT	WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp ) ;
} ;

BOOL
SetupDialog::WMCreate( HWND hDlg )
{
	TCHAR	buf[ 128 ] ;
	LPCTSTR	appName = TEXT("POBox") ;
	int		mode2index[] = { 1, 0, 1, 1 } ;

	/* o[Wݒ肷 */
	wsprintf( buf, TEXT("GAWARO %s Options"), appName ) ;
	SetWindowText( hDlg, buf ) ;
	wsprintf( buf,
			  TEXT("%s for WinCE V%d.%02d\r\n")
			  TEXT("Copyright %c 1998 %s\r\n")
			  TEXT("All Rights Reserved"),
			  appName, g_dwAppVersion / 100, g_dwAppVersion % 100,
			  0xA9, TEXT("Eiichiro Ito") ) ;
	SetDlgItemText( hDlg, IDC_COPYRIGHT, buf ) ;
	/* ڂ̒lݒ肷 */
	SetDlgItemText( hDlg, IDC_PATH_DICT, g_szDictBase ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_ADDSTRING, (WPARAM) 0, (LPARAM) TEXT("Kana") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_ADDSTRING, (WPARAM) 0, (LPARAM) TEXT("Roma") ) ;
	SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_SETCURSEL, (WPARAM) mode2index[g_dwSoftKey], 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CHK_SAVE,
						BM_SETCHECK, (WPARAM) (g_fSaveDic ? 1 : 0), 0 ) ;
	SendDlgItemMessage( hDlg, IDC_CHK_PREDICT,
						BM_SETCHECK, (WPARAM) (g_fPredict ? 1 : 0), 0 ) ;
	SetForegroundWindow( hDlg ) ;
	return FALSE ;
}

LRESULT
SetupDialog::WMCommand( HWND hDlg, UINT msg, WPARAM wp, LPARAM lp )
{
	TCHAR	buf[ MAX_PATH ] ;
	int		index2mode[] = { 1, 2 } ;
	DWORD	attr, ret = 0, oldSoftKey ;

	if ( wp == IDCANCEL ) {
		EndDialog( hDlg, 0 ) ;
		return TRUE ;
	} else if ( wp != IDOK ) {
		return FALSE ;
	}
	/* OKꂽꍇ */
	/* t@C̃pX */
	GetDlgItemText( hDlg, IDC_PATH_DICT, buf, MAX_PATH ) ;
	attr = GetFileAttributes( buf ) ;
	if ( !*buf || (attr == 0xFFFFFFFF) || !(attr & FILE_ATTRIBUTE_DIRECTORY) ) {
		/* Ct@C݂ȂCfBNg̏ꍇ͖߂ */
		MessageBeep( MB_ICONHAND ) ;
		return TRUE ;
	}
	if ( _tcscmp( g_szDictBase, buf ) ) {
		/* ύXtO */
		ret |= DIALOG_RET_CHANGEDICT ;
		_tcscpy( g_szDictBase, buf ) ;
	}
	/* \tgL[tO */
	oldSoftKey = g_dwSoftKey ;
	g_dwSoftKey = index2mode[ SendDlgItemMessage( hDlg, IDC_CMB_POS, CB_GETCURSEL, 0, 0 ) ] ;
	if ( oldSoftKey != g_dwSoftKey ) {
		ret |= DIALOG_RET_CHANGEKEY ;
	}
	/* ۑtO */
	g_fSaveDic = SendDlgItemMessage( hDlg, IDC_CHK_SAVE, BM_GETCHECK, 0, 0 ) ? 1 : 0 ;
	/* \\tO */
	g_fPredict = SendDlgItemMessage( hDlg, IDC_CHK_PREDICT, BM_GETCHECK, 0, 0 ) ? 1 : 0 ;
	/* ύXtO */
	ret |= DIALOG_RET_CHANGE ;
	EndDialog( hDlg, ret ) ;
	return TRUE ;
}

BOOL
SetupDialogExec( HINSTANCE hInst, HWND hWnd )
{
	BOOL			ret ;
	SetupDialog		*pDialog = new SetupDialog( hInst ) ;

	ret = DialogBoxParam( hInst, MAKEINTRESOURCE(IDD_DLG_SETUP), hWnd, (DLGPROC) DlgProc, (LPARAM) pDialog ) ;
	delete pDialog ;
	return ret ;
}
