/*++

Copyright (c) 1997 Microsoft Corporation

Module Name:

    aygshell.h

Abstract:

    Shell defines.

Author:

    Michael G. Toepke (mtoepke) 12-Jun-1997

--*/

#ifndef __AYGSHELL_H__
#define __AYGSHELL_H__


#ifdef __cplusplus
extern "C" {
#endif


//
// flags in the fdwFlags field of SIPINFO.
//
typedef enum tagSipFlags {
    SIPF_ON                 = 0x01,
    SIPF_DOCKED             = 0x02,
    SIPF_LOCKED             = 0x04,
    SIPF_DISABLECOMPLETION  = 0x08
} SIPFLAGS;


//
// The SIPINFO structure.
//
typedef struct _tagSipInfo {
    DWORD  cbSize;
    DWORD  fdwFlags;
    RECT   rcVisibleDesktop;
    RECT   rcSipRect;    
    DWORD  dwImDataSize;
    LPVOID pvImData;
} SIPINFO;


//
// Supported system parameters.
//
#ifndef SPI_SETSIPINFO
#define SPI_SETSIPINFO          224
#endif
#define SPI_GETSIPINFO          225
#define SPI_SETCURRENTIM        226
#define SPI_GETCURRENTIM        227
#define SPI_SETCOMPLETIONINFO   223
#define SPI_APPBUTTONCHANGE     228

//Gryphon special controls
#define WC_CAPEDIT    L"CAPEDIT"
#define WC_TSTATIC    L"TTSTATIC"
#define WC_TBUTTON    L"TTBUTTON"

#define CEM_UPCASEALLWORDS    (WM_USER + 1)

//
// SHSipInfo function.
//
WINSHELLAPI
BOOL
SHSipInfo(
    UINT uiAction,
    UINT uiParam,
    PVOID pvParam,
    UINT fWinIni );


BYTE SHGetAppKeyAssoc( LPCTSTR ptszApp );
BOOL SHSetAppKeyWndAssoc( BYTE bVk, HWND hwnd );
BOOL SHInitExtraControls(void);


#ifdef __cplusplus
}
#endif


#endif // __AYGSHELL_H__
