/*
 * C compatible standard library
 * Copyright 1998-2000 (C) Eiichiroh Itoh
 *
 * 1997/11/06:Eiichiroh Itoh
 *  (1) Initial development
 * Modification
 * 1998/04/03:Eiichiroh Itoh
 *  (1) modify for POBox
 * 1999/12/23:Eiichiroh Itoh
 *  (1) add CEFILE structure and modify related function
 * 2000/01/05:Eiichiroh Itoh
 *  (1) add fprintf function
 * 2000/02/26:Eiichiroh Itoh
 *  (1) fix bug about nBufSize in Fgetc
 *
 */
#define	STRICT
#include	<windows.h>
#include	<tchar.h>
#include	"cetools.h"

/*--------------------------------------------------------------------
 * {ϊ֘A
 *--------------------------------------------------------------------*/
static	BOOL		g_bInitCodeConv = FALSE ;
static	BOOL		g_bUseBuiltin = FALSE ;
static	BOOL		g_bUseKctrl = FALSE ;
static	HINSTANCE	g_hlib = 0 ;
#ifdef	_WIN32_WCE
#define	CP_ACP		0
typedef	WINBASEAPI int(*WCTMB)(UINT,DWORD,LPCWSTR,int,LPSTR ,int,LPCSTR,LPBOOL) ;
typedef	WINBASEAPI int(*MBTWC)(UINT,DWORD,LPCSTR ,int,LPWSTR,int) ;
int (*g_WideCharToMultiByte)( UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, int cchWideChar, LPSTR lpMultiByteStr, int cchMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUserDefaultChar ) ;
int (*g_MultiByteToWideChar)( UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr, int cchMultiByte, LPWSTR lpWideCharStr, int cchWideChar ) ;
#else	/* _WIN32_WCE */
#define	g_WideCharToMultiByte	WideCharToMultiByte
#define	g_MultiByteToWideChar	MultiByteToWideChar
#endif	/* _WIN32_WCE */
typedef	DWORD(*KMBTWC)(const BYTE *,LPTSTR,DWORD) ;
typedef	DWORD(*KWCTMB)(LPCTSTR,BYTE *,DWORD) ;
typedef	BOOL(*KINIT)(void) ;
DWORD	(*g_sjis2unicode)( const BYTE *src, LPTSTR dst, DWORD max ) ;
DWORD	(*g_unicode2sjis)( LPCTSTR src, BYTE *dst, DWORD max ) ;
BOOL	(*g_InitKanjiControls)( void ) ;

#ifdef	_WIN32_WCE
#define		TT(x)		TEXT(x)
#else	/* _WIN32_WCE */
#define		TT(x)		(x)
#endif	/* _WIN32_WCE */

#ifdef	UNICODE
#undef	mbstowcs
#undef	wcstombs

BOOL
init_CodeConv( void )
{
	if ( g_bInitCodeConv ) {
		return TRUE ;
	}
	g_bInitCodeConv = TRUE ;
	/* VXe񋟂̊֐̗L𒲂ׂ */
	g_bUseBuiltin = FALSE ;
#ifdef	_WIN32_WCE
	if ( GetUserDefaultLangID() == LANG_JAPANESE ) {
		g_hlib = LoadLibrary( TEXT("COREDLL.DLL") ) ;
		if ( g_hlib ) {
			g_MultiByteToWideChar = (MBTWC) GetProcAddress( g_hlib, TT("MultiByteToWideChar") ) ;
			g_WideCharToMultiByte = (WCTMB) GetProcAddress( g_hlib, TT("WideCharToMultiByte") ) ;
			if ( g_MultiByteToWideChar && g_WideCharToMultiByte ) {
				g_bUseBuiltin = TRUE ;
				return TRUE ;
			}
			FreeLibrary( g_hlib ) ;
			g_hlib = 0 ;
		}
	}
#else	/* _WIN32_WCE */
	g_bUseBuiltin = TRUE ;
	return TRUE ;
#endif	/* _WIN32_WCE */
	/* KCTRL̗L𒲂ׂ */
	g_bUseKctrl = FALSE ;
	g_hlib = LoadLibrary( TEXT("KCTRL.DLL") ) ;
	if ( g_hlib ) {
		g_InitKanjiControls = (KINIT) GetProcAddress( g_hlib, TT("InitKanjiControls") ) ;
		g_sjis2unicode = (KMBTWC) GetProcAddress( g_hlib, TT("sjis2unicode") ) ;
		g_unicode2sjis = (KWCTMB) GetProcAddress( g_hlib, TT("unicode2sjis") ) ;
		if ( g_InitKanjiControls && g_sjis2unicode && g_unicode2sjis ) {
			if ( (*g_InitKanjiControls)() ) {
				g_bUseKctrl = TRUE ;
				return TRUE ;
			}
		}
		FreeLibrary( g_hlib ) ;
		g_hlib = 0 ;
	}
	return FALSE ;
}

int
Mbstowcs( LPTSTR szUnicode, LPCSTR szSjis, int nSize )
{
	init_CodeConv() ;
	if ( g_bUseBuiltin ) {
		if ( szUnicode ) {
			return g_MultiByteToWideChar( CP_ACP, 0, szSjis, nSize, szUnicode, nSize ) ;
		} else {
			return g_MultiByteToWideChar( CP_ACP, 0, szSjis, nSize, szUnicode, 0 ) ;
		}
	} else if ( g_bUseKctrl ) {
		return g_sjis2unicode( szSjis, szUnicode, (nSize + 1) * sizeof (TCHAR) ) / sizeof (TCHAR) - 1 ;
	}
	return mbstowcs( szUnicode, szSjis, nSize ) ;
}

int
Wcstombs( LPSTR szSjis, LPCTSTR szUnicode, int nSize )
{
	init_CodeConv() ;
	if ( g_bUseBuiltin ) {
		if ( szSjis ) {
			return g_WideCharToMultiByte( CP_ACP, 0, szUnicode, -1, szSjis, nSize, NULL, NULL ) ;
		} else {
			return g_WideCharToMultiByte( CP_ACP, 0, szUnicode, -1, szSjis, 0, NULL, NULL ) ;
		}
	} else if ( g_bUseKctrl ) {
		return g_unicode2sjis( szUnicode, szSjis, nSize + 1 ) - 1 ;
	}
	return wcstombs( szSjis, szUnicode, nSize ) ;
}
#endif	/* UNICODE */

/*--------------------------------------------------------------------
 * t@C֘A
 *--------------------------------------------------------------------*/
CEFILE	g_CEFILE[ NUM_CEFILE ] ;
BOOL	g_bInitCEFILE = FALSE ;
TCHAR	g_szLocalBuf[ 1024 ] ;
#define	DEFAULT_BUF_SIZE	256

static	void
clear_CEFILE( CEFILE *fp )
{
	fp->m_bUse = FALSE ;
	fp->handle.m_hfile = INVALID_HANDLE_VALUE ;
	fp->m_bHwnd = FALSE ;
	fp->m_bEof = FALSE ;
	fp->m_bBinary = FALSE ;
	fp->m_bError = FALSE ;
	fp->m_dwRin = 0 ;
	fp->m_dwRout = 0 ;
	fp->m_dwRsize = DEFAULT_BUF_SIZE ;
	fp->m_dwWin = 0 ;
	fp->m_bReadDone = FALSE ;
	if ( fp->m_rBuf ) {
		LocalFree( fp->m_rBuf ) ;
	}
	fp->m_rBuf = (LPBYTE) LocalAlloc( LPTR, fp->m_dwRsize ) ;
	memset( fp->m_sBuf, 0, sizeof fp->m_sBuf ) ;
}

static	void
init_CEFILE( void )
{
	int		i ;

	if ( g_bInitCEFILE ) {
		return ;
	}
	g_bInitCEFILE = TRUE ;
	for ( i = 0 ; i < NUM_CEFILE ; i ++ ) {
		g_CEFILE[ i ].m_rBuf = 0 ;
		clear_CEFILE( &g_CEFILE[ i ] ) ;
	}
	CE_stdin->m_bUse = TRUE ;
	CE_stdin->m_bHwnd = TRUE ;
	CE_stdin->handle.m_hwnd = 0 ;
	CE_stdin->m_bBinary = FALSE ;
	CE_stdout->m_bUse = TRUE ;
	CE_stdout->m_bHwnd = TRUE ;
	CE_stdout->handle.m_hwnd = 0 ;
	CE_stdout->m_bBinary = FALSE ;
	CE_stderr->m_bUse = TRUE ;
	CE_stderr->m_bHwnd = TRUE ;
	CE_stderr->handle.m_hwnd = 0 ;
	CE_stderr->m_bBinary = FALSE ;
}

CEFILE*
find_empty_CEFILE( void )
{
	int		i ;
	CEFILE	*fp ;

	init_CEFILE() ;
	for ( i = 0 ; i < NUM_CEFILE ; i ++ ) {
		fp = &g_CEFILE[ i ] ;
		if ( !fp->m_bUse ) {
			clear_CEFILE( fp ) ;
			return fp ;
		}
	}
	return NULL ;
}

CEFILE*
Fopen( LPCSTR path, LPCSTR modestr )
{
#ifdef	UNICODE
	TCHAR	sjisPath[ MAX_PATH ], sjisMode[ 32 ] ;

	if ( Mbstowcs( sjisPath, path, MAX_PATH ) == -1 ) {
		return NULL ;
	}
	if ( Mbstowcs( sjisMode, modestr, 32 ) == -1 ) {
		return NULL ;
	}
#else	/* UNICODE */
	LPCTSTR	sjisPath = path ;
	LPCTSTR	sjisMode = modestr ;
#endif	/* UNICODE */
	return FopenW( sjisPath, sjisMode ) ;
}

CEFILE*
FopenW( LPCTSTR path, LPCTSTR modestr )
{
	CEFILE	*fp ;
	BOOL	bTrunc = FALSE, bLast = FALSE ;
	DWORD	access = GENERIC_READ ;
	DWORD	mode = FILE_SHARE_READ ;
	DWORD	dist = OPEN_EXISTING ;

	fp = find_empty_CEFILE() ;
	if ( !fp ) {
		return NULL ;
	}
	fp->m_bBinary = FALSE ;
	fp->m_bError = FALSE ;
	if ( *modestr == TEXT('r') ) {
		access = GENERIC_READ ;
		dist = OPEN_EXISTING ;
		if ( modestr[1] == TEXT('+') ) {
			access = GENERIC_READ|GENERIC_WRITE ;
			dist = OPEN_ALWAYS ;
			if ( modestr[2] == TEXT('b') ) {
				fp->m_bBinary = TRUE ;
			}
		} else if ( modestr[1] == TEXT('b') ) {
			fp->m_bBinary = TRUE ;
		}
	} else if ( *modestr == TEXT('w') ) {
		access = GENERIC_WRITE ;
		dist = CREATE_ALWAYS ;
		bTrunc = TRUE ;
		if ( modestr[1] == TEXT('+') ) {
			access = GENERIC_READ|GENERIC_WRITE ;
			if ( modestr[2] == TEXT('b') ) {
				fp->m_bBinary = TRUE ;
			}
		} else if ( modestr[1] == TEXT('b') ) {
			fp->m_bBinary = TRUE ;
		}
	} else if ( *modestr == TEXT('a') ) {
		access = GENERIC_WRITE ;
		dist = CREATE_ALWAYS ;
		bLast = TRUE ;
		if ( modestr[1] == TEXT('+') ) {
			access = GENERIC_READ|GENERIC_WRITE ;
			if ( modestr[2] == TEXT('b') ) {
				fp->m_bBinary = TRUE ;
			}
		} else if ( modestr[1] == TEXT('b') ) {
			fp->m_bBinary = TRUE ;
		}
	} else {
		return FALSE ;
	}
	fp->handle.m_hfile = CreateFile( path, access, mode, NULL,
							  dist, FILE_ATTRIBUTE_NORMAL, 0 ) ;
	if ( fp->handle.m_hfile == INVALID_HANDLE_VALUE ) {
		return NULL ;
	}
	fp->m_bUse = TRUE ;
	if ( bTrunc ) {
		SetEndOfFile( fp->handle.m_hfile ) ;
	} else if ( bLast ) {
		SetFilePointer( fp->handle.m_hfile, 0, NULL, FILE_END ) ;
	}
	fp->m_bEof = FALSE ;
	fp->m_dwRin = fp->m_dwRout = fp->m_dwWin = 0 ;
	return fp ;
}

void
Fclose( CEFILE *fp )
{
	if ( fp->m_bHwnd ) {
		return ;
	}
	if ( fp->handle.m_hfile != INVALID_HANDLE_VALUE ) {
		Fflush( fp ) ;
		CloseHandle( fp->handle.m_hfile ) ;
		fp->m_bUse = FALSE ;
		fp->handle.m_hfile = INVALID_HANDLE_VALUE ;
	}
}

int
Fgetc( CEFILE *fp )
{
	int		c ;
	BOOL	ret ;
	DWORD	nRead ;
	LPTSTR	pUnicode ;
	int		nSjis, nUnicode ;

	do {
		if ( fp->m_bEof ) {
			return CE_EOF ;
		}
		if ( fp->m_dwRin == fp->m_dwRout ) {
			fp->m_dwRin = fp->m_dwRout = 0 ;
			fp->m_dwRsize = DEFAULT_BUF_SIZE ;
			if ( fp->m_bHwnd ) {
				if ( fp->m_bReadDone ) {
					fp->m_bEof = TRUE ;
					return CE_EOF ;
				}
				fp->m_bReadDone = TRUE ;
				if ( fp->m_rBuf ) {
					LocalFree( fp->m_rBuf ) ;
					fp->m_rBuf = 0 ;
				}
				nSjis = 0 ;
				nUnicode = GetWindowTextLength( fp->handle.m_hwnd ) ;
				pUnicode = (LPTSTR) LocalAlloc( LPTR, (nUnicode + 1) * sizeof (TCHAR) ) ;
				if ( pUnicode ) {
#ifdef	UNICODE
					GetWindowText( fp->handle.m_hwnd, pUnicode, nUnicode + 1 ) ;
					nSjis = wcstombs( NULL, pUnicode, nUnicode ) ;
					if ( nSjis != -1 ) {
						fp->m_rBuf = (LPBYTE) LocalAlloc( LPTR, nSjis + 1 ) ;
						if ( fp->m_rBuf ) {
							wcstombs( fp->m_rBuf, pUnicode, nUnicode ) ;
							fp->m_rBuf[ nSjis ] = 0 ;
							nSjis = strlen( fp->m_rBuf ) ;
						}
					}
					LocalFree( pUnicode ) ;
#else	/* UNICODE */
					GetWindowText( fp->handle.m_hwnd, pUnicode, nUnicode + 1 ) ;
					fp->m_rBuf = pUnicode ;
					fp->m_rBuf[ nUnicode ] = 0 ;
					nSjis = nUnicode ;
#endif	/* UNICODE */
				}
				if ( !nSjis ) {
					fp->m_bEof = TRUE ;
					return CE_EOF ;
				}
				nRead = nSjis ;
				fp->m_dwRsize = nSjis + 1 ;
			} else {
				ret = ReadFile( fp->handle.m_hfile, fp->m_rBuf, fp->m_dwRsize, &nRead, NULL ) ;
				if ( !ret || !nRead ) {
					fp->m_bEof = TRUE ;
					return CE_EOF ;
				}
			}
			fp->m_dwRin = nRead ;
			fp->m_dwRin %= fp->m_dwRsize ;
		}
		c = (int) fp->m_rBuf[ fp->m_dwRout ] ;
		fp->m_dwRout ++ ;
		fp->m_dwRout %= fp->m_dwRsize ;
	} while ( !fp->m_bBinary && c == '\r' ) ;
	return c ;
}

char *
Fgets( char *buf, int size, CEFILE *fp )
{
	int		c ;
	LPBYTE	ptr = buf ;

	size -- ;
	while ( (c = Fgetc( fp )) != CE_EOF ) {
		if ( !size ) {
			break ;
		}
		*ptr++ = c ;
		if ( c == '\n' ) {
			break ;
		}
	}
	*ptr = 0 ;
	return ptr == buf ? NULL : buf ;
}

static	int
Fputc_sub( int c, CEFILE *fp )
{
	DWORD	tmp, nWrite ;

	fp->m_sBuf[ fp->m_dwWin ] = c ;
	fp->m_dwWin ++ ;
	fp->m_dwWin %= sizeof fp->m_sBuf ;
	if ( !fp->m_dwWin || c == '\n' ) {
		tmp = fp->m_dwWin ? fp->m_dwWin : sizeof fp->m_sBuf ;
		fp->m_dwWin = 0 ;
		if ( fp->m_bHwnd ) {
#ifdef	UNICODE
			int		ret ;

			ret = Mbstowcs( g_szLocalBuf, fp->m_sBuf, tmp ) ;
			if ( ret == -1 ) {
				fp->m_bError = TRUE ;
				return FALSE ;
			}
			g_szLocalBuf[ ret ] = TEXT('\0') ;
#else	/* UNICODE */
			strcpy( g_szLocalBuf, fp->m_sBuf ) ;
			g_szLocalBuf[ tmp ] = TEXT('\0') ;
#endif	/* UNICODE */
			AddStrToEditControl( fp->handle.m_hwnd, g_szLocalBuf ) ;
		} else if ( !WriteFile( fp->handle.m_hfile, fp->m_sBuf, tmp, &nWrite, NULL ) ) {
			fp->m_bError = TRUE ;
			return FALSE ;
		} else if ( nWrite == 0 ) {
			fp->m_bError = TRUE ;
			return FALSE ;
		}
	}
	return TRUE ;
}

int
Fputc( int c, CEFILE *fp )
{
	if ( !fp->m_bBinary && c == '\n' ) {
		if ( !Fputc_sub( '\r', fp ) ) {
			return -1 ;
		}
	}
	return Fputc_sub( c, fp ) ? c : -1 ;
}

int
Fputs( const char *buf, CEFILE *fp )
{
	BYTE	c ;
	int		last = -1 ;

	while ( c = *buf++ ) {
		last = (int) c ;
		if ( Fputc( last, fp ) == -1 ) {
			return -1 ;
		}
	}
	return last ;
}

int
Fread( void *_buf, int size, CEFILE *fp )
{
	char	*buf = (char*) _buf ;
	int		c, nRead = 0 ;

	if ( !size ) {
		return nRead ;
	}
	do {
		c = Fgetc( fp ) ;
		if ( c == -1 ) {
			return nRead ;
		}
		*buf++ = c ;
		nRead ++ ;
	} while ( -- size ) ;
	return nRead ;
}

void
Fwrite( const void *_buf, int size, CEFILE *fp )
{
	const char	*buf = (const char *) _buf ;
	if ( !size ) {
		return ;
	}
	do {
		Fputc( *buf++, fp ) ;
	} while ( -- size ) ;
}

void
Fflush( CEFILE *fp )
{
	DWORD	nWrite ;

	if ( fp->m_dwWin ) {
		if ( fp->m_bHwnd ) {
#ifdef	UNICODE
			int		ret ;

			ret = Mbstowcs( g_szLocalBuf, fp->m_sBuf, fp->m_dwWin ) ;
			if ( ret != -1 ) {
				g_szLocalBuf[ ret ] = TEXT('\0') ;
#else	/* UNICODE */
				strcpy( g_szLocalBuf, fp->m_sBuf ) ;
				g_szLocalBuf[ fp->m_dwWin ] = TEXT('\0') ;
#endif	/* UNICODE */
				AddStrToEditControl( fp->handle.m_hwnd, g_szLocalBuf ) ;
#ifdef	UNICODE
			}
#endif	/* UNICODE */
		} else {
			WriteFile( fp->handle.m_hfile, fp->m_sBuf, fp->m_dwWin, &nWrite, NULL ) ;
		}
		fp->m_dwWin = 0 ;
	}
}

BOOL
Ferror( CEFILE *fp )
{
	return fp->m_bError ;
}

int
Fseek( CEFILE *fp, long offset, int whence )
{
	DWORD   method ;

	if ( fp->m_bHwnd ) {
		return -1 ;
	}
	if ( whence == 1 ) {
		method = FILE_CURRENT ;
	} else if ( whence == 2 ) {
		method = FILE_END ;
	} else {
		method = FILE_BEGIN ;
	}
	fp->m_bEof = FALSE ;
	fp->m_dwRin = fp->m_dwRout = fp->m_dwWin = 0 ;
	return SetFilePointer( fp->handle.m_hfile, offset, NULL, method ) ? 0 : -1 ;
}

DWORD
Fsize( CEFILE *fp )
{
	if ( fp->m_bHwnd ) {
		int		nSjis ;
		int		nUnicode ;
#ifdef	UNICODE
		LPTSTR	pUnicode ;
#endif	/* UNICODE */

		nSjis = 0 ;
		nUnicode = GetWindowTextLength( fp->handle.m_hwnd ) ;
#ifdef	UNICODE
		pUnicode = (LPTSTR) LocalAlloc( LPTR, (nUnicode + 1) * sizeof (TCHAR) ) ;
		if ( pUnicode ) {
			GetWindowText( fp->handle.m_hwnd, pUnicode, nUnicode ) ;
			pUnicode[ nUnicode ] = 0 ;
			nSjis = wcstombs( NULL, pUnicode, nUnicode + 1 ) ;
			if ( nSjis == -1 ) {
				nSjis = 0 ;
			}
			LocalFree( pUnicode ) ;
		}
#else	/* UNICODE */
		nSjis = nUnicode ;
#endif	/* UNICODE */
		return nSjis ;
	}
	return GetFileSize( fp->handle.m_hfile, NULL ) ;
}

int
Feof( CEFILE *fp )
{
	return fp->m_bEof ? CE_EOF : 0 ;
}

/*--------------------------------------------------------------------
 * EBhEXg[֘A
 *--------------------------------------------------------------------*/
void
AddStrToEditControl( HWND hwnd, LPCTSTR szUnicode )
{
	DWORD	len ;

	if ( hwnd ) {
		len = GetWindowTextLength( hwnd ) ;
		SendMessage( hwnd, EM_SETSEL, (WPARAM) len, (LPARAM) len ) ;
		SendMessage( hwnd, EM_REPLACESEL, (WPARAM) FALSE, (LPARAM) szUnicode ) ;
	}
}

void
AttachWinToStream( CEFILE *fp, HWND hwnd )
{
	init_CEFILE() ;

	if ( fp->m_bUse && fp->m_bHwnd ) {
		fp->handle.m_hwnd = hwnd ;
		fp->m_bEof = FALSE ;
		fp->m_bBinary = FALSE ;
		fp->m_bError = FALSE ;
		fp->m_dwRin = 0 ;
		fp->m_dwRout = 0 ;
		fp->m_dwWin = 0 ;
		fp->m_bReadDone = FALSE ;
		if ( fp->m_rBuf ) {
			LocalFree( fp->m_rBuf ) ;
			fp->m_rBuf = 0 ;
		}
		memset( fp->m_sBuf, 0, sizeof fp->m_sBuf ) ;
	}
}

/*--------------------------------------------------------------------
 * fBNg֘A
 *--------------------------------------------------------------------*/
#ifndef	NO_DIR
void
slash2backslash( LPTSTR str )
{
	LPTSTR	ptr ;

	/* '/''\'ɕϊ */
	while ( ptr = _tcschr( str, TEXT('/') ) ) {
		*ptr = TEXT('\\') ;
	}
}

void
catdir( LPTSTR body, LPCTSTR adddir, LPTSTR pPrevDir )
{
	DWORD	len ;
	LPTSTR	ptr ;

	slash2backslash( body ) ;
	if ( pPrevDir ) {
		_tcscpy( pPrevDir, TEXT("..") ) ;
	}
	while ( *adddir ) {
		if ( _tcschr( TEXT("/\\"), *adddir ) ) {
			/* 擪"/""\"̏ꍇ͓ǂݔ΂ */
			adddir ++ ;
			continue ;
		}
		if ( adddir[0] == TEXT('.') && adddir[1] == TEXT('.') ) {
			ptr = _tcsrchr( body, TEXT('\\') ) ;
			if ( ptr && pPrevDir ) {
				_tcscpy( pPrevDir, ptr + 1 ) ;
			}
			if ( ptr && ptr != body ) {
				*ptr = 0 ;
			} else {
				_tcscpy( body, TEXT("\\") ) ;
			}
			adddir += 2 ;
		} else if ( adddir[0] == TEXT('.') ) {
			adddir ++ ;
		} else {
			break ;
		}
	}
	if ( !*adddir ) {
		return ;
	}
	len = _tcslen( body ) ;
	if ( !len || body[ len - 1 ] != TEXT('\\') ) {
		body[ len ++ ] = TEXT('\\') ;
	}
	_tcscpy( &body[ len ], adddir ) ;
	slash2backslash( body ) ;
}

void
rel2abs( LPTSTR newPath, LPCTSTR oldPath, LPCTSTR adddir )
{
	if ( _tcschr( TEXT("/\\"), *adddir ) ) {
		_tcscpy( newPath, adddir ) ;
		slash2backslash( newPath ) ;
	} else {
		_tcscpy( newPath, oldPath ) ;
		catdir( newPath, adddir, NULL ) ;
	}
}
#endif	/* NO_DIR */

int
sleep( int sec )
{
	Sleep( sec * 1000 ) ;
	return 0 ;
}

#ifndef	NO_STRING
#undef		islower
#define		islower(c)		((c)>='a'&&(c)<='z')
#define		toupper(c)		(islower(c)?(c)-'a'+'A':(c))

int
stricmp( const char *src, const char *dst )
{
	char	c = 0, c1 ;

	while ( (c = *src++) ) {
		c = toupper( c ) ;
		c1 = *dst++ ;
		c1 = toupper( c1 ) ;
		if ( c != c1 ) {
			return c - c1 ;
		}
	}
	c = toupper( c ) ;
	c1 = *dst++ ;
	c1 = toupper( c1 ) ;
	return c - c1 ;
}

int
strnicmp( const char *src, const char *dst, int len )
{
	char	c = 0, c1 ;

	while ( len && (c = *src++) ) {
		c = toupper( c ) ;
		c1 = *dst++ ;
		c1 = toupper( c1 ) ;
		if ( c != c1 ) {
			return c - c1 ;
		}
		len -- ;
	}
	c = toupper( c ) ;
	c1 = *dst++ ;
	c1 = toupper( c1 ) ;
	return len ? c - c1 : 0 ;
}

int
bcmp( char *s1, char *s2, int len )
{
	return memcmp( s1, s2, len ) ;
}

int
bzero( char *s, int len )
{
	memset( s, 0, len ) ;
	return 0 ;
}

void
strcat_num( char *str, int num )
{
	CHAR	digits[ 10 ], *ptr = digits ;

	str += strlen( str ) ;
	if ( num < 0 ) {
		*str++ = '-' ;
		num = - num ;
	}
	if ( num ) {
		while ( num ) {
			*ptr++ = '0' + (CHAR) (num % 10) ;
			num /= 10 ;
		}
	} else {
		*ptr++ = '0' ;
	}
	while ( ptr -- != digits ) {
		*str++ = *ptr ;
	}
	*str = 0 ;
}

void
strcat_char( char *str, int c )
{
	str += strlen( str ) ;
	*str++ = (char) (c & 0xFF) ;
	*str = 0 ;
}
#endif	/* NO_STRING */

#ifndef	NO_SPRINTF
static	char	SprintNumList[] = "0123456789abcdef" ;

static int
SprintfNum( char **buf, int i, int r )
{
	int		q, count ;

	count = 0 ;
	if ( i < 0 ) {
		*(*buf) ++ = '-' ;
		i = -i ;
		count ++ ;
	}
	q = i / r ;
	if ( q ) {
		count += SprintfNum( buf, q, r ) ;
	}
	*(*buf) ++ = SprintNumList[ i % r ] ;
	*(*buf) = '\0' ;
	count ++ ;
	return count ;
}

static int
SprintfSub( char *buf, const char *fmt, va_list *ap )
{
	int		c ;
	char	*orgbuf = buf ;

	while ( ( c = *fmt++ ) != '\0' ) {
		if ( c != '%') {
			*buf++ = c ;
		} else {
			c = *fmt++ ;
			switch ( c ) {
			case 'c':
				*buf++ = (char) (0xFF & va_arg( *ap, int )) ;
				break ;
			case 'l':
				c = *fmt++ ;
			case 'x':
				SprintfNum( &buf, va_arg( *ap, int ), 16 ) ;
				break ;
			case 'd':
				SprintfNum( &buf, va_arg( *ap, int ), 10 ) ;
				break ;
			case 'o':
				SprintfNum( &buf, va_arg( *ap, int ), 8 ) ;
				break ;
			case 's':
				strcpy( buf, va_arg( *ap, char * ) ) ;
				buf += strlen( buf ) ;
				break ;
			default:
				if ( (c < '0' || c > '9') && c != '-' ) {
					*buf++ = c ;
				}
				break ;
			}
		}
	}
	*buf = 0 ;
	return strlen( orgbuf ) ;
}

static int
FprintfSub( CEFILE *fp, const char *fmt, va_list *ap )
{
	int		c, count ;
	char	buf[ 32 ], *ptr ;

	count = 0 ;
	while ( ( c = *fmt++ ) != '\0' ) {
		if ( c != '%') {
			count ++ ;
			Fputc( c, fp ) ;
		} else {
			ptr = buf ;
			c = *fmt++ ;
			switch ( c ) {
			case 'c':
				count ++ ;
				c = (int) (0xFF & va_arg( *ap, int )) ;
				Fputc( c, fp ) ;
				break ;
			case 'l':
				c = *fmt++ ;
			case 'x':
				count += SprintfNum( &ptr, va_arg( *ap, int ), 16 ) ;
				Fputs( buf, fp ) ;
				break ;
			case 'd':
				count += SprintfNum( &ptr, va_arg( *ap, int ), 10 ) ;
				Fputs( buf, fp ) ;
				break ;
			case 'o':
				count += SprintfNum( &ptr, va_arg( *ap, int ), 8 ) ;
				Fputs( buf, fp ) ;
				break ;
			case 's':
				ptr = va_arg( *ap, char * ) ;
				count += strlen( ptr ) ;
				Fputs( ptr, fp ) ;
				break ;
			default:
				if ( (c < '0' || c > '9') && c != '-' ) {
					count ++ ;
					Fputc( c, fp ) ;
				}
				break ;
			}
		}
	}
	return count ;
}

int
Sprintf( char *buf, const char *fmt, ... )
{
	int			ret ;
	va_list		pvar ;

	va_start( pvar, fmt ) ;
	ret = SprintfSub( buf, fmt, &pvar ) ;
	va_end( pvar ) ;
	return ret ;
}

int
Fprintf( CEFILE *fp, const char *fmt, ... )
{
	int			ret ;
	va_list		pvar ;

	va_start( pvar, fmt ) ;
	ret = FprintfSub( fp, fmt, &pvar ) ;
	va_end( pvar ) ;
	return ret ;
}

int
Printf( const char *fmt, ... )
{
	int			ret ;
	va_list		pvar ;

	va_start( pvar, fmt ) ;
	ret = FprintfSub( CE_stdout, fmt, &pvar ) ;
	va_end( pvar ) ;
	return ret ;
}
#endif	/* NO_SPRINTF */

#ifndef	NO_CLIPBOARD
int
SendClipboard( const char *sjis )
{
	LPTSTR		ptr ;
	DWORD		size ;
#ifdef	_WIN32_WCE
	HLOCAL		hGMem ;
#else	/* _WIN32_WCE */
	HGLOBAL		hGMem ;
#endif	/* _WIN32_WCE */

	size = sjis2unicode( (LPBYTE) sjis, NULL, 0 ) ;
	if ( !size ) {
		return 1 ;
	}
	/* Nbv{[hI[v */
	if ( !OpenClipboard( 0 ) ) {
		return 0 ;
	} else if ( !EmptyClipboard() ) {
		CloseClipboard() ;
		return 0 ;
	}
	/* Kvȕmۂs */
#ifdef	_WIN32_WCE
	hGMem = LocalAlloc( LMEM_FIXED, size ) ;
	ptr = (LPTSTR) hGMem ;
#else	/* _WIN32_WCE */
	hGMem = GlobalAlloc( GMEM_MOVEABLE|GMEM_DDESHARE, size ) ;
	ptr = (LPTSTR) GlobalLock( hGMem ) ;
#endif	/* _WIN32_WCE */
	/* UNICODE->JISϊʂɏ */
	sjis2unicode( (LPBYTE) sjis, ptr, size ) ;
	/* Nbv{[hɌʂZbg */
	SetClipboardData( CF_UNICODETEXT, hGMem ) ;
#ifndef	_WIN32_WCE
	GlobalUnlock( hGMem ) ;
#endif	/* _WIN32_WCE */
	/* Nbv{[hN[Y */
	CloseClipboard() ;
	return 1 ;
}

int
ReceiveClipboard( char *sjis )
{
	LPCTSTR		cbptr ;
	int			cbsize, ret = 0 ;
#ifdef  _WIN32_WCE
	HLOCAL		hGMem ;
#else   /* _WIN32_WCE */
	HGLOBAL		hGMem ;
#endif  /* _WIN32_WCE */

	if ( !OpenClipboard( 0 ) ) {
		return 0 ;
	}
#ifdef  _WIN32_WCE
	hGMem = GetClipboardData( CF_UNICODETEXT ) ;
	cbsize = LocalSize( hGMem ) ;
	cbptr = (LPCTSTR) hGMem ;
#else   /* _WIN32_WCE */
	hGMem = GetClipboardData( CF_UNICODETEXT ) ;
	cbsize = GlobalSize( hGMem ) ;
	cbptr = (LPCTSTR) GlobalLock( hGMem ) ;
#endif  /* _WIN32_WCE */
	if ( !cbsize ) {
		goto exit ;
	}
	ret = unicode2sjis( cbptr, (LPBYTE) sjis, cbsize ) ;

exit:
#ifndef _WIN32_WCE
	GlobalUnlock( hGMem ) ;
#endif  /* _WIN32_WCE */
	CloseClipboard() ;
	return ret ;
}
#endif	/* NO_CLIPBOARD */

int
Exit( int retcode )
{
	RaiseException( EXCEPTION_QUIT, 0, 0, 0 ) ;
	return 0 ;
}
