/*
 * Dialog functions
 * Copyright 1998-2000 (C) Eiichiroh Itoh
 *
 * 1999/12/29:Eiichiroh Itoh
 *  (1) Initial development
 * Modification
 * 2000/02/23:Eiichiroh Itoh
 *  (1) Modify for nqc-2.1r1
 *  (2) Add Scout target
 *
 */
#define	STRICT
#include	<windows.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	<commdlg.h>
#include	<tchar.h>
#include	"cetools.h"
#include	"cebase.h"
#include	"ceapp.h"
#include	"resource.h"
#include	"cedialog.h"

/*
 * Xg{bNXp̌Œsb`tHg쐬
 */
HFONT
CreateListboxFont()
{
	LOGFONT         lf ;

	/* tHg擾 */
	memset( &lf, 0, sizeof lf ) ;
	lf.lfPitchAndFamily = FIXED_PITCH | FF_MODERN ;
	lf.lfCharSet = 128 ;
	lf.lfHeight = 13 ;
	return CreateFontIndirect( &lf ) ;
}

static	LOGFONT		g_font ;
static	BOOL		g_bFont = FALSE ;

static int CALLBACK
SelectFontCallback( const LOGFONT *lplf, const TEXTMETRIC *lpntm, DWORD nFontType, LPARAM lParam )
{
	if ( _tcsicmp( lplf->lfFaceName, g_szFontName ) ) {
		return 1 ;
	}
	g_bFont = TRUE ;
	memcpy( &g_font, lplf, sizeof (LOGFONT) ) ;
	return 0 ;
}

HFONT
CreateSpecifiedFont( HWND hwnd )
{
	HDC		hDC ;

	g_bFont = FALSE ;
	memset( &g_font, 0, sizeof g_font ) ;
	hDC = GetDC( hwnd ) ;
	EnumFontFamilies( hDC, NULL, SelectFontCallback, 0 ) ;
	ReleaseDC( hwnd, hDC ) ;
	if ( !g_bFont ) {
		return NULL ;
	}
	g_font.lfHeight = g_dwFontHeight ;
	g_font.lfWidth = 0 ;
	g_font.lfWeight = 0 ;
	return CreateFontIndirect( &g_font ) ;
}

#define		MAX_FONTFAMILY		32

typedef struct {
	int		m_nNumFonts ;
	TCHAR	m_szFontFamily[ LF_FACESIZE ] ;
} FONTFAMILYSTRUCT ;

static	BOOL				g_bInitFont = FALSE ;
static	FONTFAMILYSTRUCT	g_fontFamily[ MAX_FONTFAMILY ] ;
static	int					g_nNumFontFamily = 0 ;

static int CALLBACK
FontFamilyCallback( const LOGFONT *lplf, const TEXTMETRIC *lpntm, DWORD nFontType, LPARAM lParam )
{
	if ( g_nNumFontFamily >= MAX_FONTFAMILY ) {
		return 0 ;
	}
	_tcscpy( g_fontFamily[ g_nNumFontFamily ++ ].m_szFontFamily, lplf->lfFaceName ) ;
	return 1 ;
}

static int CALLBACK
SingleFontCallback( const LOGFONT *lplf, const TEXTMETRIC *lpntm, DWORD nFontType, LPARAM lParam )
{
	FONTFAMILYSTRUCT	*pfont ;

	pfont = (FONTFAMILYSTRUCT*) lParam ;
	pfont->m_nNumFonts ++ ;
	return 1 ;
}

static BOOL
InitFontList( HWND hwnd )
{
	int		i ;
	HDC		hdc ;

	if ( g_bInitFont ) {
		return TRUE ;
	}
	g_bInitFont = TRUE ;
	g_nNumFontFamily = 0 ;
	hdc = GetDC( hwnd ) ;
	EnumFontFamilies( hdc, NULL, FontFamilyCallback, 0 ) ;
	for ( i = 0 ; i < g_nNumFontFamily ; i ++ ) {
		g_fontFamily[ i ].m_nNumFonts = 0 ;
		EnumFontFamilies( hdc, g_fontFamily[ i ].m_szFontFamily,
						  SingleFontCallback,
						  (LPARAM) &g_fontFamily[ i ] ) ;
	}
	ReleaseDC( hwnd, hdc ) ;
	return TRUE ;
}

/* ----------------------------------------------------------------------
 * ZbgAbv_CAO
 * ---------------------------------------------------------------------- */
static	BOOL APIENTRY
GeneralDlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	HDC			hDC ;
	NMHDR		*nmhdr ;
	HWND		hwndCtrl ;
	int			i, nPoint ;

	switch ( message ) {
	case WM_INITDIALOG:
		InitFontList( 0 ) ;
		hwndCtrl = GetDlgItem( hDlg, IDC_CMB_FNAME ) ;
		for ( i = 0 ; i < g_nNumFontFamily ; i ++ ) {
			SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) g_fontFamily[ i ].m_szFontFamily ) ;
		}
		hwndCtrl = GetDlgItem( hDlg, IDC_CMB_FSIZE ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("8") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("9") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("10") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("11") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("12") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("14") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("16") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("20") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("24") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("28") ) ;
		SendMessage( hwndCtrl, CB_ADDSTRING, 0, (LPARAM) TEXT("36") ) ;
		SetDlgItemText( hDlg, IDC_CMB_FNAME, g_szFontName ) ;
		if ( g_dwFontHeight ) {
			hDC = GetDC( hDlg ) ;
			nPoint = g_dwFontHeight * 72 / GetDeviceCaps( hDC, LOGPIXELSY ) ;
			ReleaseDC( hDlg, hDC ) ;
			SetDlgItemInt( hDlg, IDC_CMB_FSIZE, nPoint, FALSE ) ;
		}
		return TRUE ;
	case WM_NOTIFY:
		nmhdr = (NMHDR*) lParam ;
		switch ( nmhdr->code ) {
		case PSN_APPLY:
			GetDlgItemText( hDlg, IDC_CMB_FNAME, g_szFontName, sizeof g_szFontName / sizeof *g_szFontName ) ;
			nPoint = GetDlgItemInt( hDlg, IDC_CMB_FSIZE, NULL, FALSE ) ;
			hDC = GetDC( hDlg ) ;
			g_dwFontHeight = (nPoint * GetDeviceCaps( hDC, LOGPIXELSY ) + 71) / 72 ;
			ReleaseDC( hDlg, hDC ) ;
			break ;
		}
		break ;
	}
	return FALSE ;
}

static	BOOL APIENTRY
Compiler1DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	NMHDR		*nmhdr ;

	switch ( message ) {
	case WM_INITDIALOG:
		SendDlgItemMessage( hDlg, IDC_CHK_AUTOSAVE, BM_SETCHECK, (WPARAM) g_dwAutoSave   ? BST_CHECKED : BST_UNCHECKED, 0 ) ;
		SendDlgItemMessage( hDlg, IDC_CHK_COMPAT,   BM_SETCHECK, (WPARAM) g_dwCompatible ? BST_CHECKED : BST_UNCHECKED, 0 ) ;
		SendDlgItemMessage( hDlg, IDC_CHK_LISTING,  BM_SETCHECK, (WPARAM) g_dwListing    ? BST_CHECKED : BST_UNCHECKED, 0 ) ;
		SendDlgItemMessage( hDlg, IDC_CHK_NOSYS,    BM_SETCHECK, (WPARAM) g_dwNoSysFile  ? BST_CHECKED : BST_UNCHECKED, 0 ) ;
		SendDlgItemMessage( hDlg, IDC_CMB_TARGET,   CB_ADDSTRING, 0, (LPARAM) TEXT("RCX") ) ;
		SendDlgItemMessage( hDlg, IDC_CMB_TARGET,   CB_ADDSTRING, 0, (LPARAM) TEXT("Scout") ) ;
		SendDlgItemMessage( hDlg, IDC_CMB_TARGET,   CB_ADDSTRING, 0, (LPARAM) TEXT("CyberMaster") ) ;
		SendDlgItemMessage( hDlg, IDC_CMB_TARGET,   CB_SETCURSEL, (WPARAM) g_dwTargetMode, 0 ) ;
		return TRUE ;
	case WM_NOTIFY:
		nmhdr = (NMHDR*) lParam ;
		switch ( nmhdr->code ) {
		case PSN_APPLY:
			g_dwAutoSave   = SendDlgItemMessage( hDlg, IDC_CHK_AUTOSAVE, BM_GETCHECK, 0, 0 ) == BST_CHECKED ;
			g_dwCompatible = SendDlgItemMessage( hDlg, IDC_CHK_COMPAT,   BM_GETCHECK, 0, 0 ) == BST_CHECKED ;
			g_dwListing    = SendDlgItemMessage( hDlg, IDC_CHK_LISTING,  BM_GETCHECK, 0, 0 ) == BST_CHECKED ;
			g_dwNoSysFile  = SendDlgItemMessage( hDlg, IDC_CHK_NOSYS,    BM_GETCHECK, 0, 0 ) == BST_CHECKED ;
			g_dwTargetMode = SendDlgItemMessage( hDlg, IDC_CMB_TARGET,   CB_GETCURSEL, 0, 0 ) ;
			break ;
		}
		break ;
	}
	return FALSE ;
}

static	BOOL APIENTRY
Compiler2DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	NMHDR		*nmhdr ;

	switch ( message ) {
	case WM_INITDIALOG:
		SetDlgItemText( hDlg, IDC_EDT_INCLUDE,  g_szIncludePath ) ;
		SetDlgItemText( hDlg, IDC_EDT_DEFINE,   g_szDefine ) ;
		SetDlgItemText( hDlg, IDC_EDT_UNDEFINE, g_szUndefine ) ;
		return TRUE ;
	case WM_NOTIFY:
		nmhdr = (NMHDR*) lParam ;
		switch ( nmhdr->code ) {
		case PSN_APPLY:
			GetDlgItemText( hDlg, IDC_EDT_INCLUDE,  g_szIncludePath, sizeof g_szIncludePath / sizeof *g_szIncludePath ) ;
			GetDlgItemText( hDlg, IDC_EDT_DEFINE,   g_szDefine,  sizeof g_szDefine / sizeof *g_szDefine ) ;
			GetDlgItemText( hDlg, IDC_EDT_UNDEFINE, g_szUndefine, sizeof g_szUndefine / sizeof *g_szUndefine ) ;
			break ;
		}
		break ;
	}
	return FALSE ;
}

static	BOOL APIENTRY
DownloadDlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	NMHDR		*nmhdr ;

	switch ( message ) {
	case WM_INITDIALOG:
		SetDlgItemText( hDlg, IDC_EDT_PORT, g_szSerialPort ) ;
		SetDlgItemInt( hDlg, IDC_EDT_RXTIMEOUT, g_dwRxTimeout, FALSE ) ;
		SendDlgItemMessage( hDlg, IDC_CHK_VERBOSE, BM_SETCHECK, (WPARAM) g_dwVerbose     ? BST_CHECKED : BST_UNCHECKED, 0 ) ;
		return TRUE ;
	case WM_NOTIFY:
		nmhdr = (NMHDR*) lParam ;
		switch ( nmhdr->code ) {
		case PSN_APPLY:
			GetDlgItemText( hDlg, IDC_EDT_PORT,  g_szSerialPort, sizeof g_szSerialPort / sizeof *g_szSerialPort ) ;
			g_dwRxTimeout   = GetDlgItemInt( hDlg, IDC_EDT_RXTIMEOUT, NULL, FALSE ) ;
			g_dwVerbose     = SendDlgItemMessage( hDlg, IDC_CHK_VERBOSE, BM_GETCHECK, 0, 0 ) == BST_CHECKED ;
			break ;
		}
	}
	return FALSE ;
}

BOOL
SetupDialogExec( HWND hwnd )
{
	DWORD			ret ;
	PROPSHEETPAGE	psp ;
	PROPSHEETHEADER	psh ;
	HPROPSHEETPAGE	hpsp[ 4 ] ;

	psp.dwSize = sizeof (PROPSHEETPAGE) ;
	psp.dwFlags = PSP_DEFAULT ;
	psp.hInstance = g_hInst ;

	psp.pszTemplate = MAKEINTRESOURCE(IDD_LCLD_GENERAL) ;
	psp.pfnDlgProc = (DLGPROC) GeneralDlgProc ;
	hpsp[ 0 ] = CreatePropertySheetPage( &psp ) ;

	psp.pszTemplate = MAKEINTRESOURCE(IDD_LCLD_COMPILER) ;
	psp.pfnDlgProc = (DLGPROC) Compiler1DlgProc ;
	hpsp[ 1 ] = CreatePropertySheetPage( &psp ) ;

	psp.pszTemplate = MAKEINTRESOURCE(IDD_LCLD_COMPILER2) ;
	psp.pfnDlgProc = (DLGPROC) Compiler2DlgProc ;
	hpsp[ 2 ] = CreatePropertySheetPage( &psp ) ;

	psp.pszTemplate = MAKEINTRESOURCE(IDD_LCLD_DOWNLOAD) ;
	psp.pfnDlgProc = (DLGPROC) DownloadDlgProc ;
	hpsp[ 3 ] = CreatePropertySheetPage( &psp ) ;

	memset( &psh, 0, sizeof (PROPSHEETHEADER) ) ;
	psh.dwSize = sizeof (PROPSHEETHEADER) ;
	psh.dwFlags = PSH_PROPTITLE ;
	psh.dwFlags = PSH_DEFAULT ;
	psh.hwndParent = hwnd ;
	psh.hInstance = g_hInst ;
	psh.pszCaption = TEXT("Options") ;
	psh.nPages = sizeof hpsp / sizeof hpsp[0] ;
	psh.nStartPage = 0 ;
	psh.phpage = hpsp ;
	/* vpeBV[g\ */
	ret = PropertySheet( &psh ) ;
	if ( ret == -1 ) {
		return FALSE ;
	}
	return TRUE ;
}
