/*
 * CENQC main part (window handling)
 * Copyright 1998-2000 (C) Eiichiroh Itoh
 *
 * 1999/12/29:Eiichiroh Itoh
 *  (1) Initial development
 * Modification
 * 2000/02/23:Eiichiroh Itoh
 *  (1) Modify for nqc-2.1r1
 *
 */
#define	STRICT
#include	<windows.h>
#include	<windowsx.h>
#include	<commctrl.h>
#include	<commdlg.h>
#include	<tchar.h>
#include	"cetools.h"
#include	"cebase.h"
#include	"ceapp.h"
#include	"resource.h"
#include	"cedialog.h"
#include	"cenqc.h"

extern "C" {
	TCHAR		g_szMessageBuf[ 1024 ] ;
	TCHAR		g_szFontName[ MAX_PATH ] = TEXT("") ;
	TCHAR		g_szIncludePath[ MAX_PATH ] = TEXT("") ;
	TCHAR		g_szDefine[ MAX_PATH ] = TEXT("") ;
	TCHAR		g_szUndefine[ MAX_PATH ] = TEXT("") ;
	TCHAR		g_szSerialPort[ MAX_PATH ] = TEXT("COM1:") ;
	DWORD		g_dwFontHeight = 0 ;
	DWORD		g_dwCompatible = 0 ;
	DWORD		g_dwListing = 0 ;
	DWORD		g_dwNoSysFile = 0 ;
	DWORD		g_dwRxTimeout = 50 ;
	DWORD		g_dwVerbose = 0 ;
	DWORD		g_dwTargetMode ;
	DWORD		g_dwAutoSave = 0 ;
} ;

static	BOOL	g_bDeleteReg = FALSE ;		/* WXg폜ꍇ*^* */
static	TCHAR	g_szTitleName[ 128 ] = szTitleName ;

BOOL CALLBACK	AboutDlgFunc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam ) ;

/*
 * CEBhE
 */
class MainWindow : public Window {
private:
	MainApp		*m_pApp ;			/* AvP[Vւ̃|C^ */
	HWND		m_hwndCB ;			/* CommandBar̃nh */
	HWND		m_hwndCBButton ;	/* CommandBar̃{^𑀍삷邽߂̃nh */
	HICON		m_hIcon ;			/* AvACR̃nh */
	HFONT		m_hfont ;
	HWND		m_hwndEditor ;		/* ҏẄ̃nh */
	HWND		m_hwndBuild ;		/* rḧ̃nh */
	HWND		m_hwndDownload ;		/* R\[̈̃nh */
	HWND		m_hwndLastFocus ;	/* tH[JX̂Rg[ */
	TCHAR		m_szPathname[ MAX_PATH ] ;

	RECT		m_rectContent ;		/* ë̋` */
	DWORD		m_dwTopPos ;		/* zuYW */

	DWORD	CreateCommandBar() ;
	void	SetWindowTitle() ;
	BOOL	CheckModify() ;
	BOOL	SelectFolder() ;
	BOOL	DirTree() ;
	void	LayoutControls( void ) ;

public:
	MainWindow( MainApp * ) ;
	~MainWindow() ;

	BOOL	Create() ;
	void	WMCreate( HWND hWnd ) ;
	void	ReadEditor( LPCTSTR szPath ) ;
	void	WMDestroy() ;
	LRESULT	WMCommand( HWND hWnd, UINT msg, WPARAM wp, LPARAM lp ) ;
	void	WMSetFocus() ;
	BOOL	WMClose() ;
	LRESULT	WMWndProc( HWND hWnd,  UINT msg, WPARAM wParam, LPARAM lParam, BOOL *bDefault ) ;
	void	WMInitMenuPopup( HMENU hmenuPopup, UINT uPos, BOOL fSystemMenu ) ;
	void	WMSize( DWORD fwSize, WORD nWidth, WORD nHeight ) ;
	void	EnterContentView() ;
	void	EnterTitleView() ;
	BOOL	FindString() ;
	void	FindStringExec() ;
	BOOL	FindStringForwardFile( DWORD dwStartIndex, LPDWORD pFoundIndex ) ;
	BOOL	New() ;
	BOOL	Open() ;
	BOOL	Open( LPCTSTR szPathname ) ;
	BOOL	Save() ;
	BOOL	SaveAs() ;
	BOOL	SaveToFile( LPCTSTR szPathname ) ;
	BOOL	ChangeView( HWND hwnd ) ;
	BOOL	CompileDownload() ;
	BOOL	Compile() ;
	BOOL	Download() ;

	BOOL	Setup() ;

	static	BOOL	RegisterClass( HINSTANCE hInst ) ;
	static	LPCTSTR	GetClassName() { return szClassName ; }

	static	int		title_proc( int index, const BYTE **ptr, int *len ) ;
} ;

/*-------------------------------------------------------------------------*
 * MainApp
 *-------------------------------------------------------------------------*/
MainApp::MainApp()
{
	m_pMainWnd = 0 ;
}

MainApp::~MainApp()
{
}

BOOL
MainApp::Create( HINSTANCE hInstance )
{
	m_hInst = hInstance ;

	if ( !MainWindow::RegisterClass( m_hInst ) ) {
		return FALSE ;
	}

#ifdef	_WIN32_WCE
	m_hAccl = LoadAccelerators( m_hInst,
								MAKEINTRESOURCE(IDR_ACCELERATOR1) ) ;
#else	/* _WIN32_WCE */
	m_hAccl = LoadAccelerators( GetModuleHandle(NULL),
								MAKEINTRESOURCE(IDR_ACCELERATOR1) ) ;
#endif	/* _WIN32_WCE */

	GetReg() ;

	m_pMainWnd = new MainWindow( this ) ;
	if ( !m_pMainWnd ) {
		return FALSE ;
	}
	if ( !m_pMainWnd->Create() ) {
		return FALSE ;
	}

	/* ʂOʂɂ */
	SetForegroundWindow( m_pMainWnd->get_hwnd() ) ;
	return TRUE ;
}

int
MainApp::Run()
{
	MSG		msg ;

	while ( GetMessage( &msg, NULL, 0, 0 ) ) {
		if ( !TranslateAccelerator( m_pMainWnd->get_hwnd(), m_hAccl, &msg ) ) {
			TranslateMessage( &msg ) ;
		}
		DispatchMessage( &msg ) ;
	}
	return msg.wParam ;
}

#define		REG_BASEKEY			TEXT("Software\\Gawaro\\")
#define		VAR_INCLUDEPATH		TEXT("IncludePath")
#define		VAR_DEFINE			TEXT("Define")
#define		VAR_UNDEFINE		TEXT("Undefine")
#define		VAR_SERIALPORT		TEXT("SerialPort")
#define		VAR_COMPATIBLE		TEXT("Compatible")
#define		VAR_LISTING			TEXT("Listing")
#define		VAR_NOSYSFILE		TEXT("NoSysFile")
#define		VAR_RXTIMEOUT		TEXT("RxTimeout")
#define		VAR_VERBOSE			TEXT("Verbose")
#define		VAR_TARGETMODE		TEXT("TargetMode")
#define		VAR_AUTOSAVE		TEXT("AutoSave")
#define		VAR_FONTNAME		TEXT("FontName")
#define		VAR_FONTHEIGHT		TEXT("FontHeight")

/*
 * WXg̏擾
 */
BOOL
MainApp::GetReg()
{
	HKEY	hk ;
	LONG	lret ;
	LPTSTR	name ;
	LPBYTE	lpData ;
	DWORD	dwType, cbData ;
	TCHAR	subkey[ MAX_PATH ] ;

	_tcscpy( subkey, REG_BASEKEY ) ;
	_tcscat( subkey, szTitleName ) ;
	/* WXgL[I[v */
	lret = RegOpenKeyEx( HKEY_CURRENT_USER, subkey, 0, KEY_QUERY_VALUE, &hk ) ;
	if ( lret != ERROR_SUCCESS ) {
		return FALSE ;
	}
	/* IncludePath */
	name = VAR_INCLUDEPATH ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) g_szIncludePath ;
	cbData = sizeof g_szIncludePath ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* Define */
	name = VAR_DEFINE ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) g_szDefine ;
	cbData = sizeof g_szDefine ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* Undefine */
	name = VAR_UNDEFINE ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) g_szUndefine ;
	cbData = sizeof g_szUndefine ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* SerialPort */
	name = VAR_SERIALPORT ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) g_szSerialPort ;
	cbData = sizeof g_szSerialPort ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* Compatible */
	name = VAR_COMPATIBLE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwCompatible ;
	cbData = sizeof g_dwCompatible ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* HMargin */
	name = VAR_LISTING ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwListing ;
	cbData = sizeof g_dwListing ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* NoSysFile */
	name = VAR_NOSYSFILE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwNoSysFile ;
	cbData = sizeof g_dwNoSysFile ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* RxTimeout */
	name = VAR_RXTIMEOUT ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwRxTimeout ;
	cbData = sizeof g_dwRxTimeout ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* Verbose */
	name = VAR_VERBOSE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwVerbose ;
	cbData = sizeof g_dwVerbose ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* TargetMode */
	name = VAR_TARGETMODE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwTargetMode ;
	cbData = sizeof g_dwTargetMode ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* AutoSave */
	name = VAR_AUTOSAVE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwAutoSave ;
	cbData = sizeof g_dwAutoSave ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* FontName */
	name = VAR_FONTNAME ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) g_szFontName ;
	cbData = sizeof g_szFontName ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* FontHeight */
	name = VAR_FONTHEIGHT ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwFontHeight ;
	cbData = sizeof g_dwFontHeight ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	/* WXgN[Y */
	RegCloseKey( hk ) ;
	return TRUE ;
}

/*
 * WXgւ̏ݒ
 */
BOOL
MainApp::SetReg() const
{
	HKEY	hk ;
	LONG	lret ;
	LPTSTR	name ;
	LPCTSTR	szPtr ;
	LPBYTE	lpData ;
	TCHAR	subkey[ MAX_PATH ] ;
	DWORD	ret, dwType, cbData ;

	_tcscpy( subkey, REG_BASEKEY ) ;
	_tcscat( subkey, szTitleName ) ;
	/* WXgL[쐬 */
	lret = RegCreateKeyEx( HKEY_CURRENT_USER, subkey, 0, TEXT(""), 0,
#ifdef	_WIN32_WCE
						   0,
#else	/* _WIN32_WCE */
						   KEY_ALL_ACCESS,
#endif	/* _WIN32_WCE */
						   NULL, &hk, &ret ) ;
	if ( lret != ERROR_SUCCESS ) {
		return FALSE ;
	}
	/* IncludePath */
	szPtr = g_szIncludePath ;
	name = VAR_INCLUDEPATH ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) szPtr ;
	cbData = (_tcslen(szPtr) + 1) * sizeof (*szPtr) ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* Define */
	szPtr = g_szDefine ;
	name = VAR_DEFINE ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) szPtr ;
	cbData = (_tcslen(szPtr) + 1) * sizeof (*szPtr) ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* Undefine */
	szPtr = g_szUndefine ;
	name = VAR_UNDEFINE ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) szPtr ;
	cbData = (_tcslen(szPtr) + 1) * sizeof (*szPtr) ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* SerialPort */
	szPtr = g_szSerialPort ;
	name = VAR_SERIALPORT ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) szPtr ;
	cbData = (_tcslen(szPtr) + 1) * sizeof (*szPtr) ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* Compatible */
	name = VAR_COMPATIBLE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwCompatible ;
	cbData = sizeof g_dwCompatible ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* Listing */
	name = VAR_LISTING ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwListing ;
	cbData = sizeof g_dwListing ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* NoSysFile */
	name = VAR_NOSYSFILE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwNoSysFile ;
	cbData = sizeof g_dwNoSysFile ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* RxTimeout */
	name = VAR_RXTIMEOUT ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwRxTimeout ;
	cbData = sizeof g_dwRxTimeout ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* Verbose */
	name = VAR_VERBOSE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwVerbose ;
	cbData = sizeof g_dwVerbose ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* TargetMode */
	name = VAR_TARGETMODE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwTargetMode ;
	cbData = sizeof g_dwTargetMode ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* AutoSave */
	name = VAR_AUTOSAVE ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwAutoSave ;
	cbData = sizeof g_dwAutoSave ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* FontName */
	szPtr = g_szFontName ;
	name = VAR_FONTNAME;
	dwType = REG_SZ ;
	lpData = (LPBYTE) szPtr ;
	cbData = (_tcslen(szPtr) + 1) * sizeof (*szPtr) ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* FontHeight */
	name = VAR_FONTHEIGHT ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &g_dwFontHeight ;
	cbData = sizeof g_dwFontHeight ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	/* WXgN[Y */
	RegCloseKey( hk ) ;
	return TRUE ;
}

/*
 * WXg폜
 */
void
MainApp::DeleteReg() const
{
	TCHAR	subkey[ MAX_PATH ] ;

	_tcscpy( subkey, REG_BASEKEY ) ;
	_tcscat( subkey, szTitleName ) ;
	RegDeleteKey( HKEY_CURRENT_USER, subkey ) ;
}

/*-------------------------------------------------------------------------*
 * MainWindow
 *-------------------------------------------------------------------------*/
MainWindow::MainWindow( MainApp *pApp )
{
	m_pApp = pApp ;
	m_hIcon = 0 ;
	m_hfont = 0 ;
	m_hwndLastFocus = 0 ;
	*m_szPathname = TEXT('\0') ;
}

MainWindow::~MainWindow()
{
	if ( m_hIcon ) {
		::DeleteObject( m_hIcon ) ;
	}
	if ( m_hfont ) {
		::DeleteObject( m_hfont ) ;
	}
}

/*
 * Rg[̉ʓʒuvZ
 */
void
MainWindow::LayoutControls( void )
{
	RECT		rect ;
	DWORD		tw, th ;
	DWORD		x1, x2, x3, y1, y2, y3 ;
	DWORD		w1, w2, w3, h1, h2, h3 ;

	/* \̈߂ */
	GetClientRect( m_hwnd, &rect ) ;
	tw = rect.right ;
	th = rect.bottom ;
	/* Rg[̔zuvZ */
	x1 = x2 = x3 = 0 ;
	y1 = y2 = y3 = m_dwTopPos ;
	w1 = w2 = tw - 2 ;
	w3 = 2 ;
	h1 = h2 = h3 = th - m_dwTopPos ;
	/* e̋`쐬 */
	m_rectContent.left = x2 ;
	m_rectContent.top = y2 ;
	m_rectContent.right = x2 + w2 ;
	m_rectContent.bottom = y2 + h2 ;
}

void
MainWindow::WMCreate( HWND hWnd )
{
	HINSTANCE	hInst = m_pApp->get_inst() ;

	m_hwnd = hWnd ;
	/* ACR쐬^XNo[ɓo^ */
	m_hIcon = (HICON) LoadImage( m_pApp->get_inst(), MAKEINTRESOURCE(IDI_APPICON),
								 IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR ) ;
	if ( m_hIcon ) {
		SendMessage( hWnd, WM_SETICON, FALSE, (LPARAM)m_hIcon ) ;
	}
	/* R}ho[ǉ */
	m_dwTopPos = 2 ;
	m_dwTopPos += CreateCommandBar() ;
	/* Rg[̔zuvZ */
	LayoutControls() ;

	m_hwndEditor = CreateWindow( TEXT("EDIT"),
						TEXT(""),
						WS_CHILD|WS_VISIBLE|WS_BORDER|WS_TABSTOP|WS_VSCROLL|
						ES_MULTILINE,
						m_rectContent.left,
						m_rectContent.top,
						m_rectContent.right - m_rectContent.left,
						m_rectContent.bottom - m_rectContent.top,
						hWnd,
						(HMENU) IDC_EDITOR,
						hInst,
						0 ) ;
	SendMessage( m_hwndEditor, EM_FMTLINES, (WPARAM) FALSE, 0 ) ;

	m_hwndBuild = CreateWindow( TEXT("EDIT"),
						TEXT(""),
						WS_CHILD|WS_BORDER|WS_TABSTOP|WS_VSCROLL|
						ES_MULTILINE,
						m_rectContent.left,
						m_rectContent.top,
						m_rectContent.right - m_rectContent.left,
						m_rectContent.bottom - m_rectContent.top,
						hWnd,
						(HMENU) IDC_BUILD,
						hInst,
						0 ) ;

	m_hwndDownload = CreateWindow( TEXT("EDIT"),
						TEXT(""),
						WS_CHILD|WS_BORDER|WS_TABSTOP|WS_VSCROLL|
						ES_MULTILINE,
						m_rectContent.left,
						m_rectContent.top,
						m_rectContent.right - m_rectContent.left,
						m_rectContent.bottom - m_rectContent.top,
						hWnd,
						(HMENU) IDC_DOWNLOAD,
						hInst,
						0 ) ;
	if ( *g_szFontName && g_dwFontHeight ) {
		/* tHg쐬 */
		m_hfont = CreateSpecifiedFont( m_hwnd ) ;
		if ( m_hfont ) {
			SendMessage( m_hwndEditor,   WM_SETFONT, (WPARAM) m_hfont, MAKELPARAM(TRUE, 0) ) ;
			SendMessage( m_hwndBuild,    WM_SETFONT, (WPARAM) m_hfont, MAKELPARAM(FALSE, 0) ) ;
			SendMessage( m_hwndDownload, WM_SETFONT, (WPARAM) m_hfont, MAKELPARAM(FALSE, 0) ) ;
		}
	}
	if ( *g_szArgs ) {
		/* Ŏw肵t@Cǂ݂ */
		Open( g_szArgs ) ;
	} else {
		/* tH[JXݒ肷 */
		ChangeView( m_hwndEditor ) ;
	}
}

/*
 * ҏẄɃt@Ceǂݍ
 */
void
MainWindow::ReadEditor( LPCTSTR szPath )
{
	/* ҏẄ̓eNA */
	SetWindowText( m_hwndEditor, TEXT("") ) ;
}

void
MainWindow::WMDestroy()
{
	PostQuitMessage( 0 ) ;
}

LRESULT
MainWindow::WMCommand( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	WORD		idCtrl = LOWORD(wParam) ;
	WORD		notifyCode = HIWORD(wParam) ;

	switch ( idCtrl ) {
	case IDM_UNDO:
		SendMessage( m_hwndLastFocus, WM_UNDO, 0, 0 ) ;
		break ;
	case IDM_CUT:
		SendMessage( m_hwndLastFocus, WM_CUT, 0, 0 ) ;
		break ;
	case IDM_COPY:
		SendMessage( m_hwndLastFocus, WM_COPY, 0, 0 ) ;
		break ;
	case IDM_PASTE:
		SendMessage( m_hwndLastFocus, WM_PASTE, 0, 0 ) ;
		break ;
	case IDM_DELETE:
		SendMessage( m_hwndLastFocus, EM_REPLACESEL, (WPARAM) TRUE, (LPARAM) TEXT("") ) ;
		break ;
	case IDM_SELECTALL:
		SendMessage( m_hwndLastFocus, EM_SETSEL, 0, (LPARAM) -1 ) ;
		break ;
	case IDM_NEW:
		/* VKɂ */
		New() ;
		break ;
	case IDM_OPEN:
		/* t@Cǂ݂ */
		Open() ;
		break ;
	case IDM_SAVE:
		/* ҏW̕t@Cɕۑ */
		Save() ;
		break ;
	case IDM_SAVEAS:
		/* ҏW̕t@Cɕۑ */
		SaveAs() ;
		break ;
	case IDM_EXIT:
		PostMessage( hWnd, WM_CLOSE, 0, 0 ) ;
		break ;
	case IDM_VIEW_EDITOR:
		ChangeView( m_hwndEditor ) ;
		break ;
	case IDM_VIEW_BUILD:
		ChangeView( m_hwndBuild ) ;
		break ;
	case IDM_VIEW_DOWNLOAD:
		ChangeView( m_hwndDownload ) ;
		break ;
	case IDM_COMPILEDOWNLOAD:
		CompileDownload() ;
		break ;
	case IDM_COMPILE:
		Compile() ;
		break ;
	case IDM_DOWNLOAD:
		Download() ;
		break ;
	case IDM_SETUP:
		/* IvVݒs */
		Setup() ;
		break ;
	case IDC_EDITOR:
	case IDC_BUILD:
	case IDC_DOWNLOAD:
		if ( notifyCode == EN_SETFOCUS ) {
			m_hwndLastFocus = (HWND) lParam ;
		}
		break ;
	case IDM_PROGRAM1:
		ChangeView( m_hwndDownload ) ;
		CE_change_program( 0, m_hwndDownload ) ;
		break ;
	case IDM_PROGRAM2:
		ChangeView( m_hwndDownload ) ;
		CE_change_program( 1, m_hwndDownload ) ;
		break ;
	case IDM_PROGRAM3:
		ChangeView( m_hwndDownload ) ;
		CE_change_program( 2, m_hwndDownload ) ;
		break ;
	case IDM_PROGRAM4:
		ChangeView( m_hwndDownload ) ;
		CE_change_program( 3, m_hwndDownload ) ;
		break ;
	case IDM_PROGRAM5:
		ChangeView( m_hwndDownload ) ;
		CE_change_program( 4, m_hwndDownload ) ;
		break ;
	case IDM_RUN:
		ChangeView( m_hwndDownload ) ;
		CE_run_program( TRUE, m_hwndDownload ) ;
		break ;
	case IDM_STOP:
		ChangeView( m_hwndDownload ) ;
		CE_run_program( FALSE, m_hwndDownload ) ;
		break ;
	}
	return 0 ;
}

BOOL
MainWindow::WMClose()
{
	/* e\ɉύX𔽉f */
	if ( !CheckModify() ) {
		return TRUE ;
	}
	if ( g_bDeleteReg ) {
		m_pApp->DeleteReg() ;
	} else {
		m_pApp->SetReg() ;
	}
	return FALSE ;
}

void
MainWindow::WMSetFocus()
{
	if ( m_hwndLastFocus ) {
		SetFocus( m_hwndLastFocus ) ;
	}
}

LRESULT
MainWindow::WMWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam, BOOL *bDefault )
{
	BOOL	bChanged = FALSE ;

	*bDefault = FALSE ;
	switch ( msg ) {
	case WM_INITMENUPOPUP:
		WMInitMenuPopup( (HMENU) wParam, (UINT) LOWORD(lParam), (BOOL) HIWORD(lParam) ) ;
		break ;
	case WM_HELP:
		DialogBox( g_hInst, MAKEINTRESOURCE(IDD_DLG_ABOUT), hWnd, AboutDlgFunc ) ;
		if ( g_bDeleteReg ) {
			SendMessage( hWnd, WM_COMMAND, IDM_EXIT, 0 ) ;
		}
		break ;
	default:
		*bDefault = TRUE ;
		break ;
	}
	return 0 ;
}

void
MainWindow::WMInitMenuPopup( HMENU hmenuPopup, UINT uPos, BOOL fSystemMenu )
{
	MENUITEMINFO	mii ;
	UINT			uEnable ;
	HWND			hwndCtrl ;
	DWORD			dwStart, dwEnd ;

	hwndCtrl = GetFocus() ;
	memset( &mii, 0, sizeof mii ) ;
	switch ( uPos ) {
	case 0:
		EnableMenuItem( hmenuPopup, IDM_SAVE,
						MF_BYCOMMAND | (SendMessage( m_hwndEditor, EM_GETMODIFY, 0, 0 ) ? 0 : MF_GRAYED ) ) ;
		break ;
	case 1:
		EnableMenuItem( hmenuPopup, IDM_UNDO,
			MF_BYCOMMAND | (SendMessage( m_hwndLastFocus, EM_CANUNDO, 0, 0 ) ? 0 : MF_GRAYED) ) ;
		SendMessage( m_hwndLastFocus, EM_GETSEL, (WPARAM) &dwStart, (LPARAM) &dwEnd ) ;
		EnableMenuItem( hmenuPopup, IDM_CUT, MF_BYCOMMAND | (dwStart == dwEnd ? MF_GRAYED : 0) ) ;
		uEnable = MF_BYCOMMAND ;
		EnableMenuItem( hmenuPopup, IDM_COPY, uEnable ) ;
		EnableMenuItem( hmenuPopup, IDM_PASTE, uEnable ) ;
		EnableMenuItem( hmenuPopup, IDM_DELETE, uEnable ) ;
		EnableMenuItem( hmenuPopup, IDM_SELECTALL, uEnable ) ;
		break ;
	case 2:
		CheckMenuItem( hmenuPopup, IDM_VIEW_EDITOR,
					   MF_BYCOMMAND | (IsWindowVisible( m_hwndEditor ) ? MF_CHECKED : MF_UNCHECKED) ) ;
		CheckMenuItem( hmenuPopup, IDM_VIEW_BUILD,
					   MF_BYCOMMAND | (IsWindowVisible( m_hwndBuild ) ? MF_CHECKED : MF_UNCHECKED) ) ;
		CheckMenuItem( hmenuPopup, IDM_VIEW_DOWNLOAD,
					   MF_BYCOMMAND | (IsWindowVisible( m_hwndDownload ) ? MF_CHECKED : MF_UNCHECKED) ) ;
		break ;
	}
}

void
MainWindow::WMSize( DWORD fwSize, WORD nWidth, WORD nHeight )
{
	LayoutControls() ;
	SetWindowPos( m_hwndEditor, 0, 0, 0,
				  m_rectContent.right - m_rectContent.left,
				  m_rectContent.bottom - m_rectContent.top,
				  SWP_NOMOVE|SWP_NOZORDER ) ;
	SetWindowPos( m_hwndBuild, 0, 0, 0,
				  m_rectContent.right - m_rectContent.left,
				  m_rectContent.bottom - m_rectContent.top,
				  SWP_NOMOVE|SWP_NOZORDER ) ;
	SetWindowPos( m_hwndDownload, 0, 0, 0,
				  m_rectContent.right - m_rectContent.left,
				  m_rectContent.bottom - m_rectContent.top,
				  SWP_NOMOVE|SWP_NOZORDER ) ;
}

/*
 * EBhE^Cgݒ肷
 */
void
MainWindow::SetWindowTitle()
{
	SetWindowText( m_hwnd, g_szTitleName ) ;
}

/*
 * e\̈ɉC𔽉f
 */
BOOL
MainWindow::CheckModify()
{
	DWORD	dwRet ;

	if ( !SendMessage( m_hwndEditor, EM_GETMODIFY, 0, 0 ) ) {
		/* CȂꍇ */
		return TRUE ;
	}
	/* t@Cɕۑ邩ǂq˂ */
	wsprintf( g_szMessageBuf, TEXT("Save changes?") ) ;
	dwRet = MessageBox( m_hwnd, g_szMessageBuf, TEXT("Save File"), MB_YESNOCANCEL|MB_ICONQUESTION ) ;
	if ( dwRet == IDCANCEL ) {
		/* LZꂽꍇ */
		return FALSE ;
	} else if ( dwRet == IDYES ) {
		/* t@Cɕۑ */
		if ( !*m_szPathname ) {
			/* t@C̏ꍇ͖Otĕۑ */
			if ( !SaveAs() ) {
				return FALSE ;
			}
		} else if ( !SaveToFile( m_szPathname ) ) {
			return FALSE ;
		}
	}
	/* CtONA */
	SendMessage( m_hwndEditor, EM_SETMODIFY, (WPARAM) FALSE, 0 ) ;
	return TRUE ;
}

/*
 * Vt@C쐬
 */
BOOL
MainWindow::New()
{
	/* ҏWǂ`FbN */
	if ( !CheckModify() ) {
		return FALSE ;
	}
	/* t@CNA */
	*m_szPathname = TEXT('\0') ;
	/* ҏWeNA */
	SetWindowText( m_hwndEditor, TEXT("") ) ;
	/* EBhE^CgZbg */
	SetWindowText( m_hwnd, szTitleName ) ;
	/* ҏẄɐ؂ւ */
	ChangeView( m_hwndEditor ) ;
	return TRUE ;
}

/*
 * t@Cǂ݂
 */
BOOL
MainWindow::Open()
{
	OPENFILENAME	ofn ;
	TCHAR			szPathname[ MAX_PATH ] ;
	TCHAR			szInitDir[ MAX_PATH ], *ptr ;

	/* ҏWǂ`FbN */
	if ( !CheckModify() ) {
		return FALSE ;
	}
	/* \fBNg쐬 */
	_tcscpy( szInitDir, m_szPathname ) ;
	ptr = _tcsrchr( szInitDir, TEXT('\\') ) ;
	if ( ptr && ptr != szInitDir ) {
		*ptr = TEXT('\0') ;
	}
	*szPathname = TEXT('\0') ;
	/* t@CI[v_CAOJ */
	memset( &ofn, 0, sizeof ofn ) ;
	ofn.lStructSize = sizeof ofn ;
	ofn.hwndOwner = m_hwnd ;
	ofn.hInstance = g_hInst ;
	ofn.lpstrFilter = TEXT("NQC Files (*.NQC)\0*.NQC\0All Files (*.*)\0*.*\0\0") ;
	ofn.lpstrCustomFilter = NULL ;
	ofn.nMaxCustFilter = 0 ;
	ofn.nFilterIndex = 1 ;
	ofn.lpstrFile = szPathname ;
	ofn.nMaxFile = MAX_PATH ;
	ofn.lpstrFileTitle = NULL ;
	ofn.nMaxFileTitle = 0 ;
	ofn.lpstrInitialDir = szInitDir ;
	ofn.lpstrTitle = NULL ;
	ofn.Flags = 0 ;
	ofn.nFileOffset = 0 ;
	ofn.nFileExtension = 0 ;
	ofn.lpstrDefExt = TEXT("NQC") ;
	ofn.lCustData = 0 ;
	ofn.lpfnHook = NULL ;
	ofn.lpTemplateName = NULL ;
	if ( !GetOpenFileName( &ofn ) ) {
		return FALSE ;
	}
	return Open( szPathname ) ;
}

/*
 * w肵t@Cǂ݂
 */
BOOL
MainWindow::Open( LPCTSTR szPathname )
{
	CEFILE		*fp ;
	BOOL		bError ;
#ifdef	UNICODE
	DWORD		ret ;
	LPTSTR		szUnicode ;
#endif	/* UNICODE */
	DWORD		len, dwLineno ;
	CHAR		szSjis[ 256 ], *ptr ;

	bError = FALSE ;
	dwLineno = 0 ;
	AttachWinToStream( CE_stdout, m_hwndBuild ) ;
	AttachWinToStream( CE_stderr, m_hwndBuild ) ;
	/* ҏẄɃt@Cǂ݂ */
	fp = FopenW( szPathname, TEXT("r") ) ;
	if ( fp == NULL ) {
		MessageBox( m_hwnd, TEXT("Can't open file"), TEXT("Error"), MB_OK|MB_ICONHAND ) ;
		return FALSE ;
	}
	SetWindowText( m_hwndEditor, TEXT("") ) ;
	ShowWindow( m_hwndEditor, SW_HIDE ) ;
	while ( !Feof( fp ) ) {
		dwLineno ++ ;
		/* 1sǂ݂ */
		Fgets( szSjis, sizeof szSjis - 2, fp ) ;
		ptr = strchr( szSjis, '\n' ) ;
		if ( ptr ) {
			/* sCRLFɂ */
			*ptr++ = '\r' ;
			*ptr++ = '\n' ;
			*ptr++ = '\0' ;
		}
#ifdef	UNICODE
		/* UNICODEϊɕKvȕ𓾂 */
		len = strlen( szSjis ) + 1 ;
		ret = Mbstowcs( NULL, szSjis, len ) ;
		if ( ret == -1 ) {
			/* UNICODEɕϊłȂꍇ */
			Fputs( "Error in reading file\n", CE_stderr ) ;
			Sprintf( szSjis, "Illegal character in Line: %d\n", dwLineno ) ;
			Fputs( szSjis, CE_stderr ) ;
			bError = TRUE ;
			break ;
		}
		szUnicode = (LPTSTR) LocalAlloc( LPTR, (ret + 1) * sizeof (TCHAR) ) ;
		if ( szUnicode ) {
			/* UNICODEɕϊ */
			Mbstowcs( szUnicode, szSjis, len ) ;
			/* ҏẄɒǉ */
			len = GetWindowTextLength( m_hwndEditor ) ;
			SendMessage( m_hwndEditor, EM_SETSEL, (WPARAM) len, (LPARAM) len ) ;
			SendMessage( m_hwndEditor, EM_REPLACESEL, (WPARAM) FALSE, (LPARAM) szUnicode ) ;
			LocalFree( szUnicode ) ;
		}
#else	/* UNICODE */
			/* ҏẄɒǉ */
			len = GetWindowTextLength( m_hwndEditor ) ;
			SendMessage( m_hwndEditor, EM_SETSEL, (WPARAM) len, (LPARAM) len ) ;
			SendMessage( m_hwndEditor, EM_REPLACESEL, (WPARAM) FALSE, (LPARAM) szSjis ) ;
#endif	/* UNICODE */
	}
	Fclose( fp ) ;
	/* ҏẄ̐擪ɃJ[\Zbg */
	SendMessage( m_hwndEditor, EM_SETSEL, (WPARAM) 0, (LPARAM) 0 ) ;
	SendMessage( m_hwndEditor, EM_SCROLLCARET, (WPARAM) 0, (LPARAM) 0 ) ;
	/* CtONA */
	SendMessage( m_hwndEditor, EM_SETMODIFY, (WPARAM) FALSE, 0 ) ;
	if ( bError ) {
		/* G[ꍇ */
		*m_szPathname = TEXT('\0') ;
		/* rḧ\ */
		ChangeView( m_hwndBuild ) ;
	} else {
		/* G[Ȃꍇ */
		_tcscpy( m_szPathname, szPathname ) ;
		/* ҏẄ\ */
		ChangeView( m_hwndEditor ) ;
	}
	return TRUE ;
}

/*
 * t@Cۑ
 */
BOOL
MainWindow::Save()
{
	if ( !*m_szPathname ) {
		return SaveAs() ;
	}
	return SaveToFile( m_szPathname ) ;
}

/*
 * t@Cʖŕۑ
 */
BOOL
MainWindow::SaveAs()
{
	OPENFILENAME	ofn ;
	TCHAR			szPathname[ MAX_PATH ] ;
	TCHAR			szInitDir[ MAX_PATH ], *ptr ;

	/* \fBNg쐬 */
	_tcscpy( szInitDir, m_szPathname ) ;
	ptr = _tcsrchr( szInitDir, TEXT('\\') ) ;
	if ( ptr && ptr != szInitDir ) {
		*ptr = TEXT('\0') ;
	}
	*szPathname = TEXT('\0') ;
	/* t@CI[v_CAOJ */
	memset( &ofn, 0, sizeof ofn ) ;
	ofn.lStructSize = sizeof ofn ;
	ofn.hwndOwner = m_hwnd ;
	ofn.hInstance = g_hInst ;
	ofn.lpstrFilter = TEXT("NQC Files (*.NQC)\0*.NQC\0All Files (*.*)\0*.*\0\0") ;
	ofn.lpstrCustomFilter = NULL ;
	ofn.nMaxCustFilter = 0 ;
	ofn.nFilterIndex = 1 ;
	ofn.lpstrFile = szPathname ;
	ofn.nMaxFile = MAX_PATH ;
	ofn.lpstrFileTitle = NULL ;
	ofn.nMaxFileTitle = 0 ;
	ofn.lpstrInitialDir = szInitDir ;
	ofn.lpstrTitle = NULL ;
	ofn.Flags = 0 ;
	ofn.nFileOffset = 0 ;
	ofn.nFileExtension = 0 ;
	ofn.lpstrDefExt = TEXT("NQC") ;
	ofn.lCustData = 0 ;
	ofn.lpfnHook = NULL ;
	ofn.lpTemplateName = NULL ;
	if ( !GetSaveFileName( &ofn ) ) {
		return FALSE ;
	}
	/* t@Cɑ݂邩ǂׂ */
	if ( GetFileAttributes( szPathname ) != 0xFFFFFFFF ) {
		if ( MessageBox( m_hwnd, TEXT("Replace existing file?"), TEXT("Save As"), MB_YESNO|MB_ICONQUESTION ) != IDYES ) {
			return FALSE ;
		}
	}
	return SaveToFile( szPathname ) ;
}

/*
 * ҏẄ̓et@Cɕۑ
 */
BOOL
MainWindow::SaveToFile( LPCTSTR szPathname )
{
	CEFILE		*fp ;
	BOOL		bError ;
#ifdef	UNICODE
	DWORD		ret ;
	CHAR		*szSjis ;
#endif	/* UNICODE */
	TCHAR		szUnicode[ 256 ] ;
	DWORD		dwNumline, i, len ;

	bError = FALSE ;
	AttachWinToStream( CE_stdout, m_hwndBuild ) ;
	AttachWinToStream( CE_stderr, m_hwndBuild ) ;
	/* ۑt@CJ */
	fp = FopenW( szPathname, TEXT("wb") ) ;
	if ( fp == NULL ) {
		MessageBox( m_hwnd, TEXT("Can't save file"), TEXT("Error"), MB_OK|MB_ICONHAND ) ;
		return FALSE ;
	}
	/* ҏẄ̍s𓾂 */
	dwNumline = SendMessage( m_hwndEditor, EM_GETLINECOUNT, 0, 0 ) ;
	for ( i = 0 ; i < dwNumline ; i ++ ) {
		/* isڂ̍s𓾂 */
		*(LPWORD)szUnicode = sizeof szUnicode / sizeof *szUnicode ;
		len = SendMessage( m_hwndEditor, EM_GETLINE, (WPARAM) i, (LPARAM) szUnicode ) ;
		if ( i != dwNumline - 1 ) {
			szUnicode[ len ++ ] = TEXT('\r') ;
			szUnicode[ len ++ ] = TEXT('\n') ;
		}
		szUnicode[ len ++ ] = TEXT('\0') ;
#ifdef	UNICODE
		/* Shift-JISϊɕKvȕ𓾂 */
		ret = Wcstombs( NULL, szUnicode, 0 ) ;
		if ( ret == -1 ) {
			/* Shift-JISɕϊłȂꍇ */
			Fputs( "Error in writing file\n", CE_stderr ) ;
			Sprintf( szSjis, "Illegal character in Line: %d\n", i + 1 ) ;
			Fputs( szSjis, CE_stderr ) ;
			bError = TRUE ;
			break ;
		}
		szSjis = (LPSTR) LocalAlloc( LPTR, ret + 1 ) ;
		if ( szSjis ) {
			/* Shift-JISɕϊ */
			Wcstombs( szSjis, szUnicode, ret ) ;
			Fputs( szSjis, fp ) ;
			LocalFree( szSjis ) ;
		}
#else	/* UNICODE */
		Fputs( szUnicode, fp ) ;
#endif	/* UNICODE */
	}
	Fclose( fp ) ;
	if ( bError ) {
		/* G[ꍇ */
		/* rḧ\ */
		ChangeView( m_hwndBuild ) ;
	} else {
		/* G[Ȃꍇ */
		_tcscpy( m_szPathname, szPathname ) ;
		/* CtONA */
		SendMessage( m_hwndEditor, EM_SETMODIFY, (WPARAM) FALSE, 0 ) ;
	}
	return TRUE ;
}

/*
 * \ʂ؂ւ
 */
BOOL
MainWindow::ChangeView( HWND hwnd )
{
	if ( IsWindowVisible( hwnd ) ) {
		/* ɕ\Ăꍇ͉Ȃ */
		return FALSE ;
	}
	/* EBhE\ */
	ShowWindow( hwnd, SW_SHOW ) ;
	SetFocus( hwnd ) ;
	/* \ĂEBhEB */
	if ( hwnd != m_hwndEditor ) {
		ShowWindow( m_hwndEditor, SW_HIDE ) ;
	}
	if ( hwnd != m_hwndBuild ) {
		ShowWindow( m_hwndBuild, SW_HIDE ) ;
	}
	if ( hwnd != m_hwndDownload ) {
		ShowWindow( m_hwndDownload, SW_HIDE ) ;
	}
#ifdef	_WIN32_WCE
	/* R}h{^̃IIt؂ւ */
	SendMessage( m_hwndCBButton, TB_CHECKBUTTON, IDM_VIEW_EDITOR, hwnd == m_hwndEditor ) ;
	SendMessage( m_hwndCBButton, TB_CHECKBUTTON, IDM_VIEW_BUILD, hwnd == m_hwndBuild ) ;
	SendMessage( m_hwndCBButton, TB_CHECKBUTTON, IDM_VIEW_DOWNLOAD, hwnd == m_hwndDownload ) ;
#endif	/* _WIN32_WCE */
	UpdateWindow( hwnd ) ;
	return TRUE ;
}

/*
 * RpCAKvɉă_E[h
 */
BOOL
MainWindow::CompileDownload()
{
	ChangeView( m_hwndBuild ) ;
	if ( !CE_compile_sub( m_hwndEditor, m_hwndBuild ) ) {
		return FALSE ;
	}
	ChangeView( m_hwndDownload ) ;
	if ( !CE_download_sub( m_hwndDownload ) ) {
		return FALSE ;
	}
	return TRUE ;
}

/*
 * RpCAKvɉă_E[h
 */
BOOL
MainWindow::Compile()
{
	TCHAR		szRcxPathname[ MAX_PATH ] ;

	if ( g_dwAutoSave ) {
		if ( !*m_szPathname ) {
			/* t@C̏ꍇ͕ۑĂRpC */
			if ( !SaveAs() ) {
				return FALSE ;
			}
		} else if ( SendMessage( m_hwndEditor, EM_GETMODIFY, 0, 0 ) ) {
			/* ύXꍇ̓t@Cۑ */
			if ( !SaveToFile( m_szPathname ) ) {
				return FALSE ;
			}
		}
	}
	ChangeView( m_hwndBuild ) ;
	if ( !CE_compile_main( m_hwndEditor, m_hwndBuild, m_szPathname, szRcxPathname ) ) {
		return FALSE ;
	}
	return TRUE ;
}

/*
 * RCXt@Cǂ݂݁A_E[h
 */
BOOL
MainWindow::Download()
{
	OPENFILENAME	ofn ;
	TCHAR			szPathname[ MAX_PATH ] ;
	TCHAR			szInitDir[ MAX_PATH ], *ptr ;

	/* \fBNg쐬 */
	_tcscpy( szInitDir, m_szPathname ) ;
	ptr = _tcsrchr( szInitDir, TEXT('\\') ) ;
	if ( ptr && ptr != szInitDir ) {
		*ptr = TEXT('\0') ;
	}
	*szPathname = TEXT('\0') ;
	/* t@CI[v_CAOJ */
	memset( &ofn, 0, sizeof ofn ) ;
	ofn.lStructSize = sizeof ofn ;
	ofn.hwndOwner = m_hwnd ;
	ofn.hInstance = g_hInst ;
	ofn.lpstrFilter = TEXT("RCX Files (*.RCX)\0*.RCX\0All Files (*.*)\0*.*\0\0") ;
	ofn.lpstrCustomFilter = NULL ;
	ofn.nMaxCustFilter = 0 ;
	ofn.nFilterIndex = 1 ;
	ofn.lpstrFile = szPathname ;
	ofn.nMaxFile = MAX_PATH ;
	ofn.lpstrFileTitle = NULL ;
	ofn.nMaxFileTitle = 0 ;
	ofn.lpstrInitialDir = szInitDir ;
	ofn.lpstrTitle = NULL ;
	ofn.Flags = 0 ;
	ofn.nFileOffset = 0 ;
	ofn.nFileExtension = 0 ;
	ofn.lpstrDefExt = TEXT("RCX") ;
	ofn.lCustData = 0 ;
	ofn.lpfnHook = NULL ;
	ofn.lpTemplateName = NULL ;
	if ( !GetOpenFileName( &ofn ) ) {
		return FALSE ;
	}
	ChangeView( m_hwndDownload ) ;
	if ( !CE_download_main( szPathname, m_hwndDownload ) ) {
		return FALSE ;
	}
	return TRUE ;
}

/*
 * ZbgAbv_CAOo
 */
BOOL
MainWindow::Setup()
{
	HFONT	hfont ;
	DWORD	dwFontHeight ;
	TCHAR	szFontName[ MAX_PATH ] ;

	_tcscpy( szFontName, g_szFontName ) ;
	dwFontHeight = g_dwFontHeight ;
	if ( !SetupDialogExec( m_hwnd ) ) {
		return FALSE ;
	}
	if ( _tcsicmp( szFontName, g_szFontName ) || dwFontHeight != g_dwFontHeight ) {
		/* tHg쐬 */
		hfont = CreateSpecifiedFont( m_hwnd ) ;
		if ( hfont ) {
			/* tHgݒ肷 */
			SendMessage( m_hwndEditor,   WM_SETFONT, (WPARAM) hfont, MAKELPARAM(TRUE, 0) ) ;
			SendMessage( m_hwndBuild,    WM_SETFONT, (WPARAM) hfont, MAKELPARAM(FALSE, 0) ) ;
			SendMessage( m_hwndDownload, WM_SETFONT, (WPARAM) hfont, MAKELPARAM(FALSE, 0) ) ;
			/* ̃tHg폜 */
			if ( m_hfont ) {
				::DeleteObject( m_hfont ) ;
			}
			m_hfont = hfont ;
		}
	}
	return TRUE ;
}

BOOL
MainWindow::Create()
{
	HWND	hWnd = CreateWindowEx( 0,
						GetClassName(),
						g_szTitleName,
#ifdef	_WIN32_WCE
						WS_VISIBLE,
						0, 0, CW_USEDEFAULT, CW_USEDEFAULT,
#else	/* _WIN32_WCE */
						WS_VISIBLE|WS_SIZEBOX|WS_CAPTION|WS_SYSMENU,
						0, 0, CW_USEDEFAULT, CW_USEDEFAULT,
#endif	/* _WIN32_WCE */
						NULL,
						NULL,
						m_pApp->get_inst(),
						this ) ;
	if ( hWnd == 0 ) {
		return FALSE ;
	}
    ShowWindow( hWnd, SW_SHOW ) ;
    UpdateWindow( hWnd ) ;
    return TRUE ;
}

DWORD
MainWindow::CreateCommandBar()
{
	HINSTANCE	hInst = m_pApp->get_inst() ;

#ifdef	_WIN32_WCE
	static LPCTSTR	szTooltips[] = {
		TEXT(""),
		TEXT("New"), TEXT("Open"), TEXT("Save"),
		TEXT("Cut"), TEXT("Copy"), TEXT("Paste"),
		TEXT("Editor"), TEXT("Build"), TEXT("Download")
	} ;
	TBBUTTON	g_tbWideButton[] = {
		{ 0,                0, TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
		{ 6,          IDM_NEW, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0,  0},
		{ 7,         IDM_OPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0,  1},
		{ 8,         IDM_SAVE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0,  2},
		{ 0,                0, TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
		{ 0,          IDM_CUT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0,  3},
		{ 1,         IDM_COPY, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0,  4},
		{ 2,        IDM_PASTE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0,  5},
		{ 0,                0, TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
		{15,  IDM_VIEW_EDITOR, TBSTATE_ENABLED, TBSTYLE_CHECK,  0, 0, 0,  6},
		{16,   IDM_VIEW_BUILD, TBSTATE_ENABLED, TBSTYLE_CHECK,  0, 0, 0,  7},
		{17,IDM_VIEW_DOWNLOAD, TBSTATE_ENABLED, TBSTYLE_CHECK,  0, 0, 0,  8},
	} ;
#if		(_WIN32_WCE < 200) | (defined (SH4))
	TBBUTTON	g_tbNarrowButton[] = {
		{ 0,                0, TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
		{15,  IDM_VIEW_EDITOR, TBSTATE_ENABLED, TBSTYLE_BUTTON|TBSTYLE_CHECKED, 0, 0, 0,  6},
		{16,   IDM_VIEW_BUILD, TBSTATE_ENABLED, TBSTYLE_BUTTON|TBSTYLE_CHECKED, 0, 0, 0,  7},
		{17,IDM_VIEW_DOWNLOAD, TBSTATE_ENABLED, TBSTYLE_BUTTON|TBSTYLE_CHECKED, 0, 0, 0,  8},
	} ;

	m_hwndCB = CommandBar_Create( hInst, m_hwnd, 0 ) ;
	CommandBar_AddToolTips( m_hwndCB, sizeof (szTooltips) / sizeof (*szTooltips), szTooltips ) ;
	if ( g_bNarrow ) {
		CommandBar_InsertMenubar( m_hwndCB, hInst, IDR_NARROW_MENU, 0 ) ;
		CommandBar_AddBitmap( m_hwndCB, HINST_COMMCTRL, IDB_STD_SMALL_COLOR, 15, 0, 0 ) ;
		CommandBar_AddBitmap( m_hwndCB, g_hInst, IDR_TOOLBAR1, 3, 0, 0 ) ;
		CommandBar_AddButtons( m_hwndCB, sizeof(g_tbNarrowButton) / sizeof(*g_tbNarrowButton), g_tbNarrowButton ) ;
	} else {
		CommandBar_InsertMenubar( m_hwndCB, hInst, IDR_MAIN_MENU, 0 ) ;
		CommandBar_AddBitmap( m_hwndCB, HINST_COMMCTRL, IDB_STD_SMALL_COLOR, 15, 0, 0 ) ;
		CommandBar_AddBitmap( m_hwndCB, g_hInst, IDR_TOOLBAR1, 3, 0, 0 ) ;
		CommandBar_AddButtons( m_hwndCB, sizeof(g_tbWideButton) / sizeof(*g_tbWideButton), g_tbWideButton ) ;
	}
	m_hwndCBButton = m_hwndCB ;
	CommandBar_AddAdornments( m_hwndCB, CMDBAR_HELP, 0 ) ;
	return CommandBar_Height( m_hwndCB ) ;
#else	/* _WIN32_WCE */
	BOOL		bRet ;
	HWND		hwnd ;
	REBARBANDINFO	rbbi[2] ;

	m_hwndCB = CommandBands_Create( hInst, m_hwnd, IDC_BAND,
					RBS_VARHEIGHT|RBS_BANDBORDERS|RBS_SMARTLABELS/*|RBS_AUTOSIZE*/,
					NULL ) ;
	if ( m_hwndCB == NULL ) {
		wsprintf( g_szMessageBuf, TEXT("CommandBands_Create:%d"), GetLastError() ) ;
		MessageBox( m_hwnd, g_szMessageBuf, TEXT(""), MB_OK ) ;
	}

	memset( rbbi, 0, sizeof rbbi ) ;
	rbbi[0].cbSize = sizeof (REBARBANDINFO) ;
	rbbi[0].fMask = RBBIM_ID |  RBBIM_IMAGE | RBBIM_SIZE | RBBIM_STYLE ;
	rbbi[0].fStyle = RBBS_NOGRIPPER ;
	rbbi[0].wID = IDC_BAND_MENU ;
	rbbi[0].cx = 230 ;
	rbbi[0].iImage = 0 ;

	rbbi[1].cbSize = sizeof (REBARBANDINFO) ;
	rbbi[1].fMask = RBBIM_ID |  RBBIM_IMAGE | RBBIM_SIZE ;
	rbbi[1].wID = IDC_BAND_BUTTON ;
	rbbi[1].cx = 125 ;
	rbbi[1].iImage = 0 ;

	bRet = CommandBands_AddBands( m_hwndCB, hInst, 2, rbbi ) ;
	/* j[ǉ */
	hwnd = CommandBands_GetCommandBar( m_hwndCB, 0 ) ;
	bRet = CommandBar_InsertMenubar( hwnd, hInst, IDR_MAIN_MENU, 0 ) ;
	if ( !bRet ) {
		wsprintf( g_szMessageBuf, TEXT("CommandBar_InsertMenubar:%d"), GetLastError() ) ;
		MessageBox( m_hwnd, g_szMessageBuf, TEXT(""), MB_OK ) ;
	}
	/* {^ǉ */
	hwnd = CommandBands_GetCommandBar( m_hwndCB, 1 ) ;
	CommandBar_AddBitmap( hwnd, HINST_COMMCTRL, IDB_STD_SMALL_COLOR, 15, 0, 0 ) ;
	CommandBar_AddBitmap( hwnd, g_hInst, IDR_TOOLBAR1, 3, 0, 0 ) ;
	CommandBar_AddButtons( hwnd, sizeof(g_tbWideButton) / sizeof(*g_tbWideButton), g_tbWideButton ) ;
	m_hwndCBButton = hwnd ;
	/* wv{^AN[Y{^ǉ */
	CommandBands_AddAdornments( m_hwndCB, hInst, CMDBAR_HELP, NULL ) ;

	CommandBands_Show( m_hwndCB, TRUE ) ;
	return CommandBands_Height( m_hwndCB ) ;
#endif	/* _WIN32_WCE */
#else	/* _WIN32_WCE */
	return 0 ;
#endif	/* _WIN32_WCE */
}

BOOL
MainWindow::RegisterClass( HINSTANCE hInst )
{
	WNDCLASS	wc ;

	wc.style         = NULL ;
	wc.lpfnWndProc   = (WNDPROC) WndProc ;
	wc.cbClsExtra    = 0 ;
	wc.cbWndExtra    = 4 ;
	wc.hInstance     = hInst ;
	wc.hIcon         = NULL ;
	wc.hCursor       = NULL ;
	wc.hbrBackground = (HBRUSH) GetStockObject( WHITE_BRUSH ) ;
#ifdef	_WIN32_WCE
	wc.lpszMenuName  = 0 ;
#else	/* _WIN32_WCE */
	wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MAIN_MENU) ;
#endif	/* _WIN32_WCE */
	wc.lpszClassName = 	GetClassName() ;
	return ::RegisterClass( &wc ) ;
}

BOOL CALLBACK
AboutDlgFunc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	TCHAR	buf[ 128 ] ;

	switch ( message ) {
	case WM_INITDIALOG:
		/* _CAO^Cg */
		_tcscpy( buf, TEXT("About ") ) ;
		_tcscat( buf, szTitleName ) ;
		SetWindowText( hDlg, buf ) ;
		/* AvP[Vo[W */
		CE_print_copyright( GetDlgItem( hDlg, IDC_EDT_COPYRIGHT ) ) ;
		return TRUE ;
	case WM_COMMAND:
		switch ( GET_WM_COMMAND_ID( wParam, lParam ) ) {
		case IDOK:
		case IDCANCEL:
			EndDialog( hDlg, TRUE ) ;
			return TRUE ;
		case IDC_APPICON:
			if ( MessageBox( hDlg, TEXT("Uninstall this application?"), TEXT("Uninstall"), MB_YESNO|MB_ICONQUESTION ) == IDYES ) {
				g_bDeleteReg = TRUE ;
				EndDialog( hDlg, FALSE ) ;
			}
			break ;
		}
		break ;
	}
	return FALSE ;
}
