/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "RCX_Target.h"


static const struct RCX_Target sTargets[] = {
{ kRCX_RCXTarget,	"RCX", 			"__RCX",	10,	8, 32, 0 },
{ kRCX_CMTarget,	"CyberMaster",	"__CM",		4,	4, 32, 0 },
{ kRCX_ScoutTarget,	"Scout",		"__SCOUT",	6,	3, 10, 8 },
};

const RCX_Target *getTarget(RCX_TargetType type)
{
	// don't assume order of array matches types
	for(unsigned i=0; i<sizeof(sTargets)/sizeof(RCX_Target); ++i)
		if (sTargets[i].fType == type) return &sTargets[i];

	return 0;
};
