/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __RCX_Link_h
#define __RCX_Link_h

#ifndef __PSerial_h
#include "PSerial.h"
#endif

#ifndef __RCX_Result_h
#include "RCX_Result.h"
#endif

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

#ifndef __RCX_Target_h
#include "RCX_Target.h"
#endif

class RCX_Cmd;

class RCX_Link
{
public:
	enum
	{
		kMaxCmdLength = 1000,
		kMaxReplyLength	= 1000,
		kMinTimeout = 50,
		kMaxTimeout = 400
	};
	
	 
				RCX_Link();
	virtual		~RCX_Link();

	RCX_Result 	Open(const char *portName = nil);
	void		Close();
	
	RCX_Result	Sync();

	RCX_Result	Send(const RCX_Cmd *cmd, bool retry=true, int timeout = 0);
	RCX_Result	Send(const UByte *data, int length, bool retry=true, int timeout = 0);

	RCX_Result	GetReply(UByte *data, int maxLength);
	UByte		GetReplyByte(int index)	const { return fRxData[index]; }

	RCX_Result	SendFragment(RCX_FragmentType type, UByte taskNumber, const UByte *data, int length, int total=0);
	RCX_Result	SendFirmware(const UByte *data, int length, int start, bool fast);
	RCX_Result	Download(const UByte *data, int length, int chunk);

	virtual bool DownloadProgress(int soFar, int total);
		
	RCX_Result	GetVersion(ULong &rom, ULong &ram);
	RCX_Result	GetBatteryLevel();
	RCX_Result	GetValue(RCX_Value value);
	
	void		SetVerbose(bool b)	{ fVerbose = b; }
	bool		GetVerbose() const	{ return fVerbose; }
	
	void		SetRxTimeout(int t)		{ fRxTimeout = t; fDynamicTimeout = false; }
	
	void		SetTarget(RCX_TargetType target);

private:
	RCX_Result	_SendFirmware(const UByte *data, int length, int start, bool progress);
	RCX_Result	_SendFromTxBuffer(int timeout);
	void		BuildTxData(const UByte *data, int length);
	void		BeginProgress(int total);
	bool		IncrementProgress(int delta);
	void		AdjustReply(int offset, RCX_Result length);
		
	PSerial*	fSerial;
	UByte*	fTxData;
	int		fTxLength;
	UByte	fTxLastCommand;
	
	UByte*	fRxData;
	int		fRxLength;
	
	RCX_Result	fResult;
	
	bool		fVerbose;
	bool		fSynced;
	RCX_TargetType		fTarget;
	int			fRxTimeout;
	bool		fDynamicTimeout;
	
	// use for fast download
	bool		fFastMode;
	
	// new fields to track download progress;
	int			fDownloadTotal;
	int			fDownloadSoFar;
};


#endif
