/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __SwitchStmt_h
#define __SwitchStmt_h

#ifndef __Stmt_h
#include "Stmt.h"
#endif

#ifndef __Clause_h
#include "Clause.h"
#endif

#ifndef __PArray_h
#include "PArray.h"
#endif

class SwitchStmt : public ChainStmt
{
public:
			SwitchStmt(Clause *c, Stmt *s);
			~SwitchStmt();
	
	virtual	void	EmitActual(Bytecode &b);
	virtual void	EmitSwitchCases(Bytecode &b, SwitchState &s);

	Stmt*	Clone(Mapping *b) const;

private:	
	Clause*		fSelector;
};


class SwitchState
{
public:
				SwitchState(RCX_Value selector, int defaultLabel) :
					fSelector(selector),
					fDefaultLabel(defaultLabel)
					{}
				
	bool		ContainsCase(int v);
	void		AddCase(int v)			{ fCases.Append(v); }

	RCX_Value	GetSelector() const		{ return fSelector; }
	int			GetDefaultLabel() const	{ return fDefaultLabel; }
	
private:
	RCX_Value	fSelector;
	int			fDefaultLabel;
	PArray<int>	fCases;
};

#endif
